<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Tier StructType
 * @subpackage Structs
 */
class CT_Tier extends CT_Gegenstand
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArtID;
    /**
     * The Rasse
     * Meta information extracted from the WSDL
     * - documentation: kann bei Mischlingen n-fach vorkommen.Bei Hunden sollte das Attribut Hunderasse verwendet werden.
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: unbounded
     * - minLength: 0
     * - minOccurs: 0
     * @var string[]
     */
    public $Rasse;
    /**
     * The Hunderasse
     * Meta information extracted from the WSDL
     * - documentation: kann bei Mischlingen n-fach vorkommen. Die eigentliche Liste wird nicht referenziert und ist damit nicht direkter Bestandteil des Modells. Den Katalog finden Sie im Modell Kataloge. Die Liste kann über den generischen Suchservice
     * (N480) durchsuch- und abrufbar gemacht werden. | Die gültigen Werte der Hunderassen MÜSSEN dem Katalog ST_KatalogHunderasse entnommen werden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Hunderasse;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Registriernummer
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - length: 17
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Registriernummer;
    /**
     * The Geburtsdatum
     * Meta information extracted from the WSDL
     * - documentation: nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Geburtsdatum;
    /**
     * The Geschlecht
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Geschlecht;
    /**
     * The Farbe
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Farbe;
    /**
     * The Nutzungsart
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Nutzungsart;
    /**
     * The Steuerpflicht
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Steuerpflicht;
    /**
     * The Kampfhund
     * Meta information extracted from the WSDL
     * - documentation: Angabe, ob es sich bei dem Tier um einen Kampfhund handelt.Ja = KampfhundNein = Kein Kampfhund
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Kampfhund;
    /**
     * Constructor method for CT_Tier
     * @uses CT_Tier::setArtID()
     * @uses CT_Tier::setRasse()
     * @uses CT_Tier::setHunderasse()
     * @uses CT_Tier::setName()
     * @uses CT_Tier::setRegistriernummer()
     * @uses CT_Tier::setGeburtsdatum()
     * @uses CT_Tier::setGeschlecht()
     * @uses CT_Tier::setFarbe()
     * @uses CT_Tier::setNutzungsart()
     * @uses CT_Tier::setSteuerpflicht()
     * @uses CT_Tier::setKampfhund()
     * @param string $artID
     * @param string[] $rasse
     * @param string[] $hunderasse
     * @param string $name
     * @param string $registriernummer
     * @param string $geburtsdatum
     * @param string $geschlecht
     * @param string $farbe
     * @param string $nutzungsart
     * @param string $steuerpflicht
     * @param bool $kampfhund
     */
    public function __construct($artID = null, array $rasse = array(), array $hunderasse = array(), $name = null, $registriernummer = null, $geburtsdatum = null, $geschlecht = null, $farbe = null, $nutzungsart = null, $steuerpflicht = null, $kampfhund = null)
    {
        $this
            ->setArtID($artID)
            ->setRasse($rasse)
            ->setHunderasse($hunderasse)
            ->setName($name)
            ->setRegistriernummer($registriernummer)
            ->setGeburtsdatum($geburtsdatum)
            ->setGeschlecht($geschlecht)
            ->setFarbe($farbe)
            ->setNutzungsart($nutzungsart)
            ->setSteuerpflicht($steuerpflicht)
            ->setKampfhund($kampfhund);
    }
    /**
     * Get ArtID value
     * @return string|null
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @uses \BiPRO\EnumType\ST_Tierart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Tierart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artID
     * @return \BiPRO\StructType\CT_Tier
     */
    public function setArtID($artID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Tierart::valueIsValid($artID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Tierart', is_array($artID) ? implode(', ', $artID) : var_export($artID, true), implode(', ', \BiPRO\EnumType\ST_Tierart::getValidValues())), __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Rasse value
     * @return string[]|null
     */
    public function getRasse()
    {
        return $this->Rasse;
    }
    /**
     * This method is responsible for validating the values passed to the setRasse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRasse method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRasseForArrayConstraintsFromSetRasse(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_TierRasseItem) {
            // validation for constraint: itemType
            if (!is_string($cT_TierRasseItem)) {
                $invalidValues[] = is_object($cT_TierRasseItem) ? get_class($cT_TierRasseItem) : sprintf('%s(%s)', gettype($cT_TierRasseItem), var_export($cT_TierRasseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Rasse property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setRasse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRasse method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRasseForMaxLengthConstraintFromSetRasse($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_TierRasseItem) {
            // validation for constraint: maxLength(80)
            if (mb_strlen($cT_TierRasseItem) > 80) {
                $invalidValues[] = var_export($cT_TierRasseItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 80', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setRasse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRasse method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRasseForMinLengthConstraintFromSetRasse($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_TierRasseItem) {
            // validation for constraint: minLength
            if (mb_strlen($cT_TierRasseItem) < 0) {
                $invalidValues[] = var_export($cT_TierRasseItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 0', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Rasse value
     * @throws \InvalidArgumentException
     * @param string[] $rasse
     * @return \BiPRO\StructType\CT_Tier
     */
    public function setRasse(array $rasse = array())
    {
        // validation for constraint: array
        if ('' !== ($rasseArrayErrorMessage = self::validateRasseForArrayConstraintsFromSetRasse($rasse))) {
            throw new \InvalidArgumentException($rasseArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(80)
        if ('' !== ($rasseMaxLengthErrorMessage = self::validateRasseForMaxLengthConstraintFromSetRasse($rasse))) {
            throw new \InvalidArgumentException($rasseMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: minLength
        if ('' !== ($rasseMinLengthErrorMessage = self::validateRasseForMinLengthConstraintFromSetRasse($rasse))) {
            throw new \InvalidArgumentException($rasseMinLengthErrorMessage, __LINE__);
        }
        $this->Rasse = $rasse;
        return $this;
    }
    /**
     * Add item to Rasse value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \BiPRO\StructType\CT_Tier
     */
    public function addToRasse($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Rasse property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (mb_strlen($item) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: minLength
        if (mb_strlen($item) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($item)), __LINE__);
        }
        $this->Rasse[] = $item;
        return $this;
    }
    /**
     * Get Hunderasse value
     * @return string[]|null
     */
    public function getHunderasse()
    {
        return $this->Hunderasse;
    }
    /**
     * This method is responsible for validating the values passed to the setHunderasse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHunderasse method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHunderasseForArrayConstraintsFromSetHunderasse(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_TierHunderasseItem) {
            // validation for constraint: itemType
            if (!is_string($cT_TierHunderasseItem)) {
                $invalidValues[] = is_object($cT_TierHunderasseItem) ? get_class($cT_TierHunderasseItem) : sprintf('%s(%s)', gettype($cT_TierHunderasseItem), var_export($cT_TierHunderasseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Hunderasse property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Hunderasse value
     * @throws \InvalidArgumentException
     * @param string[] $hunderasse
     * @return \BiPRO\StructType\CT_Tier
     */
    public function setHunderasse(array $hunderasse = array())
    {
        // validation for constraint: array
        if ('' !== ($hunderasseArrayErrorMessage = self::validateHunderasseForArrayConstraintsFromSetHunderasse($hunderasse))) {
            throw new \InvalidArgumentException($hunderasseArrayErrorMessage, __LINE__);
        }
        $this->Hunderasse = is_array($hunderasse) ? implode(' ', $hunderasse) : null;
        return $this;
    }
    /**
     * Add item to Hunderasse value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \BiPRO\StructType\CT_Tier
     */
    public function addToHunderasse($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Hunderasse property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Hunderasse[] = $item;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \BiPRO\StructType\CT_Tier
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($name) && mb_strlen($name) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($name)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($name) && mb_strlen($name) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Registriernummer value
     * @return string|null
     */
    public function getRegistriernummer()
    {
        return $this->Registriernummer;
    }
    /**
     * Set Registriernummer value
     * @param string $registriernummer
     * @return \BiPRO\StructType\CT_Tier
     */
    public function setRegistriernummer($registriernummer = null)
    {
        // validation for constraint: string
        if (!is_null($registriernummer) && !is_string($registriernummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registriernummer, true), gettype($registriernummer)), __LINE__);
        }
        // validation for constraint: length(17)
        if (!is_null($registriernummer) && mb_strlen($registriernummer) !== 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 17', mb_strlen($registriernummer)), __LINE__);
        }
        $this->Registriernummer = $registriernummer;
        return $this;
    }
    /**
     * Get Geburtsdatum value
     * @return string|null
     */
    public function getGeburtsdatum()
    {
        return $this->Geburtsdatum;
    }
    /**
     * Set Geburtsdatum value
     * @param string $geburtsdatum
     * @return \BiPRO\StructType\CT_Tier
     */
    public function setGeburtsdatum($geburtsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($geburtsdatum) && !is_string($geburtsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geburtsdatum, true), gettype($geburtsdatum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($geburtsdatum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $geburtsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($geburtsdatum, true)), __LINE__);
        }
        $this->Geburtsdatum = $geburtsdatum;
        return $this;
    }
    /**
     * Get Geschlecht value
     * @return string|null
     */
    public function getGeschlecht()
    {
        return $this->Geschlecht;
    }
    /**
     * Set Geschlecht value
     * @uses \BiPRO\EnumType\ST_TierGeschlecht::valueIsValid()
     * @uses \BiPRO\EnumType\ST_TierGeschlecht::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $geschlecht
     * @return \BiPRO\StructType\CT_Tier
     */
    public function setGeschlecht($geschlecht = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_TierGeschlecht::valueIsValid($geschlecht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_TierGeschlecht', is_array($geschlecht) ? implode(', ', $geschlecht) : var_export($geschlecht, true), implode(', ', \BiPRO\EnumType\ST_TierGeschlecht::getValidValues())), __LINE__);
        }
        $this->Geschlecht = $geschlecht;
        return $this;
    }
    /**
     * Get Farbe value
     * @return string|null
     */
    public function getFarbe()
    {
        return $this->Farbe;
    }
    /**
     * Set Farbe value
     * @param string $farbe
     * @return \BiPRO\StructType\CT_Tier
     */
    public function setFarbe($farbe = null)
    {
        // validation for constraint: string
        if (!is_null($farbe) && !is_string($farbe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($farbe, true), gettype($farbe)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($farbe) && mb_strlen($farbe) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($farbe)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($farbe) && mb_strlen($farbe) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($farbe)), __LINE__);
        }
        $this->Farbe = $farbe;
        return $this;
    }
    /**
     * Get Nutzungsart value
     * @return string|null
     */
    public function getNutzungsart()
    {
        return $this->Nutzungsart;
    }
    /**
     * Set Nutzungsart value
     * @uses \BiPRO\EnumType\ST_TierNutzungsart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_TierNutzungsart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nutzungsart
     * @return \BiPRO\StructType\CT_Tier
     */
    public function setNutzungsart($nutzungsart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_TierNutzungsart::valueIsValid($nutzungsart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_TierNutzungsart', is_array($nutzungsart) ? implode(', ', $nutzungsart) : var_export($nutzungsart, true), implode(', ', \BiPRO\EnumType\ST_TierNutzungsart::getValidValues())), __LINE__);
        }
        $this->Nutzungsart = $nutzungsart;
        return $this;
    }
    /**
     * Get Steuerpflicht value
     * @return string|null
     */
    public function getSteuerpflicht()
    {
        return $this->Steuerpflicht;
    }
    /**
     * Set Steuerpflicht value
     * @uses \BiPRO\EnumType\ST_Tiersteuer::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Tiersteuer::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $steuerpflicht
     * @return \BiPRO\StructType\CT_Tier
     */
    public function setSteuerpflicht($steuerpflicht = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Tiersteuer::valueIsValid($steuerpflicht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Tiersteuer', is_array($steuerpflicht) ? implode(', ', $steuerpflicht) : var_export($steuerpflicht, true), implode(', ', \BiPRO\EnumType\ST_Tiersteuer::getValidValues())), __LINE__);
        }
        $this->Steuerpflicht = $steuerpflicht;
        return $this;
    }
    /**
     * Get Kampfhund value
     * @return bool|null
     */
    public function getKampfhund()
    {
        return $this->Kampfhund;
    }
    /**
     * Set Kampfhund value
     * @param bool $kampfhund
     * @return \BiPRO\StructType\CT_Tier
     */
    public function setKampfhund($kampfhund = null)
    {
        // validation for constraint: boolean
        if (!is_null($kampfhund) && !is_bool($kampfhund)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kampfhund, true), gettype($kampfhund)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($kampfhund) && !preg_match('/true|false/', $kampfhund)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($kampfhund, true)), __LINE__);
        }
        $this->Kampfhund = $kampfhund;
        return $this;
    }
}
