<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_TAA StructType
 * Meta information extracted from the WSDL
 * - documentation: Basisklasse für Tarifierung, Angebot und Antrag
 * @subpackage Structs
 */
abstract class CT_TAA extends CT_Geschaeftsvorgang
{
    /**
     * The Verkaufsprodukt
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \BiPRO\StructType\CT_Verkaufsprodukt[]
     */
    public $Verkaufsprodukt;
    /**
     * The Zahlungsart
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Zahlungsart;
    /**
     * The Inkassoart
     * Meta information extracted from the WSDL
     * - documentation: Die Inkassoart gibt an, von wem (VU oder VM) die Prämie eingezogen wird. Die Information ist bei einigen VU tarifierungsrelevant. Bei Inkassoart = 1 (Vermittlerinkasso) muss ggf. noch die Abrechnungsart angegeben werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Inkassoart;
    /**
     * The Abrechnungsart
     * Meta information extracted from the WSDL
     * - documentation: Angabe ob es sich bei den vom Vermittler eingezogenen Beiträgen um Brutto- (Vermittler leitet auch den Courtageanteil an das VU weiter) oder Nettobeiträge (Vermittler behält Courtageanteile ein) handelt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Abrechnungsart;
    /**
     * The Partner
     * Meta information extracted from the WSDL
     * - documentation: Partnerliste. Diese Verknuepfung stellt keine logische Beziehung dar, sondern das reine Enthaltensein aller Partner in Form einer Liste innerhalb des konkreten Geschaeftsvorgangs. Referenziert werden diese Partner mit Hilfe der von
     * Partnerrolle abgeleiteten Rollen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Partner[]
     */
    public $Partner;
    /**
     * The Versicherungsnehmer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Vertragspartner
     */
    public $Versicherungsnehmer;
    /**
     * The Aktivitaet
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Aktivitaet[]
     */
    public $Aktivitaet;
    /**
     * The Gegenstand
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Gegenstand[]
     */
    public $Gegenstand;
    /**
     * The VorNebenVersicherung
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_VorNebenVertrag[]
     */
    public $VorNebenVersicherung;
    /**
     * The Personengruppe
     * Meta information extracted from the WSDL
     * - documentation: Personengruppenliste.Diese Verknuepfung stellt keine logische Beziehung dar, sondern das reine Enthaltensein aller Personengruppen in Form einer Liste innerhalb des konkreten Geschaeftsvorgangs. Referenziert werden diese
     * Personengruppen mit Hilfe der von Personengruppenrolle abgeleiteten Rollen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Personengruppe[]
     */
    public $Personengruppe;
    /**
     * The Vertragsverbindungsnummer
     * Meta information extracted from the WSDL
     * - documentation: Referenz eines Vertrages auf einen anderen Vertrag (z.B. Rahmenvertrag, Gruppenvertrag). Die Vertragsverbindungsnummer gibt den zugrunde liegenden Gruppen-/Rahmenvertrag an.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Vertragsnummer[]
     */
    public $Vertragsverbindungsnummer;
    /**
     * Constructor method for CT_TAA
     * @uses CT_TAA::setVerkaufsprodukt()
     * @uses CT_TAA::setZahlungsart()
     * @uses CT_TAA::setInkassoart()
     * @uses CT_TAA::setAbrechnungsart()
     * @uses CT_TAA::setPartner()
     * @uses CT_TAA::setVersicherungsnehmer()
     * @uses CT_TAA::setAktivitaet()
     * @uses CT_TAA::setGegenstand()
     * @uses CT_TAA::setVorNebenVersicherung()
     * @uses CT_TAA::setPersonengruppe()
     * @uses CT_TAA::setVertragsverbindungsnummer()
     * @param \BiPRO\StructType\CT_Verkaufsprodukt[] $verkaufsprodukt
     * @param string $zahlungsart
     * @param string $inkassoart
     * @param string $abrechnungsart
     * @param \BiPRO\StructType\CT_Partner[] $partner
     * @param \BiPRO\StructType\CT_Vertragspartner $versicherungsnehmer
     * @param \BiPRO\StructType\CT_Aktivitaet[] $aktivitaet
     * @param \BiPRO\StructType\CT_Gegenstand[] $gegenstand
     * @param \BiPRO\StructType\CT_VorNebenVertrag[] $vorNebenVersicherung
     * @param \BiPRO\StructType\CT_Personengruppe[] $personengruppe
     * @param \BiPRO\StructType\CT_Vertragsnummer[] $vertragsverbindungsnummer
     */
    public function __construct(array $verkaufsprodukt = array(), $zahlungsart = null, $inkassoart = null, $abrechnungsart = null, array $partner = array(), \BiPRO\StructType\CT_Vertragspartner $versicherungsnehmer = null, array $aktivitaet = array(), array $gegenstand = array(), array $vorNebenVersicherung = array(), array $personengruppe = array(), array $vertragsverbindungsnummer = array())
    {
        $this
            ->setVerkaufsprodukt($verkaufsprodukt)
            ->setZahlungsart($zahlungsart)
            ->setInkassoart($inkassoart)
            ->setAbrechnungsart($abrechnungsart)
            ->setPartner($partner)
            ->setVersicherungsnehmer($versicherungsnehmer)
            ->setAktivitaet($aktivitaet)
            ->setGegenstand($gegenstand)
            ->setVorNebenVersicherung($vorNebenVersicherung)
            ->setPersonengruppe($personengruppe)
            ->setVertragsverbindungsnummer($vertragsverbindungsnummer);
    }
    /**
     * Get Verkaufsprodukt value
     * @return \BiPRO\StructType\CT_Verkaufsprodukt[]
     */
    public function getVerkaufsprodukt()
    {
        return $this->Verkaufsprodukt;
    }
    /**
     * This method is responsible for validating the values passed to the setVerkaufsprodukt method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVerkaufsprodukt method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVerkaufsproduktForArrayConstraintsFromSetVerkaufsprodukt(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_TAAVerkaufsproduktItem) {
            // validation for constraint: itemType
            if (!$cT_TAAVerkaufsproduktItem instanceof \BiPRO\StructType\CT_Verkaufsprodukt) {
                $invalidValues[] = is_object($cT_TAAVerkaufsproduktItem) ? get_class($cT_TAAVerkaufsproduktItem) : sprintf('%s(%s)', gettype($cT_TAAVerkaufsproduktItem), var_export($cT_TAAVerkaufsproduktItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Verkaufsprodukt property can only contain items of type \BiPRO\StructType\CT_Verkaufsprodukt, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Verkaufsprodukt value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Verkaufsprodukt[] $verkaufsprodukt
     * @return \BiPRO\StructType\CT_TAA
     */
    public function setVerkaufsprodukt(array $verkaufsprodukt = array())
    {
        // validation for constraint: array
        if ('' !== ($verkaufsproduktArrayErrorMessage = self::validateVerkaufsproduktForArrayConstraintsFromSetVerkaufsprodukt($verkaufsprodukt))) {
            throw new \InvalidArgumentException($verkaufsproduktArrayErrorMessage, __LINE__);
        }
        $this->Verkaufsprodukt = $verkaufsprodukt;
        return $this;
    }
    /**
     * Add item to Verkaufsprodukt value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Verkaufsprodukt $item
     * @return \BiPRO\StructType\CT_TAA
     */
    public function addToVerkaufsprodukt(\BiPRO\StructType\CT_Verkaufsprodukt $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Verkaufsprodukt) {
            throw new \InvalidArgumentException(sprintf('The Verkaufsprodukt property can only contain items of type \BiPRO\StructType\CT_Verkaufsprodukt, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Verkaufsprodukt[] = $item;
        return $this;
    }
    /**
     * Get Zahlungsart value
     * @return string|null
     */
    public function getZahlungsart()
    {
        return $this->Zahlungsart;
    }
    /**
     * Set Zahlungsart value
     * @uses \BiPRO\EnumType\ST_Zahlungsart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Zahlungsart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zahlungsart
     * @return \BiPRO\StructType\CT_TAA
     */
    public function setZahlungsart($zahlungsart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Zahlungsart::valueIsValid($zahlungsart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Zahlungsart', is_array($zahlungsart) ? implode(', ', $zahlungsart) : var_export($zahlungsart, true), implode(', ', \BiPRO\EnumType\ST_Zahlungsart::getValidValues())), __LINE__);
        }
        $this->Zahlungsart = $zahlungsart;
        return $this;
    }
    /**
     * Get Inkassoart value
     * @return string|null
     */
    public function getInkassoart()
    {
        return $this->Inkassoart;
    }
    /**
     * Set Inkassoart value
     * @uses \BiPRO\EnumType\ST_Inkassoart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Inkassoart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $inkassoart
     * @return \BiPRO\StructType\CT_TAA
     */
    public function setInkassoart($inkassoart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Inkassoart::valueIsValid($inkassoart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Inkassoart', is_array($inkassoart) ? implode(', ', $inkassoart) : var_export($inkassoart, true), implode(', ', \BiPRO\EnumType\ST_Inkassoart::getValidValues())), __LINE__);
        }
        $this->Inkassoart = $inkassoart;
        return $this;
    }
    /**
     * Get Abrechnungsart value
     * @return string|null
     */
    public function getAbrechnungsart()
    {
        return $this->Abrechnungsart;
    }
    /**
     * Set Abrechnungsart value
     * @uses \BiPRO\EnumType\ST_Abrechnungsart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Abrechnungsart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $abrechnungsart
     * @return \BiPRO\StructType\CT_TAA
     */
    public function setAbrechnungsart($abrechnungsart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Abrechnungsart::valueIsValid($abrechnungsart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Abrechnungsart', is_array($abrechnungsart) ? implode(', ', $abrechnungsart) : var_export($abrechnungsart, true), implode(', ', \BiPRO\EnumType\ST_Abrechnungsart::getValidValues())), __LINE__);
        }
        $this->Abrechnungsart = $abrechnungsart;
        return $this;
    }
    /**
     * Get Partner value
     * @return \BiPRO\StructType\CT_Partner[]|null
     */
    public function getPartner()
    {
        return $this->Partner;
    }
    /**
     * This method is responsible for validating the values passed to the setPartner method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPartner method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePartnerForArrayConstraintsFromSetPartner(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_TAAPartnerItem) {
            // validation for constraint: itemType
            if (!$cT_TAAPartnerItem instanceof \BiPRO\StructType\CT_Partner) {
                $invalidValues[] = is_object($cT_TAAPartnerItem) ? get_class($cT_TAAPartnerItem) : sprintf('%s(%s)', gettype($cT_TAAPartnerItem), var_export($cT_TAAPartnerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Partner property can only contain items of type \BiPRO\StructType\CT_Partner, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Partner value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Partner[] $partner
     * @return \BiPRO\StructType\CT_TAA
     */
    public function setPartner(array $partner = array())
    {
        // validation for constraint: array
        if ('' !== ($partnerArrayErrorMessage = self::validatePartnerForArrayConstraintsFromSetPartner($partner))) {
            throw new \InvalidArgumentException($partnerArrayErrorMessage, __LINE__);
        }
        $this->Partner = $partner;
        return $this;
    }
    /**
     * Add item to Partner value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Partner $item
     * @return \BiPRO\StructType\CT_TAA
     */
    public function addToPartner(\BiPRO\StructType\CT_Partner $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Partner) {
            throw new \InvalidArgumentException(sprintf('The Partner property can only contain items of type \BiPRO\StructType\CT_Partner, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Partner[] = $item;
        return $this;
    }
    /**
     * Get Versicherungsnehmer value
     * @return \BiPRO\StructType\CT_Vertragspartner|null
     */
    public function getVersicherungsnehmer()
    {
        return $this->Versicherungsnehmer;
    }
    /**
     * Set Versicherungsnehmer value
     * @param \BiPRO\StructType\CT_Vertragspartner $versicherungsnehmer
     * @return \BiPRO\StructType\CT_TAA
     */
    public function setVersicherungsnehmer(\BiPRO\StructType\CT_Vertragspartner $versicherungsnehmer = null)
    {
        $this->Versicherungsnehmer = $versicherungsnehmer;
        return $this;
    }
    /**
     * Get Aktivitaet value
     * @return \BiPRO\StructType\CT_Aktivitaet[]|null
     */
    public function getAktivitaet()
    {
        return $this->Aktivitaet;
    }
    /**
     * This method is responsible for validating the values passed to the setAktivitaet method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAktivitaet method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAktivitaetForArrayConstraintsFromSetAktivitaet(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_TAAAktivitaetItem) {
            // validation for constraint: itemType
            if (!$cT_TAAAktivitaetItem instanceof \BiPRO\StructType\CT_Aktivitaet) {
                $invalidValues[] = is_object($cT_TAAAktivitaetItem) ? get_class($cT_TAAAktivitaetItem) : sprintf('%s(%s)', gettype($cT_TAAAktivitaetItem), var_export($cT_TAAAktivitaetItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Aktivitaet property can only contain items of type \BiPRO\StructType\CT_Aktivitaet, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Aktivitaet value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Aktivitaet[] $aktivitaet
     * @return \BiPRO\StructType\CT_TAA
     */
    public function setAktivitaet(array $aktivitaet = array())
    {
        // validation for constraint: array
        if ('' !== ($aktivitaetArrayErrorMessage = self::validateAktivitaetForArrayConstraintsFromSetAktivitaet($aktivitaet))) {
            throw new \InvalidArgumentException($aktivitaetArrayErrorMessage, __LINE__);
        }
        $this->Aktivitaet = $aktivitaet;
        return $this;
    }
    /**
     * Add item to Aktivitaet value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Aktivitaet $item
     * @return \BiPRO\StructType\CT_TAA
     */
    public function addToAktivitaet(\BiPRO\StructType\CT_Aktivitaet $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Aktivitaet) {
            throw new \InvalidArgumentException(sprintf('The Aktivitaet property can only contain items of type \BiPRO\StructType\CT_Aktivitaet, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Aktivitaet[] = $item;
        return $this;
    }
    /**
     * Get Gegenstand value
     * @return \BiPRO\StructType\CT_Gegenstand[]|null
     */
    public function getGegenstand()
    {
        return $this->Gegenstand;
    }
    /**
     * This method is responsible for validating the values passed to the setGegenstand method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGegenstand method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGegenstandForArrayConstraintsFromSetGegenstand(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_TAAGegenstandItem) {
            // validation for constraint: itemType
            if (!$cT_TAAGegenstandItem instanceof \BiPRO\StructType\CT_Gegenstand) {
                $invalidValues[] = is_object($cT_TAAGegenstandItem) ? get_class($cT_TAAGegenstandItem) : sprintf('%s(%s)', gettype($cT_TAAGegenstandItem), var_export($cT_TAAGegenstandItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Gegenstand property can only contain items of type \BiPRO\StructType\CT_Gegenstand, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Gegenstand value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Gegenstand[] $gegenstand
     * @return \BiPRO\StructType\CT_TAA
     */
    public function setGegenstand(array $gegenstand = array())
    {
        // validation for constraint: array
        if ('' !== ($gegenstandArrayErrorMessage = self::validateGegenstandForArrayConstraintsFromSetGegenstand($gegenstand))) {
            throw new \InvalidArgumentException($gegenstandArrayErrorMessage, __LINE__);
        }
        $this->Gegenstand = $gegenstand;
        return $this;
    }
    /**
     * Add item to Gegenstand value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Gegenstand $item
     * @return \BiPRO\StructType\CT_TAA
     */
    public function addToGegenstand(\BiPRO\StructType\CT_Gegenstand $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Gegenstand) {
            throw new \InvalidArgumentException(sprintf('The Gegenstand property can only contain items of type \BiPRO\StructType\CT_Gegenstand, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Gegenstand[] = $item;
        return $this;
    }
    /**
     * Get VorNebenVersicherung value
     * @return \BiPRO\StructType\CT_VorNebenVertrag[]|null
     */
    public function getVorNebenVersicherung()
    {
        return $this->VorNebenVersicherung;
    }
    /**
     * This method is responsible for validating the values passed to the setVorNebenVersicherung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVorNebenVersicherung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVorNebenVersicherungForArrayConstraintsFromSetVorNebenVersicherung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_TAAVorNebenVersicherungItem) {
            // validation for constraint: itemType
            if (!$cT_TAAVorNebenVersicherungItem instanceof \BiPRO\StructType\CT_VorNebenVertrag) {
                $invalidValues[] = is_object($cT_TAAVorNebenVersicherungItem) ? get_class($cT_TAAVorNebenVersicherungItem) : sprintf('%s(%s)', gettype($cT_TAAVorNebenVersicherungItem), var_export($cT_TAAVorNebenVersicherungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VorNebenVersicherung property can only contain items of type \BiPRO\StructType\CT_VorNebenVertrag, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VorNebenVersicherung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_VorNebenVertrag[] $vorNebenVersicherung
     * @return \BiPRO\StructType\CT_TAA
     */
    public function setVorNebenVersicherung(array $vorNebenVersicherung = array())
    {
        // validation for constraint: array
        if ('' !== ($vorNebenVersicherungArrayErrorMessage = self::validateVorNebenVersicherungForArrayConstraintsFromSetVorNebenVersicherung($vorNebenVersicherung))) {
            throw new \InvalidArgumentException($vorNebenVersicherungArrayErrorMessage, __LINE__);
        }
        $this->VorNebenVersicherung = $vorNebenVersicherung;
        return $this;
    }
    /**
     * Add item to VorNebenVersicherung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_VorNebenVertrag $item
     * @return \BiPRO\StructType\CT_TAA
     */
    public function addToVorNebenVersicherung(\BiPRO\StructType\CT_VorNebenVertrag $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_VorNebenVertrag) {
            throw new \InvalidArgumentException(sprintf('The VorNebenVersicherung property can only contain items of type \BiPRO\StructType\CT_VorNebenVertrag, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->VorNebenVersicherung[] = $item;
        return $this;
    }
    /**
     * Get Personengruppe value
     * @return \BiPRO\StructType\CT_Personengruppe[]|null
     */
    public function getPersonengruppe()
    {
        return $this->Personengruppe;
    }
    /**
     * This method is responsible for validating the values passed to the setPersonengruppe method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPersonengruppe method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePersonengruppeForArrayConstraintsFromSetPersonengruppe(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_TAAPersonengruppeItem) {
            // validation for constraint: itemType
            if (!$cT_TAAPersonengruppeItem instanceof \BiPRO\StructType\CT_Personengruppe) {
                $invalidValues[] = is_object($cT_TAAPersonengruppeItem) ? get_class($cT_TAAPersonengruppeItem) : sprintf('%s(%s)', gettype($cT_TAAPersonengruppeItem), var_export($cT_TAAPersonengruppeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Personengruppe property can only contain items of type \BiPRO\StructType\CT_Personengruppe, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Personengruppe value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Personengruppe[] $personengruppe
     * @return \BiPRO\StructType\CT_TAA
     */
    public function setPersonengruppe(array $personengruppe = array())
    {
        // validation for constraint: array
        if ('' !== ($personengruppeArrayErrorMessage = self::validatePersonengruppeForArrayConstraintsFromSetPersonengruppe($personengruppe))) {
            throw new \InvalidArgumentException($personengruppeArrayErrorMessage, __LINE__);
        }
        $this->Personengruppe = $personengruppe;
        return $this;
    }
    /**
     * Add item to Personengruppe value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Personengruppe $item
     * @return \BiPRO\StructType\CT_TAA
     */
    public function addToPersonengruppe(\BiPRO\StructType\CT_Personengruppe $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Personengruppe) {
            throw new \InvalidArgumentException(sprintf('The Personengruppe property can only contain items of type \BiPRO\StructType\CT_Personengruppe, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Personengruppe[] = $item;
        return $this;
    }
    /**
     * Get Vertragsverbindungsnummer value
     * @return \BiPRO\StructType\CT_Vertragsnummer[]|null
     */
    public function getVertragsverbindungsnummer()
    {
        return $this->Vertragsverbindungsnummer;
    }
    /**
     * This method is responsible for validating the values passed to the setVertragsverbindungsnummer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVertragsverbindungsnummer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVertragsverbindungsnummerForArrayConstraintsFromSetVertragsverbindungsnummer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_TAAVertragsverbindungsnummerItem) {
            // validation for constraint: itemType
            if (!$cT_TAAVertragsverbindungsnummerItem instanceof \BiPRO\StructType\CT_Vertragsnummer) {
                $invalidValues[] = is_object($cT_TAAVertragsverbindungsnummerItem) ? get_class($cT_TAAVertragsverbindungsnummerItem) : sprintf('%s(%s)', gettype($cT_TAAVertragsverbindungsnummerItem), var_export($cT_TAAVertragsverbindungsnummerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Vertragsverbindungsnummer property can only contain items of type \BiPRO\StructType\CT_Vertragsnummer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Vertragsverbindungsnummer value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Vertragsnummer[] $vertragsverbindungsnummer
     * @return \BiPRO\StructType\CT_TAA
     */
    public function setVertragsverbindungsnummer(array $vertragsverbindungsnummer = array())
    {
        // validation for constraint: array
        if ('' !== ($vertragsverbindungsnummerArrayErrorMessage = self::validateVertragsverbindungsnummerForArrayConstraintsFromSetVertragsverbindungsnummer($vertragsverbindungsnummer))) {
            throw new \InvalidArgumentException($vertragsverbindungsnummerArrayErrorMessage, __LINE__);
        }
        $this->Vertragsverbindungsnummer = $vertragsverbindungsnummer;
        return $this;
    }
    /**
     * Add item to Vertragsverbindungsnummer value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Vertragsnummer $item
     * @return \BiPRO\StructType\CT_TAA
     */
    public function addToVertragsverbindungsnummer(\BiPRO\StructType\CT_Vertragsnummer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Vertragsnummer) {
            throw new \InvalidArgumentException(sprintf('The Vertragsverbindungsnummer property can only contain items of type \BiPRO\StructType\CT_Vertragsnummer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Vertragsverbindungsnummer[] = $item;
        return $this;
    }
}
