<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_SturmElementarSchaden StructType
 * Meta information extracted from the WSDL
 * - documentation: Schaden durch Sturm oder ein Elementarereignis.
 * @subpackage Structs
 */
class CT_SturmElementarSchaden extends CT_SchadenZuObjekt
{
    /**
     * The FensterTuerenVerschlossen
     * Meta information extracted from the WSDL
     * - documentation: JA = Fenster und Türen waren verschlossen.NEIN = Fenster und Türen waren nicht verschlossen.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $FensterTuerenVerschlossen;
    /**
     * The RegenSchmutzEingedrungen
     * Meta information extracted from the WSDL
     * - documentation: JA = Regen und/oder Schmutz eingedrungen.NEIN = Kein Regen und/oder Schmutz eingedrungen.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $RegenSchmutzEingedrungen;
    /**
     * The Eindringungsoeffnung
     * Meta information extracted from the WSDL
     * - documentation: Öffnung, durch die Regen und/oder Schmutz eingedrungen sind.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Eindringungsoeffnung;
    /**
     * Constructor method for CT_SturmElementarSchaden
     * @uses CT_SturmElementarSchaden::setFensterTuerenVerschlossen()
     * @uses CT_SturmElementarSchaden::setRegenSchmutzEingedrungen()
     * @uses CT_SturmElementarSchaden::setEindringungsoeffnung()
     * @param bool $fensterTuerenVerschlossen
     * @param bool $regenSchmutzEingedrungen
     * @param string[] $eindringungsoeffnung
     */
    public function __construct($fensterTuerenVerschlossen = null, $regenSchmutzEingedrungen = null, array $eindringungsoeffnung = array())
    {
        $this
            ->setFensterTuerenVerschlossen($fensterTuerenVerschlossen)
            ->setRegenSchmutzEingedrungen($regenSchmutzEingedrungen)
            ->setEindringungsoeffnung($eindringungsoeffnung);
    }
    /**
     * Get FensterTuerenVerschlossen value
     * @return bool|null
     */
    public function getFensterTuerenVerschlossen()
    {
        return $this->FensterTuerenVerschlossen;
    }
    /**
     * Set FensterTuerenVerschlossen value
     * @param bool $fensterTuerenVerschlossen
     * @return \BiPRO\StructType\CT_SturmElementarSchaden
     */
    public function setFensterTuerenVerschlossen($fensterTuerenVerschlossen = null)
    {
        // validation for constraint: boolean
        if (!is_null($fensterTuerenVerschlossen) && !is_bool($fensterTuerenVerschlossen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fensterTuerenVerschlossen, true), gettype($fensterTuerenVerschlossen)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($fensterTuerenVerschlossen) && !preg_match('/true|false/', $fensterTuerenVerschlossen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($fensterTuerenVerschlossen, true)), __LINE__);
        }
        $this->FensterTuerenVerschlossen = $fensterTuerenVerschlossen;
        return $this;
    }
    /**
     * Get RegenSchmutzEingedrungen value
     * @return bool|null
     */
    public function getRegenSchmutzEingedrungen()
    {
        return $this->RegenSchmutzEingedrungen;
    }
    /**
     * Set RegenSchmutzEingedrungen value
     * @param bool $regenSchmutzEingedrungen
     * @return \BiPRO\StructType\CT_SturmElementarSchaden
     */
    public function setRegenSchmutzEingedrungen($regenSchmutzEingedrungen = null)
    {
        // validation for constraint: boolean
        if (!is_null($regenSchmutzEingedrungen) && !is_bool($regenSchmutzEingedrungen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($regenSchmutzEingedrungen, true), gettype($regenSchmutzEingedrungen)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($regenSchmutzEingedrungen) && !preg_match('/true|false/', $regenSchmutzEingedrungen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($regenSchmutzEingedrungen, true)), __LINE__);
        }
        $this->RegenSchmutzEingedrungen = $regenSchmutzEingedrungen;
        return $this;
    }
    /**
     * Get Eindringungsoeffnung value
     * @return string[]|null
     */
    public function getEindringungsoeffnung()
    {
        return $this->Eindringungsoeffnung;
    }
    /**
     * This method is responsible for validating the values passed to the setEindringungsoeffnung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEindringungsoeffnung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEindringungsoeffnungForArrayConstraintsFromSetEindringungsoeffnung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_SturmElementarSchadenEindringungsoeffnungItem) {
            // validation for constraint: enumeration
            if (!\BiPRO\EnumType\ST_Gebaeudeoeffnung::valueIsValid($cT_SturmElementarSchadenEindringungsoeffnungItem)) {
                $invalidValues[] = is_object($cT_SturmElementarSchadenEindringungsoeffnungItem) ? get_class($cT_SturmElementarSchadenEindringungsoeffnungItem) : sprintf('%s(%s)', gettype($cT_SturmElementarSchadenEindringungsoeffnungItem), var_export($cT_SturmElementarSchadenEindringungsoeffnungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Gebaeudeoeffnung', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \BiPRO\EnumType\ST_Gebaeudeoeffnung::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Eindringungsoeffnung value
     * @uses \BiPRO\EnumType\ST_Gebaeudeoeffnung::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Gebaeudeoeffnung::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $eindringungsoeffnung
     * @return \BiPRO\StructType\CT_SturmElementarSchaden
     */
    public function setEindringungsoeffnung(array $eindringungsoeffnung = array())
    {
        // validation for constraint: array
        if ('' !== ($eindringungsoeffnungArrayErrorMessage = self::validateEindringungsoeffnungForArrayConstraintsFromSetEindringungsoeffnung($eindringungsoeffnung))) {
            throw new \InvalidArgumentException($eindringungsoeffnungArrayErrorMessage, __LINE__);
        }
        $this->Eindringungsoeffnung = $eindringungsoeffnung;
        return $this;
    }
    /**
     * Add item to Eindringungsoeffnung value
     * @uses \BiPRO\EnumType\ST_Gebaeudeoeffnung::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Gebaeudeoeffnung::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \BiPRO\StructType\CT_SturmElementarSchaden
     */
    public function addToEindringungsoeffnung($item)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Gebaeudeoeffnung::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Gebaeudeoeffnung', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \BiPRO\EnumType\ST_Gebaeudeoeffnung::getValidValues())), __LINE__);
        }
        $this->Eindringungsoeffnung[] = $item;
        return $this;
    }
}
