<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Steuerbefreiung StructType
 * Meta information extracted from the WSDL
 * - documentation: Informationen zu einer Steuerbefreiung.
 * @subpackage Structs
 */
class CT_Steuerbefreiung extends CT_Objekt
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Art der Steuerbefreiung.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArtID;
    /**
     * The Gueltigkeitszeitraum
     * Meta information extracted from the WSDL
     * - documentation: Gültigkeitszeitraum der Steuerbefreiung. Der Zeitraum MUSS konkret angegeben werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zeitraum
     */
    public $Gueltigkeitszeitraum;
    /**
     * The Freistellungsbetrag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Freistellungsbetrag
     */
    public $Freistellungsbetrag;
    /**
     * Constructor method for CT_Steuerbefreiung
     * @uses CT_Steuerbefreiung::setArtID()
     * @uses CT_Steuerbefreiung::setGueltigkeitszeitraum()
     * @uses CT_Steuerbefreiung::setFreistellungsbetrag()
     * @param string $artID
     * @param \BiPRO\StructType\CT_Zeitraum $gueltigkeitszeitraum
     * @param \BiPRO\StructType\CT_Freistellungsbetrag $freistellungsbetrag
     */
    public function __construct($artID = null, \BiPRO\StructType\CT_Zeitraum $gueltigkeitszeitraum = null, \BiPRO\StructType\CT_Freistellungsbetrag $freistellungsbetrag = null)
    {
        $this
            ->setArtID($artID)
            ->setGueltigkeitszeitraum($gueltigkeitszeitraum)
            ->setFreistellungsbetrag($freistellungsbetrag);
    }
    /**
     * Get ArtID value
     * @return string|null
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @uses \BiPRO\EnumType\ST_Steuerbefreiungsart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Steuerbefreiungsart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artID
     * @return \BiPRO\StructType\CT_Steuerbefreiung
     */
    public function setArtID($artID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Steuerbefreiungsart::valueIsValid($artID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Steuerbefreiungsart', is_array($artID) ? implode(', ', $artID) : var_export($artID, true), implode(', ', \BiPRO\EnumType\ST_Steuerbefreiungsart::getValidValues())), __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Gueltigkeitszeitraum value
     * @return \BiPRO\StructType\CT_Zeitraum|null
     */
    public function getGueltigkeitszeitraum()
    {
        return $this->Gueltigkeitszeitraum;
    }
    /**
     * Set Gueltigkeitszeitraum value
     * @param \BiPRO\StructType\CT_Zeitraum $gueltigkeitszeitraum
     * @return \BiPRO\StructType\CT_Steuerbefreiung
     */
    public function setGueltigkeitszeitraum(\BiPRO\StructType\CT_Zeitraum $gueltigkeitszeitraum = null)
    {
        $this->Gueltigkeitszeitraum = $gueltigkeitszeitraum;
        return $this;
    }
    /**
     * Get Freistellungsbetrag value
     * @return \BiPRO\StructType\CT_Freistellungsbetrag|null
     */
    public function getFreistellungsbetrag()
    {
        return $this->Freistellungsbetrag;
    }
    /**
     * Set Freistellungsbetrag value
     * @param \BiPRO\StructType\CT_Freistellungsbetrag $freistellungsbetrag
     * @return \BiPRO\StructType\CT_Steuerbefreiung
     */
    public function setFreistellungsbetrag(\BiPRO\StructType\CT_Freistellungsbetrag $freistellungsbetrag = null)
    {
        $this->Freistellungsbetrag = $freistellungsbetrag;
        return $this;
    }
}
