<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_SonstigerGegenstand StructType
 * Meta information extracted from the WSDL
 * - documentation: Ein Gegenstand, der im BiPRO-Datenmodell nicht durch eine eigenständige Klasse spezifiziert ist.
 * @subpackage Structs
 */
class CT_SonstigerGegenstand extends CT_Gegenstand
{
    /**
     * The Identifikationsnummer
     * Meta information extracted from the WSDL
     * - documentation: Nummer, um einen Gegenstand eindeutig identifizieren zu können, z. B. Seriennummer oder Wertsachencodierung.
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Identifikationsnummer;
    /**
     * The Eigentuemer
     * Meta information extracted from the WSDL
     * - documentation: Eigentümer des Gegenstandes.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Eigentuemer[]
     */
    public $Eigentuemer;
    /**
     * Constructor method for CT_SonstigerGegenstand
     * @uses CT_SonstigerGegenstand::setIdentifikationsnummer()
     * @uses CT_SonstigerGegenstand::setEigentuemer()
     * @param string $identifikationsnummer
     * @param \BiPRO\StructType\CT_Eigentuemer[] $eigentuemer
     */
    public function __construct($identifikationsnummer = null, array $eigentuemer = array())
    {
        $this
            ->setIdentifikationsnummer($identifikationsnummer)
            ->setEigentuemer($eigentuemer);
    }
    /**
     * Get Identifikationsnummer value
     * @return string|null
     */
    public function getIdentifikationsnummer()
    {
        return $this->Identifikationsnummer;
    }
    /**
     * Set Identifikationsnummer value
     * @param string $identifikationsnummer
     * @return \BiPRO\StructType\CT_SonstigerGegenstand
     */
    public function setIdentifikationsnummer($identifikationsnummer = null)
    {
        // validation for constraint: string
        if (!is_null($identifikationsnummer) && !is_string($identifikationsnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identifikationsnummer, true), gettype($identifikationsnummer)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($identifikationsnummer) && mb_strlen($identifikationsnummer) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($identifikationsnummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($identifikationsnummer) && mb_strlen($identifikationsnummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($identifikationsnummer)), __LINE__);
        }
        $this->Identifikationsnummer = $identifikationsnummer;
        return $this;
    }
    /**
     * Get Eigentuemer value
     * @return \BiPRO\StructType\CT_Eigentuemer[]|null
     */
    public function getEigentuemer()
    {
        return $this->Eigentuemer;
    }
    /**
     * This method is responsible for validating the values passed to the setEigentuemer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEigentuemer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEigentuemerForArrayConstraintsFromSetEigentuemer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_SonstigerGegenstandEigentuemerItem) {
            // validation for constraint: itemType
            if (!$cT_SonstigerGegenstandEigentuemerItem instanceof \BiPRO\StructType\CT_Eigentuemer) {
                $invalidValues[] = is_object($cT_SonstigerGegenstandEigentuemerItem) ? get_class($cT_SonstigerGegenstandEigentuemerItem) : sprintf('%s(%s)', gettype($cT_SonstigerGegenstandEigentuemerItem), var_export($cT_SonstigerGegenstandEigentuemerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Eigentuemer property can only contain items of type \BiPRO\StructType\CT_Eigentuemer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Eigentuemer value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Eigentuemer[] $eigentuemer
     * @return \BiPRO\StructType\CT_SonstigerGegenstand
     */
    public function setEigentuemer(array $eigentuemer = array())
    {
        // validation for constraint: array
        if ('' !== ($eigentuemerArrayErrorMessage = self::validateEigentuemerForArrayConstraintsFromSetEigentuemer($eigentuemer))) {
            throw new \InvalidArgumentException($eigentuemerArrayErrorMessage, __LINE__);
        }
        $this->Eigentuemer = $eigentuemer;
        return $this;
    }
    /**
     * Add item to Eigentuemer value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Eigentuemer $item
     * @return \BiPRO\StructType\CT_SonstigerGegenstand
     */
    public function addToEigentuemer(\BiPRO\StructType\CT_Eigentuemer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Eigentuemer) {
            throw new \InvalidArgumentException(sprintf('The Eigentuemer property can only contain items of type \BiPRO\StructType\CT_Eigentuemer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Eigentuemer[] = $item;
        return $this;
    }
}
