<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_SelbstgenutztesWohneigentum StructType
 * @subpackage Structs
 */
class CT_SelbstgenutztesWohneigentum extends CT_ZusaetzlichePartnerdaten
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Wohneigentum gemäß GDV-Schlüssel Satzart 0210.050/2 Feld 24
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ArtID;
    /**
     * The VersichertBeiEigenemVU
     * Meta information extracted from the WSDL
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $VersichertBeiEigenemVU;
    /**
     * The WohngebaeudeVU
     * Meta information extracted from the WSDL
     * - documentation: Versicherer, bei dem die Wohngebäudeversicherung gedeckt ist.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Unternehmen
     */
    public $WohngebaeudeVU;
    /**
     * Constructor method for CT_SelbstgenutztesWohneigentum
     * @uses CT_SelbstgenutztesWohneigentum::setArtID()
     * @uses CT_SelbstgenutztesWohneigentum::setVersichertBeiEigenemVU()
     * @uses CT_SelbstgenutztesWohneigentum::setWohngebaeudeVU()
     * @param string $artID
     * @param bool $versichertBeiEigenemVU
     * @param \BiPRO\StructType\CT_Unternehmen $wohngebaeudeVU
     */
    public function __construct($artID = null, $versichertBeiEigenemVU = null, \BiPRO\StructType\CT_Unternehmen $wohngebaeudeVU = null)
    {
        $this
            ->setArtID($artID)
            ->setVersichertBeiEigenemVU($versichertBeiEigenemVU)
            ->setWohngebaeudeVU($wohngebaeudeVU);
    }
    /**
     * Get ArtID value
     * @return string
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @uses \BiPRO\EnumType\ST_Wohneigentum::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Wohneigentum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artID
     * @return \BiPRO\StructType\CT_SelbstgenutztesWohneigentum
     */
    public function setArtID($artID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Wohneigentum::valueIsValid($artID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Wohneigentum', is_array($artID) ? implode(', ', $artID) : var_export($artID, true), implode(', ', \BiPRO\EnumType\ST_Wohneigentum::getValidValues())), __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get VersichertBeiEigenemVU value
     * @return bool|null
     */
    public function getVersichertBeiEigenemVU()
    {
        return $this->VersichertBeiEigenemVU;
    }
    /**
     * Set VersichertBeiEigenemVU value
     * @param bool $versichertBeiEigenemVU
     * @return \BiPRO\StructType\CT_SelbstgenutztesWohneigentum
     */
    public function setVersichertBeiEigenemVU($versichertBeiEigenemVU = null)
    {
        // validation for constraint: boolean
        if (!is_null($versichertBeiEigenemVU) && !is_bool($versichertBeiEigenemVU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($versichertBeiEigenemVU, true), gettype($versichertBeiEigenemVU)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($versichertBeiEigenemVU) && !preg_match('/true|false/', $versichertBeiEigenemVU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($versichertBeiEigenemVU, true)), __LINE__);
        }
        $this->VersichertBeiEigenemVU = $versichertBeiEigenemVU;
        return $this;
    }
    /**
     * Get WohngebaeudeVU value
     * @return \BiPRO\StructType\CT_Unternehmen|null
     */
    public function getWohngebaeudeVU()
    {
        return $this->WohngebaeudeVU;
    }
    /**
     * Set WohngebaeudeVU value
     * @param \BiPRO\StructType\CT_Unternehmen $wohngebaeudeVU
     * @return \BiPRO\StructType\CT_SelbstgenutztesWohneigentum
     */
    public function setWohngebaeudeVU(\BiPRO\StructType\CT_Unternehmen $wohngebaeudeVU = null)
    {
        $this->WohngebaeudeVU = $wohngebaeudeVU;
        return $this;
    }
}
