<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_SchadenobjektTransport StructType
 * Meta information extracted from the WSDL
 * - documentation: Transport, der in einen Schaden involviert ist.
 * @subpackage Structs
 */
class CT_SchadenobjektTransport extends CT_Schadenobjekt
{
    /**
     * The Versicherungsanmeldungsnummer
     * Meta information extracted from the WSDL
     * - documentation: Nummer der Versicherungsanmeldung für den geschädigten Transport (Deklarationsnummer).
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Versicherungsanmeldungsnummer;
    /**
     * The Versicherungsanmeldungsdatum
     * Meta information extracted from the WSDL
     * - documentation: Datum der Versicherungsanmeldung für den geschädigten Transport (Deklarationsdatum). | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Versicherungsanmeldungsdatum;
    /**
     * The SicherungTransportgut
     * Meta information extracted from the WSDL
     * - documentation: Beschreibung der Sicherung des Transportguts, z.B. durch Befestigungen und/oder durch Gurte.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $SicherungTransportgut;
    /**
     * The AeussereBeschaedigung
     * Meta information extracted from the WSDL
     * - documentation: JA = Es liegt eine äußere Beschädigung des Transportgutes vor.NEIN = Es liegt keine äußere Beschädigung des Transportgutes vor.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $AeussereBeschaedigung;
    /**
     * The BeschaedigungVerpackung
     * Meta information extracted from the WSDL
     * - documentation: JA = Die Verpackung ist beschädigt.NEIN = Die Verpackung ist nicht beschädigt.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $BeschaedigungVerpackung;
    /**
     * The BeschaedigungVerpackungBeschreibung
     * Meta information extracted from the WSDL
     * - documentation: Beschreibung der Beschädigungen an der Verpackung.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $BeschaedigungVerpackungBeschreibung;
    /**
     * The BeiAblieferungFestgestellt
     * Meta information extracted from the WSDL
     * - documentation: JA = Der Schaden wurde vor oder bei der Ablieferung festgestellt.NEIN = Der Schaden wurde erst nach der Ablieferung festgestellt.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $BeiAblieferungFestgestellt;
    /**
     * The VomFrachtfuehrerBestaetigt
     * Meta information extracted from the WSDL
     * - documentation: JA = Der Schaden wurde vom Frachtführer bestätigt.NEIN = Der Schaden wurde vom Frachtführer nicht bestätigt.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $VomFrachtfuehrerBestaetigt;
    /**
     * The SchriftlicheBestaetigung
     * Meta information extracted from the WSDL
     * - documentation: JA = Eine schriftliche Bestätigung des Frachtführers liegt vor.NEIN = Eine schriftliche Bestätigung des Frachtführers liegt nicht vor.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $SchriftlicheBestaetigung;
    /**
     * The BestaetigungBeigefuegt
     * Meta information extracted from the WSDL
     * - documentation: JA = Die schriftliche Bestätigung des Frachtführers ist beigefügt.NEIN = Die schriftliche Bestätigung des Frachtführers wird nachgereicht.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $BestaetigungBeigefuegt;
    /**
     * The VerantwortlichkeitDritter
     * Meta information extracted from the WSDL
     * - documentation: JA = Es liegt eine Verantwortlichkeit Dritter vor.NEIN = Es liegt keine Verantwortlichkeit Dritter vor.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $VerantwortlichkeitDritter;
    /**
     * The VorgehenHaftbarmachung
     * Meta information extracted from the WSDL
     * - documentation: Beschreibung des Vorgehens, mit dem der Verantwortliche haftbar gemacht wurde.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VorgehenHaftbarmachung;
    /**
     * The HaftungschreibenBeigefuegt
     * Meta information extracted from the WSDL
     * - documentation: JA = Das Haftungschreiben ist beigefügt.NEIN = Das Haftungschreiben muss nachgereicht werden.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $HaftungschreibenBeigefuegt;
    /**
     * The Transportfahrzeug
     * Meta information extracted from the WSDL
     * - documentation: Referenz auf das Fahrzeug, das zum Zeitpunkt des Schadens genutzt wurde.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Transportfahrzeug
     */
    public $Transportfahrzeug;
    /**
     * The Verkehrstraeger
     * Meta information extracted from the WSDL
     * - documentation: Verkehrsträger des geschädigten Transports.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Verkehrstraeger[]
     */
    public $Verkehrstraeger;
    /**
     * The EntladenDurch
     * Meta information extracted from the WSDL
     * - documentation: Partner, der die Entladung des geschädigten Transports vorgenommen hat.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_EntladenDurch
     */
    public $EntladenDurch;
    /**
     * The SicherungDurch
     * Meta information extracted from the WSDL
     * - documentation: Partner, der die Ladungssicherung des geschädigten Transports vorgenommen hat.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_SicherungDurch
     */
    public $SicherungDurch;
    /**
     * Constructor method for CT_SchadenobjektTransport
     * @uses CT_SchadenobjektTransport::setVersicherungsanmeldungsnummer()
     * @uses CT_SchadenobjektTransport::setVersicherungsanmeldungsdatum()
     * @uses CT_SchadenobjektTransport::setSicherungTransportgut()
     * @uses CT_SchadenobjektTransport::setAeussereBeschaedigung()
     * @uses CT_SchadenobjektTransport::setBeschaedigungVerpackung()
     * @uses CT_SchadenobjektTransport::setBeschaedigungVerpackungBeschreibung()
     * @uses CT_SchadenobjektTransport::setBeiAblieferungFestgestellt()
     * @uses CT_SchadenobjektTransport::setVomFrachtfuehrerBestaetigt()
     * @uses CT_SchadenobjektTransport::setSchriftlicheBestaetigung()
     * @uses CT_SchadenobjektTransport::setBestaetigungBeigefuegt()
     * @uses CT_SchadenobjektTransport::setVerantwortlichkeitDritter()
     * @uses CT_SchadenobjektTransport::setVorgehenHaftbarmachung()
     * @uses CT_SchadenobjektTransport::setHaftungschreibenBeigefuegt()
     * @uses CT_SchadenobjektTransport::setTransportfahrzeug()
     * @uses CT_SchadenobjektTransport::setVerkehrstraeger()
     * @uses CT_SchadenobjektTransport::setEntladenDurch()
     * @uses CT_SchadenobjektTransport::setSicherungDurch()
     * @param string $versicherungsanmeldungsnummer
     * @param string $versicherungsanmeldungsdatum
     * @param string $sicherungTransportgut
     * @param bool $aeussereBeschaedigung
     * @param bool $beschaedigungVerpackung
     * @param string $beschaedigungVerpackungBeschreibung
     * @param bool $beiAblieferungFestgestellt
     * @param bool $vomFrachtfuehrerBestaetigt
     * @param bool $schriftlicheBestaetigung
     * @param bool $bestaetigungBeigefuegt
     * @param bool $verantwortlichkeitDritter
     * @param string $vorgehenHaftbarmachung
     * @param bool $haftungschreibenBeigefuegt
     * @param \BiPRO\StructType\CT_Transportfahrzeug $transportfahrzeug
     * @param \BiPRO\StructType\CT_Verkehrstraeger[] $verkehrstraeger
     * @param \BiPRO\StructType\CT_EntladenDurch $entladenDurch
     * @param \BiPRO\StructType\CT_SicherungDurch $sicherungDurch
     */
    public function __construct($versicherungsanmeldungsnummer = null, $versicherungsanmeldungsdatum = null, $sicherungTransportgut = null, $aeussereBeschaedigung = null, $beschaedigungVerpackung = null, $beschaedigungVerpackungBeschreibung = null, $beiAblieferungFestgestellt = null, $vomFrachtfuehrerBestaetigt = null, $schriftlicheBestaetigung = null, $bestaetigungBeigefuegt = null, $verantwortlichkeitDritter = null, $vorgehenHaftbarmachung = null, $haftungschreibenBeigefuegt = null, \BiPRO\StructType\CT_Transportfahrzeug $transportfahrzeug = null, array $verkehrstraeger = array(), \BiPRO\StructType\CT_EntladenDurch $entladenDurch = null, \BiPRO\StructType\CT_SicherungDurch $sicherungDurch = null)
    {
        $this
            ->setVersicherungsanmeldungsnummer($versicherungsanmeldungsnummer)
            ->setVersicherungsanmeldungsdatum($versicherungsanmeldungsdatum)
            ->setSicherungTransportgut($sicherungTransportgut)
            ->setAeussereBeschaedigung($aeussereBeschaedigung)
            ->setBeschaedigungVerpackung($beschaedigungVerpackung)
            ->setBeschaedigungVerpackungBeschreibung($beschaedigungVerpackungBeschreibung)
            ->setBeiAblieferungFestgestellt($beiAblieferungFestgestellt)
            ->setVomFrachtfuehrerBestaetigt($vomFrachtfuehrerBestaetigt)
            ->setSchriftlicheBestaetigung($schriftlicheBestaetigung)
            ->setBestaetigungBeigefuegt($bestaetigungBeigefuegt)
            ->setVerantwortlichkeitDritter($verantwortlichkeitDritter)
            ->setVorgehenHaftbarmachung($vorgehenHaftbarmachung)
            ->setHaftungschreibenBeigefuegt($haftungschreibenBeigefuegt)
            ->setTransportfahrzeug($transportfahrzeug)
            ->setVerkehrstraeger($verkehrstraeger)
            ->setEntladenDurch($entladenDurch)
            ->setSicherungDurch($sicherungDurch);
    }
    /**
     * Get Versicherungsanmeldungsnummer value
     * @return string|null
     */
    public function getVersicherungsanmeldungsnummer()
    {
        return $this->Versicherungsanmeldungsnummer;
    }
    /**
     * Set Versicherungsanmeldungsnummer value
     * @param string $versicherungsanmeldungsnummer
     * @return \BiPRO\StructType\CT_SchadenobjektTransport
     */
    public function setVersicherungsanmeldungsnummer($versicherungsanmeldungsnummer = null)
    {
        // validation for constraint: string
        if (!is_null($versicherungsanmeldungsnummer) && !is_string($versicherungsanmeldungsnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($versicherungsanmeldungsnummer, true), gettype($versicherungsanmeldungsnummer)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($versicherungsanmeldungsnummer) && mb_strlen($versicherungsanmeldungsnummer) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($versicherungsanmeldungsnummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($versicherungsanmeldungsnummer) && mb_strlen($versicherungsanmeldungsnummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($versicherungsanmeldungsnummer)), __LINE__);
        }
        $this->Versicherungsanmeldungsnummer = $versicherungsanmeldungsnummer;
        return $this;
    }
    /**
     * Get Versicherungsanmeldungsdatum value
     * @return string|null
     */
    public function getVersicherungsanmeldungsdatum()
    {
        return $this->Versicherungsanmeldungsdatum;
    }
    /**
     * Set Versicherungsanmeldungsdatum value
     * @param string $versicherungsanmeldungsdatum
     * @return \BiPRO\StructType\CT_SchadenobjektTransport
     */
    public function setVersicherungsanmeldungsdatum($versicherungsanmeldungsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($versicherungsanmeldungsdatum) && !is_string($versicherungsanmeldungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($versicherungsanmeldungsdatum, true), gettype($versicherungsanmeldungsdatum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($versicherungsanmeldungsdatum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $versicherungsanmeldungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($versicherungsanmeldungsdatum, true)), __LINE__);
        }
        $this->Versicherungsanmeldungsdatum = $versicherungsanmeldungsdatum;
        return $this;
    }
    /**
     * Get SicherungTransportgut value
     * @return string|null
     */
    public function getSicherungTransportgut()
    {
        return $this->SicherungTransportgut;
    }
    /**
     * Set SicherungTransportgut value
     * @param string $sicherungTransportgut
     * @return \BiPRO\StructType\CT_SchadenobjektTransport
     */
    public function setSicherungTransportgut($sicherungTransportgut = null)
    {
        // validation for constraint: string
        if (!is_null($sicherungTransportgut) && !is_string($sicherungTransportgut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sicherungTransportgut, true), gettype($sicherungTransportgut)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($sicherungTransportgut) && mb_strlen($sicherungTransportgut) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($sicherungTransportgut)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($sicherungTransportgut) && mb_strlen($sicherungTransportgut) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($sicherungTransportgut)), __LINE__);
        }
        $this->SicherungTransportgut = $sicherungTransportgut;
        return $this;
    }
    /**
     * Get AeussereBeschaedigung value
     * @return bool|null
     */
    public function getAeussereBeschaedigung()
    {
        return $this->AeussereBeschaedigung;
    }
    /**
     * Set AeussereBeschaedigung value
     * @param bool $aeussereBeschaedigung
     * @return \BiPRO\StructType\CT_SchadenobjektTransport
     */
    public function setAeussereBeschaedigung($aeussereBeschaedigung = null)
    {
        // validation for constraint: boolean
        if (!is_null($aeussereBeschaedigung) && !is_bool($aeussereBeschaedigung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aeussereBeschaedigung, true), gettype($aeussereBeschaedigung)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($aeussereBeschaedigung) && !preg_match('/true|false/', $aeussereBeschaedigung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($aeussereBeschaedigung, true)), __LINE__);
        }
        $this->AeussereBeschaedigung = $aeussereBeschaedigung;
        return $this;
    }
    /**
     * Get BeschaedigungVerpackung value
     * @return bool|null
     */
    public function getBeschaedigungVerpackung()
    {
        return $this->BeschaedigungVerpackung;
    }
    /**
     * Set BeschaedigungVerpackung value
     * @param bool $beschaedigungVerpackung
     * @return \BiPRO\StructType\CT_SchadenobjektTransport
     */
    public function setBeschaedigungVerpackung($beschaedigungVerpackung = null)
    {
        // validation for constraint: boolean
        if (!is_null($beschaedigungVerpackung) && !is_bool($beschaedigungVerpackung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($beschaedigungVerpackung, true), gettype($beschaedigungVerpackung)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($beschaedigungVerpackung) && !preg_match('/true|false/', $beschaedigungVerpackung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($beschaedigungVerpackung, true)), __LINE__);
        }
        $this->BeschaedigungVerpackung = $beschaedigungVerpackung;
        return $this;
    }
    /**
     * Get BeschaedigungVerpackungBeschreibung value
     * @return string|null
     */
    public function getBeschaedigungVerpackungBeschreibung()
    {
        return $this->BeschaedigungVerpackungBeschreibung;
    }
    /**
     * Set BeschaedigungVerpackungBeschreibung value
     * @param string $beschaedigungVerpackungBeschreibung
     * @return \BiPRO\StructType\CT_SchadenobjektTransport
     */
    public function setBeschaedigungVerpackungBeschreibung($beschaedigungVerpackungBeschreibung = null)
    {
        // validation for constraint: string
        if (!is_null($beschaedigungVerpackungBeschreibung) && !is_string($beschaedigungVerpackungBeschreibung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beschaedigungVerpackungBeschreibung, true), gettype($beschaedigungVerpackungBeschreibung)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($beschaedigungVerpackungBeschreibung) && mb_strlen($beschaedigungVerpackungBeschreibung) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($beschaedigungVerpackungBeschreibung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($beschaedigungVerpackungBeschreibung) && mb_strlen($beschaedigungVerpackungBeschreibung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($beschaedigungVerpackungBeschreibung)), __LINE__);
        }
        $this->BeschaedigungVerpackungBeschreibung = $beschaedigungVerpackungBeschreibung;
        return $this;
    }
    /**
     * Get BeiAblieferungFestgestellt value
     * @return bool|null
     */
    public function getBeiAblieferungFestgestellt()
    {
        return $this->BeiAblieferungFestgestellt;
    }
    /**
     * Set BeiAblieferungFestgestellt value
     * @param bool $beiAblieferungFestgestellt
     * @return \BiPRO\StructType\CT_SchadenobjektTransport
     */
    public function setBeiAblieferungFestgestellt($beiAblieferungFestgestellt = null)
    {
        // validation for constraint: boolean
        if (!is_null($beiAblieferungFestgestellt) && !is_bool($beiAblieferungFestgestellt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($beiAblieferungFestgestellt, true), gettype($beiAblieferungFestgestellt)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($beiAblieferungFestgestellt) && !preg_match('/true|false/', $beiAblieferungFestgestellt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($beiAblieferungFestgestellt, true)), __LINE__);
        }
        $this->BeiAblieferungFestgestellt = $beiAblieferungFestgestellt;
        return $this;
    }
    /**
     * Get VomFrachtfuehrerBestaetigt value
     * @return bool|null
     */
    public function getVomFrachtfuehrerBestaetigt()
    {
        return $this->VomFrachtfuehrerBestaetigt;
    }
    /**
     * Set VomFrachtfuehrerBestaetigt value
     * @param bool $vomFrachtfuehrerBestaetigt
     * @return \BiPRO\StructType\CT_SchadenobjektTransport
     */
    public function setVomFrachtfuehrerBestaetigt($vomFrachtfuehrerBestaetigt = null)
    {
        // validation for constraint: boolean
        if (!is_null($vomFrachtfuehrerBestaetigt) && !is_bool($vomFrachtfuehrerBestaetigt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vomFrachtfuehrerBestaetigt, true), gettype($vomFrachtfuehrerBestaetigt)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($vomFrachtfuehrerBestaetigt) && !preg_match('/true|false/', $vomFrachtfuehrerBestaetigt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($vomFrachtfuehrerBestaetigt, true)), __LINE__);
        }
        $this->VomFrachtfuehrerBestaetigt = $vomFrachtfuehrerBestaetigt;
        return $this;
    }
    /**
     * Get SchriftlicheBestaetigung value
     * @return bool|null
     */
    public function getSchriftlicheBestaetigung()
    {
        return $this->SchriftlicheBestaetigung;
    }
    /**
     * Set SchriftlicheBestaetigung value
     * @param bool $schriftlicheBestaetigung
     * @return \BiPRO\StructType\CT_SchadenobjektTransport
     */
    public function setSchriftlicheBestaetigung($schriftlicheBestaetigung = null)
    {
        // validation for constraint: boolean
        if (!is_null($schriftlicheBestaetigung) && !is_bool($schriftlicheBestaetigung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($schriftlicheBestaetigung, true), gettype($schriftlicheBestaetigung)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($schriftlicheBestaetigung) && !preg_match('/true|false/', $schriftlicheBestaetigung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($schriftlicheBestaetigung, true)), __LINE__);
        }
        $this->SchriftlicheBestaetigung = $schriftlicheBestaetigung;
        return $this;
    }
    /**
     * Get BestaetigungBeigefuegt value
     * @return bool|null
     */
    public function getBestaetigungBeigefuegt()
    {
        return $this->BestaetigungBeigefuegt;
    }
    /**
     * Set BestaetigungBeigefuegt value
     * @param bool $bestaetigungBeigefuegt
     * @return \BiPRO\StructType\CT_SchadenobjektTransport
     */
    public function setBestaetigungBeigefuegt($bestaetigungBeigefuegt = null)
    {
        // validation for constraint: boolean
        if (!is_null($bestaetigungBeigefuegt) && !is_bool($bestaetigungBeigefuegt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bestaetigungBeigefuegt, true), gettype($bestaetigungBeigefuegt)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($bestaetigungBeigefuegt) && !preg_match('/true|false/', $bestaetigungBeigefuegt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($bestaetigungBeigefuegt, true)), __LINE__);
        }
        $this->BestaetigungBeigefuegt = $bestaetigungBeigefuegt;
        return $this;
    }
    /**
     * Get VerantwortlichkeitDritter value
     * @return bool|null
     */
    public function getVerantwortlichkeitDritter()
    {
        return $this->VerantwortlichkeitDritter;
    }
    /**
     * Set VerantwortlichkeitDritter value
     * @param bool $verantwortlichkeitDritter
     * @return \BiPRO\StructType\CT_SchadenobjektTransport
     */
    public function setVerantwortlichkeitDritter($verantwortlichkeitDritter = null)
    {
        // validation for constraint: boolean
        if (!is_null($verantwortlichkeitDritter) && !is_bool($verantwortlichkeitDritter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($verantwortlichkeitDritter, true), gettype($verantwortlichkeitDritter)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($verantwortlichkeitDritter) && !preg_match('/true|false/', $verantwortlichkeitDritter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($verantwortlichkeitDritter, true)), __LINE__);
        }
        $this->VerantwortlichkeitDritter = $verantwortlichkeitDritter;
        return $this;
    }
    /**
     * Get VorgehenHaftbarmachung value
     * @return string|null
     */
    public function getVorgehenHaftbarmachung()
    {
        return $this->VorgehenHaftbarmachung;
    }
    /**
     * Set VorgehenHaftbarmachung value
     * @uses \BiPRO\EnumType\ST_AnspruchErhoben::valueIsValid()
     * @uses \BiPRO\EnumType\ST_AnspruchErhoben::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vorgehenHaftbarmachung
     * @return \BiPRO\StructType\CT_SchadenobjektTransport
     */
    public function setVorgehenHaftbarmachung($vorgehenHaftbarmachung = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_AnspruchErhoben::valueIsValid($vorgehenHaftbarmachung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_AnspruchErhoben', is_array($vorgehenHaftbarmachung) ? implode(', ', $vorgehenHaftbarmachung) : var_export($vorgehenHaftbarmachung, true), implode(', ', \BiPRO\EnumType\ST_AnspruchErhoben::getValidValues())), __LINE__);
        }
        $this->VorgehenHaftbarmachung = $vorgehenHaftbarmachung;
        return $this;
    }
    /**
     * Get HaftungschreibenBeigefuegt value
     * @return bool|null
     */
    public function getHaftungschreibenBeigefuegt()
    {
        return $this->HaftungschreibenBeigefuegt;
    }
    /**
     * Set HaftungschreibenBeigefuegt value
     * @param bool $haftungschreibenBeigefuegt
     * @return \BiPRO\StructType\CT_SchadenobjektTransport
     */
    public function setHaftungschreibenBeigefuegt($haftungschreibenBeigefuegt = null)
    {
        // validation for constraint: boolean
        if (!is_null($haftungschreibenBeigefuegt) && !is_bool($haftungschreibenBeigefuegt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($haftungschreibenBeigefuegt, true), gettype($haftungschreibenBeigefuegt)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($haftungschreibenBeigefuegt) && !preg_match('/true|false/', $haftungschreibenBeigefuegt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($haftungschreibenBeigefuegt, true)), __LINE__);
        }
        $this->HaftungschreibenBeigefuegt = $haftungschreibenBeigefuegt;
        return $this;
    }
    /**
     * Get Transportfahrzeug value
     * @return \BiPRO\StructType\CT_Transportfahrzeug|null
     */
    public function getTransportfahrzeug()
    {
        return $this->Transportfahrzeug;
    }
    /**
     * Set Transportfahrzeug value
     * @param \BiPRO\StructType\CT_Transportfahrzeug $transportfahrzeug
     * @return \BiPRO\StructType\CT_SchadenobjektTransport
     */
    public function setTransportfahrzeug(\BiPRO\StructType\CT_Transportfahrzeug $transportfahrzeug = null)
    {
        $this->Transportfahrzeug = $transportfahrzeug;
        return $this;
    }
    /**
     * Get Verkehrstraeger value
     * @return \BiPRO\StructType\CT_Verkehrstraeger[]|null
     */
    public function getVerkehrstraeger()
    {
        return $this->Verkehrstraeger;
    }
    /**
     * This method is responsible for validating the values passed to the setVerkehrstraeger method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVerkehrstraeger method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVerkehrstraegerForArrayConstraintsFromSetVerkehrstraeger(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_SchadenobjektTransportVerkehrstraegerItem) {
            // validation for constraint: itemType
            if (!$cT_SchadenobjektTransportVerkehrstraegerItem instanceof \BiPRO\StructType\CT_Verkehrstraeger) {
                $invalidValues[] = is_object($cT_SchadenobjektTransportVerkehrstraegerItem) ? get_class($cT_SchadenobjektTransportVerkehrstraegerItem) : sprintf('%s(%s)', gettype($cT_SchadenobjektTransportVerkehrstraegerItem), var_export($cT_SchadenobjektTransportVerkehrstraegerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Verkehrstraeger property can only contain items of type \BiPRO\StructType\CT_Verkehrstraeger, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Verkehrstraeger value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Verkehrstraeger[] $verkehrstraeger
     * @return \BiPRO\StructType\CT_SchadenobjektTransport
     */
    public function setVerkehrstraeger(array $verkehrstraeger = array())
    {
        // validation for constraint: array
        if ('' !== ($verkehrstraegerArrayErrorMessage = self::validateVerkehrstraegerForArrayConstraintsFromSetVerkehrstraeger($verkehrstraeger))) {
            throw new \InvalidArgumentException($verkehrstraegerArrayErrorMessage, __LINE__);
        }
        $this->Verkehrstraeger = $verkehrstraeger;
        return $this;
    }
    /**
     * Add item to Verkehrstraeger value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Verkehrstraeger $item
     * @return \BiPRO\StructType\CT_SchadenobjektTransport
     */
    public function addToVerkehrstraeger(\BiPRO\StructType\CT_Verkehrstraeger $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Verkehrstraeger) {
            throw new \InvalidArgumentException(sprintf('The Verkehrstraeger property can only contain items of type \BiPRO\StructType\CT_Verkehrstraeger, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Verkehrstraeger[] = $item;
        return $this;
    }
    /**
     * Get EntladenDurch value
     * @return \BiPRO\StructType\CT_EntladenDurch|null
     */
    public function getEntladenDurch()
    {
        return $this->EntladenDurch;
    }
    /**
     * Set EntladenDurch value
     * @param \BiPRO\StructType\CT_EntladenDurch $entladenDurch
     * @return \BiPRO\StructType\CT_SchadenobjektTransport
     */
    public function setEntladenDurch(\BiPRO\StructType\CT_EntladenDurch $entladenDurch = null)
    {
        $this->EntladenDurch = $entladenDurch;
        return $this;
    }
    /**
     * Get SicherungDurch value
     * @return \BiPRO\StructType\CT_SicherungDurch|null
     */
    public function getSicherungDurch()
    {
        return $this->SicherungDurch;
    }
    /**
     * Set SicherungDurch value
     * @param \BiPRO\StructType\CT_SicherungDurch $sicherungDurch
     * @return \BiPRO\StructType\CT_SchadenobjektTransport
     */
    public function setSicherungDurch(\BiPRO\StructType\CT_SicherungDurch $sicherungDurch = null)
    {
        $this->SicherungDurch = $sicherungDurch;
        return $this;
    }
}
