<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_SchadenobjektGebaeude StructType
 * Meta information extracted from the WSDL
 * - documentation: Gebäude, das in einen Schaden involviert ist.
 * @subpackage Structs
 */
class CT_SchadenobjektGebaeude extends CT_Schadenobjekt
{
    /**
     * The WohnenBeeintraechtigt
     * Meta information extracted from the WSDL
     * - documentation: JA = Das Wohnen im geschädigten Gebäude ist beeinträchtigt.NEIN = Das Wohnen im geschädigten Gebäude ist nicht beeinträchtigt
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $WohnenBeeintraechtigt;
    /**
     * The WohnenBeeintraechtigtStaerke
     * Meta information extracted from the WSDL
     * - documentation: Stärke der Beeinträchtigung des Wohnens im geschädigten Gebäude.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WohnenBeeintraechtigtStaerke;
    /**
     * The SicherheitBeeintraechtigt
     * Meta information extracted from the WSDL
     * - documentation: JA = Die Sicherheit des geschädigten Gebäudes ist beeinträchtigt.NEIN = Die Sicherheit des geschädigten Gebäudes ist nicht beeinträchtigt.Sicherheit bedeutet hier z. B. Standsicherheit aber auch Explosionsgefahr etc.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $SicherheitBeeintraechtigt;
    /**
     * The EindringenMoeglich
     * Meta information extracted from the WSDL
     * - documentation: JA = Ein Eindringen in das geschädigte Gebäude ist möglich.NEIN = Ein Eindringen in das geschädigte Gebäude ist nicht möglich
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $EindringenMoeglich;
    /**
     * The ArbeitsablaufBeeintraechtigt
     * Meta information extracted from the WSDL
     * - documentation: JA = Der Arbeitsablauf im geschädigten Gebäude ist beeinträchtigt.NEIN = Der Arbeitsablauf im geschädigten Gebäude ist nicht beeinträchtigt.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $ArbeitsablaufBeeintraechtigt;
    /**
     * The BetriebsunterbrechungBesteht
     * Meta information extracted from the WSDL
     * - documentation: JA = Die Betriebsunterbrechung dauert an.NEIN = sonst
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $BetriebsunterbrechungBesteht;
    /**
     * The BeeintraechtigungBeschreibung
     * Meta information extracted from the WSDL
     * - documentation: Beschreibung der Art und Dauer der Beeinträchtigungen bei der Nutzung des geschädigten Gebäudes.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $BeeintraechtigungBeschreibung;
    /**
     * The BetroffeneBodenflaeche
     * Meta information extracted from the WSDL
     * - documentation: Die physische Ausdehnung der vom Schaden betroffenen Bodenfläche.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Groesse
     */
    public $BetroffeneBodenflaeche;
    /**
     * The BetroffeneDeckenflaeche
     * Meta information extracted from the WSDL
     * - documentation: Die physische Ausdehnung der vom Schaden betroffenen Deckenfläche.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Groesse
     */
    public $BetroffeneDeckenflaeche;
    /**
     * The BetroffeneWandflaeche
     * Meta information extracted from the WSDL
     * - documentation: Die physische Ausdehnung der vom Schaden betroffenen Wandfläche.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Groesse
     */
    public $BetroffeneWandflaeche;
    /**
     * The BetroffeneFlaeche
     * Meta information extracted from the WSDL
     * - documentation: Die physische Ausdehnung der vom Schaden betroffenen Fläche.Die Assoziation BetroffeneFlaeche DARF NUR genutzt werden, wenn die Assoziationen BetroffeneBodenflaeche, BetroffeneWandflaeche und BetroffeneDeckenflaeche nicht genutzt
     * werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Groesse
     */
    public $BetroffeneFlaeche;
    /**
     * Constructor method for CT_SchadenobjektGebaeude
     * @uses CT_SchadenobjektGebaeude::setWohnenBeeintraechtigt()
     * @uses CT_SchadenobjektGebaeude::setWohnenBeeintraechtigtStaerke()
     * @uses CT_SchadenobjektGebaeude::setSicherheitBeeintraechtigt()
     * @uses CT_SchadenobjektGebaeude::setEindringenMoeglich()
     * @uses CT_SchadenobjektGebaeude::setArbeitsablaufBeeintraechtigt()
     * @uses CT_SchadenobjektGebaeude::setBetriebsunterbrechungBesteht()
     * @uses CT_SchadenobjektGebaeude::setBeeintraechtigungBeschreibung()
     * @uses CT_SchadenobjektGebaeude::setBetroffeneBodenflaeche()
     * @uses CT_SchadenobjektGebaeude::setBetroffeneDeckenflaeche()
     * @uses CT_SchadenobjektGebaeude::setBetroffeneWandflaeche()
     * @uses CT_SchadenobjektGebaeude::setBetroffeneFlaeche()
     * @param bool $wohnenBeeintraechtigt
     * @param string $wohnenBeeintraechtigtStaerke
     * @param bool $sicherheitBeeintraechtigt
     * @param bool $eindringenMoeglich
     * @param bool $arbeitsablaufBeeintraechtigt
     * @param bool $betriebsunterbrechungBesteht
     * @param string $beeintraechtigungBeschreibung
     * @param \BiPRO\StructType\CT_Groesse $betroffeneBodenflaeche
     * @param \BiPRO\StructType\CT_Groesse $betroffeneDeckenflaeche
     * @param \BiPRO\StructType\CT_Groesse $betroffeneWandflaeche
     * @param \BiPRO\StructType\CT_Groesse $betroffeneFlaeche
     */
    public function __construct($wohnenBeeintraechtigt = null, $wohnenBeeintraechtigtStaerke = null, $sicherheitBeeintraechtigt = null, $eindringenMoeglich = null, $arbeitsablaufBeeintraechtigt = null, $betriebsunterbrechungBesteht = null, $beeintraechtigungBeschreibung = null, \BiPRO\StructType\CT_Groesse $betroffeneBodenflaeche = null, \BiPRO\StructType\CT_Groesse $betroffeneDeckenflaeche = null, \BiPRO\StructType\CT_Groesse $betroffeneWandflaeche = null, \BiPRO\StructType\CT_Groesse $betroffeneFlaeche = null)
    {
        $this
            ->setWohnenBeeintraechtigt($wohnenBeeintraechtigt)
            ->setWohnenBeeintraechtigtStaerke($wohnenBeeintraechtigtStaerke)
            ->setSicherheitBeeintraechtigt($sicherheitBeeintraechtigt)
            ->setEindringenMoeglich($eindringenMoeglich)
            ->setArbeitsablaufBeeintraechtigt($arbeitsablaufBeeintraechtigt)
            ->setBetriebsunterbrechungBesteht($betriebsunterbrechungBesteht)
            ->setBeeintraechtigungBeschreibung($beeintraechtigungBeschreibung)
            ->setBetroffeneBodenflaeche($betroffeneBodenflaeche)
            ->setBetroffeneDeckenflaeche($betroffeneDeckenflaeche)
            ->setBetroffeneWandflaeche($betroffeneWandflaeche)
            ->setBetroffeneFlaeche($betroffeneFlaeche);
    }
    /**
     * Get WohnenBeeintraechtigt value
     * @return bool|null
     */
    public function getWohnenBeeintraechtigt()
    {
        return $this->WohnenBeeintraechtigt;
    }
    /**
     * Set WohnenBeeintraechtigt value
     * @param bool $wohnenBeeintraechtigt
     * @return \BiPRO\StructType\CT_SchadenobjektGebaeude
     */
    public function setWohnenBeeintraechtigt($wohnenBeeintraechtigt = null)
    {
        // validation for constraint: boolean
        if (!is_null($wohnenBeeintraechtigt) && !is_bool($wohnenBeeintraechtigt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($wohnenBeeintraechtigt, true), gettype($wohnenBeeintraechtigt)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($wohnenBeeintraechtigt) && !preg_match('/true|false/', $wohnenBeeintraechtigt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($wohnenBeeintraechtigt, true)), __LINE__);
        }
        $this->WohnenBeeintraechtigt = $wohnenBeeintraechtigt;
        return $this;
    }
    /**
     * Get WohnenBeeintraechtigtStaerke value
     * @return string|null
     */
    public function getWohnenBeeintraechtigtStaerke()
    {
        return $this->WohnenBeeintraechtigtStaerke;
    }
    /**
     * Set WohnenBeeintraechtigtStaerke value
     * @uses \BiPRO\EnumType\ST_Staerkegrad::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Staerkegrad::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $wohnenBeeintraechtigtStaerke
     * @return \BiPRO\StructType\CT_SchadenobjektGebaeude
     */
    public function setWohnenBeeintraechtigtStaerke($wohnenBeeintraechtigtStaerke = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Staerkegrad::valueIsValid($wohnenBeeintraechtigtStaerke)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Staerkegrad', is_array($wohnenBeeintraechtigtStaerke) ? implode(', ', $wohnenBeeintraechtigtStaerke) : var_export($wohnenBeeintraechtigtStaerke, true), implode(', ', \BiPRO\EnumType\ST_Staerkegrad::getValidValues())), __LINE__);
        }
        $this->WohnenBeeintraechtigtStaerke = $wohnenBeeintraechtigtStaerke;
        return $this;
    }
    /**
     * Get SicherheitBeeintraechtigt value
     * @return bool|null
     */
    public function getSicherheitBeeintraechtigt()
    {
        return $this->SicherheitBeeintraechtigt;
    }
    /**
     * Set SicherheitBeeintraechtigt value
     * @param bool $sicherheitBeeintraechtigt
     * @return \BiPRO\StructType\CT_SchadenobjektGebaeude
     */
    public function setSicherheitBeeintraechtigt($sicherheitBeeintraechtigt = null)
    {
        // validation for constraint: boolean
        if (!is_null($sicherheitBeeintraechtigt) && !is_bool($sicherheitBeeintraechtigt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sicherheitBeeintraechtigt, true), gettype($sicherheitBeeintraechtigt)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($sicherheitBeeintraechtigt) && !preg_match('/true|false/', $sicherheitBeeintraechtigt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($sicherheitBeeintraechtigt, true)), __LINE__);
        }
        $this->SicherheitBeeintraechtigt = $sicherheitBeeintraechtigt;
        return $this;
    }
    /**
     * Get EindringenMoeglich value
     * @return bool|null
     */
    public function getEindringenMoeglich()
    {
        return $this->EindringenMoeglich;
    }
    /**
     * Set EindringenMoeglich value
     * @param bool $eindringenMoeglich
     * @return \BiPRO\StructType\CT_SchadenobjektGebaeude
     */
    public function setEindringenMoeglich($eindringenMoeglich = null)
    {
        // validation for constraint: boolean
        if (!is_null($eindringenMoeglich) && !is_bool($eindringenMoeglich)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eindringenMoeglich, true), gettype($eindringenMoeglich)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($eindringenMoeglich) && !preg_match('/true|false/', $eindringenMoeglich)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($eindringenMoeglich, true)), __LINE__);
        }
        $this->EindringenMoeglich = $eindringenMoeglich;
        return $this;
    }
    /**
     * Get ArbeitsablaufBeeintraechtigt value
     * @return bool|null
     */
    public function getArbeitsablaufBeeintraechtigt()
    {
        return $this->ArbeitsablaufBeeintraechtigt;
    }
    /**
     * Set ArbeitsablaufBeeintraechtigt value
     * @param bool $arbeitsablaufBeeintraechtigt
     * @return \BiPRO\StructType\CT_SchadenobjektGebaeude
     */
    public function setArbeitsablaufBeeintraechtigt($arbeitsablaufBeeintraechtigt = null)
    {
        // validation for constraint: boolean
        if (!is_null($arbeitsablaufBeeintraechtigt) && !is_bool($arbeitsablaufBeeintraechtigt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($arbeitsablaufBeeintraechtigt, true), gettype($arbeitsablaufBeeintraechtigt)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($arbeitsablaufBeeintraechtigt) && !preg_match('/true|false/', $arbeitsablaufBeeintraechtigt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($arbeitsablaufBeeintraechtigt, true)), __LINE__);
        }
        $this->ArbeitsablaufBeeintraechtigt = $arbeitsablaufBeeintraechtigt;
        return $this;
    }
    /**
     * Get BetriebsunterbrechungBesteht value
     * @return bool|null
     */
    public function getBetriebsunterbrechungBesteht()
    {
        return $this->BetriebsunterbrechungBesteht;
    }
    /**
     * Set BetriebsunterbrechungBesteht value
     * @param bool $betriebsunterbrechungBesteht
     * @return \BiPRO\StructType\CT_SchadenobjektGebaeude
     */
    public function setBetriebsunterbrechungBesteht($betriebsunterbrechungBesteht = null)
    {
        // validation for constraint: boolean
        if (!is_null($betriebsunterbrechungBesteht) && !is_bool($betriebsunterbrechungBesteht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($betriebsunterbrechungBesteht, true), gettype($betriebsunterbrechungBesteht)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($betriebsunterbrechungBesteht) && !preg_match('/true|false/', $betriebsunterbrechungBesteht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($betriebsunterbrechungBesteht, true)), __LINE__);
        }
        $this->BetriebsunterbrechungBesteht = $betriebsunterbrechungBesteht;
        return $this;
    }
    /**
     * Get BeeintraechtigungBeschreibung value
     * @return string|null
     */
    public function getBeeintraechtigungBeschreibung()
    {
        return $this->BeeintraechtigungBeschreibung;
    }
    /**
     * Set BeeintraechtigungBeschreibung value
     * @param string $beeintraechtigungBeschreibung
     * @return \BiPRO\StructType\CT_SchadenobjektGebaeude
     */
    public function setBeeintraechtigungBeschreibung($beeintraechtigungBeschreibung = null)
    {
        // validation for constraint: string
        if (!is_null($beeintraechtigungBeschreibung) && !is_string($beeintraechtigungBeschreibung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beeintraechtigungBeschreibung, true), gettype($beeintraechtigungBeschreibung)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($beeintraechtigungBeschreibung) && mb_strlen($beeintraechtigungBeschreibung) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($beeintraechtigungBeschreibung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($beeintraechtigungBeschreibung) && mb_strlen($beeintraechtigungBeschreibung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($beeintraechtigungBeschreibung)), __LINE__);
        }
        $this->BeeintraechtigungBeschreibung = $beeintraechtigungBeschreibung;
        return $this;
    }
    /**
     * Get BetroffeneBodenflaeche value
     * @return \BiPRO\StructType\CT_Groesse|null
     */
    public function getBetroffeneBodenflaeche()
    {
        return $this->BetroffeneBodenflaeche;
    }
    /**
     * Set BetroffeneBodenflaeche value
     * @param \BiPRO\StructType\CT_Groesse $betroffeneBodenflaeche
     * @return \BiPRO\StructType\CT_SchadenobjektGebaeude
     */
    public function setBetroffeneBodenflaeche(\BiPRO\StructType\CT_Groesse $betroffeneBodenflaeche = null)
    {
        $this->BetroffeneBodenflaeche = $betroffeneBodenflaeche;
        return $this;
    }
    /**
     * Get BetroffeneDeckenflaeche value
     * @return \BiPRO\StructType\CT_Groesse|null
     */
    public function getBetroffeneDeckenflaeche()
    {
        return $this->BetroffeneDeckenflaeche;
    }
    /**
     * Set BetroffeneDeckenflaeche value
     * @param \BiPRO\StructType\CT_Groesse $betroffeneDeckenflaeche
     * @return \BiPRO\StructType\CT_SchadenobjektGebaeude
     */
    public function setBetroffeneDeckenflaeche(\BiPRO\StructType\CT_Groesse $betroffeneDeckenflaeche = null)
    {
        $this->BetroffeneDeckenflaeche = $betroffeneDeckenflaeche;
        return $this;
    }
    /**
     * Get BetroffeneWandflaeche value
     * @return \BiPRO\StructType\CT_Groesse|null
     */
    public function getBetroffeneWandflaeche()
    {
        return $this->BetroffeneWandflaeche;
    }
    /**
     * Set BetroffeneWandflaeche value
     * @param \BiPRO\StructType\CT_Groesse $betroffeneWandflaeche
     * @return \BiPRO\StructType\CT_SchadenobjektGebaeude
     */
    public function setBetroffeneWandflaeche(\BiPRO\StructType\CT_Groesse $betroffeneWandflaeche = null)
    {
        $this->BetroffeneWandflaeche = $betroffeneWandflaeche;
        return $this;
    }
    /**
     * Get BetroffeneFlaeche value
     * @return \BiPRO\StructType\CT_Groesse|null
     */
    public function getBetroffeneFlaeche()
    {
        return $this->BetroffeneFlaeche;
    }
    /**
     * Set BetroffeneFlaeche value
     * @param \BiPRO\StructType\CT_Groesse $betroffeneFlaeche
     * @return \BiPRO\StructType\CT_SchadenobjektGebaeude
     */
    public function setBetroffeneFlaeche(\BiPRO\StructType\CT_Groesse $betroffeneFlaeche = null)
    {
        $this->BetroffeneFlaeche = $betroffeneFlaeche;
        return $this;
    }
}
