<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_SchadenobjektAnlage StructType
 * Meta information extracted from the WSDL
 * - documentation: Anlage, die in einen Schaden involviert ist.
 * @subpackage Structs
 */
class CT_SchadenobjektAnlage extends CT_Schadenobjekt
{
    /**
     * The BereitsEingebaut
     * Meta information extracted from the WSDL
     * - documentation: JA = Die geschädigte Anlage war bereits eingebaut.NEIN = Die geschädigte Anlage war noch nicht eingebaut.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $BereitsEingebaut;
    /**
     * The VoraussichtlicheAusfallzeit
     * Meta information extracted from the WSDL
     * - documentation: Die voraussichtliche Ausfallzeit der geschädigten Anlage. Ist kein Beginn angegeben, MUSS das Schadendatum angenommen werden. Beginn und Ende MÜSSEN mindestens als Datum übermittelt werden. Wird eine Zeitangabe übermittelt, MUSS
     * diese mit Stunden und Minuten angegeben werden. Eine Zeitzone DARF übermittelt werden. Fehlt die Zeitzone, MUSS die am angegebenen Datum in Deutschland gültige Zeitzone angenommen werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zeitraum2
     */
    public $VoraussichtlicheAusfallzeit;
    /**
     * The Provisorium
     * Meta information extracted from the WSDL
     * - documentation: Dauer, für die ein Provisorium installiert wird.Der Zeitraum MUSS durch die Attribute Beginn und Ende spezifiziert werden. Beginn und Ende MÜSSEN mit einem vollständigen Datum definiert sein. Die Angabe einer Zeit oder einer
     * Zeitzone DARF NICHT erfolgen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zeitraum2
     */
    public $Provisorium;
    /**
     * Constructor method for CT_SchadenobjektAnlage
     * @uses CT_SchadenobjektAnlage::setBereitsEingebaut()
     * @uses CT_SchadenobjektAnlage::setVoraussichtlicheAusfallzeit()
     * @uses CT_SchadenobjektAnlage::setProvisorium()
     * @param bool $bereitsEingebaut
     * @param \BiPRO\StructType\CT_Zeitraum2 $voraussichtlicheAusfallzeit
     * @param \BiPRO\StructType\CT_Zeitraum2 $provisorium
     */
    public function __construct($bereitsEingebaut = null, \BiPRO\StructType\CT_Zeitraum2 $voraussichtlicheAusfallzeit = null, \BiPRO\StructType\CT_Zeitraum2 $provisorium = null)
    {
        $this
            ->setBereitsEingebaut($bereitsEingebaut)
            ->setVoraussichtlicheAusfallzeit($voraussichtlicheAusfallzeit)
            ->setProvisorium($provisorium);
    }
    /**
     * Get BereitsEingebaut value
     * @return bool|null
     */
    public function getBereitsEingebaut()
    {
        return $this->BereitsEingebaut;
    }
    /**
     * Set BereitsEingebaut value
     * @param bool $bereitsEingebaut
     * @return \BiPRO\StructType\CT_SchadenobjektAnlage
     */
    public function setBereitsEingebaut($bereitsEingebaut = null)
    {
        // validation for constraint: boolean
        if (!is_null($bereitsEingebaut) && !is_bool($bereitsEingebaut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bereitsEingebaut, true), gettype($bereitsEingebaut)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($bereitsEingebaut) && !preg_match('/true|false/', $bereitsEingebaut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($bereitsEingebaut, true)), __LINE__);
        }
        $this->BereitsEingebaut = $bereitsEingebaut;
        return $this;
    }
    /**
     * Get VoraussichtlicheAusfallzeit value
     * @return \BiPRO\StructType\CT_Zeitraum2|null
     */
    public function getVoraussichtlicheAusfallzeit()
    {
        return $this->VoraussichtlicheAusfallzeit;
    }
    /**
     * Set VoraussichtlicheAusfallzeit value
     * @param \BiPRO\StructType\CT_Zeitraum2 $voraussichtlicheAusfallzeit
     * @return \BiPRO\StructType\CT_SchadenobjektAnlage
     */
    public function setVoraussichtlicheAusfallzeit(\BiPRO\StructType\CT_Zeitraum2 $voraussichtlicheAusfallzeit = null)
    {
        $this->VoraussichtlicheAusfallzeit = $voraussichtlicheAusfallzeit;
        return $this;
    }
    /**
     * Get Provisorium value
     * @return \BiPRO\StructType\CT_Zeitraum2|null
     */
    public function getProvisorium()
    {
        return $this->Provisorium;
    }
    /**
     * Set Provisorium value
     * @param \BiPRO\StructType\CT_Zeitraum2 $provisorium
     * @return \BiPRO\StructType\CT_SchadenobjektAnlage
     */
    public function setProvisorium(\BiPRO\StructType\CT_Zeitraum2 $provisorium = null)
    {
        $this->Provisorium = $provisorium;
        return $this;
    }
}
