<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Schadenobjekt StructType
 * Meta information extracted from the WSDL
 * - documentation: Gegenstand, der in einen Schaden involviert ist.
 * @subpackage Structs
 */
class CT_Schadenobjekt extends CT_Gegenstandsrolle
{
    /**
     * The Identifikation
     * Meta information extracted from the WSDL
     * - documentation: Identifikation des Schadenobjekts, z. B. laufende Nummer im Schadenverzeichnis.
     * - base: xsd:string
     * - maxLength: 17
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Identifikation;
    /**
     * The Bezeichnung
     * Meta information extracted from the WSDL
     * - documentation: Bezeichnung des Schadenobjekts.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Bezeichnung;
    /**
     * The AnzahlGleichartigerObjekte
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der gleichartigen Objekte, die in ihrer Gesamtheit das Schadenobjekt darstellen.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $AnzahlGleichartigerObjekte;
    /**
     * The Vertragsposition
     * Meta information extracted from the WSDL
     * - documentation: Referenz des Schadensobjekts auf die Position dieses Objekts im Versicherungsvertrag.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Vertragsposition;
    /**
     * The Anschaffungsdatum
     * Meta information extracted from the WSDL
     * - documentation: Datum der Anschaffung des Schadenobjekts. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Anschaffungsdatum;
    /**
     * The BelegeVorhanden
     * Meta information extracted from the WSDL
     * - documentation: JA = Über den Wert des Schadenobjekts sind Belege vorhanden.NEIN = Über den Wert des Schadenobjekts sind keine Belege vorhanden.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $BelegeVorhanden;
    /**
     * The Entschaedigungsrelevant
     * Meta information extracted from the WSDL
     * - documentation: JA = Dieses Schadenobjekt ist relevant für die Entschädigungsberechnung.NEIN = Dieses Schadenobjekt ist nicht relevant für die Entschädigungsberechnung.Falls das Attribut nicht belegt ist, MUSS es als mit "Ja" belegt
     * interpretiert werden.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Entschaedigungsrelevant;
    /**
     * The Zustand
     * Meta information extracted from the WSDL
     * - documentation: Zustand des Schadenobjekts.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Zustand;
    /**
     * The Beschaedigung
     * Meta information extracted from the WSDL
     * - documentation: Beschreibung von Art und Umfang der Beschädigung des Schadenobjekts
     * - base: xsd:string
     * - maxLength: 1000
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Beschaedigung;
    /**
     * The Reparaturmoeglichkeit
     * Meta information extracted from the WSDL
     * - documentation: Beschreibung der Reparaturmöglichkeit oder Begründung, warum Reparatur nicht möglich.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Reparaturmoeglichkeit;
    /**
     * The VorschaedenVorhanden
     * Meta information extracted from the WSDL
     * - documentation: JA = Das Schadenobjekt hatte mindestens einen Vorschaden.NEIN = Das Schadenobjekt hatte keinen Vorschaden.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $VorschaedenVorhanden;
    /**
     * The VorschaedenBeschreibung
     * Meta information extracted from the WSDL
     * - documentation: Beschreibung der Vorschäden zu diesem Schadenobjekt.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $VorschaedenBeschreibung;
    /**
     * The VorschaedenRepariert
     * Meta information extracted from the WSDL
     * - documentation: JA = Alle Vorschäden wurden repariert.NEIN = Ein oder mehrere Vorschäden wurden nicht repariert.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $VorschaedenRepariert;
    /**
     * The BesitzverhaeltnisVP
     * Meta information extracted from the WSDL
     * - documentation: JA = Die beschädigte Sache wurde geliehen, gemietet, gepachtet, verwahrt, geleast oder ohne Erlaubnis erlangt.NEIN = sonst
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $BesitzverhaeltnisVP;
    /**
     * The ArtBesitzverhaeltnisVP
     * Meta information extracted from the WSDL
     * - documentation: Art des Besitzverhältnisses von der versicherten Person an der beschädigten Sache.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArtBesitzverhaeltnisVP;
    /**
     * The Sicherungsabtretung
     * Meta information extracted from the WSDL
     * - documentation: JA = Für das Schadenobjekt liegt eine Sicherungsabtretung vor.NEIN = Für das Schadenobjekt liegt keine Sicherungsabtretung vor.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Sicherungsabtretung;
    /**
     * The Leistung
     * Meta information extracted from the WSDL
     * - documentation: Leistung im Rahmen der Schadenbeseitigung zu dem Schadenobjekt (Inkludiert auch immatrielle Schadenbeseitigung wie z.B. Verdienstausfall).
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Leistung[]
     */
    public $Leistung;
    /**
     * The VoraussichtlicheReparaturdauer
     * Meta information extracted from the WSDL
     * - documentation: Voraussichtliche Dauer der Reparatur. Die Angabe MUSS mit einer der folgenden Alternativen erfolgen:a) Konkreter Zeitraum mit Beginn- und EndedatumDer Zeitraum MUSS durch die Attribute Beginn und Ende spezifiziert werden. Beginn und
     * Ende MÜSSEN mindestens als Datum übermittelt werden. Wird eine Zeitangabe übermittelt, MUSS diese mit Stunden und Minuten angegeben werden. Eine Zeitzone DARF übermittelt werden. Fehlt die Zeitzone, MUSS die am angegebenen Datum in Deutschland
     * gültige Zeitzone angenommen werden.b) Nur Endedatum, falls die Reparatur bereits begonnen hatDer Zeitraum MUSS durch das Attribut Ende spezifiziert werden. Ende MUSS mindestens als Datum übermittelt werden. Wird eine Zeitangabe übermittelt, MUSS
     * diese mit Stunden und Minuten angegeben werden. Eine Zeitzone DARF übermittelt werden. Fehlt die Zeitzone, MUSS die am angegebenen Datum in Deutschland gültige Zeitzone angenommen werden.c) DauerDie Dauer MUSS durch die Attribute AnzahlTage
     * und/oder AnzahlMonate und/oder AnzahlJahre spezifiziert werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zeitraum2
     */
    public $VoraussichtlicheReparaturdauer;
    /**
     * The SchadenZuObjekt
     * Meta information extracted from the WSDL
     * - documentation: Detailinformationen zu dem Schadenobjekt in Abhängigkeit von der Art des Schadens.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_SchadenZuObjekt[]
     */
    public $SchadenZuObjekt;
    /**
     * The TatsaechlicheReparaturdauer
     * Meta information extracted from the WSDL
     * - documentation: Tatsächliche Dauer der Reparatur. Die Angabe MUSS mit einer der folgenden Alternativen erfolgen:a) Konkreter Zeitraum mit Beginn- und EndedatumDer Zeitraum MUSS durch die Attribute Beginn und Ende spezifiziert werden. Beginn und
     * Ende MÜSSEN mindestens als Datum übermittelt werden. Wird eine Zeitangabe übermittelt, MUSS diese mit Stunden und Minuten angegeben werden. Eine Zeitzone DARF übermittelt werden. Fehlt die Zeitzone, MUSS die am angegebenen Datum in Deutschland
     * gültige Zeitzone angenommen werden. b) Nur Endedatum, falls die Reparatur bereits begonnen hatDer Zeitraum MUSS durch das Attribut Ende spezifiziert werden. Ende MUSS mindestens als Datum übermittelt werden. Wird eine Zeitangabe übermittelt, MUSS
     * diese mit Stunden und Minuten angegeben werden. Eine Zeitzone DARF übermittelt werden. Fehlt die Zeitzone, MUSS die am angegebenen Datum in Deutschland gültige Zeitzone angenommen werden. c) DauerDie Dauer MUSS durch die Attribute AnzahlTage
     * und/oder AnzahlMonate und/oder AnzahlJahre spezifiziert werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zeitraum2
     */
    public $TatsaechlicheReparaturdauer;
    /**
     * The Schadenhoehe
     * Meta information extracted from the WSDL
     * - documentation: Höhe des Schadens an dem geschädigten Objekt als Geldwert.Diese DARF auf allen Ebenen angegeben werden. Es gibt keine Summierungsregel. Normalerweise erfolgt die Angabe auf der größtmöglichen Detailtiefe.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Schadenhoehe[]
     */
    public $Schadenhoehe;
    /**
     * The Schadenmanagement
     * Meta information extracted from the WSDL
     * - documentation: Informationen zum Management des Schadens an dem geschädigten Objekt (z.B. Werkstattsteuerung, Handwerkerservice).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Schadenmanagement
     */
    public $Schadenmanagement;
    /**
     * The Alter
     * Meta information extracted from the WSDL
     * - documentation: Alter des Schadenobjekts.Es MUSS in Anzahl Jahre und/oder Anzahl Monate angegeben werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zeitraum2
     */
    public $Alter;
    /**
     * The Besichtigung
     * Meta information extracted from the WSDL
     * - documentation: Besichtigung des Schadenobjekts.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Besichtigung[]
     */
    public $Besichtigung;
    /**
     * Constructor method for CT_Schadenobjekt
     * @uses CT_Schadenobjekt::setIdentifikation()
     * @uses CT_Schadenobjekt::setBezeichnung()
     * @uses CT_Schadenobjekt::setAnzahlGleichartigerObjekte()
     * @uses CT_Schadenobjekt::setVertragsposition()
     * @uses CT_Schadenobjekt::setAnschaffungsdatum()
     * @uses CT_Schadenobjekt::setBelegeVorhanden()
     * @uses CT_Schadenobjekt::setEntschaedigungsrelevant()
     * @uses CT_Schadenobjekt::setZustand()
     * @uses CT_Schadenobjekt::setBeschaedigung()
     * @uses CT_Schadenobjekt::setReparaturmoeglichkeit()
     * @uses CT_Schadenobjekt::setVorschaedenVorhanden()
     * @uses CT_Schadenobjekt::setVorschaedenBeschreibung()
     * @uses CT_Schadenobjekt::setVorschaedenRepariert()
     * @uses CT_Schadenobjekt::setBesitzverhaeltnisVP()
     * @uses CT_Schadenobjekt::setArtBesitzverhaeltnisVP()
     * @uses CT_Schadenobjekt::setSicherungsabtretung()
     * @uses CT_Schadenobjekt::setLeistung()
     * @uses CT_Schadenobjekt::setVoraussichtlicheReparaturdauer()
     * @uses CT_Schadenobjekt::setSchadenZuObjekt()
     * @uses CT_Schadenobjekt::setTatsaechlicheReparaturdauer()
     * @uses CT_Schadenobjekt::setSchadenhoehe()
     * @uses CT_Schadenobjekt::setSchadenmanagement()
     * @uses CT_Schadenobjekt::setAlter()
     * @uses CT_Schadenobjekt::setBesichtigung()
     * @param string $identifikation
     * @param string $bezeichnung
     * @param float $anzahlGleichartigerObjekte
     * @param string $vertragsposition
     * @param string $anschaffungsdatum
     * @param bool $belegeVorhanden
     * @param bool $entschaedigungsrelevant
     * @param string $zustand
     * @param string $beschaedigung
     * @param string $reparaturmoeglichkeit
     * @param bool $vorschaedenVorhanden
     * @param string $vorschaedenBeschreibung
     * @param bool $vorschaedenRepariert
     * @param bool $besitzverhaeltnisVP
     * @param string $artBesitzverhaeltnisVP
     * @param bool $sicherungsabtretung
     * @param \BiPRO\StructType\CT_Leistung[] $leistung
     * @param \BiPRO\StructType\CT_Zeitraum2 $voraussichtlicheReparaturdauer
     * @param \BiPRO\StructType\CT_SchadenZuObjekt[] $schadenZuObjekt
     * @param \BiPRO\StructType\CT_Zeitraum2 $tatsaechlicheReparaturdauer
     * @param \BiPRO\StructType\CT_Schadenhoehe[] $schadenhoehe
     * @param \BiPRO\StructType\CT_Schadenmanagement $schadenmanagement
     * @param \BiPRO\StructType\CT_Zeitraum2 $alter
     * @param \BiPRO\StructType\CT_Besichtigung[] $besichtigung
     */
    public function __construct($identifikation = null, $bezeichnung = null, $anzahlGleichartigerObjekte = null, $vertragsposition = null, $anschaffungsdatum = null, $belegeVorhanden = null, $entschaedigungsrelevant = null, $zustand = null, $beschaedigung = null, $reparaturmoeglichkeit = null, $vorschaedenVorhanden = null, $vorschaedenBeschreibung = null, $vorschaedenRepariert = null, $besitzverhaeltnisVP = null, $artBesitzverhaeltnisVP = null, $sicherungsabtretung = null, array $leistung = array(), \BiPRO\StructType\CT_Zeitraum2 $voraussichtlicheReparaturdauer = null, array $schadenZuObjekt = array(), \BiPRO\StructType\CT_Zeitraum2 $tatsaechlicheReparaturdauer = null, array $schadenhoehe = array(), \BiPRO\StructType\CT_Schadenmanagement $schadenmanagement = null, \BiPRO\StructType\CT_Zeitraum2 $alter = null, array $besichtigung = array())
    {
        $this
            ->setIdentifikation($identifikation)
            ->setBezeichnung($bezeichnung)
            ->setAnzahlGleichartigerObjekte($anzahlGleichartigerObjekte)
            ->setVertragsposition($vertragsposition)
            ->setAnschaffungsdatum($anschaffungsdatum)
            ->setBelegeVorhanden($belegeVorhanden)
            ->setEntschaedigungsrelevant($entschaedigungsrelevant)
            ->setZustand($zustand)
            ->setBeschaedigung($beschaedigung)
            ->setReparaturmoeglichkeit($reparaturmoeglichkeit)
            ->setVorschaedenVorhanden($vorschaedenVorhanden)
            ->setVorschaedenBeschreibung($vorschaedenBeschreibung)
            ->setVorschaedenRepariert($vorschaedenRepariert)
            ->setBesitzverhaeltnisVP($besitzverhaeltnisVP)
            ->setArtBesitzverhaeltnisVP($artBesitzverhaeltnisVP)
            ->setSicherungsabtretung($sicherungsabtretung)
            ->setLeistung($leistung)
            ->setVoraussichtlicheReparaturdauer($voraussichtlicheReparaturdauer)
            ->setSchadenZuObjekt($schadenZuObjekt)
            ->setTatsaechlicheReparaturdauer($tatsaechlicheReparaturdauer)
            ->setSchadenhoehe($schadenhoehe)
            ->setSchadenmanagement($schadenmanagement)
            ->setAlter($alter)
            ->setBesichtigung($besichtigung);
    }
    /**
     * Get Identifikation value
     * @return string|null
     */
    public function getIdentifikation()
    {
        return $this->Identifikation;
    }
    /**
     * Set Identifikation value
     * @param string $identifikation
     * @return \BiPRO\StructType\CT_Schadenobjekt
     */
    public function setIdentifikation($identifikation = null)
    {
        // validation for constraint: string
        if (!is_null($identifikation) && !is_string($identifikation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identifikation, true), gettype($identifikation)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($identifikation) && mb_strlen($identifikation) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($identifikation)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($identifikation) && mb_strlen($identifikation) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($identifikation)), __LINE__);
        }
        $this->Identifikation = $identifikation;
        return $this;
    }
    /**
     * Get Bezeichnung value
     * @return string|null
     */
    public function getBezeichnung()
    {
        return $this->Bezeichnung;
    }
    /**
     * Set Bezeichnung value
     * @param string $bezeichnung
     * @return \BiPRO\StructType\CT_Schadenobjekt
     */
    public function setBezeichnung($bezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($bezeichnung) && !is_string($bezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bezeichnung, true), gettype($bezeichnung)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($bezeichnung) && mb_strlen($bezeichnung) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($bezeichnung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($bezeichnung) && mb_strlen($bezeichnung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($bezeichnung)), __LINE__);
        }
        $this->Bezeichnung = $bezeichnung;
        return $this;
    }
    /**
     * Get AnzahlGleichartigerObjekte value
     * @return float|null
     */
    public function getAnzahlGleichartigerObjekte()
    {
        return $this->AnzahlGleichartigerObjekte;
    }
    /**
     * Set AnzahlGleichartigerObjekte value
     * @param float $anzahlGleichartigerObjekte
     * @return \BiPRO\StructType\CT_Schadenobjekt
     */
    public function setAnzahlGleichartigerObjekte($anzahlGleichartigerObjekte = null)
    {
        // validation for constraint: float
        if (!is_null($anzahlGleichartigerObjekte) && !(is_float($anzahlGleichartigerObjekte) || is_numeric($anzahlGleichartigerObjekte))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($anzahlGleichartigerObjekte, true), gettype($anzahlGleichartigerObjekte)), __LINE__);
        }
        $this->AnzahlGleichartigerObjekte = $anzahlGleichartigerObjekte;
        return $this;
    }
    /**
     * Get Vertragsposition value
     * @return string|null
     */
    public function getVertragsposition()
    {
        return $this->Vertragsposition;
    }
    /**
     * Set Vertragsposition value
     * @param string $vertragsposition
     * @return \BiPRO\StructType\CT_Schadenobjekt
     */
    public function setVertragsposition($vertragsposition = null)
    {
        // validation for constraint: string
        if (!is_null($vertragsposition) && !is_string($vertragsposition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vertragsposition, true), gettype($vertragsposition)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($vertragsposition) && mb_strlen($vertragsposition) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($vertragsposition)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($vertragsposition) && mb_strlen($vertragsposition) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($vertragsposition)), __LINE__);
        }
        $this->Vertragsposition = $vertragsposition;
        return $this;
    }
    /**
     * Get Anschaffungsdatum value
     * @return string|null
     */
    public function getAnschaffungsdatum()
    {
        return $this->Anschaffungsdatum;
    }
    /**
     * Set Anschaffungsdatum value
     * @param string $anschaffungsdatum
     * @return \BiPRO\StructType\CT_Schadenobjekt
     */
    public function setAnschaffungsdatum($anschaffungsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($anschaffungsdatum) && !is_string($anschaffungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($anschaffungsdatum, true), gettype($anschaffungsdatum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($anschaffungsdatum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $anschaffungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($anschaffungsdatum, true)), __LINE__);
        }
        $this->Anschaffungsdatum = $anschaffungsdatum;
        return $this;
    }
    /**
     * Get BelegeVorhanden value
     * @return bool|null
     */
    public function getBelegeVorhanden()
    {
        return $this->BelegeVorhanden;
    }
    /**
     * Set BelegeVorhanden value
     * @param bool $belegeVorhanden
     * @return \BiPRO\StructType\CT_Schadenobjekt
     */
    public function setBelegeVorhanden($belegeVorhanden = null)
    {
        // validation for constraint: boolean
        if (!is_null($belegeVorhanden) && !is_bool($belegeVorhanden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($belegeVorhanden, true), gettype($belegeVorhanden)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($belegeVorhanden) && !preg_match('/true|false/', $belegeVorhanden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($belegeVorhanden, true)), __LINE__);
        }
        $this->BelegeVorhanden = $belegeVorhanden;
        return $this;
    }
    /**
     * Get Entschaedigungsrelevant value
     * @return bool|null
     */
    public function getEntschaedigungsrelevant()
    {
        return $this->Entschaedigungsrelevant;
    }
    /**
     * Set Entschaedigungsrelevant value
     * @param bool $entschaedigungsrelevant
     * @return \BiPRO\StructType\CT_Schadenobjekt
     */
    public function setEntschaedigungsrelevant($entschaedigungsrelevant = null)
    {
        // validation for constraint: boolean
        if (!is_null($entschaedigungsrelevant) && !is_bool($entschaedigungsrelevant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($entschaedigungsrelevant, true), gettype($entschaedigungsrelevant)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($entschaedigungsrelevant) && !preg_match('/true|false/', $entschaedigungsrelevant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($entschaedigungsrelevant, true)), __LINE__);
        }
        $this->Entschaedigungsrelevant = $entschaedigungsrelevant;
        return $this;
    }
    /**
     * Get Zustand value
     * @return string|null
     */
    public function getZustand()
    {
        return $this->Zustand;
    }
    /**
     * Set Zustand value
     * @uses \BiPRO\EnumType\ST_ZustandSchadenobjekt::valueIsValid()
     * @uses \BiPRO\EnumType\ST_ZustandSchadenobjekt::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zustand
     * @return \BiPRO\StructType\CT_Schadenobjekt
     */
    public function setZustand($zustand = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_ZustandSchadenobjekt::valueIsValid($zustand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_ZustandSchadenobjekt', is_array($zustand) ? implode(', ', $zustand) : var_export($zustand, true), implode(', ', \BiPRO\EnumType\ST_ZustandSchadenobjekt::getValidValues())), __LINE__);
        }
        $this->Zustand = $zustand;
        return $this;
    }
    /**
     * Get Beschaedigung value
     * @return string|null
     */
    public function getBeschaedigung()
    {
        return $this->Beschaedigung;
    }
    /**
     * Set Beschaedigung value
     * @param string $beschaedigung
     * @return \BiPRO\StructType\CT_Schadenobjekt
     */
    public function setBeschaedigung($beschaedigung = null)
    {
        // validation for constraint: string
        if (!is_null($beschaedigung) && !is_string($beschaedigung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beschaedigung, true), gettype($beschaedigung)), __LINE__);
        }
        // validation for constraint: maxLength(1000)
        if (!is_null($beschaedigung) && mb_strlen($beschaedigung) > 1000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1000', mb_strlen($beschaedigung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($beschaedigung) && mb_strlen($beschaedigung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($beschaedigung)), __LINE__);
        }
        $this->Beschaedigung = $beschaedigung;
        return $this;
    }
    /**
     * Get Reparaturmoeglichkeit value
     * @return string|null
     */
    public function getReparaturmoeglichkeit()
    {
        return $this->Reparaturmoeglichkeit;
    }
    /**
     * Set Reparaturmoeglichkeit value
     * @param string $reparaturmoeglichkeit
     * @return \BiPRO\StructType\CT_Schadenobjekt
     */
    public function setReparaturmoeglichkeit($reparaturmoeglichkeit = null)
    {
        // validation for constraint: string
        if (!is_null($reparaturmoeglichkeit) && !is_string($reparaturmoeglichkeit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reparaturmoeglichkeit, true), gettype($reparaturmoeglichkeit)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($reparaturmoeglichkeit) && mb_strlen($reparaturmoeglichkeit) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($reparaturmoeglichkeit)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($reparaturmoeglichkeit) && mb_strlen($reparaturmoeglichkeit) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($reparaturmoeglichkeit)), __LINE__);
        }
        $this->Reparaturmoeglichkeit = $reparaturmoeglichkeit;
        return $this;
    }
    /**
     * Get VorschaedenVorhanden value
     * @return bool|null
     */
    public function getVorschaedenVorhanden()
    {
        return $this->VorschaedenVorhanden;
    }
    /**
     * Set VorschaedenVorhanden value
     * @param bool $vorschaedenVorhanden
     * @return \BiPRO\StructType\CT_Schadenobjekt
     */
    public function setVorschaedenVorhanden($vorschaedenVorhanden = null)
    {
        // validation for constraint: boolean
        if (!is_null($vorschaedenVorhanden) && !is_bool($vorschaedenVorhanden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vorschaedenVorhanden, true), gettype($vorschaedenVorhanden)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($vorschaedenVorhanden) && !preg_match('/true|false/', $vorschaedenVorhanden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($vorschaedenVorhanden, true)), __LINE__);
        }
        $this->VorschaedenVorhanden = $vorschaedenVorhanden;
        return $this;
    }
    /**
     * Get VorschaedenBeschreibung value
     * @return string|null
     */
    public function getVorschaedenBeschreibung()
    {
        return $this->VorschaedenBeschreibung;
    }
    /**
     * Set VorschaedenBeschreibung value
     * @param string $vorschaedenBeschreibung
     * @return \BiPRO\StructType\CT_Schadenobjekt
     */
    public function setVorschaedenBeschreibung($vorschaedenBeschreibung = null)
    {
        // validation for constraint: string
        if (!is_null($vorschaedenBeschreibung) && !is_string($vorschaedenBeschreibung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vorschaedenBeschreibung, true), gettype($vorschaedenBeschreibung)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($vorschaedenBeschreibung) && mb_strlen($vorschaedenBeschreibung) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($vorschaedenBeschreibung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($vorschaedenBeschreibung) && mb_strlen($vorschaedenBeschreibung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($vorschaedenBeschreibung)), __LINE__);
        }
        $this->VorschaedenBeschreibung = $vorschaedenBeschreibung;
        return $this;
    }
    /**
     * Get VorschaedenRepariert value
     * @return bool|null
     */
    public function getVorschaedenRepariert()
    {
        return $this->VorschaedenRepariert;
    }
    /**
     * Set VorschaedenRepariert value
     * @param bool $vorschaedenRepariert
     * @return \BiPRO\StructType\CT_Schadenobjekt
     */
    public function setVorschaedenRepariert($vorschaedenRepariert = null)
    {
        // validation for constraint: boolean
        if (!is_null($vorschaedenRepariert) && !is_bool($vorschaedenRepariert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vorschaedenRepariert, true), gettype($vorschaedenRepariert)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($vorschaedenRepariert) && !preg_match('/true|false/', $vorschaedenRepariert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($vorschaedenRepariert, true)), __LINE__);
        }
        $this->VorschaedenRepariert = $vorschaedenRepariert;
        return $this;
    }
    /**
     * Get BesitzverhaeltnisVP value
     * @return bool|null
     */
    public function getBesitzverhaeltnisVP()
    {
        return $this->BesitzverhaeltnisVP;
    }
    /**
     * Set BesitzverhaeltnisVP value
     * @param bool $besitzverhaeltnisVP
     * @return \BiPRO\StructType\CT_Schadenobjekt
     */
    public function setBesitzverhaeltnisVP($besitzverhaeltnisVP = null)
    {
        // validation for constraint: boolean
        if (!is_null($besitzverhaeltnisVP) && !is_bool($besitzverhaeltnisVP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($besitzverhaeltnisVP, true), gettype($besitzverhaeltnisVP)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($besitzverhaeltnisVP) && !preg_match('/true|false/', $besitzverhaeltnisVP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($besitzverhaeltnisVP, true)), __LINE__);
        }
        $this->BesitzverhaeltnisVP = $besitzverhaeltnisVP;
        return $this;
    }
    /**
     * Get ArtBesitzverhaeltnisVP value
     * @return string|null
     */
    public function getArtBesitzverhaeltnisVP()
    {
        return $this->ArtBesitzverhaeltnisVP;
    }
    /**
     * Set ArtBesitzverhaeltnisVP value
     * @uses \BiPRO\EnumType\ST_Besitzverhaeltnis::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Besitzverhaeltnis::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artBesitzverhaeltnisVP
     * @return \BiPRO\StructType\CT_Schadenobjekt
     */
    public function setArtBesitzverhaeltnisVP($artBesitzverhaeltnisVP = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Besitzverhaeltnis::valueIsValid($artBesitzverhaeltnisVP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Besitzverhaeltnis', is_array($artBesitzverhaeltnisVP) ? implode(', ', $artBesitzverhaeltnisVP) : var_export($artBesitzverhaeltnisVP, true), implode(', ', \BiPRO\EnumType\ST_Besitzverhaeltnis::getValidValues())), __LINE__);
        }
        $this->ArtBesitzverhaeltnisVP = $artBesitzverhaeltnisVP;
        return $this;
    }
    /**
     * Get Sicherungsabtretung value
     * @return bool|null
     */
    public function getSicherungsabtretung()
    {
        return $this->Sicherungsabtretung;
    }
    /**
     * Set Sicherungsabtretung value
     * @param bool $sicherungsabtretung
     * @return \BiPRO\StructType\CT_Schadenobjekt
     */
    public function setSicherungsabtretung($sicherungsabtretung = null)
    {
        // validation for constraint: boolean
        if (!is_null($sicherungsabtretung) && !is_bool($sicherungsabtretung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sicherungsabtretung, true), gettype($sicherungsabtretung)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($sicherungsabtretung) && !preg_match('/true|false/', $sicherungsabtretung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($sicherungsabtretung, true)), __LINE__);
        }
        $this->Sicherungsabtretung = $sicherungsabtretung;
        return $this;
    }
    /**
     * Get Leistung value
     * @return \BiPRO\StructType\CT_Leistung[]|null
     */
    public function getLeistung()
    {
        return $this->Leistung;
    }
    /**
     * This method is responsible for validating the values passed to the setLeistung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLeistung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLeistungForArrayConstraintsFromSetLeistung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_SchadenobjektLeistungItem) {
            // validation for constraint: itemType
            if (!$cT_SchadenobjektLeistungItem instanceof \BiPRO\StructType\CT_Leistung) {
                $invalidValues[] = is_object($cT_SchadenobjektLeistungItem) ? get_class($cT_SchadenobjektLeistungItem) : sprintf('%s(%s)', gettype($cT_SchadenobjektLeistungItem), var_export($cT_SchadenobjektLeistungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Leistung property can only contain items of type \BiPRO\StructType\CT_Leistung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Leistung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Leistung[] $leistung
     * @return \BiPRO\StructType\CT_Schadenobjekt
     */
    public function setLeistung(array $leistung = array())
    {
        // validation for constraint: array
        if ('' !== ($leistungArrayErrorMessage = self::validateLeistungForArrayConstraintsFromSetLeistung($leistung))) {
            throw new \InvalidArgumentException($leistungArrayErrorMessage, __LINE__);
        }
        $this->Leistung = $leistung;
        return $this;
    }
    /**
     * Add item to Leistung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Leistung $item
     * @return \BiPRO\StructType\CT_Schadenobjekt
     */
    public function addToLeistung(\BiPRO\StructType\CT_Leistung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Leistung) {
            throw new \InvalidArgumentException(sprintf('The Leistung property can only contain items of type \BiPRO\StructType\CT_Leistung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Leistung[] = $item;
        return $this;
    }
    /**
     * Get VoraussichtlicheReparaturdauer value
     * @return \BiPRO\StructType\CT_Zeitraum2|null
     */
    public function getVoraussichtlicheReparaturdauer()
    {
        return $this->VoraussichtlicheReparaturdauer;
    }
    /**
     * Set VoraussichtlicheReparaturdauer value
     * @param \BiPRO\StructType\CT_Zeitraum2 $voraussichtlicheReparaturdauer
     * @return \BiPRO\StructType\CT_Schadenobjekt
     */
    public function setVoraussichtlicheReparaturdauer(\BiPRO\StructType\CT_Zeitraum2 $voraussichtlicheReparaturdauer = null)
    {
        $this->VoraussichtlicheReparaturdauer = $voraussichtlicheReparaturdauer;
        return $this;
    }
    /**
     * Get SchadenZuObjekt value
     * @return \BiPRO\StructType\CT_SchadenZuObjekt[]|null
     */
    public function getSchadenZuObjekt()
    {
        return $this->SchadenZuObjekt;
    }
    /**
     * This method is responsible for validating the values passed to the setSchadenZuObjekt method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSchadenZuObjekt method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSchadenZuObjektForArrayConstraintsFromSetSchadenZuObjekt(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_SchadenobjektSchadenZuObjektItem) {
            // validation for constraint: itemType
            if (!$cT_SchadenobjektSchadenZuObjektItem instanceof \BiPRO\StructType\CT_SchadenZuObjekt) {
                $invalidValues[] = is_object($cT_SchadenobjektSchadenZuObjektItem) ? get_class($cT_SchadenobjektSchadenZuObjektItem) : sprintf('%s(%s)', gettype($cT_SchadenobjektSchadenZuObjektItem), var_export($cT_SchadenobjektSchadenZuObjektItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SchadenZuObjekt property can only contain items of type \BiPRO\StructType\CT_SchadenZuObjekt, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SchadenZuObjekt value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_SchadenZuObjekt[] $schadenZuObjekt
     * @return \BiPRO\StructType\CT_Schadenobjekt
     */
    public function setSchadenZuObjekt(array $schadenZuObjekt = array())
    {
        // validation for constraint: array
        if ('' !== ($schadenZuObjektArrayErrorMessage = self::validateSchadenZuObjektForArrayConstraintsFromSetSchadenZuObjekt($schadenZuObjekt))) {
            throw new \InvalidArgumentException($schadenZuObjektArrayErrorMessage, __LINE__);
        }
        $this->SchadenZuObjekt = $schadenZuObjekt;
        return $this;
    }
    /**
     * Add item to SchadenZuObjekt value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_SchadenZuObjekt $item
     * @return \BiPRO\StructType\CT_Schadenobjekt
     */
    public function addToSchadenZuObjekt(\BiPRO\StructType\CT_SchadenZuObjekt $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_SchadenZuObjekt) {
            throw new \InvalidArgumentException(sprintf('The SchadenZuObjekt property can only contain items of type \BiPRO\StructType\CT_SchadenZuObjekt, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SchadenZuObjekt[] = $item;
        return $this;
    }
    /**
     * Get TatsaechlicheReparaturdauer value
     * @return \BiPRO\StructType\CT_Zeitraum2|null
     */
    public function getTatsaechlicheReparaturdauer()
    {
        return $this->TatsaechlicheReparaturdauer;
    }
    /**
     * Set TatsaechlicheReparaturdauer value
     * @param \BiPRO\StructType\CT_Zeitraum2 $tatsaechlicheReparaturdauer
     * @return \BiPRO\StructType\CT_Schadenobjekt
     */
    public function setTatsaechlicheReparaturdauer(\BiPRO\StructType\CT_Zeitraum2 $tatsaechlicheReparaturdauer = null)
    {
        $this->TatsaechlicheReparaturdauer = $tatsaechlicheReparaturdauer;
        return $this;
    }
    /**
     * Get Schadenhoehe value
     * @return \BiPRO\StructType\CT_Schadenhoehe[]|null
     */
    public function getSchadenhoehe()
    {
        return $this->Schadenhoehe;
    }
    /**
     * This method is responsible for validating the values passed to the setSchadenhoehe method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSchadenhoehe method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSchadenhoeheForArrayConstraintsFromSetSchadenhoehe(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_SchadenobjektSchadenhoeheItem) {
            // validation for constraint: itemType
            if (!$cT_SchadenobjektSchadenhoeheItem instanceof \BiPRO\StructType\CT_Schadenhoehe) {
                $invalidValues[] = is_object($cT_SchadenobjektSchadenhoeheItem) ? get_class($cT_SchadenobjektSchadenhoeheItem) : sprintf('%s(%s)', gettype($cT_SchadenobjektSchadenhoeheItem), var_export($cT_SchadenobjektSchadenhoeheItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Schadenhoehe property can only contain items of type \BiPRO\StructType\CT_Schadenhoehe, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Schadenhoehe value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Schadenhoehe[] $schadenhoehe
     * @return \BiPRO\StructType\CT_Schadenobjekt
     */
    public function setSchadenhoehe(array $schadenhoehe = array())
    {
        // validation for constraint: array
        if ('' !== ($schadenhoeheArrayErrorMessage = self::validateSchadenhoeheForArrayConstraintsFromSetSchadenhoehe($schadenhoehe))) {
            throw new \InvalidArgumentException($schadenhoeheArrayErrorMessage, __LINE__);
        }
        $this->Schadenhoehe = $schadenhoehe;
        return $this;
    }
    /**
     * Add item to Schadenhoehe value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Schadenhoehe $item
     * @return \BiPRO\StructType\CT_Schadenobjekt
     */
    public function addToSchadenhoehe(\BiPRO\StructType\CT_Schadenhoehe $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Schadenhoehe) {
            throw new \InvalidArgumentException(sprintf('The Schadenhoehe property can only contain items of type \BiPRO\StructType\CT_Schadenhoehe, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Schadenhoehe[] = $item;
        return $this;
    }
    /**
     * Get Schadenmanagement value
     * @return \BiPRO\StructType\CT_Schadenmanagement|null
     */
    public function getSchadenmanagement()
    {
        return $this->Schadenmanagement;
    }
    /**
     * Set Schadenmanagement value
     * @param \BiPRO\StructType\CT_Schadenmanagement $schadenmanagement
     * @return \BiPRO\StructType\CT_Schadenobjekt
     */
    public function setSchadenmanagement(\BiPRO\StructType\CT_Schadenmanagement $schadenmanagement = null)
    {
        $this->Schadenmanagement = $schadenmanagement;
        return $this;
    }
    /**
     * Get Alter value
     * @return \BiPRO\StructType\CT_Zeitraum2|null
     */
    public function getAlter()
    {
        return $this->Alter;
    }
    /**
     * Set Alter value
     * @param \BiPRO\StructType\CT_Zeitraum2 $alter
     * @return \BiPRO\StructType\CT_Schadenobjekt
     */
    public function setAlter(\BiPRO\StructType\CT_Zeitraum2 $alter = null)
    {
        $this->Alter = $alter;
        return $this;
    }
    /**
     * Get Besichtigung value
     * @return \BiPRO\StructType\CT_Besichtigung[]|null
     */
    public function getBesichtigung()
    {
        return $this->Besichtigung;
    }
    /**
     * This method is responsible for validating the values passed to the setBesichtigung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBesichtigung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBesichtigungForArrayConstraintsFromSetBesichtigung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_SchadenobjektBesichtigungItem) {
            // validation for constraint: itemType
            if (!$cT_SchadenobjektBesichtigungItem instanceof \BiPRO\StructType\CT_Besichtigung) {
                $invalidValues[] = is_object($cT_SchadenobjektBesichtigungItem) ? get_class($cT_SchadenobjektBesichtigungItem) : sprintf('%s(%s)', gettype($cT_SchadenobjektBesichtigungItem), var_export($cT_SchadenobjektBesichtigungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Besichtigung property can only contain items of type \BiPRO\StructType\CT_Besichtigung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Besichtigung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Besichtigung[] $besichtigung
     * @return \BiPRO\StructType\CT_Schadenobjekt
     */
    public function setBesichtigung(array $besichtigung = array())
    {
        // validation for constraint: array
        if ('' !== ($besichtigungArrayErrorMessage = self::validateBesichtigungForArrayConstraintsFromSetBesichtigung($besichtigung))) {
            throw new \InvalidArgumentException($besichtigungArrayErrorMessage, __LINE__);
        }
        $this->Besichtigung = $besichtigung;
        return $this;
    }
    /**
     * Add item to Besichtigung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Besichtigung $item
     * @return \BiPRO\StructType\CT_Schadenobjekt
     */
    public function addToBesichtigung(\BiPRO\StructType\CT_Besichtigung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Besichtigung) {
            throw new \InvalidArgumentException(sprintf('The Besichtigung property can only contain items of type \BiPRO\StructType\CT_Besichtigung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Besichtigung[] = $item;
        return $this;
    }
}
