<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Schadennummer StructType
 * Meta information extracted from the WSDL
 * - documentation: Ordnungsbegriff zur Verwaltung eines Schadenfalls bzw. eines Leistungsfalls bei dem Partner, der als Quelle spezifiziert wird. Ist keine Quelle spezifiziert, ist die Schadenummer desjenigen Partners gemeint, der den Schadenfall
 * bearbeitet (üblicherweise der Versicherer).
 * @subpackage Structs
 */
class CT_Schadennummer extends CT_Objekt
{
    /**
     * The Nummer
     * Meta information extracted from the WSDL
     * - documentation: Ordnungsbegriff zur Verwaltung eines Schadenfalls bzw. eines Leistungsfalls. | Ordnungsbegriff zur Verwaltung eines Schadens bzw. einer Leistung.
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $Nummer;
    /**
     * The Quelle
     * Meta information extracted from the WSDL
     * - documentation: Partner, der die Schadennummer vergeben hat.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Quelle
     */
    public $Quelle;
    /**
     * Constructor method for CT_Schadennummer
     * @uses CT_Schadennummer::setNummer()
     * @uses CT_Schadennummer::setQuelle()
     * @param string $nummer
     * @param \BiPRO\StructType\CT_Quelle $quelle
     */
    public function __construct($nummer = null, \BiPRO\StructType\CT_Quelle $quelle = null)
    {
        $this
            ->setNummer($nummer)
            ->setQuelle($quelle);
    }
    /**
     * Get Nummer value
     * @return string
     */
    public function getNummer()
    {
        return $this->Nummer;
    }
    /**
     * Set Nummer value
     * @param string $nummer
     * @return \BiPRO\StructType\CT_Schadennummer
     */
    public function setNummer($nummer = null)
    {
        // validation for constraint: string
        if (!is_null($nummer) && !is_string($nummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nummer, true), gettype($nummer)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($nummer) && mb_strlen($nummer) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($nummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($nummer) && mb_strlen($nummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($nummer)), __LINE__);
        }
        $this->Nummer = $nummer;
        return $this;
    }
    /**
     * Get Quelle value
     * @return \BiPRO\StructType\CT_Quelle|null
     */
    public function getQuelle()
    {
        return $this->Quelle;
    }
    /**
     * Set Quelle value
     * @param \BiPRO\StructType\CT_Quelle $quelle
     * @return \BiPRO\StructType\CT_Schadennummer
     */
    public function setQuelle(\BiPRO\StructType\CT_Quelle $quelle = null)
    {
        $this->Quelle = $quelle;
        return $this;
    }
}
