<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Schadenmanagement StructType
 * Meta information extracted from the WSDL
 * - documentation: Informationen zum Management des Schadens an einer geschädigten Person oder an einem geschädigten Objekt.
 * @subpackage Structs
 */
class CT_Schadenmanagement extends CT_Objekt
{
    /**
     * The SchadenmanagementGewuenscht
     * Meta information extracted from the WSDL
     * - documentation: JA = Versicherungsnehmer oder Geschädigter wünscht Schadenmanagement (z.B. Werkstattsteuerung, Handwerkerservice)NEIN = Versicherungsnehmer oder Geschädigter wünscht kein Schadenmanagement
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $SchadenmanagementGewuenscht;
    /**
     * The Ablehnungsgrund
     * Meta information extracted from the WSDL
     * - documentation: Grund für die Ablehnung des Schadenmanagements durch den Versicherungnehmer oder Geschädigten.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_AblehnungsgrundSchadenmanagement
     */
    public $Ablehnungsgrund;
    /**
     * The Vereinbarungen
     * Meta information extracted from the WSDL
     * - documentation: Vereinbarungen, die zum Schadenmanagement getroffen wurden.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Vereinbarungen;
    /**
     * The Ausfallvereinbarung
     * Meta information extracted from the WSDL
     * - documentation: Vereinbarung zur Kompensation des Ausfalls.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ausfallvereinbarung;
    /**
     * The Reparaturstatus
     * Meta information extracted from the WSDL
     * - documentation: Status der Reparatur.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reparaturstatus;
    /**
     * The GewuenschterRegulierungsempfaenger
     * Meta information extracted from the WSDL
     * - documentation: Partner, an den die Schadenregulierung erfolgen soll.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Regulierungsempfaenger
     */
    public $GewuenschterRegulierungsempfaenger;
    /**
     * The Leistungserbringer
     * Meta information extracted from the WSDL
     * - documentation: Partner, der das Schadenmanagement durchführt (z.B. Assistance-Dienstleister, Werkstatt, Handwerker).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Leistungserbringer
     */
    public $Leistungserbringer;
    /**
     * Constructor method for CT_Schadenmanagement
     * @uses CT_Schadenmanagement::setSchadenmanagementGewuenscht()
     * @uses CT_Schadenmanagement::setAblehnungsgrund()
     * @uses CT_Schadenmanagement::setVereinbarungen()
     * @uses CT_Schadenmanagement::setAusfallvereinbarung()
     * @uses CT_Schadenmanagement::setReparaturstatus()
     * @uses CT_Schadenmanagement::setGewuenschterRegulierungsempfaenger()
     * @uses CT_Schadenmanagement::setLeistungserbringer()
     * @param bool $schadenmanagementGewuenscht
     * @param \BiPRO\StructType\STE_AblehnungsgrundSchadenmanagement $ablehnungsgrund
     * @param string $vereinbarungen
     * @param string $ausfallvereinbarung
     * @param string $reparaturstatus
     * @param \BiPRO\StructType\CT_Regulierungsempfaenger $gewuenschterRegulierungsempfaenger
     * @param \BiPRO\StructType\CT_Leistungserbringer $leistungserbringer
     */
    public function __construct($schadenmanagementGewuenscht = null, \BiPRO\StructType\STE_AblehnungsgrundSchadenmanagement $ablehnungsgrund = null, $vereinbarungen = null, $ausfallvereinbarung = null, $reparaturstatus = null, \BiPRO\StructType\CT_Regulierungsempfaenger $gewuenschterRegulierungsempfaenger = null, \BiPRO\StructType\CT_Leistungserbringer $leistungserbringer = null)
    {
        $this
            ->setSchadenmanagementGewuenscht($schadenmanagementGewuenscht)
            ->setAblehnungsgrund($ablehnungsgrund)
            ->setVereinbarungen($vereinbarungen)
            ->setAusfallvereinbarung($ausfallvereinbarung)
            ->setReparaturstatus($reparaturstatus)
            ->setGewuenschterRegulierungsempfaenger($gewuenschterRegulierungsempfaenger)
            ->setLeistungserbringer($leistungserbringer);
    }
    /**
     * Get SchadenmanagementGewuenscht value
     * @return bool|null
     */
    public function getSchadenmanagementGewuenscht()
    {
        return $this->SchadenmanagementGewuenscht;
    }
    /**
     * Set SchadenmanagementGewuenscht value
     * @param bool $schadenmanagementGewuenscht
     * @return \BiPRO\StructType\CT_Schadenmanagement
     */
    public function setSchadenmanagementGewuenscht($schadenmanagementGewuenscht = null)
    {
        // validation for constraint: boolean
        if (!is_null($schadenmanagementGewuenscht) && !is_bool($schadenmanagementGewuenscht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($schadenmanagementGewuenscht, true), gettype($schadenmanagementGewuenscht)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($schadenmanagementGewuenscht) && !preg_match('/true|false/', $schadenmanagementGewuenscht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($schadenmanagementGewuenscht, true)), __LINE__);
        }
        $this->SchadenmanagementGewuenscht = $schadenmanagementGewuenscht;
        return $this;
    }
    /**
     * Get Ablehnungsgrund value
     * @return \BiPRO\StructType\STE_AblehnungsgrundSchadenmanagement|null
     */
    public function getAblehnungsgrund()
    {
        return $this->Ablehnungsgrund;
    }
    /**
     * Set Ablehnungsgrund value
     * @param \BiPRO\StructType\STE_AblehnungsgrundSchadenmanagement $ablehnungsgrund
     * @return \BiPRO\StructType\CT_Schadenmanagement
     */
    public function setAblehnungsgrund(\BiPRO\StructType\STE_AblehnungsgrundSchadenmanagement $ablehnungsgrund = null)
    {
        $this->Ablehnungsgrund = $ablehnungsgrund;
        return $this;
    }
    /**
     * Get Vereinbarungen value
     * @return string|null
     */
    public function getVereinbarungen()
    {
        return $this->Vereinbarungen;
    }
    /**
     * Set Vereinbarungen value
     * @param string $vereinbarungen
     * @return \BiPRO\StructType\CT_Schadenmanagement
     */
    public function setVereinbarungen($vereinbarungen = null)
    {
        // validation for constraint: string
        if (!is_null($vereinbarungen) && !is_string($vereinbarungen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vereinbarungen, true), gettype($vereinbarungen)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($vereinbarungen) && mb_strlen($vereinbarungen) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($vereinbarungen)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($vereinbarungen) && mb_strlen($vereinbarungen) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($vereinbarungen)), __LINE__);
        }
        $this->Vereinbarungen = $vereinbarungen;
        return $this;
    }
    /**
     * Get Ausfallvereinbarung value
     * @return string|null
     */
    public function getAusfallvereinbarung()
    {
        return $this->Ausfallvereinbarung;
    }
    /**
     * Set Ausfallvereinbarung value
     * @uses \BiPRO\EnumType\ST_Ausfallvereinbarung::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Ausfallvereinbarung::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ausfallvereinbarung
     * @return \BiPRO\StructType\CT_Schadenmanagement
     */
    public function setAusfallvereinbarung($ausfallvereinbarung = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Ausfallvereinbarung::valueIsValid($ausfallvereinbarung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Ausfallvereinbarung', is_array($ausfallvereinbarung) ? implode(', ', $ausfallvereinbarung) : var_export($ausfallvereinbarung, true), implode(', ', \BiPRO\EnumType\ST_Ausfallvereinbarung::getValidValues())), __LINE__);
        }
        $this->Ausfallvereinbarung = $ausfallvereinbarung;
        return $this;
    }
    /**
     * Get Reparaturstatus value
     * @return string|null
     */
    public function getReparaturstatus()
    {
        return $this->Reparaturstatus;
    }
    /**
     * Set Reparaturstatus value
     * @uses \BiPRO\EnumType\ST_Leistungsstatus::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Leistungsstatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reparaturstatus
     * @return \BiPRO\StructType\CT_Schadenmanagement
     */
    public function setReparaturstatus($reparaturstatus = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Leistungsstatus::valueIsValid($reparaturstatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Leistungsstatus', is_array($reparaturstatus) ? implode(', ', $reparaturstatus) : var_export($reparaturstatus, true), implode(', ', \BiPRO\EnumType\ST_Leistungsstatus::getValidValues())), __LINE__);
        }
        $this->Reparaturstatus = $reparaturstatus;
        return $this;
    }
    /**
     * Get GewuenschterRegulierungsempfaenger value
     * @return \BiPRO\StructType\CT_Regulierungsempfaenger|null
     */
    public function getGewuenschterRegulierungsempfaenger()
    {
        return $this->GewuenschterRegulierungsempfaenger;
    }
    /**
     * Set GewuenschterRegulierungsempfaenger value
     * @param \BiPRO\StructType\CT_Regulierungsempfaenger $gewuenschterRegulierungsempfaenger
     * @return \BiPRO\StructType\CT_Schadenmanagement
     */
    public function setGewuenschterRegulierungsempfaenger(\BiPRO\StructType\CT_Regulierungsempfaenger $gewuenschterRegulierungsempfaenger = null)
    {
        $this->GewuenschterRegulierungsempfaenger = $gewuenschterRegulierungsempfaenger;
        return $this;
    }
    /**
     * Get Leistungserbringer value
     * @return \BiPRO\StructType\CT_Leistungserbringer|null
     */
    public function getLeistungserbringer()
    {
        return $this->Leistungserbringer;
    }
    /**
     * Set Leistungserbringer value
     * @param \BiPRO\StructType\CT_Leistungserbringer $leistungserbringer
     * @return \BiPRO\StructType\CT_Schadenmanagement
     */
    public function setLeistungserbringer(\BiPRO\StructType\CT_Leistungserbringer $leistungserbringer = null)
    {
        $this->Leistungserbringer = $leistungserbringer;
        return $this;
    }
}
