<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Schadenauskunft StructType
 * Meta information extracted from the WSDL
 * - documentation: Die Klasse Schadenauskunft ist der Geschäftsvorgang zum Teilprozess TP50001 Auskunft gemäß Norm 503 Schadenservice.
 * @subpackage Structs
 */
class CT_Schadenauskunft extends CT_Objekt
{
    /**
     * The Schadennummer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Schadennummer
     */
    public $Schadennummer;
    /**
     * The Unternehmen
     * Meta information extracted from the WSDL
     * - documentation: Unterstützt der Service Provider eine Schadenauskunft für mehrere Versicherer, MUSS im Objekt Unternehmen der Versicherer spezifiziert werden, von dem die Daten des gewünschten Schadens abgerufen werden sollen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Unternehmen
     */
    public $Unternehmen;
    /**
     * The Ereignis
     * Meta information extracted from the WSDL
     * - documentation: Ein Schadenfall als Ergebnis einer Schadenauskunft beschrieben durch GENAU EINE Klasse Ereignis, GENAU EINE Klasse Schaden und GENAU EINE Klasse SchadenfallLeistungsfall.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Ereignis
     */
    public $Ereignis;
    /**
     * The Gegenstand
     * Meta information extracted from the WSDL
     * - documentation: Gegenstandsliste. Diese Verknüpfung stellt keine logische Beziehung dar, sondern das reine Enthaltensein aller Gegenstände in Form einer Liste innerhalb der Schadenauskunft. Referenziert werden diese Gegenstände mit Hilfe der von
     * Gegenstandsrolle abgeleiteten Rollen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Gegenstand[]
     */
    public $Gegenstand;
    /**
     * The Partner
     * Meta information extracted from the WSDL
     * - documentation: Partnerliste. Diese Verknüpfung stellt keine logische Beziehung dar, sondern das reine Enthaltensein aller Partner in Form einer Liste innerhalb der Schadenauskunft. Referenziert werden diese Partner mit Hilfe der von Partnerrolle
     * abgeleiteten Rollen.Alle Partner werden als Partner geliefert (auch die, die beim VU nicht als eigenständiger Partner geführt, sondern in den Schadendaten gespeichert werden).
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Partner[]
     */
    public $Partner;
    /**
     * Constructor method for CT_Schadenauskunft
     * @uses CT_Schadenauskunft::setSchadennummer()
     * @uses CT_Schadenauskunft::setUnternehmen()
     * @uses CT_Schadenauskunft::setEreignis()
     * @uses CT_Schadenauskunft::setGegenstand()
     * @uses CT_Schadenauskunft::setPartner()
     * @param \BiPRO\StructType\CT_Schadennummer $schadennummer
     * @param \BiPRO\StructType\CT_Unternehmen $unternehmen
     * @param \BiPRO\StructType\CT_Ereignis $ereignis
     * @param \BiPRO\StructType\CT_Gegenstand[] $gegenstand
     * @param \BiPRO\StructType\CT_Partner[] $partner
     */
    public function __construct(\BiPRO\StructType\CT_Schadennummer $schadennummer = null, \BiPRO\StructType\CT_Unternehmen $unternehmen = null, \BiPRO\StructType\CT_Ereignis $ereignis = null, array $gegenstand = array(), array $partner = array())
    {
        $this
            ->setSchadennummer($schadennummer)
            ->setUnternehmen($unternehmen)
            ->setEreignis($ereignis)
            ->setGegenstand($gegenstand)
            ->setPartner($partner);
    }
    /**
     * Get Schadennummer value
     * @return \BiPRO\StructType\CT_Schadennummer|null
     */
    public function getSchadennummer()
    {
        return $this->Schadennummer;
    }
    /**
     * Set Schadennummer value
     * @param \BiPRO\StructType\CT_Schadennummer $schadennummer
     * @return \BiPRO\StructType\CT_Schadenauskunft
     */
    public function setSchadennummer(\BiPRO\StructType\CT_Schadennummer $schadennummer = null)
    {
        $this->Schadennummer = $schadennummer;
        return $this;
    }
    /**
     * Get Unternehmen value
     * @return \BiPRO\StructType\CT_Unternehmen|null
     */
    public function getUnternehmen()
    {
        return $this->Unternehmen;
    }
    /**
     * Set Unternehmen value
     * @param \BiPRO\StructType\CT_Unternehmen $unternehmen
     * @return \BiPRO\StructType\CT_Schadenauskunft
     */
    public function setUnternehmen(\BiPRO\StructType\CT_Unternehmen $unternehmen = null)
    {
        $this->Unternehmen = $unternehmen;
        return $this;
    }
    /**
     * Get Ereignis value
     * @return \BiPRO\StructType\CT_Ereignis|null
     */
    public function getEreignis()
    {
        return $this->Ereignis;
    }
    /**
     * Set Ereignis value
     * @param \BiPRO\StructType\CT_Ereignis $ereignis
     * @return \BiPRO\StructType\CT_Schadenauskunft
     */
    public function setEreignis(\BiPRO\StructType\CT_Ereignis $ereignis = null)
    {
        $this->Ereignis = $ereignis;
        return $this;
    }
    /**
     * Get Gegenstand value
     * @return \BiPRO\StructType\CT_Gegenstand[]|null
     */
    public function getGegenstand()
    {
        return $this->Gegenstand;
    }
    /**
     * This method is responsible for validating the values passed to the setGegenstand method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGegenstand method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGegenstandForArrayConstraintsFromSetGegenstand(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_SchadenauskunftGegenstandItem) {
            // validation for constraint: itemType
            if (!$cT_SchadenauskunftGegenstandItem instanceof \BiPRO\StructType\CT_Gegenstand) {
                $invalidValues[] = is_object($cT_SchadenauskunftGegenstandItem) ? get_class($cT_SchadenauskunftGegenstandItem) : sprintf('%s(%s)', gettype($cT_SchadenauskunftGegenstandItem), var_export($cT_SchadenauskunftGegenstandItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Gegenstand property can only contain items of type \BiPRO\StructType\CT_Gegenstand, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Gegenstand value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Gegenstand[] $gegenstand
     * @return \BiPRO\StructType\CT_Schadenauskunft
     */
    public function setGegenstand(array $gegenstand = array())
    {
        // validation for constraint: array
        if ('' !== ($gegenstandArrayErrorMessage = self::validateGegenstandForArrayConstraintsFromSetGegenstand($gegenstand))) {
            throw new \InvalidArgumentException($gegenstandArrayErrorMessage, __LINE__);
        }
        $this->Gegenstand = $gegenstand;
        return $this;
    }
    /**
     * Add item to Gegenstand value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Gegenstand $item
     * @return \BiPRO\StructType\CT_Schadenauskunft
     */
    public function addToGegenstand(\BiPRO\StructType\CT_Gegenstand $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Gegenstand) {
            throw new \InvalidArgumentException(sprintf('The Gegenstand property can only contain items of type \BiPRO\StructType\CT_Gegenstand, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Gegenstand[] = $item;
        return $this;
    }
    /**
     * Get Partner value
     * @return \BiPRO\StructType\CT_Partner[]|null
     */
    public function getPartner()
    {
        return $this->Partner;
    }
    /**
     * This method is responsible for validating the values passed to the setPartner method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPartner method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePartnerForArrayConstraintsFromSetPartner(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_SchadenauskunftPartnerItem) {
            // validation for constraint: itemType
            if (!$cT_SchadenauskunftPartnerItem instanceof \BiPRO\StructType\CT_Partner) {
                $invalidValues[] = is_object($cT_SchadenauskunftPartnerItem) ? get_class($cT_SchadenauskunftPartnerItem) : sprintf('%s(%s)', gettype($cT_SchadenauskunftPartnerItem), var_export($cT_SchadenauskunftPartnerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Partner property can only contain items of type \BiPRO\StructType\CT_Partner, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Partner value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Partner[] $partner
     * @return \BiPRO\StructType\CT_Schadenauskunft
     */
    public function setPartner(array $partner = array())
    {
        // validation for constraint: array
        if ('' !== ($partnerArrayErrorMessage = self::validatePartnerForArrayConstraintsFromSetPartner($partner))) {
            throw new \InvalidArgumentException($partnerArrayErrorMessage, __LINE__);
        }
        $this->Partner = $partner;
        return $this;
    }
    /**
     * Add item to Partner value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Partner $item
     * @return \BiPRO\StructType\CT_Schadenauskunft
     */
    public function addToPartner(\BiPRO\StructType\CT_Partner $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Partner) {
            throw new \InvalidArgumentException(sprintf('The Partner property can only contain items of type \BiPRO\StructType\CT_Partner, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Partner[] = $item;
        return $this;
    }
}
