<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Schadenanschrift StructType
 * Meta information extracted from the WSDL
 * - documentation: Anschrift eines Schadenereignisses.
 * @subpackage Structs
 */
class CT_Schadenanschrift extends CT_Adresse
{
    /**
     * The Schadenort
     * Meta information extracted from the WSDL
     * - documentation: Ergänzende Beschreibung zum Schadenort. Z. B. "Auf der A7 im Elbtunnel Fahrtrichtung Norden", "in der Küche des ersten Stockwerks", "in der Garage".
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Schadenort;
    /**
     * The Flurstueck
     * Meta information extracted from the WSDL
     * - documentation: Identifikation des Flurstücks.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Flurstueck;
    /**
     * The Gemarkung
     * Meta information extracted from the WSDL
     * - documentation: Identifikation der Gemarkung.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Gemarkung;
    /**
     * Constructor method for CT_Schadenanschrift
     * @uses CT_Schadenanschrift::setSchadenort()
     * @uses CT_Schadenanschrift::setFlurstueck()
     * @uses CT_Schadenanschrift::setGemarkung()
     * @param string $schadenort
     * @param string $flurstueck
     * @param string $gemarkung
     */
    public function __construct($schadenort = null, $flurstueck = null, $gemarkung = null)
    {
        $this
            ->setSchadenort($schadenort)
            ->setFlurstueck($flurstueck)
            ->setGemarkung($gemarkung);
    }
    /**
     * Get Schadenort value
     * @return string|null
     */
    public function getSchadenort()
    {
        return $this->Schadenort;
    }
    /**
     * Set Schadenort value
     * @param string $schadenort
     * @return \BiPRO\StructType\CT_Schadenanschrift
     */
    public function setSchadenort($schadenort = null)
    {
        // validation for constraint: string
        if (!is_null($schadenort) && !is_string($schadenort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schadenort, true), gettype($schadenort)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($schadenort) && mb_strlen($schadenort) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($schadenort)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($schadenort) && mb_strlen($schadenort) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($schadenort)), __LINE__);
        }
        $this->Schadenort = $schadenort;
        return $this;
    }
    /**
     * Get Flurstueck value
     * @return string|null
     */
    public function getFlurstueck()
    {
        return $this->Flurstueck;
    }
    /**
     * Set Flurstueck value
     * @param string $flurstueck
     * @return \BiPRO\StructType\CT_Schadenanschrift
     */
    public function setFlurstueck($flurstueck = null)
    {
        // validation for constraint: string
        if (!is_null($flurstueck) && !is_string($flurstueck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flurstueck, true), gettype($flurstueck)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($flurstueck) && mb_strlen($flurstueck) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($flurstueck)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($flurstueck) && mb_strlen($flurstueck) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($flurstueck)), __LINE__);
        }
        $this->Flurstueck = $flurstueck;
        return $this;
    }
    /**
     * Get Gemarkung value
     * @return string|null
     */
    public function getGemarkung()
    {
        return $this->Gemarkung;
    }
    /**
     * Set Gemarkung value
     * @param string $gemarkung
     * @return \BiPRO\StructType\CT_Schadenanschrift
     */
    public function setGemarkung($gemarkung = null)
    {
        // validation for constraint: string
        if (!is_null($gemarkung) && !is_string($gemarkung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gemarkung, true), gettype($gemarkung)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($gemarkung) && mb_strlen($gemarkung) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($gemarkung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($gemarkung) && mb_strlen($gemarkung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($gemarkung)), __LINE__);
        }
        $this->Gemarkung = $gemarkung;
        return $this;
    }
}
