<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Schaden StructType
 * Meta information extracted from the WSDL
 * - documentation: Ein Schaden beinhaltet einen oder mehrere materielle oder immaterielle Nachteile, die natürliche oder juristische Personen oder Sachen durch ein Schadenereignis erleiden.
 * @subpackage Structs
 */
class CT_Schaden extends CT_Objekt
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Art des Schadens
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ArtID;
    /**
     * The Quelle
     * Meta information extracted from the WSDL
     * - documentation: Ursprung der Informationen zum Schaden.Fehlt die Quelle, dann ist der Schadenmelder die Quelle der Schadeninformationen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Quelle
     */
    public $Quelle;
    /**
     * The Schadenhoehe
     * Meta information extracted from the WSDL
     * - documentation: Die Höhe des Schadens dargestellt als Geldwert.Diese DARF auf allen Ebenen angegeben werden. Es gibt keine Summierungsregel. Normalerweise erfolgt die Angabe auf der größtmöglichen Detailtiefe.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Schadenhoehe[]
     */
    public $Schadenhoehe;
    /**
     * The SchadenfallLeistungsfall
     * Meta information extracted from the WSDL
     * - documentation: Schadenfälle bzw. Leistungsfälle, die durch ein Versicherungsunternehmen oder einen Dritten angelegt wurden, um einen Schaden zu bearbeiten.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_SchadenfallLeistungsfall[]
     */
    public $SchadenfallLeistungsfall;
    /**
     * The GeschaedigtePerson
     * Meta information extracted from the WSDL
     * - documentation: Partner, der geschädigt wurde.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_GeschaedigtePerson[]
     */
    public $GeschaedigtePerson;
    /**
     * The Schadenobjekt
     * Meta information extracted from the WSDL
     * - documentation: Gegenstand, der in den Schaden involviert ist.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Schadenobjekt[]
     */
    public $Schadenobjekt;
    /**
     * Constructor method for CT_Schaden
     * @uses CT_Schaden::setArtID()
     * @uses CT_Schaden::setQuelle()
     * @uses CT_Schaden::setSchadenhoehe()
     * @uses CT_Schaden::setSchadenfallLeistungsfall()
     * @uses CT_Schaden::setGeschaedigtePerson()
     * @uses CT_Schaden::setSchadenobjekt()
     * @param string[] $artID
     * @param \BiPRO\StructType\CT_Quelle $quelle
     * @param \BiPRO\StructType\CT_Schadenhoehe[] $schadenhoehe
     * @param \BiPRO\StructType\CT_SchadenfallLeistungsfall[] $schadenfallLeistungsfall
     * @param \BiPRO\StructType\CT_GeschaedigtePerson[] $geschaedigtePerson
     * @param \BiPRO\StructType\CT_Schadenobjekt[] $schadenobjekt
     */
    public function __construct(array $artID = array(), \BiPRO\StructType\CT_Quelle $quelle = null, array $schadenhoehe = array(), array $schadenfallLeistungsfall = array(), array $geschaedigtePerson = array(), array $schadenobjekt = array())
    {
        $this
            ->setArtID($artID)
            ->setQuelle($quelle)
            ->setSchadenhoehe($schadenhoehe)
            ->setSchadenfallLeistungsfall($schadenfallLeistungsfall)
            ->setGeschaedigtePerson($geschaedigtePerson)
            ->setSchadenobjekt($schadenobjekt);
    }
    /**
     * Get ArtID value
     * @return string[]|null
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * This method is responsible for validating the values passed to the setArtID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setArtID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateArtIDForArrayConstraintsFromSetArtID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_SchadenArtIDItem) {
            // validation for constraint: enumeration
            if (!\BiPRO\EnumType\ST_Schaden::valueIsValid($cT_SchadenArtIDItem)) {
                $invalidValues[] = is_object($cT_SchadenArtIDItem) ? get_class($cT_SchadenArtIDItem) : sprintf('%s(%s)', gettype($cT_SchadenArtIDItem), var_export($cT_SchadenArtIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Schaden', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \BiPRO\EnumType\ST_Schaden::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ArtID value
     * @uses \BiPRO\EnumType\ST_Schaden::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Schaden::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $artID
     * @return \BiPRO\StructType\CT_Schaden
     */
    public function setArtID(array $artID = array())
    {
        // validation for constraint: array
        if ('' !== ($artIDArrayErrorMessage = self::validateArtIDForArrayConstraintsFromSetArtID($artID))) {
            throw new \InvalidArgumentException($artIDArrayErrorMessage, __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Add item to ArtID value
     * @uses \BiPRO\EnumType\ST_Schaden::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Schaden::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \BiPRO\StructType\CT_Schaden
     */
    public function addToArtID($item)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Schaden::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Schaden', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \BiPRO\EnumType\ST_Schaden::getValidValues())), __LINE__);
        }
        $this->ArtID[] = $item;
        return $this;
    }
    /**
     * Get Quelle value
     * @return \BiPRO\StructType\CT_Quelle|null
     */
    public function getQuelle()
    {
        return $this->Quelle;
    }
    /**
     * Set Quelle value
     * @param \BiPRO\StructType\CT_Quelle $quelle
     * @return \BiPRO\StructType\CT_Schaden
     */
    public function setQuelle(\BiPRO\StructType\CT_Quelle $quelle = null)
    {
        $this->Quelle = $quelle;
        return $this;
    }
    /**
     * Get Schadenhoehe value
     * @return \BiPRO\StructType\CT_Schadenhoehe[]|null
     */
    public function getSchadenhoehe()
    {
        return $this->Schadenhoehe;
    }
    /**
     * This method is responsible for validating the values passed to the setSchadenhoehe method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSchadenhoehe method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSchadenhoeheForArrayConstraintsFromSetSchadenhoehe(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_SchadenSchadenhoeheItem) {
            // validation for constraint: itemType
            if (!$cT_SchadenSchadenhoeheItem instanceof \BiPRO\StructType\CT_Schadenhoehe) {
                $invalidValues[] = is_object($cT_SchadenSchadenhoeheItem) ? get_class($cT_SchadenSchadenhoeheItem) : sprintf('%s(%s)', gettype($cT_SchadenSchadenhoeheItem), var_export($cT_SchadenSchadenhoeheItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Schadenhoehe property can only contain items of type \BiPRO\StructType\CT_Schadenhoehe, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Schadenhoehe value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Schadenhoehe[] $schadenhoehe
     * @return \BiPRO\StructType\CT_Schaden
     */
    public function setSchadenhoehe(array $schadenhoehe = array())
    {
        // validation for constraint: array
        if ('' !== ($schadenhoeheArrayErrorMessage = self::validateSchadenhoeheForArrayConstraintsFromSetSchadenhoehe($schadenhoehe))) {
            throw new \InvalidArgumentException($schadenhoeheArrayErrorMessage, __LINE__);
        }
        $this->Schadenhoehe = $schadenhoehe;
        return $this;
    }
    /**
     * Add item to Schadenhoehe value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Schadenhoehe $item
     * @return \BiPRO\StructType\CT_Schaden
     */
    public function addToSchadenhoehe(\BiPRO\StructType\CT_Schadenhoehe $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Schadenhoehe) {
            throw new \InvalidArgumentException(sprintf('The Schadenhoehe property can only contain items of type \BiPRO\StructType\CT_Schadenhoehe, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Schadenhoehe[] = $item;
        return $this;
    }
    /**
     * Get SchadenfallLeistungsfall value
     * @return \BiPRO\StructType\CT_SchadenfallLeistungsfall[]|null
     */
    public function getSchadenfallLeistungsfall()
    {
        return $this->SchadenfallLeistungsfall;
    }
    /**
     * This method is responsible for validating the values passed to the setSchadenfallLeistungsfall method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSchadenfallLeistungsfall method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSchadenfallLeistungsfallForArrayConstraintsFromSetSchadenfallLeistungsfall(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_SchadenSchadenfallLeistungsfallItem) {
            // validation for constraint: itemType
            if (!$cT_SchadenSchadenfallLeistungsfallItem instanceof \BiPRO\StructType\CT_SchadenfallLeistungsfall) {
                $invalidValues[] = is_object($cT_SchadenSchadenfallLeistungsfallItem) ? get_class($cT_SchadenSchadenfallLeistungsfallItem) : sprintf('%s(%s)', gettype($cT_SchadenSchadenfallLeistungsfallItem), var_export($cT_SchadenSchadenfallLeistungsfallItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SchadenfallLeistungsfall property can only contain items of type \BiPRO\StructType\CT_SchadenfallLeistungsfall, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SchadenfallLeistungsfall value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_SchadenfallLeistungsfall[] $schadenfallLeistungsfall
     * @return \BiPRO\StructType\CT_Schaden
     */
    public function setSchadenfallLeistungsfall(array $schadenfallLeistungsfall = array())
    {
        // validation for constraint: array
        if ('' !== ($schadenfallLeistungsfallArrayErrorMessage = self::validateSchadenfallLeistungsfallForArrayConstraintsFromSetSchadenfallLeistungsfall($schadenfallLeistungsfall))) {
            throw new \InvalidArgumentException($schadenfallLeistungsfallArrayErrorMessage, __LINE__);
        }
        $this->SchadenfallLeistungsfall = $schadenfallLeistungsfall;
        return $this;
    }
    /**
     * Add item to SchadenfallLeistungsfall value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_SchadenfallLeistungsfall $item
     * @return \BiPRO\StructType\CT_Schaden
     */
    public function addToSchadenfallLeistungsfall(\BiPRO\StructType\CT_SchadenfallLeistungsfall $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_SchadenfallLeistungsfall) {
            throw new \InvalidArgumentException(sprintf('The SchadenfallLeistungsfall property can only contain items of type \BiPRO\StructType\CT_SchadenfallLeistungsfall, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SchadenfallLeistungsfall[] = $item;
        return $this;
    }
    /**
     * Get GeschaedigtePerson value
     * @return \BiPRO\StructType\CT_GeschaedigtePerson[]|null
     */
    public function getGeschaedigtePerson()
    {
        return $this->GeschaedigtePerson;
    }
    /**
     * This method is responsible for validating the values passed to the setGeschaedigtePerson method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGeschaedigtePerson method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGeschaedigtePersonForArrayConstraintsFromSetGeschaedigtePerson(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_SchadenGeschaedigtePersonItem) {
            // validation for constraint: itemType
            if (!$cT_SchadenGeschaedigtePersonItem instanceof \BiPRO\StructType\CT_GeschaedigtePerson) {
                $invalidValues[] = is_object($cT_SchadenGeschaedigtePersonItem) ? get_class($cT_SchadenGeschaedigtePersonItem) : sprintf('%s(%s)', gettype($cT_SchadenGeschaedigtePersonItem), var_export($cT_SchadenGeschaedigtePersonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GeschaedigtePerson property can only contain items of type \BiPRO\StructType\CT_GeschaedigtePerson, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GeschaedigtePerson value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_GeschaedigtePerson[] $geschaedigtePerson
     * @return \BiPRO\StructType\CT_Schaden
     */
    public function setGeschaedigtePerson(array $geschaedigtePerson = array())
    {
        // validation for constraint: array
        if ('' !== ($geschaedigtePersonArrayErrorMessage = self::validateGeschaedigtePersonForArrayConstraintsFromSetGeschaedigtePerson($geschaedigtePerson))) {
            throw new \InvalidArgumentException($geschaedigtePersonArrayErrorMessage, __LINE__);
        }
        $this->GeschaedigtePerson = $geschaedigtePerson;
        return $this;
    }
    /**
     * Add item to GeschaedigtePerson value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_GeschaedigtePerson $item
     * @return \BiPRO\StructType\CT_Schaden
     */
    public function addToGeschaedigtePerson(\BiPRO\StructType\CT_GeschaedigtePerson $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_GeschaedigtePerson) {
            throw new \InvalidArgumentException(sprintf('The GeschaedigtePerson property can only contain items of type \BiPRO\StructType\CT_GeschaedigtePerson, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GeschaedigtePerson[] = $item;
        return $this;
    }
    /**
     * Get Schadenobjekt value
     * @return \BiPRO\StructType\CT_Schadenobjekt[]|null
     */
    public function getSchadenobjekt()
    {
        return $this->Schadenobjekt;
    }
    /**
     * This method is responsible for validating the values passed to the setSchadenobjekt method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSchadenobjekt method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSchadenobjektForArrayConstraintsFromSetSchadenobjekt(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_SchadenSchadenobjektItem) {
            // validation for constraint: itemType
            if (!$cT_SchadenSchadenobjektItem instanceof \BiPRO\StructType\CT_Schadenobjekt) {
                $invalidValues[] = is_object($cT_SchadenSchadenobjektItem) ? get_class($cT_SchadenSchadenobjektItem) : sprintf('%s(%s)', gettype($cT_SchadenSchadenobjektItem), var_export($cT_SchadenSchadenobjektItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Schadenobjekt property can only contain items of type \BiPRO\StructType\CT_Schadenobjekt, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Schadenobjekt value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Schadenobjekt[] $schadenobjekt
     * @return \BiPRO\StructType\CT_Schaden
     */
    public function setSchadenobjekt(array $schadenobjekt = array())
    {
        // validation for constraint: array
        if ('' !== ($schadenobjektArrayErrorMessage = self::validateSchadenobjektForArrayConstraintsFromSetSchadenobjekt($schadenobjekt))) {
            throw new \InvalidArgumentException($schadenobjektArrayErrorMessage, __LINE__);
        }
        $this->Schadenobjekt = $schadenobjekt;
        return $this;
    }
    /**
     * Add item to Schadenobjekt value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Schadenobjekt $item
     * @return \BiPRO\StructType\CT_Schaden
     */
    public function addToSchadenobjekt(\BiPRO\StructType\CT_Schadenobjekt $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Schadenobjekt) {
            throw new \InvalidArgumentException(sprintf('The Schadenobjekt property can only contain items of type \BiPRO\StructType\CT_Schadenobjekt, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Schadenobjekt[] = $item;
        return $this;
    }
}
