<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_ProzessFehler StructType
 * Meta information extracted from the WSDL
 * - documentation: Prozess-Objekt. Dient der Uebermittlung von Prozessfehlern.
 * @subpackage Structs
 */
class CT_ProzessFehler extends CT_Objekt
{
    /**
     * The BiPROVersion
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: \d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}
     * @var string
     */
    public $BiPROVersion;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \BiPRO\StructType\CT_Status
     */
    public $Status;
    /**
     * Constructor method for CT_ProzessFehler
     * @uses CT_ProzessFehler::setBiPROVersion()
     * @uses CT_ProzessFehler::setStatus()
     * @param string $biPROVersion
     * @param \BiPRO\StructType\CT_Status $status
     */
    public function __construct($biPROVersion = null, \BiPRO\StructType\CT_Status $status = null)
    {
        $this
            ->setBiPROVersion($biPROVersion)
            ->setStatus($status);
    }
    /**
     * Get BiPROVersion value
     * @return string
     */
    public function getBiPROVersion()
    {
        return $this->BiPROVersion;
    }
    /**
     * Set BiPROVersion value
     * @param string $biPROVersion
     * @return \BiPRO\StructType\CT_ProzessFehler
     */
    public function setBiPROVersion($biPROVersion = null)
    {
        // validation for constraint: string
        if (!is_null($biPROVersion) && !is_string($biPROVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($biPROVersion, true), gettype($biPROVersion)), __LINE__);
        }
        // validation for constraint: pattern(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})
        if (!is_null($biPROVersion) && !preg_match('/\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}/', $biPROVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}', var_export($biPROVersion, true)), __LINE__);
        }
        $this->BiPROVersion = $biPROVersion;
        return $this;
    }
    /**
     * Get Status value
     * @return \BiPRO\StructType\CT_Status
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \BiPRO\StructType\CT_Status $status
     * @return \BiPRO\StructType\CT_ProzessFehler
     */
    public function setStatus(\BiPRO\StructType\CT_Status $status = null)
    {
        $this->Status = $status;
        return $this;
    }
}
