<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Personenschaden StructType
 * Meta information extracted from the WSDL
 * - documentation: Schaden, der bei einer Person eine Verletzung, eine Gesundheitsschädigung oder den Tod zur Folge hat.
 * @subpackage Structs
 */
class CT_Personenschaden extends CT_SchadenZuPerson
{
    /**
     * The Aufenthaltsort
     * Meta information extracted from the WSDL
     * - documentation: Aufenthaltsort der geschädigten Person zum Schadenzeitpunkt. Beliebiger Text, wie "in der Küche".
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Aufenthaltsort;
    /**
     * The EWSEEGeprueft
     * Meta information extracted from the WSDL
     * - documentation: EW/SEE = Einzelfall-Einwilligungs-/SchweigepflichtentbindungserklärungJA = Die Erforderlichkeit einer EW/SEE des Betroffenen in die Übermittlung an den Adressaten wurde geprüft. Ggf. liegt die EW/SEE (entsprechend den
     * datenschurtzrechtlichen Anforderungen) vor.NEIN = Es wurde nicht geprüft.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $EWSEEGeprueft;
    /**
     * The EinwilligungenBeigefuegt
     * Meta information extracted from the WSDL
     * - documentation: JA = Einwilligungen des Betroffenen sind als Datei beigefügt.NEIN = Einwilligungen des Betroffenen sind nicht beigefügt.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $EinwilligungenBeigefuegt;
    /**
     * The Verletzung
     * Meta information extracted from the WSDL
     * - documentation: Beschreibung der Verletzung der geschädigten Person.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Verletzung;
    /**
     * The AnspruchAnDritte
     * Meta information extracted from the WSDL
     * - documentation: Freitext zum Anspruch der geschädigten Person an Dritte.
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $AnspruchAnDritte;
    /**
     * The AUBescheinigungVorhanden
     * Meta information extracted from the WSDL
     * - documentation: JA = Arbeitsunfähigkeitsbescheinigung (AU) vorhanden.NEIN = Arbeitsunfähigkeitsbescheinigung (AU) nicht vorhanden
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $AUBescheinigungVorhanden;
    /**
     * The StationaereBehandlung
     * Meta information extracted from the WSDL
     * - documentation: JA = Geschädigte Person musste sich in stationäre Behandlung begeben.NEIN = Geschädigte Person musste sich nicht in stationäre Behandlung begeben.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $StationaereBehandlung;
    /**
     * The ICDCode
     * Meta information extracted from the WSDL
     * - documentation: Diagnose der geschädigten Person gemäß ICD-Code der Weltgesundheitsorganisation (WHO) zur Klassifikation medizinischer Diagnosen (International Statistical Classification of Diseases and Related Health Problems).Attribut DARF
     * mehrfach verwendet werden. | ICD-Code der Weltgesundheitsorganisation (WHO) zur Klassifikation medizinischer Diagnosen (International Statistical Classification of Diseases and Related Health Problems).String der Länge 3, 5 oder 6.Beginnt mit
     * Buchstabe, dann 2 Ziffern.Optional folgt ein Punkt und weitere 1 bis 2 Ziffern.
     * - base: xsd:string
     * - maxLength: 6
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ICDCode;
    /**
     * The Arbeitsunfaehig
     * Meta information extracted from the WSDL
     * - documentation: Beginn des Zeitraums = Beginn der ArbeitsunfähigkeitEnde des Zeitraums = Voraussichtliches Ende der ArbeitsunfähigkeitDer Zeitraum MUSS durch die Attribute Beginn und Ende spezifiziert werden. Beginn und Ende MÜSSEN mit einem
     * vollständigen Datum definiert sein. Die Angabe einer Zeit oder einer Zeitzone DARF NICHT erfolgen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zeitraum2
     */
    public $Arbeitsunfaehig;
    /**
     * The Krankenkasse
     * Meta information extracted from the WSDL
     * - documentation: Krankenkasse der geschädigten Person.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Krankenkasse
     */
    public $Krankenkasse;
    /**
     * The Krankenhaus
     * Meta information extracted from the WSDL
     * - documentation: Krankenhaus, in dem die geschädigte Person behandelt wird oder wurde.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Krankenhaus[]
     */
    public $Krankenhaus;
    /**
     * The BehandelnderArzt
     * Meta information extracted from the WSDL
     * - documentation: Arzt, der die geschädigte Person behandelt.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Arzt[]
     */
    public $BehandelnderArzt;
    /**
     * The Berufsgenossenschaft
     * Meta information extracted from the WSDL
     * - documentation: Berufsgenossenschaft der geschädigten Person.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Berufsgenossenschaft
     */
    public $Berufsgenossenschaft;
    /**
     * Constructor method for CT_Personenschaden
     * @uses CT_Personenschaden::setAufenthaltsort()
     * @uses CT_Personenschaden::setEWSEEGeprueft()
     * @uses CT_Personenschaden::setEinwilligungenBeigefuegt()
     * @uses CT_Personenschaden::setVerletzung()
     * @uses CT_Personenschaden::setAnspruchAnDritte()
     * @uses CT_Personenschaden::setAUBescheinigungVorhanden()
     * @uses CT_Personenschaden::setStationaereBehandlung()
     * @uses CT_Personenschaden::setICDCode()
     * @uses CT_Personenschaden::setArbeitsunfaehig()
     * @uses CT_Personenschaden::setKrankenkasse()
     * @uses CT_Personenschaden::setKrankenhaus()
     * @uses CT_Personenschaden::setBehandelnderArzt()
     * @uses CT_Personenschaden::setBerufsgenossenschaft()
     * @param string $aufenthaltsort
     * @param bool $eWSEEGeprueft
     * @param bool $einwilligungenBeigefuegt
     * @param string $verletzung
     * @param string $anspruchAnDritte
     * @param bool $aUBescheinigungVorhanden
     * @param bool $stationaereBehandlung
     * @param string[] $iCDCode
     * @param \BiPRO\StructType\CT_Zeitraum2 $arbeitsunfaehig
     * @param \BiPRO\StructType\CT_Krankenkasse $krankenkasse
     * @param \BiPRO\StructType\CT_Krankenhaus[] $krankenhaus
     * @param \BiPRO\StructType\CT_Arzt[] $behandelnderArzt
     * @param \BiPRO\StructType\CT_Berufsgenossenschaft $berufsgenossenschaft
     */
    public function __construct($aufenthaltsort = null, $eWSEEGeprueft = null, $einwilligungenBeigefuegt = null, $verletzung = null, $anspruchAnDritte = null, $aUBescheinigungVorhanden = null, $stationaereBehandlung = null, array $iCDCode = array(), \BiPRO\StructType\CT_Zeitraum2 $arbeitsunfaehig = null, \BiPRO\StructType\CT_Krankenkasse $krankenkasse = null, array $krankenhaus = array(), array $behandelnderArzt = array(), \BiPRO\StructType\CT_Berufsgenossenschaft $berufsgenossenschaft = null)
    {
        $this
            ->setAufenthaltsort($aufenthaltsort)
            ->setEWSEEGeprueft($eWSEEGeprueft)
            ->setEinwilligungenBeigefuegt($einwilligungenBeigefuegt)
            ->setVerletzung($verletzung)
            ->setAnspruchAnDritte($anspruchAnDritte)
            ->setAUBescheinigungVorhanden($aUBescheinigungVorhanden)
            ->setStationaereBehandlung($stationaereBehandlung)
            ->setICDCode($iCDCode)
            ->setArbeitsunfaehig($arbeitsunfaehig)
            ->setKrankenkasse($krankenkasse)
            ->setKrankenhaus($krankenhaus)
            ->setBehandelnderArzt($behandelnderArzt)
            ->setBerufsgenossenschaft($berufsgenossenschaft);
    }
    /**
     * Get Aufenthaltsort value
     * @return string|null
     */
    public function getAufenthaltsort()
    {
        return $this->Aufenthaltsort;
    }
    /**
     * Set Aufenthaltsort value
     * @param string $aufenthaltsort
     * @return \BiPRO\StructType\CT_Personenschaden
     */
    public function setAufenthaltsort($aufenthaltsort = null)
    {
        // validation for constraint: string
        if (!is_null($aufenthaltsort) && !is_string($aufenthaltsort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aufenthaltsort, true), gettype($aufenthaltsort)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($aufenthaltsort) && mb_strlen($aufenthaltsort) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($aufenthaltsort)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($aufenthaltsort) && mb_strlen($aufenthaltsort) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($aufenthaltsort)), __LINE__);
        }
        $this->Aufenthaltsort = $aufenthaltsort;
        return $this;
    }
    /**
     * Get EWSEEGeprueft value
     * @return bool|null
     */
    public function getEWSEEGeprueft()
    {
        return $this->EWSEEGeprueft;
    }
    /**
     * Set EWSEEGeprueft value
     * @param bool $eWSEEGeprueft
     * @return \BiPRO\StructType\CT_Personenschaden
     */
    public function setEWSEEGeprueft($eWSEEGeprueft = null)
    {
        // validation for constraint: boolean
        if (!is_null($eWSEEGeprueft) && !is_bool($eWSEEGeprueft)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eWSEEGeprueft, true), gettype($eWSEEGeprueft)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($eWSEEGeprueft) && !preg_match('/true|false/', $eWSEEGeprueft)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($eWSEEGeprueft, true)), __LINE__);
        }
        $this->EWSEEGeprueft = $eWSEEGeprueft;
        return $this;
    }
    /**
     * Get EinwilligungenBeigefuegt value
     * @return bool|null
     */
    public function getEinwilligungenBeigefuegt()
    {
        return $this->EinwilligungenBeigefuegt;
    }
    /**
     * Set EinwilligungenBeigefuegt value
     * @param bool $einwilligungenBeigefuegt
     * @return \BiPRO\StructType\CT_Personenschaden
     */
    public function setEinwilligungenBeigefuegt($einwilligungenBeigefuegt = null)
    {
        // validation for constraint: boolean
        if (!is_null($einwilligungenBeigefuegt) && !is_bool($einwilligungenBeigefuegt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($einwilligungenBeigefuegt, true), gettype($einwilligungenBeigefuegt)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($einwilligungenBeigefuegt) && !preg_match('/true|false/', $einwilligungenBeigefuegt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($einwilligungenBeigefuegt, true)), __LINE__);
        }
        $this->EinwilligungenBeigefuegt = $einwilligungenBeigefuegt;
        return $this;
    }
    /**
     * Get Verletzung value
     * @return string|null
     */
    public function getVerletzung()
    {
        return $this->Verletzung;
    }
    /**
     * Set Verletzung value
     * @param string $verletzung
     * @return \BiPRO\StructType\CT_Personenschaden
     */
    public function setVerletzung($verletzung = null)
    {
        // validation for constraint: string
        if (!is_null($verletzung) && !is_string($verletzung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($verletzung, true), gettype($verletzung)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($verletzung) && mb_strlen($verletzung) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($verletzung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($verletzung) && mb_strlen($verletzung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($verletzung)), __LINE__);
        }
        $this->Verletzung = $verletzung;
        return $this;
    }
    /**
     * Get AnspruchAnDritte value
     * @return string|null
     */
    public function getAnspruchAnDritte()
    {
        return $this->AnspruchAnDritte;
    }
    /**
     * Set AnspruchAnDritte value
     * @param string $anspruchAnDritte
     * @return \BiPRO\StructType\CT_Personenschaden
     */
    public function setAnspruchAnDritte($anspruchAnDritte = null)
    {
        // validation for constraint: string
        if (!is_null($anspruchAnDritte) && !is_string($anspruchAnDritte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($anspruchAnDritte, true), gettype($anspruchAnDritte)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($anspruchAnDritte) && mb_strlen($anspruchAnDritte) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($anspruchAnDritte)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($anspruchAnDritte) && mb_strlen($anspruchAnDritte) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($anspruchAnDritte)), __LINE__);
        }
        $this->AnspruchAnDritte = $anspruchAnDritte;
        return $this;
    }
    /**
     * Get AUBescheinigungVorhanden value
     * @return bool|null
     */
    public function getAUBescheinigungVorhanden()
    {
        return $this->AUBescheinigungVorhanden;
    }
    /**
     * Set AUBescheinigungVorhanden value
     * @param bool $aUBescheinigungVorhanden
     * @return \BiPRO\StructType\CT_Personenschaden
     */
    public function setAUBescheinigungVorhanden($aUBescheinigungVorhanden = null)
    {
        // validation for constraint: boolean
        if (!is_null($aUBescheinigungVorhanden) && !is_bool($aUBescheinigungVorhanden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aUBescheinigungVorhanden, true), gettype($aUBescheinigungVorhanden)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($aUBescheinigungVorhanden) && !preg_match('/true|false/', $aUBescheinigungVorhanden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($aUBescheinigungVorhanden, true)), __LINE__);
        }
        $this->AUBescheinigungVorhanden = $aUBescheinigungVorhanden;
        return $this;
    }
    /**
     * Get StationaereBehandlung value
     * @return bool|null
     */
    public function getStationaereBehandlung()
    {
        return $this->StationaereBehandlung;
    }
    /**
     * Set StationaereBehandlung value
     * @param bool $stationaereBehandlung
     * @return \BiPRO\StructType\CT_Personenschaden
     */
    public function setStationaereBehandlung($stationaereBehandlung = null)
    {
        // validation for constraint: boolean
        if (!is_null($stationaereBehandlung) && !is_bool($stationaereBehandlung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($stationaereBehandlung, true), gettype($stationaereBehandlung)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($stationaereBehandlung) && !preg_match('/true|false/', $stationaereBehandlung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($stationaereBehandlung, true)), __LINE__);
        }
        $this->StationaereBehandlung = $stationaereBehandlung;
        return $this;
    }
    /**
     * Get ICDCode value
     * @return string[]|null
     */
    public function getICDCode()
    {
        return $this->ICDCode;
    }
    /**
     * This method is responsible for validating the values passed to the setICDCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setICDCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateICDCodeForArrayConstraintsFromSetICDCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_PersonenschadenICDCodeItem) {
            // validation for constraint: itemType
            if (!is_string($cT_PersonenschadenICDCodeItem)) {
                $invalidValues[] = is_object($cT_PersonenschadenICDCodeItem) ? get_class($cT_PersonenschadenICDCodeItem) : sprintf('%s(%s)', gettype($cT_PersonenschadenICDCodeItem), var_export($cT_PersonenschadenICDCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ICDCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setICDCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setICDCode method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateICDCodeForMaxLengthConstraintFromSetICDCode($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_PersonenschadenICDCodeItem) {
            // validation for constraint: maxLength(6)
            if (mb_strlen($cT_PersonenschadenICDCodeItem) > 6) {
                $invalidValues[] = var_export($cT_PersonenschadenICDCodeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 6', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ICDCode value
     * @throws \InvalidArgumentException
     * @param string[] $iCDCode
     * @return \BiPRO\StructType\CT_Personenschaden
     */
    public function setICDCode(array $iCDCode = array())
    {
        // validation for constraint: array
        if ('' !== ($iCDCodeArrayErrorMessage = self::validateICDCodeForArrayConstraintsFromSetICDCode($iCDCode))) {
            throw new \InvalidArgumentException($iCDCodeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(6)
        if ('' !== ($iCDCodeMaxLengthErrorMessage = self::validateICDCodeForMaxLengthConstraintFromSetICDCode($iCDCode))) {
            throw new \InvalidArgumentException($iCDCodeMaxLengthErrorMessage, __LINE__);
        }
        $this->ICDCode = $iCDCode;
        return $this;
    }
    /**
     * Add item to ICDCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \BiPRO\StructType\CT_Personenschaden
     */
    public function addToICDCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ICDCode property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (mb_strlen($item) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($item)), __LINE__);
        }
        $this->ICDCode[] = $item;
        return $this;
    }
    /**
     * Get Arbeitsunfaehig value
     * @return \BiPRO\StructType\CT_Zeitraum2|null
     */
    public function getArbeitsunfaehig()
    {
        return $this->Arbeitsunfaehig;
    }
    /**
     * Set Arbeitsunfaehig value
     * @param \BiPRO\StructType\CT_Zeitraum2 $arbeitsunfaehig
     * @return \BiPRO\StructType\CT_Personenschaden
     */
    public function setArbeitsunfaehig(\BiPRO\StructType\CT_Zeitraum2 $arbeitsunfaehig = null)
    {
        $this->Arbeitsunfaehig = $arbeitsunfaehig;
        return $this;
    }
    /**
     * Get Krankenkasse value
     * @return \BiPRO\StructType\CT_Krankenkasse|null
     */
    public function getKrankenkasse()
    {
        return $this->Krankenkasse;
    }
    /**
     * Set Krankenkasse value
     * @param \BiPRO\StructType\CT_Krankenkasse $krankenkasse
     * @return \BiPRO\StructType\CT_Personenschaden
     */
    public function setKrankenkasse(\BiPRO\StructType\CT_Krankenkasse $krankenkasse = null)
    {
        $this->Krankenkasse = $krankenkasse;
        return $this;
    }
    /**
     * Get Krankenhaus value
     * @return \BiPRO\StructType\CT_Krankenhaus[]|null
     */
    public function getKrankenhaus()
    {
        return $this->Krankenhaus;
    }
    /**
     * This method is responsible for validating the values passed to the setKrankenhaus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKrankenhaus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKrankenhausForArrayConstraintsFromSetKrankenhaus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_PersonenschadenKrankenhausItem) {
            // validation for constraint: itemType
            if (!$cT_PersonenschadenKrankenhausItem instanceof \BiPRO\StructType\CT_Krankenhaus) {
                $invalidValues[] = is_object($cT_PersonenschadenKrankenhausItem) ? get_class($cT_PersonenschadenKrankenhausItem) : sprintf('%s(%s)', gettype($cT_PersonenschadenKrankenhausItem), var_export($cT_PersonenschadenKrankenhausItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Krankenhaus property can only contain items of type \BiPRO\StructType\CT_Krankenhaus, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Krankenhaus value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Krankenhaus[] $krankenhaus
     * @return \BiPRO\StructType\CT_Personenschaden
     */
    public function setKrankenhaus(array $krankenhaus = array())
    {
        // validation for constraint: array
        if ('' !== ($krankenhausArrayErrorMessage = self::validateKrankenhausForArrayConstraintsFromSetKrankenhaus($krankenhaus))) {
            throw new \InvalidArgumentException($krankenhausArrayErrorMessage, __LINE__);
        }
        $this->Krankenhaus = $krankenhaus;
        return $this;
    }
    /**
     * Add item to Krankenhaus value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Krankenhaus $item
     * @return \BiPRO\StructType\CT_Personenschaden
     */
    public function addToKrankenhaus(\BiPRO\StructType\CT_Krankenhaus $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Krankenhaus) {
            throw new \InvalidArgumentException(sprintf('The Krankenhaus property can only contain items of type \BiPRO\StructType\CT_Krankenhaus, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Krankenhaus[] = $item;
        return $this;
    }
    /**
     * Get BehandelnderArzt value
     * @return \BiPRO\StructType\CT_Arzt[]|null
     */
    public function getBehandelnderArzt()
    {
        return $this->BehandelnderArzt;
    }
    /**
     * This method is responsible for validating the values passed to the setBehandelnderArzt method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBehandelnderArzt method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBehandelnderArztForArrayConstraintsFromSetBehandelnderArzt(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_PersonenschadenBehandelnderArztItem) {
            // validation for constraint: itemType
            if (!$cT_PersonenschadenBehandelnderArztItem instanceof \BiPRO\StructType\CT_Arzt) {
                $invalidValues[] = is_object($cT_PersonenschadenBehandelnderArztItem) ? get_class($cT_PersonenschadenBehandelnderArztItem) : sprintf('%s(%s)', gettype($cT_PersonenschadenBehandelnderArztItem), var_export($cT_PersonenschadenBehandelnderArztItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BehandelnderArzt property can only contain items of type \BiPRO\StructType\CT_Arzt, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BehandelnderArzt value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Arzt[] $behandelnderArzt
     * @return \BiPRO\StructType\CT_Personenschaden
     */
    public function setBehandelnderArzt(array $behandelnderArzt = array())
    {
        // validation for constraint: array
        if ('' !== ($behandelnderArztArrayErrorMessage = self::validateBehandelnderArztForArrayConstraintsFromSetBehandelnderArzt($behandelnderArzt))) {
            throw new \InvalidArgumentException($behandelnderArztArrayErrorMessage, __LINE__);
        }
        $this->BehandelnderArzt = $behandelnderArzt;
        return $this;
    }
    /**
     * Add item to BehandelnderArzt value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Arzt $item
     * @return \BiPRO\StructType\CT_Personenschaden
     */
    public function addToBehandelnderArzt(\BiPRO\StructType\CT_Arzt $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Arzt) {
            throw new \InvalidArgumentException(sprintf('The BehandelnderArzt property can only contain items of type \BiPRO\StructType\CT_Arzt, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BehandelnderArzt[] = $item;
        return $this;
    }
    /**
     * Get Berufsgenossenschaft value
     * @return \BiPRO\StructType\CT_Berufsgenossenschaft|null
     */
    public function getBerufsgenossenschaft()
    {
        return $this->Berufsgenossenschaft;
    }
    /**
     * Set Berufsgenossenschaft value
     * @param \BiPRO\StructType\CT_Berufsgenossenschaft $berufsgenossenschaft
     * @return \BiPRO\StructType\CT_Personenschaden
     */
    public function setBerufsgenossenschaft(\BiPRO\StructType\CT_Berufsgenossenschaft $berufsgenossenschaft = null)
    {
        $this->Berufsgenossenschaft = $berufsgenossenschaft;
        return $this;
    }
}
