<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Partnernummer StructType
 * Meta information extracted from the WSDL
 * - documentation: Eindeutige Identifizierung eines Partners bei dem Partner, der als Quelle spezifiziert wird. Wird benötigt um eine Partnernummer zu spezifieren, die nicht vom produktgebenden Unternehmen oder vom Vermittler sondern von einem Dritten
 * vergeben wurde, z. B. einem Dienstleister.
 * @subpackage Structs
 */
class CT_Partnernummer extends CT_Objekt
{
    /**
     * The Nummer
     * Meta information extracted from the WSDL
     * - documentation: Eindeutige Identifizierung eines Partners.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $Nummer;
    /**
     * The Quelle
     * Meta information extracted from the WSDL
     * - documentation: Partner, der die Partnernummer vergeben hat.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Quelle
     */
    public $Quelle;
    /**
     * Constructor method for CT_Partnernummer
     * @uses CT_Partnernummer::setNummer()
     * @uses CT_Partnernummer::setQuelle()
     * @param string $nummer
     * @param \BiPRO\StructType\CT_Quelle $quelle
     */
    public function __construct($nummer = null, \BiPRO\StructType\CT_Quelle $quelle = null)
    {
        $this
            ->setNummer($nummer)
            ->setQuelle($quelle);
    }
    /**
     * Get Nummer value
     * @return string
     */
    public function getNummer()
    {
        return $this->Nummer;
    }
    /**
     * Set Nummer value
     * @param string $nummer
     * @return \BiPRO\StructType\CT_Partnernummer
     */
    public function setNummer($nummer = null)
    {
        // validation for constraint: string
        if (!is_null($nummer) && !is_string($nummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nummer, true), gettype($nummer)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($nummer) && mb_strlen($nummer) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($nummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($nummer) && mb_strlen($nummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($nummer)), __LINE__);
        }
        $this->Nummer = $nummer;
        return $this;
    }
    /**
     * Get Quelle value
     * @return \BiPRO\StructType\CT_Quelle|null
     */
    public function getQuelle()
    {
        return $this->Quelle;
    }
    /**
     * Set Quelle value
     * @param \BiPRO\StructType\CT_Quelle $quelle
     * @return \BiPRO\StructType\CT_Partnernummer
     */
    public function setQuelle(\BiPRO\StructType\CT_Quelle $quelle = null)
    {
        $this->Quelle = $quelle;
        return $this;
    }
}
