<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Partnerbeziehung StructType
 * @subpackage Structs
 */
class CT_Partnerbeziehung extends CT_Partnerrolle
{
    /**
     * The Art
     * Meta information extracted from the WSDL
     * - documentation: Beschreibt die Art der Beziehung der Partner untereinander. Im Falle von natürlichen Personen können hierüber z. B. Verwandtschaftsverhältnisse wie z. B. Eltern-Kind-Beziehungen innerhalb der Rolle abgebildet werden.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \BiPRO\StructType\STE_Partnerbeziehung
     */
    public $Art;
    /**
     * The Beschreibung
     * Meta information extracted from the WSDL
     * - documentation: Beschreibung der Partnerbeziehung, wenn sie durch die Art nicht ausreichend spezifiert werden kann (z.B. Neffe der Oma).
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Beschreibung;
    /**
     * Constructor method for CT_Partnerbeziehung
     * @uses CT_Partnerbeziehung::setArt()
     * @uses CT_Partnerbeziehung::setBeschreibung()
     * @param \BiPRO\StructType\STE_Partnerbeziehung $art
     * @param string $beschreibung
     */
    public function __construct(\BiPRO\StructType\STE_Partnerbeziehung $art = null, $beschreibung = null)
    {
        $this
            ->setArt($art)
            ->setBeschreibung($beschreibung);
    }
    /**
     * Get Art value
     * @return \BiPRO\StructType\STE_Partnerbeziehung
     */
    public function getArt()
    {
        return $this->Art;
    }
    /**
     * Set Art value
     * @param \BiPRO\StructType\STE_Partnerbeziehung $art
     * @return \BiPRO\StructType\CT_Partnerbeziehung
     */
    public function setArt(\BiPRO\StructType\STE_Partnerbeziehung $art = null)
    {
        $this->Art = $art;
        return $this;
    }
    /**
     * Get Beschreibung value
     * @return string|null
     */
    public function getBeschreibung()
    {
        return $this->Beschreibung;
    }
    /**
     * Set Beschreibung value
     * @param string $beschreibung
     * @return \BiPRO\StructType\CT_Partnerbeziehung
     */
    public function setBeschreibung($beschreibung = null)
    {
        // validation for constraint: string
        if (!is_null($beschreibung) && !is_string($beschreibung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beschreibung, true), gettype($beschreibung)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($beschreibung) && mb_strlen($beschreibung) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($beschreibung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($beschreibung) && mb_strlen($beschreibung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($beschreibung)), __LINE__);
        }
        $this->Beschreibung = $beschreibung;
        return $this;
    }
}
