<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Partneranschrift StructType
 * Meta information extracted from the WSDL
 * - documentation: Anschrift eines Partners.
 * @subpackage Structs
 */
class CT_Partneranschrift extends CT_Adresse
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArtID;
    /**
     * The Postfach
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 8
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Postfach;
    /**
     * The Adresszusatz
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Adresszusatz;
    /**
     * The Adresstyp
     * Meta information extracted from the WSDL
     * - documentation: Typ der Partneranschrift (z.B. geschaeftlich, privat).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Adresstyp;
    /**
     * The BevorzugteKorrespondenzanschrift
     * Meta information extracted from the WSDL
     * - documentation: Identifiziert die Anschrift, an welche die Korrespondenz gerichtet werden soll. Der Provider nutzt diese Anschrift zu 100% zur Kommunikation. Die bevorzugte Anschrift darf nur einmal vorkommen.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $BevorzugteKorrespondenzanschrift;
    /**
     * Constructor method for CT_Partneranschrift
     * @uses CT_Partneranschrift::setArtID()
     * @uses CT_Partneranschrift::setPostfach()
     * @uses CT_Partneranschrift::setAdresszusatz()
     * @uses CT_Partneranschrift::setAdresstyp()
     * @uses CT_Partneranschrift::setBevorzugteKorrespondenzanschrift()
     * @param string $artID
     * @param string $postfach
     * @param string $adresszusatz
     * @param string $adresstyp
     * @param bool $bevorzugteKorrespondenzanschrift
     */
    public function __construct($artID = null, $postfach = null, $adresszusatz = null, $adresstyp = null, $bevorzugteKorrespondenzanschrift = null)
    {
        $this
            ->setArtID($artID)
            ->setPostfach($postfach)
            ->setAdresszusatz($adresszusatz)
            ->setAdresstyp($adresstyp)
            ->setBevorzugteKorrespondenzanschrift($bevorzugteKorrespondenzanschrift);
    }
    /**
     * Get ArtID value
     * @return string|null
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @uses \BiPRO\EnumType\ST_Anschriftart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Anschriftart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artID
     * @return \BiPRO\StructType\CT_Partneranschrift
     */
    public function setArtID($artID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Anschriftart::valueIsValid($artID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Anschriftart', is_array($artID) ? implode(', ', $artID) : var_export($artID, true), implode(', ', \BiPRO\EnumType\ST_Anschriftart::getValidValues())), __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Postfach value
     * @return string|null
     */
    public function getPostfach()
    {
        return $this->Postfach;
    }
    /**
     * Set Postfach value
     * @param string $postfach
     * @return \BiPRO\StructType\CT_Partneranschrift
     */
    public function setPostfach($postfach = null)
    {
        // validation for constraint: string
        if (!is_null($postfach) && !is_string($postfach)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postfach, true), gettype($postfach)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($postfach) && mb_strlen($postfach) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($postfach)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($postfach) && mb_strlen($postfach) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($postfach)), __LINE__);
        }
        $this->Postfach = $postfach;
        return $this;
    }
    /**
     * Get Adresszusatz value
     * @return string|null
     */
    public function getAdresszusatz()
    {
        return $this->Adresszusatz;
    }
    /**
     * Set Adresszusatz value
     * @param string $adresszusatz
     * @return \BiPRO\StructType\CT_Partneranschrift
     */
    public function setAdresszusatz($adresszusatz = null)
    {
        // validation for constraint: string
        if (!is_null($adresszusatz) && !is_string($adresszusatz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adresszusatz, true), gettype($adresszusatz)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($adresszusatz) && mb_strlen($adresszusatz) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($adresszusatz)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($adresszusatz) && mb_strlen($adresszusatz) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($adresszusatz)), __LINE__);
        }
        $this->Adresszusatz = $adresszusatz;
        return $this;
    }
    /**
     * Get Adresstyp value
     * @return string|null
     */
    public function getAdresstyp()
    {
        return $this->Adresstyp;
    }
    /**
     * Set Adresstyp value
     * @uses \BiPRO\EnumType\ST_Adresstyp::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Adresstyp::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $adresstyp
     * @return \BiPRO\StructType\CT_Partneranschrift
     */
    public function setAdresstyp($adresstyp = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Adresstyp::valueIsValid($adresstyp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Adresstyp', is_array($adresstyp) ? implode(', ', $adresstyp) : var_export($adresstyp, true), implode(', ', \BiPRO\EnumType\ST_Adresstyp::getValidValues())), __LINE__);
        }
        $this->Adresstyp = $adresstyp;
        return $this;
    }
    /**
     * Get BevorzugteKorrespondenzanschrift value
     * @return bool|null
     */
    public function getBevorzugteKorrespondenzanschrift()
    {
        return $this->BevorzugteKorrespondenzanschrift;
    }
    /**
     * Set BevorzugteKorrespondenzanschrift value
     * @param bool $bevorzugteKorrespondenzanschrift
     * @return \BiPRO\StructType\CT_Partneranschrift
     */
    public function setBevorzugteKorrespondenzanschrift($bevorzugteKorrespondenzanschrift = null)
    {
        // validation for constraint: boolean
        if (!is_null($bevorzugteKorrespondenzanschrift) && !is_bool($bevorzugteKorrespondenzanschrift)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bevorzugteKorrespondenzanschrift, true), gettype($bevorzugteKorrespondenzanschrift)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($bevorzugteKorrespondenzanschrift) && !preg_match('/true|false/', $bevorzugteKorrespondenzanschrift)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($bevorzugteKorrespondenzanschrift, true)), __LINE__);
        }
        $this->BevorzugteKorrespondenzanschrift = $bevorzugteKorrespondenzanschrift;
        return $this;
    }
}
