<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Oder StructType
 * Meta information extracted from the WSDL
 * - documentation: Mit der Klasse ODER können logische ODER-Verknüpfungen von zwei oder mehr Bedingungen abgebildet werden. Das Ergebnis ist true, wenn eine oder mehrere der so verknüpften Bedingungen true sind. Ist keine der verknüpften
 * Bedingungen true, so ist das Ergebnis der Verknüpfung false.
 * @subpackage Structs
 */
class CT_Oder extends CT_Bedingung
{
    /**
     * The Bedingung
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 2
     * @var \BiPRO\StructType\CT_Bedingung[]
     */
    public $Bedingung;
    /**
     * Constructor method for CT_Oder
     * @uses CT_Oder::setBedingung()
     * @param \BiPRO\StructType\CT_Bedingung[] $bedingung
     */
    public function __construct(array $bedingung = array())
    {
        $this
            ->setBedingung($bedingung);
    }
    /**
     * Get Bedingung value
     * @return \BiPRO\StructType\CT_Bedingung[]
     */
    public function getBedingung()
    {
        return $this->Bedingung;
    }
    /**
     * This method is responsible for validating the values passed to the setBedingung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBedingung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBedingungForArrayConstraintsFromSetBedingung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_OderBedingungItem) {
            // validation for constraint: itemType
            if (!$cT_OderBedingungItem instanceof \BiPRO\StructType\CT_Bedingung) {
                $invalidValues[] = is_object($cT_OderBedingungItem) ? get_class($cT_OderBedingungItem) : sprintf('%s(%s)', gettype($cT_OderBedingungItem), var_export($cT_OderBedingungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Bedingung property can only contain items of type \BiPRO\StructType\CT_Bedingung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Bedingung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Bedingung[] $bedingung
     * @return \BiPRO\StructType\CT_Oder
     */
    public function setBedingung(array $bedingung = array())
    {
        // validation for constraint: array
        if ('' !== ($bedingungArrayErrorMessage = self::validateBedingungForArrayConstraintsFromSetBedingung($bedingung))) {
            throw new \InvalidArgumentException($bedingungArrayErrorMessage, __LINE__);
        }
        $this->Bedingung = $bedingung;
        return $this;
    }
    /**
     * Add item to Bedingung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Bedingung $item
     * @return \BiPRO\StructType\CT_Oder
     */
    public function addToBedingung(\BiPRO\StructType\CT_Bedingung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Bedingung) {
            throw new \InvalidArgumentException(sprintf('The Bedingung property can only contain items of type \BiPRO\StructType\CT_Bedingung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Bedingung[] = $item;
        return $this;
    }
}
