<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Objektanschrift StructType
 * @subpackage Structs
 */
class CT_Objektanschrift extends CT_Adresse
{
    /**
     * The Flurstueck
     * Meta information extracted from the WSDL
     * - documentation: Flurstück-Nummer eines bebauten oder unbebauten Grundstücks.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Flurstueck;
    /**
     * The Parzelle
     * Meta information extracted from the WSDL
     * - documentation: Parzellen-Nummer eines bebauten oder unbebauten Grundstücks.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Parzelle;
    /**
     * Constructor method for CT_Objektanschrift
     * @uses CT_Objektanschrift::setFlurstueck()
     * @uses CT_Objektanschrift::setParzelle()
     * @param string $flurstueck
     * @param string $parzelle
     */
    public function __construct($flurstueck = null, $parzelle = null)
    {
        $this
            ->setFlurstueck($flurstueck)
            ->setParzelle($parzelle);
    }
    /**
     * Get Flurstueck value
     * @return string|null
     */
    public function getFlurstueck()
    {
        return $this->Flurstueck;
    }
    /**
     * Set Flurstueck value
     * @param string $flurstueck
     * @return \BiPRO\StructType\CT_Objektanschrift
     */
    public function setFlurstueck($flurstueck = null)
    {
        // validation for constraint: string
        if (!is_null($flurstueck) && !is_string($flurstueck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flurstueck, true), gettype($flurstueck)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($flurstueck) && mb_strlen($flurstueck) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($flurstueck)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($flurstueck) && mb_strlen($flurstueck) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($flurstueck)), __LINE__);
        }
        $this->Flurstueck = $flurstueck;
        return $this;
    }
    /**
     * Get Parzelle value
     * @return string|null
     */
    public function getParzelle()
    {
        return $this->Parzelle;
    }
    /**
     * Set Parzelle value
     * @param string $parzelle
     * @return \BiPRO\StructType\CT_Objektanschrift
     */
    public function setParzelle($parzelle = null)
    {
        // validation for constraint: string
        if (!is_null($parzelle) && !is_string($parzelle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parzelle, true), gettype($parzelle)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($parzelle) && mb_strlen($parzelle) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($parzelle)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($parzelle) && mb_strlen($parzelle) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($parzelle)), __LINE__);
        }
        $this->Parzelle = $parzelle;
        return $this;
    }
}
