<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Meldung StructType
 * Meta information extracted from the WSDL
 * - documentation: Ermoeglicht die Erweiterung einer Statusmeldung um zusaetzliche Informationen (z.B. Fehlermeldungen oder Hinweise).
 * @subpackage Structs
 */
class CT_Meldung extends CT_Objekt
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Ermoeglicht die Erweiterung einer Statusmeldung um zusaetzliche Informationen (z.B. Fehlermeldungen oder Hinweise), insbesondere dann, wenn eine synchrone Verarbeitung nicht mit einem Ergebnis abgeschlossen werden konnte. In
     * Anhängigkeit zu Status.statusid MUSS oder KANN das Objekt übermittelt werden.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ArtID;
    /**
     * The MeldungID
     * Meta information extracted from the WSDL
     * - documentation: Eindeutige Identifizierung der Meldung.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MeldungID;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - documentation: Meldung als Klartext. Diese MUSS natürlichsprachlich und für einen Endanwender (Vermittler) fachlich verständlich formuliert sein. DIe Meldung DARF auf der Benutzeroberfläche angezeigt werden.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * The Quelle
     * Meta information extracted from the WSDL
     * - documentation: Eindeutige Referenz auf das fehlerhafte Objekt und die Objekt-Eigenschaft mittels XPath.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Quelle;
    /**
     * The Identifikationsnummer
     * Meta information extracted from the WSDL
     * - documentation: Alphanummerische eindeutige Kennzeichnung der Meldung bzw. des Fehlers oder Hinweises. Anhand der Nummer wird insbesondere die nichttechnische Kommunikation zwischen Nutzer und Anbieter erleichtert.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Identifikationsnummer;
    /**
     * Constructor method for CT_Meldung
     * @uses CT_Meldung::setArtID()
     * @uses CT_Meldung::setMeldungID()
     * @uses CT_Meldung::setText()
     * @uses CT_Meldung::setQuelle()
     * @uses CT_Meldung::setIdentifikationsnummer()
     * @param string $artID
     * @param string $meldungID
     * @param string $text
     * @param string $quelle
     * @param string $identifikationsnummer
     */
    public function __construct($artID = null, $meldungID = null, $text = null, $quelle = null, $identifikationsnummer = null)
    {
        $this
            ->setArtID($artID)
            ->setMeldungID($meldungID)
            ->setText($text)
            ->setQuelle($quelle)
            ->setIdentifikationsnummer($identifikationsnummer);
    }
    /**
     * Get ArtID value
     * @return string
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @uses \BiPRO\EnumType\ST_Meldungsart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Meldungsart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artID
     * @return \BiPRO\StructType\CT_Meldung
     */
    public function setArtID($artID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Meldungsart::valueIsValid($artID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Meldungsart', is_array($artID) ? implode(', ', $artID) : var_export($artID, true), implode(', ', \BiPRO\EnumType\ST_Meldungsart::getValidValues())), __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get MeldungID value
     * @return string
     */
    public function getMeldungID()
    {
        return $this->MeldungID;
    }
    /**
     * Set MeldungID value
     * @uses \BiPRO\EnumType\ST_Meldung::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Meldung::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $meldungID
     * @return \BiPRO\StructType\CT_Meldung
     */
    public function setMeldungID($meldungID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Meldung::valueIsValid($meldungID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Meldung', is_array($meldungID) ? implode(', ', $meldungID) : var_export($meldungID, true), implode(', ', \BiPRO\EnumType\ST_Meldung::getValidValues())), __LINE__);
        }
        $this->MeldungID = $meldungID;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \BiPRO\StructType\CT_Meldung
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Get Quelle value
     * @return string|null
     */
    public function getQuelle()
    {
        return $this->Quelle;
    }
    /**
     * Set Quelle value
     * @param string $quelle
     * @return \BiPRO\StructType\CT_Meldung
     */
    public function setQuelle($quelle = null)
    {
        // validation for constraint: string
        if (!is_null($quelle) && !is_string($quelle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quelle, true), gettype($quelle)), __LINE__);
        }
        $this->Quelle = $quelle;
        return $this;
    }
    /**
     * Get Identifikationsnummer value
     * @return string|null
     */
    public function getIdentifikationsnummer()
    {
        return $this->Identifikationsnummer;
    }
    /**
     * Set Identifikationsnummer value
     * @param string $identifikationsnummer
     * @return \BiPRO\StructType\CT_Meldung
     */
    public function setIdentifikationsnummer($identifikationsnummer = null)
    {
        // validation for constraint: string
        if (!is_null($identifikationsnummer) && !is_string($identifikationsnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identifikationsnummer, true), gettype($identifikationsnummer)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($identifikationsnummer) && mb_strlen($identifikationsnummer) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($identifikationsnummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($identifikationsnummer) && mb_strlen($identifikationsnummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($identifikationsnummer)), __LINE__);
        }
        $this->Identifikationsnummer = $identifikationsnummer;
        return $this;
    }
}
