<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Mandat StructType
 * Meta information extracted from the WSDL
 * - documentation: Diese Klasse bildet ein SEPA-Mandat ab und enthält alle im Kontext SEPA-Lastschrift relevanten Entitäten.Zur vollständigen Abbildung des Mandats MÜSSEN die Attribute IBAN und BIC der Basisklasse Bankverbindung belegt werden.
 * @subpackage Structs
 */
class CT_Mandat extends CT_BankverbindungBasis
{
    /**
     * The Art
     * Meta information extracted from the WSDL
     * - documentation: Art des Mandats.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Art;
    /**
     * The Glaeubiger
     * Meta information extracted from the WSDL
     * - documentation: Der Empfänger der Zahlungen.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \BiPRO\StructType\CT_Unternehmen
     */
    public $Glaeubiger;
    /**
     * The DatumUnterschrift
     * Meta information extracted from the WSDL
     * - documentation: Datum, an dem das Mandat vom Mandatgeber unterzeichnet wurde.Liegt die Unterschrift zum abzubildenden Mandat vor, MUSS dieses Attribut gefüllt werden. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $DatumUnterschrift;
    /**
     * The OrtUnterschrift
     * Meta information extracted from the WSDL
     * - documentation: Ort, an dem das Mandat vom Mandatgeber unterzeichnet wurde.Liegt die Unterschrift zum abzubildenden Mandat vor, MUSS dieses Attribut gefüllt werden.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $OrtUnterschrift;
    /**
     * The Mandatsreferenz
     * Meta information extracted from the WSDL
     * - documentation: Eindeutige, vom Gläubiger vergebene Identifikation des Mandats.Wurde die ID vergeben, MUSS dieses Attribut gefüllt werden. | Vom Zahlungsempfänger individuell vergebenes Kennzeichen eines Mandats.
     * - base: xsd:string
     * - maxLength: 35
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Mandatsreferenz;
    /**
     * The GlaeubigerID
     * Meta information extracted from the WSDL
     * - documentation: Die Gläubiger-Identifikationsnummer dient zur kontounabhängigen und eindeutigen Identifizierung des Gläubigers. Sie wird in Deutschland von der Bundesbank erteilt und MUSS immer angegeben werden. Ist die GläubigerID im
     * vorliegenden Prozessschritt noch nicht bekannt, DARF das Attribut leer bleiben. | Eindeutige Kennzeichnung des Lastschriftgläubigers (Creditor Identifier).
     * - base: xsd:string
     * - maxLength: 35
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GlaeubigerID;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Status des Mandats.Sobald bekannt DARF dieses Attribut gefüllt werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The NotifikationsFrist
     * Meta information extracted from the WSDL
     * - documentation: Tage, die die Pre-Notification vor Abbuchung versendet werden muss.Dieses Attribut MUSS vom Provider IMMER geliefert werden, auch wenn nicht vom Standard (derzeit 24 Tage) abgewichen wird.Der Consumer DARF dieses Attribut
     * wiederholen, DARF es aber NICHT abweichend belegen. Eine Vorgabe von Consumerseite ist hierzu nicht möglich.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $NotifikationsFrist;
    /**
     * The NotifikationsWeg
     * Meta information extracted from the WSDL
     * - documentation: Zeigt die Versandart bei einem eigenständigen Pre-Notifikationsversand an.Bei postalischem Versand MUSS im Partnerobjekt des Mandatgläubiger genutzte Partneranschrift (mit BevorzugteKorrespondenzanschrift = true) übertragen
     * werden.Falls der Notifikationsweg nicht postalisch ist, MUSS die Notifikationsverbindung der Auswahl entsprechen. Bsp.: Ist Notifikationsweg = 003 (Email), muss die Notifikationsverbinung eine Mailadresse enthalten.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NotifikationsWeg;
    /**
     * The GewuenschterAbbuchungstag
     * Meta information extracted from the WSDL
     * - documentation: Kalendertag der Abbuchung entsprechend Kundenwunsch.Falls der Kunde eine Abbuchung an einem bestimmten Abbuchungstag wünscht, MUSS dieses Attribut entsprechend belegt werden. Existiert kein solch ein Wunschtermin, DARF das Attribut
     * NICHT belegt werden.Bsp.: Kunde wünscht die Abbuchung immer am 15. des Monats -> GewuenschterAbbuchungstag = 15 | Zur Abbildung von Kalendertagen.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-3][0-9]
     * @var string
     */
    public $GewuenschterAbbuchungstag;
    /**
     * The Sprache
     * Meta information extracted from the WSDL
     * - documentation: Ausfertigungssprache des Mandats und damit der Notifikationen.Request: Durch Angabe des Attributs im Request, DARF der Consumer die vom Kunden gewünschte Sprache mitteilen.Response: Der Provider MUSS dieses Attribut im Response
     * grundsätzlich mit der/den tatsächlichen Ausfertigungssprache(n) belegen. | Ausprägungen MÜSSEN ISO639-3 entsprechend.
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: unbounded
     * - minLength: 3
     * - minOccurs: 0
     * @var string[]
     */
    public $Sprache;
    /**
     * The Mandatgeber
     * Meta information extracted from the WSDL
     * - documentation: Mandatgeber. Diejenige Person, die das Mandat erteilt.Der Mandatgeber MUSS angegeben werden. Im referenzierten Partnerobjekt MÜSSEN Name und Anschrift angegeben werden. Handelt es sich um eine natürliche Person, MUSS zusätzlich
     * der Vorname angegeben werden.Bei Mandat-Änderungsprozessen ohne Auswirkung auf den Mandatgeber (z.B. Änderung der Notifikationsverbindung) DARF auf die Angabe des Mandatgebers verzichtet werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Mandatgeber
     */
    public $Mandatgeber;
    /**
     * The ZugeordneterVertrag
     * Meta information extracted from the WSDL
     * - documentation: Der dem Mandat zugeordnete Vertrag bzw. Verträge.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Vertragsnummer[]
     */
    public $ZugeordneterVertrag;
    /**
     * The Notifikationsverbindung
     * Meta information extracted from the WSDL
     * - documentation: Zur Notifikation genutzte Kommunikationsverbindung (ausser Postanschrift).Die angegebene Kommunikaionsverbindung MUSS dem Notifikationsweg entsprechen (Bsp.: wenn Notifikationsweg=Email, muss Notifikationsverbindung einer Mailadresse
     * entsprechen)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Kommunikationsverbindung
     */
    public $Notifikationsverbindung;
    /**
     * The AbweichenderSchuldner
     * Meta information extracted from the WSDL
     * - documentation: Der abweichende Schuldner ist der Schuldner, der nicht der Mandatsgeber ist. Existiert diese Rolle im vorliegenden Kontext, MUSS das Objekt entsprechend belegt werden.Bsp. Versicherungen: Weicht der Kontoinhaber vom
     * Versicherungsnehmer ab, ist der Kontoinhaber der Mandatgeber und der Versicherungsnehmer der abweichende Schuldner (sofern kein abweichender Beitragszahler existiert, sonst ist der Beitragszahler der abweichende Schuldner).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_AbweichenderSchuldner
     */
    public $AbweichenderSchuldner;
    /**
     * The MandatsAblageort
     * Meta information extracted from the WSDL
     * - documentation: Legt fest wie das SEPA-Orginalmandat verwaltet wird.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MandatsAblageort;
    /**
     * The Lastschriftart
     * Meta information extracted from the WSDL
     * - documentation: Ausprägung, ob es sich bei dieser Lastschrift um eine Basis- oder Firmenlastschrift handelt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Lastschriftart;
    /**
     * The Gueltigkeit
     * Meta information extracted from the WSDL
     * - documentation: Beginn: Zeitpunkt an dem das Mandat erstellt wurde. Dieser DARF von DatumUnterschrift abweichen.Ende: Vom Mandatsgeber festgelegtes Datum bis zu dem dieses Mandat verwendet werden darf.Es MÜSSEN konkrete Zeitpunkte angegeben werden
     * WENN diese existieren/bekannt sind. Nichtbelegung MUSS dem entsprechend interpretiert werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zeitraum
     */
    public $Gueltigkeit;
    /**
     * Constructor method for CT_Mandat
     * @uses CT_Mandat::setArt()
     * @uses CT_Mandat::setGlaeubiger()
     * @uses CT_Mandat::setDatumUnterschrift()
     * @uses CT_Mandat::setOrtUnterschrift()
     * @uses CT_Mandat::setMandatsreferenz()
     * @uses CT_Mandat::setGlaeubigerID()
     * @uses CT_Mandat::setStatus()
     * @uses CT_Mandat::setNotifikationsFrist()
     * @uses CT_Mandat::setNotifikationsWeg()
     * @uses CT_Mandat::setGewuenschterAbbuchungstag()
     * @uses CT_Mandat::setSprache()
     * @uses CT_Mandat::setMandatgeber()
     * @uses CT_Mandat::setZugeordneterVertrag()
     * @uses CT_Mandat::setNotifikationsverbindung()
     * @uses CT_Mandat::setAbweichenderSchuldner()
     * @uses CT_Mandat::setMandatsAblageort()
     * @uses CT_Mandat::setLastschriftart()
     * @uses CT_Mandat::setGueltigkeit()
     * @param string $art
     * @param \BiPRO\StructType\CT_Unternehmen $glaeubiger
     * @param string $datumUnterschrift
     * @param string $ortUnterschrift
     * @param string $mandatsreferenz
     * @param string $glaeubigerID
     * @param string $status
     * @param int $notifikationsFrist
     * @param string $notifikationsWeg
     * @param string $gewuenschterAbbuchungstag
     * @param string[] $sprache
     * @param \BiPRO\StructType\CT_Mandatgeber $mandatgeber
     * @param \BiPRO\StructType\CT_Vertragsnummer[] $zugeordneterVertrag
     * @param \BiPRO\StructType\CT_Kommunikationsverbindung $notifikationsverbindung
     * @param \BiPRO\StructType\CT_AbweichenderSchuldner $abweichenderSchuldner
     * @param string $mandatsAblageort
     * @param string $lastschriftart
     * @param \BiPRO\StructType\CT_Zeitraum $gueltigkeit
     */
    public function __construct($art = null, \BiPRO\StructType\CT_Unternehmen $glaeubiger = null, $datumUnterschrift = null, $ortUnterschrift = null, $mandatsreferenz = null, $glaeubigerID = null, $status = null, $notifikationsFrist = null, $notifikationsWeg = null, $gewuenschterAbbuchungstag = null, array $sprache = array(), \BiPRO\StructType\CT_Mandatgeber $mandatgeber = null, array $zugeordneterVertrag = array(), \BiPRO\StructType\CT_Kommunikationsverbindung $notifikationsverbindung = null, \BiPRO\StructType\CT_AbweichenderSchuldner $abweichenderSchuldner = null, $mandatsAblageort = null, $lastschriftart = null, \BiPRO\StructType\CT_Zeitraum $gueltigkeit = null)
    {
        $this
            ->setArt($art)
            ->setGlaeubiger($glaeubiger)
            ->setDatumUnterschrift($datumUnterschrift)
            ->setOrtUnterschrift($ortUnterschrift)
            ->setMandatsreferenz($mandatsreferenz)
            ->setGlaeubigerID($glaeubigerID)
            ->setStatus($status)
            ->setNotifikationsFrist($notifikationsFrist)
            ->setNotifikationsWeg($notifikationsWeg)
            ->setGewuenschterAbbuchungstag($gewuenschterAbbuchungstag)
            ->setSprache($sprache)
            ->setMandatgeber($mandatgeber)
            ->setZugeordneterVertrag($zugeordneterVertrag)
            ->setNotifikationsverbindung($notifikationsverbindung)
            ->setAbweichenderSchuldner($abweichenderSchuldner)
            ->setMandatsAblageort($mandatsAblageort)
            ->setLastschriftart($lastschriftart)
            ->setGueltigkeit($gueltigkeit);
    }
    /**
     * Get Art value
     * @return string
     */
    public function getArt()
    {
        return $this->Art;
    }
    /**
     * Set Art value
     * @uses \BiPRO\EnumType\ST_MandatArt::valueIsValid()
     * @uses \BiPRO\EnumType\ST_MandatArt::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $art
     * @return \BiPRO\StructType\CT_Mandat
     */
    public function setArt($art = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_MandatArt::valueIsValid($art)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_MandatArt', is_array($art) ? implode(', ', $art) : var_export($art, true), implode(', ', \BiPRO\EnumType\ST_MandatArt::getValidValues())), __LINE__);
        }
        $this->Art = $art;
        return $this;
    }
    /**
     * Get Glaeubiger value
     * @return \BiPRO\StructType\CT_Unternehmen
     */
    public function getGlaeubiger()
    {
        return $this->Glaeubiger;
    }
    /**
     * Set Glaeubiger value
     * @param \BiPRO\StructType\CT_Unternehmen $glaeubiger
     * @return \BiPRO\StructType\CT_Mandat
     */
    public function setGlaeubiger(\BiPRO\StructType\CT_Unternehmen $glaeubiger = null)
    {
        $this->Glaeubiger = $glaeubiger;
        return $this;
    }
    /**
     * Get DatumUnterschrift value
     * @return string|null
     */
    public function getDatumUnterschrift()
    {
        return $this->DatumUnterschrift;
    }
    /**
     * Set DatumUnterschrift value
     * @param string $datumUnterschrift
     * @return \BiPRO\StructType\CT_Mandat
     */
    public function setDatumUnterschrift($datumUnterschrift = null)
    {
        // validation for constraint: string
        if (!is_null($datumUnterschrift) && !is_string($datumUnterschrift)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumUnterschrift, true), gettype($datumUnterschrift)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($datumUnterschrift) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $datumUnterschrift)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($datumUnterschrift, true)), __LINE__);
        }
        $this->DatumUnterschrift = $datumUnterschrift;
        return $this;
    }
    /**
     * Get OrtUnterschrift value
     * @return string|null
     */
    public function getOrtUnterschrift()
    {
        return $this->OrtUnterschrift;
    }
    /**
     * Set OrtUnterschrift value
     * @param string $ortUnterschrift
     * @return \BiPRO\StructType\CT_Mandat
     */
    public function setOrtUnterschrift($ortUnterschrift = null)
    {
        // validation for constraint: string
        if (!is_null($ortUnterschrift) && !is_string($ortUnterschrift)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ortUnterschrift, true), gettype($ortUnterschrift)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($ortUnterschrift) && mb_strlen($ortUnterschrift) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($ortUnterschrift)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ortUnterschrift) && mb_strlen($ortUnterschrift) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ortUnterschrift)), __LINE__);
        }
        $this->OrtUnterschrift = $ortUnterschrift;
        return $this;
    }
    /**
     * Get Mandatsreferenz value
     * @return string|null
     */
    public function getMandatsreferenz()
    {
        return $this->Mandatsreferenz;
    }
    /**
     * Set Mandatsreferenz value
     * @param string $mandatsreferenz
     * @return \BiPRO\StructType\CT_Mandat
     */
    public function setMandatsreferenz($mandatsreferenz = null)
    {
        // validation for constraint: string
        if (!is_null($mandatsreferenz) && !is_string($mandatsreferenz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mandatsreferenz, true), gettype($mandatsreferenz)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($mandatsreferenz) && mb_strlen($mandatsreferenz) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($mandatsreferenz)), __LINE__);
        }
        $this->Mandatsreferenz = $mandatsreferenz;
        return $this;
    }
    /**
     * Get GlaeubigerID value
     * @return string|null
     */
    public function getGlaeubigerID()
    {
        return $this->GlaeubigerID;
    }
    /**
     * Set GlaeubigerID value
     * @param string $glaeubigerID
     * @return \BiPRO\StructType\CT_Mandat
     */
    public function setGlaeubigerID($glaeubigerID = null)
    {
        // validation for constraint: string
        if (!is_null($glaeubigerID) && !is_string($glaeubigerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($glaeubigerID, true), gettype($glaeubigerID)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($glaeubigerID) && mb_strlen($glaeubigerID) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($glaeubigerID)), __LINE__);
        }
        $this->GlaeubigerID = $glaeubigerID;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \BiPRO\EnumType\ST_MandatStatus::valueIsValid()
     * @uses \BiPRO\EnumType\ST_MandatStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \BiPRO\StructType\CT_Mandat
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_MandatStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_MandatStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \BiPRO\EnumType\ST_MandatStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get NotifikationsFrist value
     * @return int|null
     */
    public function getNotifikationsFrist()
    {
        return $this->NotifikationsFrist;
    }
    /**
     * Set NotifikationsFrist value
     * @param int $notifikationsFrist
     * @return \BiPRO\StructType\CT_Mandat
     */
    public function setNotifikationsFrist($notifikationsFrist = null)
    {
        // validation for constraint: int
        if (!is_null($notifikationsFrist) && !(is_int($notifikationsFrist) || ctype_digit($notifikationsFrist))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($notifikationsFrist, true), gettype($notifikationsFrist)), __LINE__);
        }
        $this->NotifikationsFrist = $notifikationsFrist;
        return $this;
    }
    /**
     * Get NotifikationsWeg value
     * @return string|null
     */
    public function getNotifikationsWeg()
    {
        return $this->NotifikationsWeg;
    }
    /**
     * Set NotifikationsWeg value
     * @uses \BiPRO\EnumType\ST_Versandart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Versandart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $notifikationsWeg
     * @return \BiPRO\StructType\CT_Mandat
     */
    public function setNotifikationsWeg($notifikationsWeg = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Versandart::valueIsValid($notifikationsWeg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Versandart', is_array($notifikationsWeg) ? implode(', ', $notifikationsWeg) : var_export($notifikationsWeg, true), implode(', ', \BiPRO\EnumType\ST_Versandart::getValidValues())), __LINE__);
        }
        $this->NotifikationsWeg = $notifikationsWeg;
        return $this;
    }
    /**
     * Get GewuenschterAbbuchungstag value
     * @return string|null
     */
    public function getGewuenschterAbbuchungstag()
    {
        return $this->GewuenschterAbbuchungstag;
    }
    /**
     * Set GewuenschterAbbuchungstag value
     * @param string $gewuenschterAbbuchungstag
     * @return \BiPRO\StructType\CT_Mandat
     */
    public function setGewuenschterAbbuchungstag($gewuenschterAbbuchungstag = null)
    {
        // validation for constraint: string
        if (!is_null($gewuenschterAbbuchungstag) && !is_string($gewuenschterAbbuchungstag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gewuenschterAbbuchungstag, true), gettype($gewuenschterAbbuchungstag)), __LINE__);
        }
        // validation for constraint: pattern([0-3][0-9])
        if (!is_null($gewuenschterAbbuchungstag) && !preg_match('/[0-3][0-9]/', $gewuenschterAbbuchungstag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-3][0-9]', var_export($gewuenschterAbbuchungstag, true)), __LINE__);
        }
        $this->GewuenschterAbbuchungstag = $gewuenschterAbbuchungstag;
        return $this;
    }
    /**
     * Get Sprache value
     * @return string[]|null
     */
    public function getSprache()
    {
        return $this->Sprache;
    }
    /**
     * This method is responsible for validating the values passed to the setSprache method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSprache method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpracheForArrayConstraintsFromSetSprache(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_MandatSpracheItem) {
            // validation for constraint: itemType
            if (!is_string($cT_MandatSpracheItem)) {
                $invalidValues[] = is_object($cT_MandatSpracheItem) ? get_class($cT_MandatSpracheItem) : sprintf('%s(%s)', gettype($cT_MandatSpracheItem), var_export($cT_MandatSpracheItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Sprache property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setSprache method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSprache method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpracheForMaxLengthConstraintFromSetSprache($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_MandatSpracheItem) {
            // validation for constraint: maxLength(3)
            if (mb_strlen($cT_MandatSpracheItem) > 3) {
                $invalidValues[] = var_export($cT_MandatSpracheItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 3', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setSprache method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSprache method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpracheForMinLengthConstraintFromSetSprache($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_MandatSpracheItem) {
            // validation for constraint: minLength(3)
            if (mb_strlen($cT_MandatSpracheItem) < 3) {
                $invalidValues[] = var_export($cT_MandatSpracheItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 3', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Sprache value
     * @throws \InvalidArgumentException
     * @param string[] $sprache
     * @return \BiPRO\StructType\CT_Mandat
     */
    public function setSprache(array $sprache = array())
    {
        // validation for constraint: array
        if ('' !== ($spracheArrayErrorMessage = self::validateSpracheForArrayConstraintsFromSetSprache($sprache))) {
            throw new \InvalidArgumentException($spracheArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(3)
        if ('' !== ($spracheMaxLengthErrorMessage = self::validateSpracheForMaxLengthConstraintFromSetSprache($sprache))) {
            throw new \InvalidArgumentException($spracheMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: minLength(3)
        if ('' !== ($spracheMinLengthErrorMessage = self::validateSpracheForMinLengthConstraintFromSetSprache($sprache))) {
            throw new \InvalidArgumentException($spracheMinLengthErrorMessage, __LINE__);
        }
        $this->Sprache = $sprache;
        return $this;
    }
    /**
     * Add item to Sprache value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \BiPRO\StructType\CT_Mandat
     */
    public function addToSprache($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Sprache property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (mb_strlen($item) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (mb_strlen($item) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($item)), __LINE__);
        }
        $this->Sprache[] = $item;
        return $this;
    }
    /**
     * Get Mandatgeber value
     * @return \BiPRO\StructType\CT_Mandatgeber|null
     */
    public function getMandatgeber()
    {
        return $this->Mandatgeber;
    }
    /**
     * Set Mandatgeber value
     * @param \BiPRO\StructType\CT_Mandatgeber $mandatgeber
     * @return \BiPRO\StructType\CT_Mandat
     */
    public function setMandatgeber(\BiPRO\StructType\CT_Mandatgeber $mandatgeber = null)
    {
        $this->Mandatgeber = $mandatgeber;
        return $this;
    }
    /**
     * Get ZugeordneterVertrag value
     * @return \BiPRO\StructType\CT_Vertragsnummer[]|null
     */
    public function getZugeordneterVertrag()
    {
        return $this->ZugeordneterVertrag;
    }
    /**
     * This method is responsible for validating the values passed to the setZugeordneterVertrag method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZugeordneterVertrag method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZugeordneterVertragForArrayConstraintsFromSetZugeordneterVertrag(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_MandatZugeordneterVertragItem) {
            // validation for constraint: itemType
            if (!$cT_MandatZugeordneterVertragItem instanceof \BiPRO\StructType\CT_Vertragsnummer) {
                $invalidValues[] = is_object($cT_MandatZugeordneterVertragItem) ? get_class($cT_MandatZugeordneterVertragItem) : sprintf('%s(%s)', gettype($cT_MandatZugeordneterVertragItem), var_export($cT_MandatZugeordneterVertragItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ZugeordneterVertrag property can only contain items of type \BiPRO\StructType\CT_Vertragsnummer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ZugeordneterVertrag value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Vertragsnummer[] $zugeordneterVertrag
     * @return \BiPRO\StructType\CT_Mandat
     */
    public function setZugeordneterVertrag(array $zugeordneterVertrag = array())
    {
        // validation for constraint: array
        if ('' !== ($zugeordneterVertragArrayErrorMessage = self::validateZugeordneterVertragForArrayConstraintsFromSetZugeordneterVertrag($zugeordneterVertrag))) {
            throw new \InvalidArgumentException($zugeordneterVertragArrayErrorMessage, __LINE__);
        }
        $this->ZugeordneterVertrag = $zugeordneterVertrag;
        return $this;
    }
    /**
     * Add item to ZugeordneterVertrag value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Vertragsnummer $item
     * @return \BiPRO\StructType\CT_Mandat
     */
    public function addToZugeordneterVertrag(\BiPRO\StructType\CT_Vertragsnummer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Vertragsnummer) {
            throw new \InvalidArgumentException(sprintf('The ZugeordneterVertrag property can only contain items of type \BiPRO\StructType\CT_Vertragsnummer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ZugeordneterVertrag[] = $item;
        return $this;
    }
    /**
     * Get Notifikationsverbindung value
     * @return \BiPRO\StructType\CT_Kommunikationsverbindung|null
     */
    public function getNotifikationsverbindung()
    {
        return $this->Notifikationsverbindung;
    }
    /**
     * Set Notifikationsverbindung value
     * @param \BiPRO\StructType\CT_Kommunikationsverbindung $notifikationsverbindung
     * @return \BiPRO\StructType\CT_Mandat
     */
    public function setNotifikationsverbindung(\BiPRO\StructType\CT_Kommunikationsverbindung $notifikationsverbindung = null)
    {
        $this->Notifikationsverbindung = $notifikationsverbindung;
        return $this;
    }
    /**
     * Get AbweichenderSchuldner value
     * @return \BiPRO\StructType\CT_AbweichenderSchuldner|null
     */
    public function getAbweichenderSchuldner()
    {
        return $this->AbweichenderSchuldner;
    }
    /**
     * Set AbweichenderSchuldner value
     * @param \BiPRO\StructType\CT_AbweichenderSchuldner $abweichenderSchuldner
     * @return \BiPRO\StructType\CT_Mandat
     */
    public function setAbweichenderSchuldner(\BiPRO\StructType\CT_AbweichenderSchuldner $abweichenderSchuldner = null)
    {
        $this->AbweichenderSchuldner = $abweichenderSchuldner;
        return $this;
    }
    /**
     * Get MandatsAblageort value
     * @return string|null
     */
    public function getMandatsAblageort()
    {
        return $this->MandatsAblageort;
    }
    /**
     * Set MandatsAblageort value
     * @uses \BiPRO\EnumType\ST_Mandatsablageort::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Mandatsablageort::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mandatsAblageort
     * @return \BiPRO\StructType\CT_Mandat
     */
    public function setMandatsAblageort($mandatsAblageort = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Mandatsablageort::valueIsValid($mandatsAblageort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Mandatsablageort', is_array($mandatsAblageort) ? implode(', ', $mandatsAblageort) : var_export($mandatsAblageort, true), implode(', ', \BiPRO\EnumType\ST_Mandatsablageort::getValidValues())), __LINE__);
        }
        $this->MandatsAblageort = $mandatsAblageort;
        return $this;
    }
    /**
     * Get Lastschriftart value
     * @return string|null
     */
    public function getLastschriftart()
    {
        return $this->Lastschriftart;
    }
    /**
     * Set Lastschriftart value
     * @uses \BiPRO\EnumType\ST_Lastschriftart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Lastschriftart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lastschriftart
     * @return \BiPRO\StructType\CT_Mandat
     */
    public function setLastschriftart($lastschriftart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Lastschriftart::valueIsValid($lastschriftart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Lastschriftart', is_array($lastschriftart) ? implode(', ', $lastschriftart) : var_export($lastschriftart, true), implode(', ', \BiPRO\EnumType\ST_Lastschriftart::getValidValues())), __LINE__);
        }
        $this->Lastschriftart = $lastschriftart;
        return $this;
    }
    /**
     * Get Gueltigkeit value
     * @return \BiPRO\StructType\CT_Zeitraum|null
     */
    public function getGueltigkeit()
    {
        return $this->Gueltigkeit;
    }
    /**
     * Set Gueltigkeit value
     * @param \BiPRO\StructType\CT_Zeitraum $gueltigkeit
     * @return \BiPRO\StructType\CT_Mandat
     */
    public function setGueltigkeit(\BiPRO\StructType\CT_Zeitraum $gueltigkeit = null)
    {
        $this->Gueltigkeit = $gueltigkeit;
        return $this;
    }
}
