<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Leitungswasserschaden StructType
 * Meta information extracted from the WSDL
 * - documentation: Ein Schaden durch bestimmungswidrig ausgetretenes Leitungswasser.
 * @subpackage Structs
 */
class CT_Leitungswasserschaden extends CT_SchadenZuObjekt
{
    /**
     * The ArtDesWassers
     * Meta information extracted from the WSDL
     * - documentation: Art des Leitungswassers.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArtDesWassers;
    /**
     * The ArtDesWassersBeschreibung
     * Meta information extracted from the WSDL
     * - documentation: Beschreibung des Leitungswassers.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $ArtDesWassersBeschreibung;
    /**
     * The Schadenstelle
     * Meta information extracted from the WSDL
     * - documentation: Lage der Schadenstelle.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Schadenstelle;
    /**
     * The GebaeudeBenutzt
     * Meta information extracted from the WSDL
     * - documentation: Gibt an, ob das Gebäude zum Schadenzeitpunkt genutzt wurde.JA = Das Gebäude wurde benutzt.NEIN = Das Gebäude war unbenutzt.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $GebaeudeBenutzt;
    /**
     * The GebaeudeBeaufsichtigt
     * Meta information extracted from the WSDL
     * - documentation: JA = Das Gebäude wurde beaufsichtigt.NEIN = Das Gebäude wurde nicht beaufsichtigt.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $GebaeudeBeaufsichtigt;
    /**
     * The RaeumeBeheizt
     * Meta information extracted from the WSDL
     * - documentation: JA = Gebäude / Räume waren beheizt.NEIN = Gebäude / Räume waren nicht beheizt.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $RaeumeBeheizt;
    /**
     * The ZeitraumUnbenutzt
     * Meta information extracted from the WSDL
     * - documentation: Zeitraum, in dem das Gebäude unbenutzt war. Der Zeitraum MUSS durch die Attribute Beginn und Ende spezifiziert werden. Beginn und Ende MÜSSEN mindestens als Datum übermittelt werden. Wird eine Zeitangabe übermittelt, MUSS diese
     * mit Stunden und Minuten angegeben werden. Eine Zeitzone DARF übermittelt werden. Fehlt die Zeitzone, MUSS die am angegebenen Datum in Deutschland gültige Zeitzone angenommen werden..
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zeitraum2
     */
    public $ZeitraumUnbenutzt;
    /**
     * Constructor method for CT_Leitungswasserschaden
     * @uses CT_Leitungswasserschaden::setArtDesWassers()
     * @uses CT_Leitungswasserschaden::setArtDesWassersBeschreibung()
     * @uses CT_Leitungswasserschaden::setSchadenstelle()
     * @uses CT_Leitungswasserschaden::setGebaeudeBenutzt()
     * @uses CT_Leitungswasserschaden::setGebaeudeBeaufsichtigt()
     * @uses CT_Leitungswasserschaden::setRaeumeBeheizt()
     * @uses CT_Leitungswasserschaden::setZeitraumUnbenutzt()
     * @param string $artDesWassers
     * @param string $artDesWassersBeschreibung
     * @param string $schadenstelle
     * @param bool $gebaeudeBenutzt
     * @param bool $gebaeudeBeaufsichtigt
     * @param bool $raeumeBeheizt
     * @param \BiPRO\StructType\CT_Zeitraum2 $zeitraumUnbenutzt
     */
    public function __construct($artDesWassers = null, $artDesWassersBeschreibung = null, $schadenstelle = null, $gebaeudeBenutzt = null, $gebaeudeBeaufsichtigt = null, $raeumeBeheizt = null, \BiPRO\StructType\CT_Zeitraum2 $zeitraumUnbenutzt = null)
    {
        $this
            ->setArtDesWassers($artDesWassers)
            ->setArtDesWassersBeschreibung($artDesWassersBeschreibung)
            ->setSchadenstelle($schadenstelle)
            ->setGebaeudeBenutzt($gebaeudeBenutzt)
            ->setGebaeudeBeaufsichtigt($gebaeudeBeaufsichtigt)
            ->setRaeumeBeheizt($raeumeBeheizt)
            ->setZeitraumUnbenutzt($zeitraumUnbenutzt);
    }
    /**
     * Get ArtDesWassers value
     * @return string|null
     */
    public function getArtDesWassers()
    {
        return $this->ArtDesWassers;
    }
    /**
     * Set ArtDesWassers value
     * @uses \BiPRO\EnumType\ST_Wasserart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Wasserart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artDesWassers
     * @return \BiPRO\StructType\CT_Leitungswasserschaden
     */
    public function setArtDesWassers($artDesWassers = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Wasserart::valueIsValid($artDesWassers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Wasserart', is_array($artDesWassers) ? implode(', ', $artDesWassers) : var_export($artDesWassers, true), implode(', ', \BiPRO\EnumType\ST_Wasserart::getValidValues())), __LINE__);
        }
        $this->ArtDesWassers = $artDesWassers;
        return $this;
    }
    /**
     * Get ArtDesWassersBeschreibung value
     * @return string|null
     */
    public function getArtDesWassersBeschreibung()
    {
        return $this->ArtDesWassersBeschreibung;
    }
    /**
     * Set ArtDesWassersBeschreibung value
     * @param string $artDesWassersBeschreibung
     * @return \BiPRO\StructType\CT_Leitungswasserschaden
     */
    public function setArtDesWassersBeschreibung($artDesWassersBeschreibung = null)
    {
        // validation for constraint: string
        if (!is_null($artDesWassersBeschreibung) && !is_string($artDesWassersBeschreibung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($artDesWassersBeschreibung, true), gettype($artDesWassersBeschreibung)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($artDesWassersBeschreibung) && mb_strlen($artDesWassersBeschreibung) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($artDesWassersBeschreibung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($artDesWassersBeschreibung) && mb_strlen($artDesWassersBeschreibung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($artDesWassersBeschreibung)), __LINE__);
        }
        $this->ArtDesWassersBeschreibung = $artDesWassersBeschreibung;
        return $this;
    }
    /**
     * Get Schadenstelle value
     * @return string|null
     */
    public function getSchadenstelle()
    {
        return $this->Schadenstelle;
    }
    /**
     * Set Schadenstelle value
     * @uses \BiPRO\EnumType\ST_Schadenstelle::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Schadenstelle::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $schadenstelle
     * @return \BiPRO\StructType\CT_Leitungswasserschaden
     */
    public function setSchadenstelle($schadenstelle = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Schadenstelle::valueIsValid($schadenstelle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Schadenstelle', is_array($schadenstelle) ? implode(', ', $schadenstelle) : var_export($schadenstelle, true), implode(', ', \BiPRO\EnumType\ST_Schadenstelle::getValidValues())), __LINE__);
        }
        $this->Schadenstelle = $schadenstelle;
        return $this;
    }
    /**
     * Get GebaeudeBenutzt value
     * @return bool|null
     */
    public function getGebaeudeBenutzt()
    {
        return $this->GebaeudeBenutzt;
    }
    /**
     * Set GebaeudeBenutzt value
     * @param bool $gebaeudeBenutzt
     * @return \BiPRO\StructType\CT_Leitungswasserschaden
     */
    public function setGebaeudeBenutzt($gebaeudeBenutzt = null)
    {
        // validation for constraint: boolean
        if (!is_null($gebaeudeBenutzt) && !is_bool($gebaeudeBenutzt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($gebaeudeBenutzt, true), gettype($gebaeudeBenutzt)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($gebaeudeBenutzt) && !preg_match('/true|false/', $gebaeudeBenutzt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($gebaeudeBenutzt, true)), __LINE__);
        }
        $this->GebaeudeBenutzt = $gebaeudeBenutzt;
        return $this;
    }
    /**
     * Get GebaeudeBeaufsichtigt value
     * @return bool|null
     */
    public function getGebaeudeBeaufsichtigt()
    {
        return $this->GebaeudeBeaufsichtigt;
    }
    /**
     * Set GebaeudeBeaufsichtigt value
     * @param bool $gebaeudeBeaufsichtigt
     * @return \BiPRO\StructType\CT_Leitungswasserschaden
     */
    public function setGebaeudeBeaufsichtigt($gebaeudeBeaufsichtigt = null)
    {
        // validation for constraint: boolean
        if (!is_null($gebaeudeBeaufsichtigt) && !is_bool($gebaeudeBeaufsichtigt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($gebaeudeBeaufsichtigt, true), gettype($gebaeudeBeaufsichtigt)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($gebaeudeBeaufsichtigt) && !preg_match('/true|false/', $gebaeudeBeaufsichtigt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($gebaeudeBeaufsichtigt, true)), __LINE__);
        }
        $this->GebaeudeBeaufsichtigt = $gebaeudeBeaufsichtigt;
        return $this;
    }
    /**
     * Get RaeumeBeheizt value
     * @return bool|null
     */
    public function getRaeumeBeheizt()
    {
        return $this->RaeumeBeheizt;
    }
    /**
     * Set RaeumeBeheizt value
     * @param bool $raeumeBeheizt
     * @return \BiPRO\StructType\CT_Leitungswasserschaden
     */
    public function setRaeumeBeheizt($raeumeBeheizt = null)
    {
        // validation for constraint: boolean
        if (!is_null($raeumeBeheizt) && !is_bool($raeumeBeheizt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($raeumeBeheizt, true), gettype($raeumeBeheizt)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($raeumeBeheizt) && !preg_match('/true|false/', $raeumeBeheizt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($raeumeBeheizt, true)), __LINE__);
        }
        $this->RaeumeBeheizt = $raeumeBeheizt;
        return $this;
    }
    /**
     * Get ZeitraumUnbenutzt value
     * @return \BiPRO\StructType\CT_Zeitraum2|null
     */
    public function getZeitraumUnbenutzt()
    {
        return $this->ZeitraumUnbenutzt;
    }
    /**
     * Set ZeitraumUnbenutzt value
     * @param \BiPRO\StructType\CT_Zeitraum2 $zeitraumUnbenutzt
     * @return \BiPRO\StructType\CT_Leitungswasserschaden
     */
    public function setZeitraumUnbenutzt(\BiPRO\StructType\CT_Zeitraum2 $zeitraumUnbenutzt = null)
    {
        $this->ZeitraumUnbenutzt = $zeitraumUnbenutzt;
        return $this;
    }
}
