<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Leistungsausschluss StructType
 * Meta information extracted from the WSDL
 * - documentation: Abbildung von Versicherungsausschlüssen. In der Krankenversicherung zur Abblidung von besonderen Vereinbarungen, insbesondere von durch das Vertriebssystem definierten Leistungsausschlüssen.
 * @subpackage Structs
 */
class CT_Leistungsausschluss extends CT_Objekt
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Hier wird die Art des Leistungsausschlusses aus einer Liste angegeben.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_Leistungsausschluss
     */
    public $ArtID;
    /**
     * The Art
     * Meta information extracted from the WSDL
     * - documentation: Wird benutzt, wenn es keine feste Werteliste gibt, oder eine externe Liste (z. B. ICD-Code) verwendet wird, oder Freitext erfasst wird.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Art;
    /**
     * The Grund
     * Meta information extracted from the WSDL
     * - documentation: Beschreibung des Grundes für denLeistungsausschluss. Z.B. Diagnosetext
     * - base: xsd:string
     * - maxLength: 1000
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Grund;
    /**
     * The Endetermin
     * Meta information extracted from the WSDL
     * - documentation: Falls der Leistungsauschluss befristet ist wird hier der Endetermin des Leistungsausschlusses eingetragen. (z.B. voraussichtlicher Geburtstermin). Darf nur angewendet werden, wenn keine Dauer für den Leistungsausschluss angegeben
     * wurde. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Endetermin;
    /**
     * The Dauer
     * Meta information extracted from the WSDL
     * - documentation: Zeitraum des Leistungsausschlusses.Der Zeitraum MUSS konkret angegeben werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zeitraum
     */
    public $Dauer;
    /**
     * Constructor method for CT_Leistungsausschluss
     * @uses CT_Leistungsausschluss::setArtID()
     * @uses CT_Leistungsausschluss::setArt()
     * @uses CT_Leistungsausschluss::setGrund()
     * @uses CT_Leistungsausschluss::setEndetermin()
     * @uses CT_Leistungsausschluss::setDauer()
     * @param \BiPRO\StructType\STE_Leistungsausschluss $artID
     * @param string $art
     * @param string $grund
     * @param string $endetermin
     * @param \BiPRO\StructType\CT_Zeitraum $dauer
     */
    public function __construct(\BiPRO\StructType\STE_Leistungsausschluss $artID = null, $art = null, $grund = null, $endetermin = null, \BiPRO\StructType\CT_Zeitraum $dauer = null)
    {
        $this
            ->setArtID($artID)
            ->setArt($art)
            ->setGrund($grund)
            ->setEndetermin($endetermin)
            ->setDauer($dauer);
    }
    /**
     * Get ArtID value
     * @return \BiPRO\StructType\STE_Leistungsausschluss|null
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @param \BiPRO\StructType\STE_Leistungsausschluss $artID
     * @return \BiPRO\StructType\CT_Leistungsausschluss
     */
    public function setArtID(\BiPRO\StructType\STE_Leistungsausschluss $artID = null)
    {
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Art value
     * @return string|null
     */
    public function getArt()
    {
        return $this->Art;
    }
    /**
     * Set Art value
     * @param string $art
     * @return \BiPRO\StructType\CT_Leistungsausschluss
     */
    public function setArt($art = null)
    {
        // validation for constraint: string
        if (!is_null($art) && !is_string($art)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($art, true), gettype($art)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($art) && mb_strlen($art) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($art)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($art) && mb_strlen($art) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($art)), __LINE__);
        }
        $this->Art = $art;
        return $this;
    }
    /**
     * Get Grund value
     * @return string|null
     */
    public function getGrund()
    {
        return $this->Grund;
    }
    /**
     * Set Grund value
     * @param string $grund
     * @return \BiPRO\StructType\CT_Leistungsausschluss
     */
    public function setGrund($grund = null)
    {
        // validation for constraint: string
        if (!is_null($grund) && !is_string($grund)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($grund, true), gettype($grund)), __LINE__);
        }
        // validation for constraint: maxLength(1000)
        if (!is_null($grund) && mb_strlen($grund) > 1000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1000', mb_strlen($grund)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($grund) && mb_strlen($grund) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($grund)), __LINE__);
        }
        $this->Grund = $grund;
        return $this;
    }
    /**
     * Get Endetermin value
     * @return string|null
     */
    public function getEndetermin()
    {
        return $this->Endetermin;
    }
    /**
     * Set Endetermin value
     * @param string $endetermin
     * @return \BiPRO\StructType\CT_Leistungsausschluss
     */
    public function setEndetermin($endetermin = null)
    {
        // validation for constraint: string
        if (!is_null($endetermin) && !is_string($endetermin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endetermin, true), gettype($endetermin)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($endetermin) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $endetermin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($endetermin, true)), __LINE__);
        }
        $this->Endetermin = $endetermin;
        return $this;
    }
    /**
     * Get Dauer value
     * @return \BiPRO\StructType\CT_Zeitraum|null
     */
    public function getDauer()
    {
        return $this->Dauer;
    }
    /**
     * Set Dauer value
     * @param \BiPRO\StructType\CT_Zeitraum $dauer
     * @return \BiPRO\StructType\CT_Leistungsausschluss
     */
    public function setDauer(\BiPRO\StructType\CT_Zeitraum $dauer = null)
    {
        $this->Dauer = $dauer;
        return $this;
    }
}
