<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Kreditkarte StructType
 * Meta information extracted from the WSDL
 * - documentation: Hinweis: Die Verarbeitung von Kreditkartendaten erfordert die Einhalltung bestimmter Regularien und Prozesse. Diese sind umfassend, aber ggf. nicht vollständig im PCIDSS: - Payment Card Industry Data Security Standard
 * beschrieben.Unter anderem ist die Speicherung des CVC Codes nicht zulässig. Die Kreditkartennummer darf nur verschlüsselt gespeichert und nicht vollständig angezeigt werden.
 * @subpackage Structs
 */
class CT_Kreditkarte extends CT_Objekt
{
    /**
     * The ZurZahlungGenutzt
     * Meta information extracted from the WSDL
     * - documentation: Gibt an, ob die Kreditkarte zur Beitragszahlung genutzt wird.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: true|false
     * @var bool
     */
    public $ZurZahlungGenutzt;
    /**
     * The Kreditkartenunternehmen
     * Meta information extracted from the WSDL
     * - documentation: Das Attribut gibt das ausstellende Kreditunternehmen der Kreditkarte an.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Kreditkartenunternehmen;
    /**
     * The GueltigVon
     * Meta information extracted from the WSDL
     * - documentation: Gibt den Beginn der Gültigkeitsdauer der Kreditkarte an. | In Form von JJJJ-MM
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]
     * @var string
     */
    public $GueltigVon;
    /**
     * The GueltigBis
     * Meta information extracted from the WSDL
     * - documentation: Gibt das Ende der Gültigkeitsdauer der Kreditkarte an. | In Form von JJJJ-MM
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]
     * @var string
     */
    public $GueltigBis;
    /**
     * The Karteninhaber
     * Meta information extracted from the WSDL
     * - documentation: Das Attribut gibt den vollständigen Namen (Vorname Nachname) des Kreditkarteninhabers an.
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Karteninhaber;
    /**
     * The Kreditkartennummer
     * Meta information extracted from the WSDL
     * - documentation: Das Attribut gibt die Kreditkartennummer der Kreditkarte an. | Die Kreditkartennummer ist eine zwölf- bis sechzehnstellige, nummerische Identifikationsnummer. Die Kreditkartennummer identifiziert die Karte eindeutig.
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minLength: 12
     * - minOccurs: 0
     * @var string
     */
    public $Kreditkartennummer;
    /**
     * The CVCode
     * Meta information extracted from the WSDL
     * - documentation: Das Attribut gibt den CV-Code der Kreditkarte an.Der Card Validation Code (CVC) ist ein Sicherheitsmerkmal auf Kreditkarten.Die Prüfnummer soll die Nutzung von gefälschten oder gestohlenen Kreditkartenangaben verhindern, da sich
     * hiermit feststellen lässt, ob eine Kreditkarte tatsächlich physisch vorliegt | Drei- oder vierstelliger Prüfcode für Kreditkarten
     * - base: xsd:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 3
     * - minOccurs: 0
     * @var string
     */
    public $CVCode;
    /**
     * Constructor method for CT_Kreditkarte
     * @uses CT_Kreditkarte::setZurZahlungGenutzt()
     * @uses CT_Kreditkarte::setKreditkartenunternehmen()
     * @uses CT_Kreditkarte::setGueltigVon()
     * @uses CT_Kreditkarte::setGueltigBis()
     * @uses CT_Kreditkarte::setKarteninhaber()
     * @uses CT_Kreditkarte::setKreditkartennummer()
     * @uses CT_Kreditkarte::setCVCode()
     * @param bool $zurZahlungGenutzt
     * @param string $kreditkartenunternehmen
     * @param string $gueltigVon
     * @param string $gueltigBis
     * @param string $karteninhaber
     * @param string $kreditkartennummer
     * @param string $cVCode
     */
    public function __construct($zurZahlungGenutzt = null, $kreditkartenunternehmen = null, $gueltigVon = null, $gueltigBis = null, $karteninhaber = null, $kreditkartennummer = null, $cVCode = null)
    {
        $this
            ->setZurZahlungGenutzt($zurZahlungGenutzt)
            ->setKreditkartenunternehmen($kreditkartenunternehmen)
            ->setGueltigVon($gueltigVon)
            ->setGueltigBis($gueltigBis)
            ->setKarteninhaber($karteninhaber)
            ->setKreditkartennummer($kreditkartennummer)
            ->setCVCode($cVCode);
    }
    /**
     * Get ZurZahlungGenutzt value
     * @return bool
     */
    public function getZurZahlungGenutzt()
    {
        return $this->ZurZahlungGenutzt;
    }
    /**
     * Set ZurZahlungGenutzt value
     * @param bool $zurZahlungGenutzt
     * @return \BiPRO\StructType\CT_Kreditkarte
     */
    public function setZurZahlungGenutzt($zurZahlungGenutzt = null)
    {
        // validation for constraint: boolean
        if (!is_null($zurZahlungGenutzt) && !is_bool($zurZahlungGenutzt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($zurZahlungGenutzt, true), gettype($zurZahlungGenutzt)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($zurZahlungGenutzt) && !preg_match('/true|false/', $zurZahlungGenutzt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($zurZahlungGenutzt, true)), __LINE__);
        }
        $this->ZurZahlungGenutzt = $zurZahlungGenutzt;
        return $this;
    }
    /**
     * Get Kreditkartenunternehmen value
     * @return string|null
     */
    public function getKreditkartenunternehmen()
    {
        return $this->Kreditkartenunternehmen;
    }
    /**
     * Set Kreditkartenunternehmen value
     * @param string $kreditkartenunternehmen
     * @return \BiPRO\StructType\CT_Kreditkarte
     */
    public function setKreditkartenunternehmen($kreditkartenunternehmen = null)
    {
        // validation for constraint: string
        if (!is_null($kreditkartenunternehmen) && !is_string($kreditkartenunternehmen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kreditkartenunternehmen, true), gettype($kreditkartenunternehmen)), __LINE__);
        }
        $this->Kreditkartenunternehmen = $kreditkartenunternehmen;
        return $this;
    }
    /**
     * Get GueltigVon value
     * @return string|null
     */
    public function getGueltigVon()
    {
        return $this->GueltigVon;
    }
    /**
     * Set GueltigVon value
     * @param string $gueltigVon
     * @return \BiPRO\StructType\CT_Kreditkarte
     */
    public function setGueltigVon($gueltigVon = null)
    {
        // validation for constraint: string
        if (!is_null($gueltigVon) && !is_string($gueltigVon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gueltigVon, true), gettype($gueltigVon)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9])
        if (!is_null($gueltigVon) && !preg_match('/\\d{4}\\-[0-1][0-9]/', $gueltigVon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]', var_export($gueltigVon, true)), __LINE__);
        }
        $this->GueltigVon = $gueltigVon;
        return $this;
    }
    /**
     * Get GueltigBis value
     * @return string|null
     */
    public function getGueltigBis()
    {
        return $this->GueltigBis;
    }
    /**
     * Set GueltigBis value
     * @param string $gueltigBis
     * @return \BiPRO\StructType\CT_Kreditkarte
     */
    public function setGueltigBis($gueltigBis = null)
    {
        // validation for constraint: string
        if (!is_null($gueltigBis) && !is_string($gueltigBis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gueltigBis, true), gettype($gueltigBis)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9])
        if (!is_null($gueltigBis) && !preg_match('/\\d{4}\\-[0-1][0-9]/', $gueltigBis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]', var_export($gueltigBis, true)), __LINE__);
        }
        $this->GueltigBis = $gueltigBis;
        return $this;
    }
    /**
     * Get Karteninhaber value
     * @return string|null
     */
    public function getKarteninhaber()
    {
        return $this->Karteninhaber;
    }
    /**
     * Set Karteninhaber value
     * @param string $karteninhaber
     * @return \BiPRO\StructType\CT_Kreditkarte
     */
    public function setKarteninhaber($karteninhaber = null)
    {
        // validation for constraint: string
        if (!is_null($karteninhaber) && !is_string($karteninhaber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($karteninhaber, true), gettype($karteninhaber)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($karteninhaber) && mb_strlen($karteninhaber) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($karteninhaber)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($karteninhaber) && mb_strlen($karteninhaber) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($karteninhaber)), __LINE__);
        }
        $this->Karteninhaber = $karteninhaber;
        return $this;
    }
    /**
     * Get Kreditkartennummer value
     * @return string|null
     */
    public function getKreditkartennummer()
    {
        return $this->Kreditkartennummer;
    }
    /**
     * Set Kreditkartennummer value
     * @param string $kreditkartennummer
     * @return \BiPRO\StructType\CT_Kreditkarte
     */
    public function setKreditkartennummer($kreditkartennummer = null)
    {
        // validation for constraint: string
        if (!is_null($kreditkartennummer) && !is_string($kreditkartennummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kreditkartennummer, true), gettype($kreditkartennummer)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($kreditkartennummer) && mb_strlen($kreditkartennummer) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($kreditkartennummer)), __LINE__);
        }
        // validation for constraint: minLength(12)
        if (!is_null($kreditkartennummer) && mb_strlen($kreditkartennummer) < 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 12', mb_strlen($kreditkartennummer)), __LINE__);
        }
        $this->Kreditkartennummer = $kreditkartennummer;
        return $this;
    }
    /**
     * Get CVCode value
     * @return string|null
     */
    public function getCVCode()
    {
        return $this->CVCode;
    }
    /**
     * Set CVCode value
     * @param string $cVCode
     * @return \BiPRO\StructType\CT_Kreditkarte
     */
    public function setCVCode($cVCode = null)
    {
        // validation for constraint: string
        if (!is_null($cVCode) && !is_string($cVCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cVCode, true), gettype($cVCode)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($cVCode) && mb_strlen($cVCode) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($cVCode)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($cVCode) && mb_strlen($cVCode) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($cVCode)), __LINE__);
        }
        $this->CVCode = $cVCode;
        return $this;
    }
}
