<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Konstruktion StructType
 * Meta information extracted from the WSDL
 * - documentation: Die Konstruktion eines Objekts und das verwendete Material.
 * @subpackage Structs
 */
class CT_Konstruktion extends CT_Objekt
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Art des Konstruktionsteils.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ArtID;
    /**
     * The Material
     * Meta information extracted from the WSDL
     * - documentation: Material, aus dem die Konstruktion gefertigt ist.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Material;
    /**
     * The Materialbeschreibung
     * Meta information extracted from the WSDL
     * - documentation: Beschreibung des Materials, falls im Attribut Material der Wert "99=Sonstiges" verwendet wird.
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Materialbeschreibung;
    /**
     * The Befestigung
     * Meta information extracted from the WSDL
     * - documentation: Befestigung, z.B der Verkleidung oder des Bodenbelages.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Befestigung;
    /**
     * Constructor method for CT_Konstruktion
     * @uses CT_Konstruktion::setArtID()
     * @uses CT_Konstruktion::setMaterial()
     * @uses CT_Konstruktion::setMaterialbeschreibung()
     * @uses CT_Konstruktion::setBefestigung()
     * @param string $artID
     * @param string $material
     * @param string $materialbeschreibung
     * @param string $befestigung
     */
    public function __construct($artID = null, $material = null, $materialbeschreibung = null, $befestigung = null)
    {
        $this
            ->setArtID($artID)
            ->setMaterial($material)
            ->setMaterialbeschreibung($materialbeschreibung)
            ->setBefestigung($befestigung);
    }
    /**
     * Get ArtID value
     * @return string
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @uses \BiPRO\EnumType\ST_Konstruktionsteil::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Konstruktionsteil::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artID
     * @return \BiPRO\StructType\CT_Konstruktion
     */
    public function setArtID($artID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Konstruktionsteil::valueIsValid($artID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Konstruktionsteil', is_array($artID) ? implode(', ', $artID) : var_export($artID, true), implode(', ', \BiPRO\EnumType\ST_Konstruktionsteil::getValidValues())), __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Material value
     * @return string
     */
    public function getMaterial()
    {
        return $this->Material;
    }
    /**
     * Set Material value
     * @uses \BiPRO\EnumType\ST_Material::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Material::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $material
     * @return \BiPRO\StructType\CT_Konstruktion
     */
    public function setMaterial($material = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Material::valueIsValid($material)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Material', is_array($material) ? implode(', ', $material) : var_export($material, true), implode(', ', \BiPRO\EnumType\ST_Material::getValidValues())), __LINE__);
        }
        $this->Material = $material;
        return $this;
    }
    /**
     * Get Materialbeschreibung value
     * @return string|null
     */
    public function getMaterialbeschreibung()
    {
        return $this->Materialbeschreibung;
    }
    /**
     * Set Materialbeschreibung value
     * @param string $materialbeschreibung
     * @return \BiPRO\StructType\CT_Konstruktion
     */
    public function setMaterialbeschreibung($materialbeschreibung = null)
    {
        // validation for constraint: string
        if (!is_null($materialbeschreibung) && !is_string($materialbeschreibung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($materialbeschreibung, true), gettype($materialbeschreibung)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($materialbeschreibung) && mb_strlen($materialbeschreibung) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($materialbeschreibung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($materialbeschreibung) && mb_strlen($materialbeschreibung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($materialbeschreibung)), __LINE__);
        }
        $this->Materialbeschreibung = $materialbeschreibung;
        return $this;
    }
    /**
     * Get Befestigung value
     * @return string|null
     */
    public function getBefestigung()
    {
        return $this->Befestigung;
    }
    /**
     * Set Befestigung value
     * @uses \BiPRO\EnumType\ST_Befestigung::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Befestigung::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $befestigung
     * @return \BiPRO\StructType\CT_Konstruktion
     */
    public function setBefestigung($befestigung = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Befestigung::valueIsValid($befestigung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Befestigung', is_array($befestigung) ? implode(', ', $befestigung) : var_export($befestigung, true), implode(', ', \BiPRO\EnumType\ST_Befestigung::getValidValues())), __LINE__);
        }
        $this->Befestigung = $befestigung;
        return $this;
    }
}
