<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Klausel StructType
 * Meta information extracted from the WSDL
 * - documentation: Klauseln sind die allgemeinen Einzelbestimmungen in einem Versicherungsvertrag. Sie konkretisieren, erweitern oder beschränken die Allgemeinen (AVB) und Besonderen Versicherungsbedingungen (BVB).Klauseln DÜRFEN NUR in dem für sie
 * vorgesehenen Kontext (Produkt, Elementarprodukt) angegeben werden.
 * @subpackage Structs
 */
class CT_Klausel extends CT_Objekt
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Anbieterspezifische Identifikation einer Klausel | Datentyp zur Identifizierung einer Anbieter-spezifischen Klausel. Da es sich um einen String handelt werden keine vollständigen Listen von Klauseln veröffentlicht.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $ArtID;
    /**
     * The Klauseltext
     * Meta information extracted from the WSDL
     * - documentation: Text der Klausel
     * - base: xsd:string
     * - maxLength: 1000
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Klauseltext;
    /**
     * The Zusatzangabe
     * Meta information extracted from the WSDL
     * - documentation: Zusatzangabe zur Klausel
     * - base: xsd:string
     * - maxLength: 1000
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Zusatzangabe;
    /**
     * The Formularbezeichnung
     * Meta information extracted from the WSDL
     * - documentation: Formularbezeichnung der Klausel
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Formularbezeichnung;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - documentation: Datum, ab dem die Version der Klausel gültig ist. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Version;
    /**
     * Constructor method for CT_Klausel
     * @uses CT_Klausel::setArtID()
     * @uses CT_Klausel::setKlauseltext()
     * @uses CT_Klausel::setZusatzangabe()
     * @uses CT_Klausel::setFormularbezeichnung()
     * @uses CT_Klausel::setVersion()
     * @param string $artID
     * @param string $klauseltext
     * @param string $zusatzangabe
     * @param string $formularbezeichnung
     * @param string $version
     */
    public function __construct($artID = null, $klauseltext = null, $zusatzangabe = null, $formularbezeichnung = null, $version = null)
    {
        $this
            ->setArtID($artID)
            ->setKlauseltext($klauseltext)
            ->setZusatzangabe($zusatzangabe)
            ->setFormularbezeichnung($formularbezeichnung)
            ->setVersion($version);
    }
    /**
     * Get ArtID value
     * @return string|null
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @param string $artID
     * @return \BiPRO\StructType\CT_Klausel
     */
    public function setArtID($artID = null)
    {
        // validation for constraint: string
        if (!is_null($artID) && !is_string($artID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($artID, true), gettype($artID)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($artID) && mb_strlen($artID) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($artID)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($artID) && mb_strlen($artID) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($artID)), __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Klauseltext value
     * @return string|null
     */
    public function getKlauseltext()
    {
        return $this->Klauseltext;
    }
    /**
     * Set Klauseltext value
     * @param string $klauseltext
     * @return \BiPRO\StructType\CT_Klausel
     */
    public function setKlauseltext($klauseltext = null)
    {
        // validation for constraint: string
        if (!is_null($klauseltext) && !is_string($klauseltext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($klauseltext, true), gettype($klauseltext)), __LINE__);
        }
        // validation for constraint: maxLength(1000)
        if (!is_null($klauseltext) && mb_strlen($klauseltext) > 1000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1000', mb_strlen($klauseltext)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($klauseltext) && mb_strlen($klauseltext) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($klauseltext)), __LINE__);
        }
        $this->Klauseltext = $klauseltext;
        return $this;
    }
    /**
     * Get Zusatzangabe value
     * @return string|null
     */
    public function getZusatzangabe()
    {
        return $this->Zusatzangabe;
    }
    /**
     * Set Zusatzangabe value
     * @param string $zusatzangabe
     * @return \BiPRO\StructType\CT_Klausel
     */
    public function setZusatzangabe($zusatzangabe = null)
    {
        // validation for constraint: string
        if (!is_null($zusatzangabe) && !is_string($zusatzangabe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zusatzangabe, true), gettype($zusatzangabe)), __LINE__);
        }
        // validation for constraint: maxLength(1000)
        if (!is_null($zusatzangabe) && mb_strlen($zusatzangabe) > 1000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1000', mb_strlen($zusatzangabe)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($zusatzangabe) && mb_strlen($zusatzangabe) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($zusatzangabe)), __LINE__);
        }
        $this->Zusatzangabe = $zusatzangabe;
        return $this;
    }
    /**
     * Get Formularbezeichnung value
     * @return string|null
     */
    public function getFormularbezeichnung()
    {
        return $this->Formularbezeichnung;
    }
    /**
     * Set Formularbezeichnung value
     * @param string $formularbezeichnung
     * @return \BiPRO\StructType\CT_Klausel
     */
    public function setFormularbezeichnung($formularbezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($formularbezeichnung) && !is_string($formularbezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formularbezeichnung, true), gettype($formularbezeichnung)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($formularbezeichnung) && mb_strlen($formularbezeichnung) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($formularbezeichnung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($formularbezeichnung) && mb_strlen($formularbezeichnung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($formularbezeichnung)), __LINE__);
        }
        $this->Formularbezeichnung = $formularbezeichnung;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \BiPRO\StructType\CT_Klausel
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($version) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($version, true)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
}
