<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Kirchensteuer StructType
 * Meta information extracted from the WSDL
 * - documentation: Angaben zu Kirchensteuerpflicht und -satz.
 * @subpackage Structs
 */
class CT_Kirchensteuer extends CT_Objekt
{
    /**
     * The Kirchensteuer
     * Meta information extracted from the WSDL
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: true|false
     * @var bool
     */
    public $Kirchensteuer;
    /**
     * The Kirchensteuersatz
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Kirchensteuersatz;
    /**
     * Constructor method for CT_Kirchensteuer
     * @uses CT_Kirchensteuer::setKirchensteuer()
     * @uses CT_Kirchensteuer::setKirchensteuersatz()
     * @param bool $kirchensteuer
     * @param float $kirchensteuersatz
     */
    public function __construct($kirchensteuer = null, $kirchensteuersatz = null)
    {
        $this
            ->setKirchensteuer($kirchensteuer)
            ->setKirchensteuersatz($kirchensteuersatz);
    }
    /**
     * Get Kirchensteuer value
     * @return bool
     */
    public function getKirchensteuer()
    {
        return $this->Kirchensteuer;
    }
    /**
     * Set Kirchensteuer value
     * @param bool $kirchensteuer
     * @return \BiPRO\StructType\CT_Kirchensteuer
     */
    public function setKirchensteuer($kirchensteuer = null)
    {
        // validation for constraint: boolean
        if (!is_null($kirchensteuer) && !is_bool($kirchensteuer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kirchensteuer, true), gettype($kirchensteuer)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($kirchensteuer) && !preg_match('/true|false/', $kirchensteuer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($kirchensteuer, true)), __LINE__);
        }
        $this->Kirchensteuer = $kirchensteuer;
        return $this;
    }
    /**
     * Get Kirchensteuersatz value
     * @return float
     */
    public function getKirchensteuersatz()
    {
        return $this->Kirchensteuersatz;
    }
    /**
     * Set Kirchensteuersatz value
     * @param float $kirchensteuersatz
     * @return \BiPRO\StructType\CT_Kirchensteuer
     */
    public function setKirchensteuersatz($kirchensteuersatz = null)
    {
        // validation for constraint: float
        if (!is_null($kirchensteuersatz) && !(is_float($kirchensteuersatz) || is_numeric($kirchensteuersatz))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kirchensteuersatz, true), gettype($kirchensteuersatz)), __LINE__);
        }
        $this->Kirchensteuersatz = $kirchensteuersatz;
        return $this;
    }
}
