<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Kennzeichen StructType
 * @subpackage Structs
 */
class CT_Kennzeichen extends CT_Objekt
{
    /**
     * The AmtlichesKennzeichen
     * Meta information extracted from the WSDL
     * - documentation: Amtliches Kfz-Kennzeichen
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $AmtlichesKennzeichen;
    /**
     * The DatumKennzeichenGueltigBis
     * Meta information extracted from the WSDL
     * - documentation: nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $DatumKennzeichenGueltigBis;
    /**
     * The AblauftageKurzzeitkennzeichen
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AblauftageKurzzeitkennzeichen;
    /**
     * The BetriebszeitraumVon
     * Meta information extracted from the WSDL
     * - documentation: Für Saison-Kennzeichen
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BetriebszeitraumVon;
    /**
     * The BetriebszeitraumBis
     * Meta information extracted from the WSDL
     * - documentation: Für Saison-Kennzeichen
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BetriebszeitraumBis;
    /**
     * The Zulassungsbezirksnummer
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Zulassungsbezirksnummer;
    /**
     * The RegioPostleitzahl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $RegioPostleitzahl;
    /**
     * The RegioOrt
     * Meta information extracted from the WSDL
     * - documentation: Die Postleitzahl alleine ist aber nicht immer eindeutig. Als Beispiel dient hier die PLZ '21039', zu der es die Orte Börnsen, Fahrendorf, Hamburg und Escheburg gibt. Zur korrekten Regionalklassen-Ermittlung sind daher die Attribute
     * RegioPostleitzahl und RegioOrt unerlässlich.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $RegioOrt;
    /**
     * The Kennzeichenart
     * Meta information extracted from the WSDL
     * - documentation: Spezifiziert die Art des Kennzeichen. Besonderheit: Über die Kennzeichenart müssen beim eVB-Abruf alle möglichen Arten des Kennzeichens (normal, Saison, Kurzzeit, rot etc.) spezifiziert werden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Kennzeichenart[]
     */
    public $Kennzeichenart;
    /**
     * The Land
     * Meta information extracted from the WSDL
     * - documentation: Land, in dem das Kennzeichen registriert ist.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Land;
    /**
     * The GruenesKennzeichen
     * Meta information extracted from the WSDL
     * - documentation: JA = Kennzeichen ist ein grünes KennzeichenNEIN = Kennzeichen ist kein grünes KennzeichenWird das Attribut nicht geliefert, MUSS es als mit 'NEIN' belegt interpretiert werden.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $GruenesKennzeichen;
    /**
     * The Wechselkennzeichen
     * Meta information extracted from the WSDL
     * - documentation: Bei bereits zugelassenen Fahrzeugen enthält dieses Attribut die Information, ob das Kennzeichen ein Wechselkennzeichen ist:JA = Das Kennzeichen ist ein WechselkennzeichenNEIN = Das Kennzeichen ist kein WechselkennzeichenBeim
     * eVB-Prozess hat das Attribut folgende Semantik:JA = Die eVB gilt nur für ein WechselkennzeichenNEIN = Die Nutzung der eVB für Wechselkennzeichen ist ausgeschlossenFehlt das Attribut = Die eVB hat keine Einschränkung bzgl. Wechselkennzeichen
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Wechselkennzeichen;
    /**
     * Constructor method for CT_Kennzeichen
     * @uses CT_Kennzeichen::setAmtlichesKennzeichen()
     * @uses CT_Kennzeichen::setDatumKennzeichenGueltigBis()
     * @uses CT_Kennzeichen::setAblauftageKurzzeitkennzeichen()
     * @uses CT_Kennzeichen::setBetriebszeitraumVon()
     * @uses CT_Kennzeichen::setBetriebszeitraumBis()
     * @uses CT_Kennzeichen::setZulassungsbezirksnummer()
     * @uses CT_Kennzeichen::setRegioPostleitzahl()
     * @uses CT_Kennzeichen::setRegioOrt()
     * @uses CT_Kennzeichen::setKennzeichenart()
     * @uses CT_Kennzeichen::setLand()
     * @uses CT_Kennzeichen::setGruenesKennzeichen()
     * @uses CT_Kennzeichen::setWechselkennzeichen()
     * @param string $amtlichesKennzeichen
     * @param string $datumKennzeichenGueltigBis
     * @param int $ablauftageKurzzeitkennzeichen
     * @param string $betriebszeitraumVon
     * @param string $betriebszeitraumBis
     * @param string $zulassungsbezirksnummer
     * @param string $regioPostleitzahl
     * @param string $regioOrt
     * @param \BiPRO\StructType\CT_Kennzeichenart[] $kennzeichenart
     * @param string $land
     * @param bool $gruenesKennzeichen
     * @param bool $wechselkennzeichen
     */
    public function __construct($amtlichesKennzeichen = null, $datumKennzeichenGueltigBis = null, $ablauftageKurzzeitkennzeichen = null, $betriebszeitraumVon = null, $betriebszeitraumBis = null, $zulassungsbezirksnummer = null, $regioPostleitzahl = null, $regioOrt = null, array $kennzeichenart = array(), $land = null, $gruenesKennzeichen = null, $wechselkennzeichen = null)
    {
        $this
            ->setAmtlichesKennzeichen($amtlichesKennzeichen)
            ->setDatumKennzeichenGueltigBis($datumKennzeichenGueltigBis)
            ->setAblauftageKurzzeitkennzeichen($ablauftageKurzzeitkennzeichen)
            ->setBetriebszeitraumVon($betriebszeitraumVon)
            ->setBetriebszeitraumBis($betriebszeitraumBis)
            ->setZulassungsbezirksnummer($zulassungsbezirksnummer)
            ->setRegioPostleitzahl($regioPostleitzahl)
            ->setRegioOrt($regioOrt)
            ->setKennzeichenart($kennzeichenart)
            ->setLand($land)
            ->setGruenesKennzeichen($gruenesKennzeichen)
            ->setWechselkennzeichen($wechselkennzeichen);
    }
    /**
     * Get AmtlichesKennzeichen value
     * @return string|null
     */
    public function getAmtlichesKennzeichen()
    {
        return $this->AmtlichesKennzeichen;
    }
    /**
     * Set AmtlichesKennzeichen value
     * @param string $amtlichesKennzeichen
     * @return \BiPRO\StructType\CT_Kennzeichen
     */
    public function setAmtlichesKennzeichen($amtlichesKennzeichen = null)
    {
        // validation for constraint: string
        if (!is_null($amtlichesKennzeichen) && !is_string($amtlichesKennzeichen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amtlichesKennzeichen, true), gettype($amtlichesKennzeichen)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($amtlichesKennzeichen) && mb_strlen($amtlichesKennzeichen) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($amtlichesKennzeichen)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($amtlichesKennzeichen) && mb_strlen($amtlichesKennzeichen) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($amtlichesKennzeichen)), __LINE__);
        }
        $this->AmtlichesKennzeichen = $amtlichesKennzeichen;
        return $this;
    }
    /**
     * Get DatumKennzeichenGueltigBis value
     * @return string|null
     */
    public function getDatumKennzeichenGueltigBis()
    {
        return $this->DatumKennzeichenGueltigBis;
    }
    /**
     * Set DatumKennzeichenGueltigBis value
     * @param string $datumKennzeichenGueltigBis
     * @return \BiPRO\StructType\CT_Kennzeichen
     */
    public function setDatumKennzeichenGueltigBis($datumKennzeichenGueltigBis = null)
    {
        // validation for constraint: string
        if (!is_null($datumKennzeichenGueltigBis) && !is_string($datumKennzeichenGueltigBis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumKennzeichenGueltigBis, true), gettype($datumKennzeichenGueltigBis)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($datumKennzeichenGueltigBis) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $datumKennzeichenGueltigBis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($datumKennzeichenGueltigBis, true)), __LINE__);
        }
        $this->DatumKennzeichenGueltigBis = $datumKennzeichenGueltigBis;
        return $this;
    }
    /**
     * Get AblauftageKurzzeitkennzeichen value
     * @return int|null
     */
    public function getAblauftageKurzzeitkennzeichen()
    {
        return $this->AblauftageKurzzeitkennzeichen;
    }
    /**
     * Set AblauftageKurzzeitkennzeichen value
     * @param int $ablauftageKurzzeitkennzeichen
     * @return \BiPRO\StructType\CT_Kennzeichen
     */
    public function setAblauftageKurzzeitkennzeichen($ablauftageKurzzeitkennzeichen = null)
    {
        // validation for constraint: int
        if (!is_null($ablauftageKurzzeitkennzeichen) && !(is_int($ablauftageKurzzeitkennzeichen) || ctype_digit($ablauftageKurzzeitkennzeichen))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ablauftageKurzzeitkennzeichen, true), gettype($ablauftageKurzzeitkennzeichen)), __LINE__);
        }
        $this->AblauftageKurzzeitkennzeichen = $ablauftageKurzzeitkennzeichen;
        return $this;
    }
    /**
     * Get BetriebszeitraumVon value
     * @return string|null
     */
    public function getBetriebszeitraumVon()
    {
        return $this->BetriebszeitraumVon;
    }
    /**
     * Set BetriebszeitraumVon value
     * @uses \BiPRO\EnumType\ST_Monat::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Monat::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $betriebszeitraumVon
     * @return \BiPRO\StructType\CT_Kennzeichen
     */
    public function setBetriebszeitraumVon($betriebszeitraumVon = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Monat::valueIsValid($betriebszeitraumVon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Monat', is_array($betriebszeitraumVon) ? implode(', ', $betriebszeitraumVon) : var_export($betriebszeitraumVon, true), implode(', ', \BiPRO\EnumType\ST_Monat::getValidValues())), __LINE__);
        }
        $this->BetriebszeitraumVon = $betriebszeitraumVon;
        return $this;
    }
    /**
     * Get BetriebszeitraumBis value
     * @return string|null
     */
    public function getBetriebszeitraumBis()
    {
        return $this->BetriebszeitraumBis;
    }
    /**
     * Set BetriebszeitraumBis value
     * @uses \BiPRO\EnumType\ST_Monat::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Monat::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $betriebszeitraumBis
     * @return \BiPRO\StructType\CT_Kennzeichen
     */
    public function setBetriebszeitraumBis($betriebszeitraumBis = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Monat::valueIsValid($betriebszeitraumBis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Monat', is_array($betriebszeitraumBis) ? implode(', ', $betriebszeitraumBis) : var_export($betriebszeitraumBis, true), implode(', ', \BiPRO\EnumType\ST_Monat::getValidValues())), __LINE__);
        }
        $this->BetriebszeitraumBis = $betriebszeitraumBis;
        return $this;
    }
    /**
     * Get Zulassungsbezirksnummer value
     * @return string|null
     */
    public function getZulassungsbezirksnummer()
    {
        return $this->Zulassungsbezirksnummer;
    }
    /**
     * Set Zulassungsbezirksnummer value
     * @param string $zulassungsbezirksnummer
     * @return \BiPRO\StructType\CT_Kennzeichen
     */
    public function setZulassungsbezirksnummer($zulassungsbezirksnummer = null)
    {
        // validation for constraint: string
        if (!is_null($zulassungsbezirksnummer) && !is_string($zulassungsbezirksnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zulassungsbezirksnummer, true), gettype($zulassungsbezirksnummer)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($zulassungsbezirksnummer) && mb_strlen($zulassungsbezirksnummer) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($zulassungsbezirksnummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($zulassungsbezirksnummer) && mb_strlen($zulassungsbezirksnummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($zulassungsbezirksnummer)), __LINE__);
        }
        $this->Zulassungsbezirksnummer = $zulassungsbezirksnummer;
        return $this;
    }
    /**
     * Get RegioPostleitzahl value
     * @return string|null
     */
    public function getRegioPostleitzahl()
    {
        return $this->RegioPostleitzahl;
    }
    /**
     * Set RegioPostleitzahl value
     * @param string $regioPostleitzahl
     * @return \BiPRO\StructType\CT_Kennzeichen
     */
    public function setRegioPostleitzahl($regioPostleitzahl = null)
    {
        // validation for constraint: string
        if (!is_null($regioPostleitzahl) && !is_string($regioPostleitzahl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regioPostleitzahl, true), gettype($regioPostleitzahl)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($regioPostleitzahl) && mb_strlen($regioPostleitzahl) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($regioPostleitzahl)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($regioPostleitzahl) && mb_strlen($regioPostleitzahl) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($regioPostleitzahl)), __LINE__);
        }
        $this->RegioPostleitzahl = $regioPostleitzahl;
        return $this;
    }
    /**
     * Get RegioOrt value
     * @return string|null
     */
    public function getRegioOrt()
    {
        return $this->RegioOrt;
    }
    /**
     * Set RegioOrt value
     * @param string $regioOrt
     * @return \BiPRO\StructType\CT_Kennzeichen
     */
    public function setRegioOrt($regioOrt = null)
    {
        // validation for constraint: string
        if (!is_null($regioOrt) && !is_string($regioOrt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regioOrt, true), gettype($regioOrt)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($regioOrt) && mb_strlen($regioOrt) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($regioOrt)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($regioOrt) && mb_strlen($regioOrt) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($regioOrt)), __LINE__);
        }
        $this->RegioOrt = $regioOrt;
        return $this;
    }
    /**
     * Get Kennzeichenart value
     * @return \BiPRO\StructType\CT_Kennzeichenart[]|null
     */
    public function getKennzeichenart()
    {
        return $this->Kennzeichenart;
    }
    /**
     * This method is responsible for validating the values passed to the setKennzeichenart method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKennzeichenart method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKennzeichenartForArrayConstraintsFromSetKennzeichenart(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_KennzeichenKennzeichenartItem) {
            // validation for constraint: itemType
            if (!$cT_KennzeichenKennzeichenartItem instanceof \BiPRO\StructType\CT_Kennzeichenart) {
                $invalidValues[] = is_object($cT_KennzeichenKennzeichenartItem) ? get_class($cT_KennzeichenKennzeichenartItem) : sprintf('%s(%s)', gettype($cT_KennzeichenKennzeichenartItem), var_export($cT_KennzeichenKennzeichenartItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Kennzeichenart property can only contain items of type \BiPRO\StructType\CT_Kennzeichenart, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Kennzeichenart value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Kennzeichenart[] $kennzeichenart
     * @return \BiPRO\StructType\CT_Kennzeichen
     */
    public function setKennzeichenart(array $kennzeichenart = array())
    {
        // validation for constraint: array
        if ('' !== ($kennzeichenartArrayErrorMessage = self::validateKennzeichenartForArrayConstraintsFromSetKennzeichenart($kennzeichenart))) {
            throw new \InvalidArgumentException($kennzeichenartArrayErrorMessage, __LINE__);
        }
        $this->Kennzeichenart = $kennzeichenart;
        return $this;
    }
    /**
     * Add item to Kennzeichenart value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Kennzeichenart $item
     * @return \BiPRO\StructType\CT_Kennzeichen
     */
    public function addToKennzeichenart(\BiPRO\StructType\CT_Kennzeichenart $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Kennzeichenart) {
            throw new \InvalidArgumentException(sprintf('The Kennzeichenart property can only contain items of type \BiPRO\StructType\CT_Kennzeichenart, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Kennzeichenart[] = $item;
        return $this;
    }
    /**
     * Get Land value
     * @return string|null
     */
    public function getLand()
    {
        return $this->Land;
    }
    /**
     * Set Land value
     * @uses \BiPRO\EnumType\ST_Laenderkennzeichen::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Laenderkennzeichen::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $land
     * @return \BiPRO\StructType\CT_Kennzeichen
     */
    public function setLand($land = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Laenderkennzeichen::valueIsValid($land)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Laenderkennzeichen', is_array($land) ? implode(', ', $land) : var_export($land, true), implode(', ', \BiPRO\EnumType\ST_Laenderkennzeichen::getValidValues())), __LINE__);
        }
        $this->Land = $land;
        return $this;
    }
    /**
     * Get GruenesKennzeichen value
     * @return bool|null
     */
    public function getGruenesKennzeichen()
    {
        return $this->GruenesKennzeichen;
    }
    /**
     * Set GruenesKennzeichen value
     * @param bool $gruenesKennzeichen
     * @return \BiPRO\StructType\CT_Kennzeichen
     */
    public function setGruenesKennzeichen($gruenesKennzeichen = null)
    {
        // validation for constraint: boolean
        if (!is_null($gruenesKennzeichen) && !is_bool($gruenesKennzeichen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($gruenesKennzeichen, true), gettype($gruenesKennzeichen)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($gruenesKennzeichen) && !preg_match('/true|false/', $gruenesKennzeichen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($gruenesKennzeichen, true)), __LINE__);
        }
        $this->GruenesKennzeichen = $gruenesKennzeichen;
        return $this;
    }
    /**
     * Get Wechselkennzeichen value
     * @return bool|null
     */
    public function getWechselkennzeichen()
    {
        return $this->Wechselkennzeichen;
    }
    /**
     * Set Wechselkennzeichen value
     * @param bool $wechselkennzeichen
     * @return \BiPRO\StructType\CT_Kennzeichen
     */
    public function setWechselkennzeichen($wechselkennzeichen = null)
    {
        // validation for constraint: boolean
        if (!is_null($wechselkennzeichen) && !is_bool($wechselkennzeichen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($wechselkennzeichen, true), gettype($wechselkennzeichen)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($wechselkennzeichen) && !preg_match('/true|false/', $wechselkennzeichen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($wechselkennzeichen, true)), __LINE__);
        }
        $this->Wechselkennzeichen = $wechselkennzeichen;
        return $this;
    }
}
