<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Kapitalanlage StructType
 * Meta information extracted from the WSDL
 * - documentation: Eine Kapitalanlage, z.B. Termineinlage Sparbrief, Termineinlage Festgeld, Sparkonto, Kontokorrentkonto, Geschäftsanteile, Depot.
 * @subpackage Structs
 */
class CT_Kapitalanlage extends CT_Objekt
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Art der Kapitalanlage.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArtID;
    /**
     * The Unterdepotnummer
     * Meta information extracted from the WSDL
     * - documentation: Identifizierung des Unterdepots, falls das Depot aus Unterdepots besteht. | Identifizierung eines Depots
     * - base: xsd:string
     * - maxLength: 17
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Unterdepotnummer;
    /**
     * The Waehrung
     * Meta information extracted from the WSDL
     * - documentation: Währung, in der die Kapitalanlage geführt wird.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Waehrung;
    /**
     * The DatumErsteEinzahlung
     * Meta information extracted from the WSDL
     * - documentation: Datum der ersten Einzahlung auf die Kapitalanlage. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $DatumErsteEinzahlung;
    /**
     * The Abtretung
     * Meta information extracted from the WSDL
     * - documentation: Kennzeichen, ob zu der Kapitalanlage eine Abtretung vorliegt.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Abtretung;
    /**
     * The Zinsen
     * Meta information extracted from the WSDL
     * - documentation: Gebuchte Zinsen zum Stichtag
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zinsen[]
     */
    public $Zinsen;
    /**
     * The Vereinbarung
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Vereinbarung[]
     */
    public $Vereinbarung;
    /**
     * The Saldo
     * Meta information extracted from the WSDL
     * - documentation: Saldo zum Stichtag
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Saldo[]
     */
    public $Saldo;
    /**
     * The Abtretungsglaeubiger
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Abtretungsglaeubiger[]
     */
    public $Abtretungsglaeubiger;
    /**
     * Constructor method for CT_Kapitalanlage
     * @uses CT_Kapitalanlage::setArtID()
     * @uses CT_Kapitalanlage::setUnterdepotnummer()
     * @uses CT_Kapitalanlage::setWaehrung()
     * @uses CT_Kapitalanlage::setDatumErsteEinzahlung()
     * @uses CT_Kapitalanlage::setAbtretung()
     * @uses CT_Kapitalanlage::setZinsen()
     * @uses CT_Kapitalanlage::setVereinbarung()
     * @uses CT_Kapitalanlage::setSaldo()
     * @uses CT_Kapitalanlage::setAbtretungsglaeubiger()
     * @param string $artID
     * @param string $unterdepotnummer
     * @param string $waehrung
     * @param string $datumErsteEinzahlung
     * @param bool $abtretung
     * @param \BiPRO\StructType\CT_Zinsen[] $zinsen
     * @param \BiPRO\StructType\CT_Vereinbarung[] $vereinbarung
     * @param \BiPRO\StructType\CT_Saldo[] $saldo
     * @param \BiPRO\StructType\CT_Abtretungsglaeubiger[] $abtretungsglaeubiger
     */
    public function __construct($artID = null, $unterdepotnummer = null, $waehrung = null, $datumErsteEinzahlung = null, $abtretung = null, array $zinsen = array(), array $vereinbarung = array(), array $saldo = array(), array $abtretungsglaeubiger = array())
    {
        $this
            ->setArtID($artID)
            ->setUnterdepotnummer($unterdepotnummer)
            ->setWaehrung($waehrung)
            ->setDatumErsteEinzahlung($datumErsteEinzahlung)
            ->setAbtretung($abtretung)
            ->setZinsen($zinsen)
            ->setVereinbarung($vereinbarung)
            ->setSaldo($saldo)
            ->setAbtretungsglaeubiger($abtretungsglaeubiger);
    }
    /**
     * Get ArtID value
     * @return string|null
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @uses \BiPRO\EnumType\ST_Kapitalanlageart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Kapitalanlageart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artID
     * @return \BiPRO\StructType\CT_Kapitalanlage
     */
    public function setArtID($artID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Kapitalanlageart::valueIsValid($artID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Kapitalanlageart', is_array($artID) ? implode(', ', $artID) : var_export($artID, true), implode(', ', \BiPRO\EnumType\ST_Kapitalanlageart::getValidValues())), __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Unterdepotnummer value
     * @return string|null
     */
    public function getUnterdepotnummer()
    {
        return $this->Unterdepotnummer;
    }
    /**
     * Set Unterdepotnummer value
     * @param string $unterdepotnummer
     * @return \BiPRO\StructType\CT_Kapitalanlage
     */
    public function setUnterdepotnummer($unterdepotnummer = null)
    {
        // validation for constraint: string
        if (!is_null($unterdepotnummer) && !is_string($unterdepotnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unterdepotnummer, true), gettype($unterdepotnummer)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($unterdepotnummer) && mb_strlen($unterdepotnummer) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($unterdepotnummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($unterdepotnummer) && mb_strlen($unterdepotnummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($unterdepotnummer)), __LINE__);
        }
        $this->Unterdepotnummer = $unterdepotnummer;
        return $this;
    }
    /**
     * Get Waehrung value
     * @return string|null
     */
    public function getWaehrung()
    {
        return $this->Waehrung;
    }
    /**
     * Set Waehrung value
     * @uses \BiPRO\EnumType\ST_Waehrungsschluessel::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Waehrungsschluessel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $waehrung
     * @return \BiPRO\StructType\CT_Kapitalanlage
     */
    public function setWaehrung($waehrung = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Waehrungsschluessel::valueIsValid($waehrung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Waehrungsschluessel', is_array($waehrung) ? implode(', ', $waehrung) : var_export($waehrung, true), implode(', ', \BiPRO\EnumType\ST_Waehrungsschluessel::getValidValues())), __LINE__);
        }
        $this->Waehrung = $waehrung;
        return $this;
    }
    /**
     * Get DatumErsteEinzahlung value
     * @return string|null
     */
    public function getDatumErsteEinzahlung()
    {
        return $this->DatumErsteEinzahlung;
    }
    /**
     * Set DatumErsteEinzahlung value
     * @param string $datumErsteEinzahlung
     * @return \BiPRO\StructType\CT_Kapitalanlage
     */
    public function setDatumErsteEinzahlung($datumErsteEinzahlung = null)
    {
        // validation for constraint: string
        if (!is_null($datumErsteEinzahlung) && !is_string($datumErsteEinzahlung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumErsteEinzahlung, true), gettype($datumErsteEinzahlung)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($datumErsteEinzahlung) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $datumErsteEinzahlung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($datumErsteEinzahlung, true)), __LINE__);
        }
        $this->DatumErsteEinzahlung = $datumErsteEinzahlung;
        return $this;
    }
    /**
     * Get Abtretung value
     * @return bool|null
     */
    public function getAbtretung()
    {
        return $this->Abtretung;
    }
    /**
     * Set Abtretung value
     * @param bool $abtretung
     * @return \BiPRO\StructType\CT_Kapitalanlage
     */
    public function setAbtretung($abtretung = null)
    {
        // validation for constraint: boolean
        if (!is_null($abtretung) && !is_bool($abtretung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($abtretung, true), gettype($abtretung)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($abtretung) && !preg_match('/true|false/', $abtretung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($abtretung, true)), __LINE__);
        }
        $this->Abtretung = $abtretung;
        return $this;
    }
    /**
     * Get Zinsen value
     * @return \BiPRO\StructType\CT_Zinsen[]|null
     */
    public function getZinsen()
    {
        return $this->Zinsen;
    }
    /**
     * This method is responsible for validating the values passed to the setZinsen method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZinsen method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZinsenForArrayConstraintsFromSetZinsen(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_KapitalanlageZinsenItem) {
            // validation for constraint: itemType
            if (!$cT_KapitalanlageZinsenItem instanceof \BiPRO\StructType\CT_Zinsen) {
                $invalidValues[] = is_object($cT_KapitalanlageZinsenItem) ? get_class($cT_KapitalanlageZinsenItem) : sprintf('%s(%s)', gettype($cT_KapitalanlageZinsenItem), var_export($cT_KapitalanlageZinsenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Zinsen property can only contain items of type \BiPRO\StructType\CT_Zinsen, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Zinsen value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Zinsen[] $zinsen
     * @return \BiPRO\StructType\CT_Kapitalanlage
     */
    public function setZinsen(array $zinsen = array())
    {
        // validation for constraint: array
        if ('' !== ($zinsenArrayErrorMessage = self::validateZinsenForArrayConstraintsFromSetZinsen($zinsen))) {
            throw new \InvalidArgumentException($zinsenArrayErrorMessage, __LINE__);
        }
        $this->Zinsen = $zinsen;
        return $this;
    }
    /**
     * Add item to Zinsen value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Zinsen $item
     * @return \BiPRO\StructType\CT_Kapitalanlage
     */
    public function addToZinsen(\BiPRO\StructType\CT_Zinsen $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Zinsen) {
            throw new \InvalidArgumentException(sprintf('The Zinsen property can only contain items of type \BiPRO\StructType\CT_Zinsen, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Zinsen[] = $item;
        return $this;
    }
    /**
     * Get Vereinbarung value
     * @return \BiPRO\StructType\CT_Vereinbarung[]|null
     */
    public function getVereinbarung()
    {
        return $this->Vereinbarung;
    }
    /**
     * This method is responsible for validating the values passed to the setVereinbarung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVereinbarung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVereinbarungForArrayConstraintsFromSetVereinbarung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_KapitalanlageVereinbarungItem) {
            // validation for constraint: itemType
            if (!$cT_KapitalanlageVereinbarungItem instanceof \BiPRO\StructType\CT_Vereinbarung) {
                $invalidValues[] = is_object($cT_KapitalanlageVereinbarungItem) ? get_class($cT_KapitalanlageVereinbarungItem) : sprintf('%s(%s)', gettype($cT_KapitalanlageVereinbarungItem), var_export($cT_KapitalanlageVereinbarungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Vereinbarung property can only contain items of type \BiPRO\StructType\CT_Vereinbarung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Vereinbarung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Vereinbarung[] $vereinbarung
     * @return \BiPRO\StructType\CT_Kapitalanlage
     */
    public function setVereinbarung(array $vereinbarung = array())
    {
        // validation for constraint: array
        if ('' !== ($vereinbarungArrayErrorMessage = self::validateVereinbarungForArrayConstraintsFromSetVereinbarung($vereinbarung))) {
            throw new \InvalidArgumentException($vereinbarungArrayErrorMessage, __LINE__);
        }
        $this->Vereinbarung = $vereinbarung;
        return $this;
    }
    /**
     * Add item to Vereinbarung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Vereinbarung $item
     * @return \BiPRO\StructType\CT_Kapitalanlage
     */
    public function addToVereinbarung(\BiPRO\StructType\CT_Vereinbarung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Vereinbarung) {
            throw new \InvalidArgumentException(sprintf('The Vereinbarung property can only contain items of type \BiPRO\StructType\CT_Vereinbarung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Vereinbarung[] = $item;
        return $this;
    }
    /**
     * Get Saldo value
     * @return \BiPRO\StructType\CT_Saldo[]|null
     */
    public function getSaldo()
    {
        return $this->Saldo;
    }
    /**
     * This method is responsible for validating the values passed to the setSaldo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSaldo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSaldoForArrayConstraintsFromSetSaldo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_KapitalanlageSaldoItem) {
            // validation for constraint: itemType
            if (!$cT_KapitalanlageSaldoItem instanceof \BiPRO\StructType\CT_Saldo) {
                $invalidValues[] = is_object($cT_KapitalanlageSaldoItem) ? get_class($cT_KapitalanlageSaldoItem) : sprintf('%s(%s)', gettype($cT_KapitalanlageSaldoItem), var_export($cT_KapitalanlageSaldoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Saldo property can only contain items of type \BiPRO\StructType\CT_Saldo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Saldo value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Saldo[] $saldo
     * @return \BiPRO\StructType\CT_Kapitalanlage
     */
    public function setSaldo(array $saldo = array())
    {
        // validation for constraint: array
        if ('' !== ($saldoArrayErrorMessage = self::validateSaldoForArrayConstraintsFromSetSaldo($saldo))) {
            throw new \InvalidArgumentException($saldoArrayErrorMessage, __LINE__);
        }
        $this->Saldo = $saldo;
        return $this;
    }
    /**
     * Add item to Saldo value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Saldo $item
     * @return \BiPRO\StructType\CT_Kapitalanlage
     */
    public function addToSaldo(\BiPRO\StructType\CT_Saldo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Saldo) {
            throw new \InvalidArgumentException(sprintf('The Saldo property can only contain items of type \BiPRO\StructType\CT_Saldo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Saldo[] = $item;
        return $this;
    }
    /**
     * Get Abtretungsglaeubiger value
     * @return \BiPRO\StructType\CT_Abtretungsglaeubiger[]|null
     */
    public function getAbtretungsglaeubiger()
    {
        return $this->Abtretungsglaeubiger;
    }
    /**
     * This method is responsible for validating the values passed to the setAbtretungsglaeubiger method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAbtretungsglaeubiger method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAbtretungsglaeubigerForArrayConstraintsFromSetAbtretungsglaeubiger(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_KapitalanlageAbtretungsglaeubigerItem) {
            // validation for constraint: itemType
            if (!$cT_KapitalanlageAbtretungsglaeubigerItem instanceof \BiPRO\StructType\CT_Abtretungsglaeubiger) {
                $invalidValues[] = is_object($cT_KapitalanlageAbtretungsglaeubigerItem) ? get_class($cT_KapitalanlageAbtretungsglaeubigerItem) : sprintf('%s(%s)', gettype($cT_KapitalanlageAbtretungsglaeubigerItem), var_export($cT_KapitalanlageAbtretungsglaeubigerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Abtretungsglaeubiger property can only contain items of type \BiPRO\StructType\CT_Abtretungsglaeubiger, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Abtretungsglaeubiger value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Abtretungsglaeubiger[] $abtretungsglaeubiger
     * @return \BiPRO\StructType\CT_Kapitalanlage
     */
    public function setAbtretungsglaeubiger(array $abtretungsglaeubiger = array())
    {
        // validation for constraint: array
        if ('' !== ($abtretungsglaeubigerArrayErrorMessage = self::validateAbtretungsglaeubigerForArrayConstraintsFromSetAbtretungsglaeubiger($abtretungsglaeubiger))) {
            throw new \InvalidArgumentException($abtretungsglaeubigerArrayErrorMessage, __LINE__);
        }
        $this->Abtretungsglaeubiger = $abtretungsglaeubiger;
        return $this;
    }
    /**
     * Add item to Abtretungsglaeubiger value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Abtretungsglaeubiger $item
     * @return \BiPRO\StructType\CT_Kapitalanlage
     */
    public function addToAbtretungsglaeubiger(\BiPRO\StructType\CT_Abtretungsglaeubiger $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Abtretungsglaeubiger) {
            throw new \InvalidArgumentException(sprintf('The Abtretungsglaeubiger property can only contain items of type \BiPRO\StructType\CT_Abtretungsglaeubiger, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Abtretungsglaeubiger[] = $item;
        return $this;
    }
}
