<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Haushalt StructType
 * Meta information extracted from the WSDL
 * - documentation: Angaben zu weiteren im Haushalt lebenden Personen (insb. Kinder).Das Attribut KinderImHaushalt (ST_KinderImHaushalt) fehlt, da der entsprechende einfache Datentyp nicht definiert ist.
 * @subpackage Structs
 */
class CT_Haushalt extends CT_Objekt
{
    /**
     * The Haushaltsgroesse
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Haushaltsgroesse;
    /**
     * The AnzahlKinder
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzahlKinder;
    /**
     * The GeburtsdatumJuengstesKind
     * Meta information extracted from the WSDL
     * - documentation: nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $GeburtsdatumJuengstesKind;
    /**
     * The GeburtsdatumAeltestesKind
     * Meta information extracted from the WSDL
     * - documentation: nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $GeburtsdatumAeltestesKind;
    /**
     * The KinderImHaushalt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_KinderImHaushalt
     */
    public $KinderImHaushalt;
    /**
     * The Haushaltsart
     * Meta information extracted from the WSDL
     * - documentation: Art des Haushalt
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_Haushaltsart
     */
    public $Haushaltsart;
    /**
     * Constructor method for CT_Haushalt
     * @uses CT_Haushalt::setHaushaltsgroesse()
     * @uses CT_Haushalt::setAnzahlKinder()
     * @uses CT_Haushalt::setGeburtsdatumJuengstesKind()
     * @uses CT_Haushalt::setGeburtsdatumAeltestesKind()
     * @uses CT_Haushalt::setKinderImHaushalt()
     * @uses CT_Haushalt::setHaushaltsart()
     * @param int $haushaltsgroesse
     * @param int $anzahlKinder
     * @param string $geburtsdatumJuengstesKind
     * @param string $geburtsdatumAeltestesKind
     * @param \BiPRO\StructType\STE_KinderImHaushalt $kinderImHaushalt
     * @param \BiPRO\StructType\STE_Haushaltsart $haushaltsart
     */
    public function __construct($haushaltsgroesse = null, $anzahlKinder = null, $geburtsdatumJuengstesKind = null, $geburtsdatumAeltestesKind = null, \BiPRO\StructType\STE_KinderImHaushalt $kinderImHaushalt = null, \BiPRO\StructType\STE_Haushaltsart $haushaltsart = null)
    {
        $this
            ->setHaushaltsgroesse($haushaltsgroesse)
            ->setAnzahlKinder($anzahlKinder)
            ->setGeburtsdatumJuengstesKind($geburtsdatumJuengstesKind)
            ->setGeburtsdatumAeltestesKind($geburtsdatumAeltestesKind)
            ->setKinderImHaushalt($kinderImHaushalt)
            ->setHaushaltsart($haushaltsart);
    }
    /**
     * Get Haushaltsgroesse value
     * @return int|null
     */
    public function getHaushaltsgroesse()
    {
        return $this->Haushaltsgroesse;
    }
    /**
     * Set Haushaltsgroesse value
     * @param int $haushaltsgroesse
     * @return \BiPRO\StructType\CT_Haushalt
     */
    public function setHaushaltsgroesse($haushaltsgroesse = null)
    {
        // validation for constraint: int
        if (!is_null($haushaltsgroesse) && !(is_int($haushaltsgroesse) || ctype_digit($haushaltsgroesse))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($haushaltsgroesse, true), gettype($haushaltsgroesse)), __LINE__);
        }
        $this->Haushaltsgroesse = $haushaltsgroesse;
        return $this;
    }
    /**
     * Get AnzahlKinder value
     * @return int|null
     */
    public function getAnzahlKinder()
    {
        return $this->AnzahlKinder;
    }
    /**
     * Set AnzahlKinder value
     * @param int $anzahlKinder
     * @return \BiPRO\StructType\CT_Haushalt
     */
    public function setAnzahlKinder($anzahlKinder = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlKinder) && !(is_int($anzahlKinder) || ctype_digit($anzahlKinder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlKinder, true), gettype($anzahlKinder)), __LINE__);
        }
        $this->AnzahlKinder = $anzahlKinder;
        return $this;
    }
    /**
     * Get GeburtsdatumJuengstesKind value
     * @return string|null
     */
    public function getGeburtsdatumJuengstesKind()
    {
        return $this->GeburtsdatumJuengstesKind;
    }
    /**
     * Set GeburtsdatumJuengstesKind value
     * @param string $geburtsdatumJuengstesKind
     * @return \BiPRO\StructType\CT_Haushalt
     */
    public function setGeburtsdatumJuengstesKind($geburtsdatumJuengstesKind = null)
    {
        // validation for constraint: string
        if (!is_null($geburtsdatumJuengstesKind) && !is_string($geburtsdatumJuengstesKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geburtsdatumJuengstesKind, true), gettype($geburtsdatumJuengstesKind)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($geburtsdatumJuengstesKind) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $geburtsdatumJuengstesKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($geburtsdatumJuengstesKind, true)), __LINE__);
        }
        $this->GeburtsdatumJuengstesKind = $geburtsdatumJuengstesKind;
        return $this;
    }
    /**
     * Get GeburtsdatumAeltestesKind value
     * @return string|null
     */
    public function getGeburtsdatumAeltestesKind()
    {
        return $this->GeburtsdatumAeltestesKind;
    }
    /**
     * Set GeburtsdatumAeltestesKind value
     * @param string $geburtsdatumAeltestesKind
     * @return \BiPRO\StructType\CT_Haushalt
     */
    public function setGeburtsdatumAeltestesKind($geburtsdatumAeltestesKind = null)
    {
        // validation for constraint: string
        if (!is_null($geburtsdatumAeltestesKind) && !is_string($geburtsdatumAeltestesKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geburtsdatumAeltestesKind, true), gettype($geburtsdatumAeltestesKind)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($geburtsdatumAeltestesKind) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $geburtsdatumAeltestesKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($geburtsdatumAeltestesKind, true)), __LINE__);
        }
        $this->GeburtsdatumAeltestesKind = $geburtsdatumAeltestesKind;
        return $this;
    }
    /**
     * Get KinderImHaushalt value
     * @return \BiPRO\StructType\STE_KinderImHaushalt|null
     */
    public function getKinderImHaushalt()
    {
        return $this->KinderImHaushalt;
    }
    /**
     * Set KinderImHaushalt value
     * @param \BiPRO\StructType\STE_KinderImHaushalt $kinderImHaushalt
     * @return \BiPRO\StructType\CT_Haushalt
     */
    public function setKinderImHaushalt(\BiPRO\StructType\STE_KinderImHaushalt $kinderImHaushalt = null)
    {
        $this->KinderImHaushalt = $kinderImHaushalt;
        return $this;
    }
    /**
     * Get Haushaltsart value
     * @return \BiPRO\StructType\STE_Haushaltsart|null
     */
    public function getHaushaltsart()
    {
        return $this->Haushaltsart;
    }
    /**
     * Set Haushaltsart value
     * @param \BiPRO\StructType\STE_Haushaltsart $haushaltsart
     * @return \BiPRO\StructType\CT_Haushalt
     */
    public function setHaushaltsart(\BiPRO\StructType\STE_Haushaltsart $haushaltsart = null)
    {
        $this->Haushaltsart = $haushaltsart;
        return $this;
    }
}
