<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Gruppenvertragspartner StructType
 * @subpackage Structs
 */
class CT_Gruppenvertragspartner extends CT_Objekt
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_Gruppenvertragspartner
     */
    public $ID;
    /**
     * The Mitgliedsnummer
     * Meta information extracted from the WSDL
     * - documentation: Identifikation des Partners beim Gruppenvertragspartner
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Mitgliedsnummer;
    /**
     * The Gruppenvertragsnummer
     * Meta information extracted from the WSDL
     * - documentation: Möglichkeit der Identifikation des Gruppenvertragspartners, wenn keine Identifizierung über ID erfolgt. Eine Identifikation ist demnach nicht nur über eine Werteliste (ID) möglich, sofern die Informationen über den
     * Gruppenvertragspartner auf anderen Wegen übermittelt werden. Bei jeder Änderung (neuer Partner oder Wegfall eines Partners) müsste ein aktualisiertes Schema verteilt werden.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Gruppenvertragsnummer;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Ermittlung, ob der gelieferte Partner bereits Mitglied ist.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Name des Gruppenvertragspartners
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for CT_Gruppenvertragspartner
     * @uses CT_Gruppenvertragspartner::setID()
     * @uses CT_Gruppenvertragspartner::setMitgliedsnummer()
     * @uses CT_Gruppenvertragspartner::setGruppenvertragsnummer()
     * @uses CT_Gruppenvertragspartner::setStatus()
     * @uses CT_Gruppenvertragspartner::setName()
     * @param \BiPRO\StructType\STE_Gruppenvertragspartner $iD
     * @param string $mitgliedsnummer
     * @param string $gruppenvertragsnummer
     * @param string $status
     * @param string $name
     */
    public function __construct(\BiPRO\StructType\STE_Gruppenvertragspartner $iD = null, $mitgliedsnummer = null, $gruppenvertragsnummer = null, $status = null, $name = null)
    {
        $this
            ->setID($iD)
            ->setMitgliedsnummer($mitgliedsnummer)
            ->setGruppenvertragsnummer($gruppenvertragsnummer)
            ->setStatus($status)
            ->setName($name);
    }
    /**
     * Get ID value
     * @return \BiPRO\StructType\STE_Gruppenvertragspartner|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \BiPRO\StructType\STE_Gruppenvertragspartner $iD
     * @return \BiPRO\StructType\CT_Gruppenvertragspartner
     */
    public function setID(\BiPRO\StructType\STE_Gruppenvertragspartner $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Mitgliedsnummer value
     * @return string|null
     */
    public function getMitgliedsnummer()
    {
        return $this->Mitgliedsnummer;
    }
    /**
     * Set Mitgliedsnummer value
     * @param string $mitgliedsnummer
     * @return \BiPRO\StructType\CT_Gruppenvertragspartner
     */
    public function setMitgliedsnummer($mitgliedsnummer = null)
    {
        // validation for constraint: string
        if (!is_null($mitgliedsnummer) && !is_string($mitgliedsnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mitgliedsnummer, true), gettype($mitgliedsnummer)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($mitgliedsnummer) && mb_strlen($mitgliedsnummer) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($mitgliedsnummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($mitgliedsnummer) && mb_strlen($mitgliedsnummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($mitgliedsnummer)), __LINE__);
        }
        $this->Mitgliedsnummer = $mitgliedsnummer;
        return $this;
    }
    /**
     * Get Gruppenvertragsnummer value
     * @return string|null
     */
    public function getGruppenvertragsnummer()
    {
        return $this->Gruppenvertragsnummer;
    }
    /**
     * Set Gruppenvertragsnummer value
     * @param string $gruppenvertragsnummer
     * @return \BiPRO\StructType\CT_Gruppenvertragspartner
     */
    public function setGruppenvertragsnummer($gruppenvertragsnummer = null)
    {
        // validation for constraint: string
        if (!is_null($gruppenvertragsnummer) && !is_string($gruppenvertragsnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gruppenvertragsnummer, true), gettype($gruppenvertragsnummer)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($gruppenvertragsnummer) && mb_strlen($gruppenvertragsnummer) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($gruppenvertragsnummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($gruppenvertragsnummer) && mb_strlen($gruppenvertragsnummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($gruppenvertragsnummer)), __LINE__);
        }
        $this->Gruppenvertragsnummer = $gruppenvertragsnummer;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \BiPRO\EnumType\ST_GruppenvertragspartnerStatus::valueIsValid()
     * @uses \BiPRO\EnumType\ST_GruppenvertragspartnerStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \BiPRO\StructType\CT_Gruppenvertragspartner
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_GruppenvertragspartnerStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_GruppenvertragspartnerStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \BiPRO\EnumType\ST_GruppenvertragspartnerStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \BiPRO\StructType\CT_Gruppenvertragspartner
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($name) && mb_strlen($name) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
}
