<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Grundstueck StructType
 * @subpackage Structs
 */
class CT_Grundstueck extends CT_Gegenstand
{
    /**
     * The Flaeche
     * Meta information extracted from the WSDL
     * - documentation: Angabe zur Gesamtfläche
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Flaeche;
    /**
     * The Werteinheit
     * Meta information extracted from the WSDL
     * - documentation: Ausprägung qm oder ha erlaubt. Werteinheit zum Attribut Flaeche.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Werteinheit;
    /**
     * The UeberdachteFlaeche
     * Meta information extracted from the WSDL
     * - documentation: Angabe zur gesamten überdachten Fläche (in Quadratmeter)
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $UeberdachteFlaeche;
    /**
     * The Eigentuemer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Eigentuemer[]
     */
    public $Eigentuemer;
    /**
     * The Vermieter
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Vermieter[]
     */
    public $Vermieter;
    /**
     * The Mieter
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Mieter[]
     */
    public $Mieter;
    /**
     * The Objektanschrift
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Objektanschrift
     */
    public $Objektanschrift;
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Dieses Attribut dient der Klassifikation der Grundstückart
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArtID;
    /**
     * Constructor method for CT_Grundstueck
     * @uses CT_Grundstueck::setFlaeche()
     * @uses CT_Grundstueck::setWerteinheit()
     * @uses CT_Grundstueck::setUeberdachteFlaeche()
     * @uses CT_Grundstueck::setEigentuemer()
     * @uses CT_Grundstueck::setVermieter()
     * @uses CT_Grundstueck::setMieter()
     * @uses CT_Grundstueck::setObjektanschrift()
     * @uses CT_Grundstueck::setArtID()
     * @param float $flaeche
     * @param string $werteinheit
     * @param float $ueberdachteFlaeche
     * @param \BiPRO\StructType\CT_Eigentuemer[] $eigentuemer
     * @param \BiPRO\StructType\CT_Vermieter[] $vermieter
     * @param \BiPRO\StructType\CT_Mieter[] $mieter
     * @param \BiPRO\StructType\CT_Objektanschrift $objektanschrift
     * @param string $artID
     */
    public function __construct($flaeche = null, $werteinheit = null, $ueberdachteFlaeche = null, array $eigentuemer = array(), array $vermieter = array(), array $mieter = array(), \BiPRO\StructType\CT_Objektanschrift $objektanschrift = null, $artID = null)
    {
        $this
            ->setFlaeche($flaeche)
            ->setWerteinheit($werteinheit)
            ->setUeberdachteFlaeche($ueberdachteFlaeche)
            ->setEigentuemer($eigentuemer)
            ->setVermieter($vermieter)
            ->setMieter($mieter)
            ->setObjektanschrift($objektanschrift)
            ->setArtID($artID);
    }
    /**
     * Get Flaeche value
     * @return float|null
     */
    public function getFlaeche()
    {
        return $this->Flaeche;
    }
    /**
     * Set Flaeche value
     * @param float $flaeche
     * @return \BiPRO\StructType\CT_Grundstueck
     */
    public function setFlaeche($flaeche = null)
    {
        // validation for constraint: float
        if (!is_null($flaeche) && !(is_float($flaeche) || is_numeric($flaeche))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($flaeche, true), gettype($flaeche)), __LINE__);
        }
        $this->Flaeche = $flaeche;
        return $this;
    }
    /**
     * Get Werteinheit value
     * @return string|null
     */
    public function getWerteinheit()
    {
        return $this->Werteinheit;
    }
    /**
     * Set Werteinheit value
     * @uses \BiPRO\EnumType\ST_Werteinheit::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Werteinheit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $werteinheit
     * @return \BiPRO\StructType\CT_Grundstueck
     */
    public function setWerteinheit($werteinheit = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Werteinheit::valueIsValid($werteinheit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Werteinheit', is_array($werteinheit) ? implode(', ', $werteinheit) : var_export($werteinheit, true), implode(', ', \BiPRO\EnumType\ST_Werteinheit::getValidValues())), __LINE__);
        }
        $this->Werteinheit = $werteinheit;
        return $this;
    }
    /**
     * Get UeberdachteFlaeche value
     * @return float|null
     */
    public function getUeberdachteFlaeche()
    {
        return $this->UeberdachteFlaeche;
    }
    /**
     * Set UeberdachteFlaeche value
     * @param float $ueberdachteFlaeche
     * @return \BiPRO\StructType\CT_Grundstueck
     */
    public function setUeberdachteFlaeche($ueberdachteFlaeche = null)
    {
        // validation for constraint: float
        if (!is_null($ueberdachteFlaeche) && !(is_float($ueberdachteFlaeche) || is_numeric($ueberdachteFlaeche))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ueberdachteFlaeche, true), gettype($ueberdachteFlaeche)), __LINE__);
        }
        $this->UeberdachteFlaeche = $ueberdachteFlaeche;
        return $this;
    }
    /**
     * Get Eigentuemer value
     * @return \BiPRO\StructType\CT_Eigentuemer[]|null
     */
    public function getEigentuemer()
    {
        return $this->Eigentuemer;
    }
    /**
     * This method is responsible for validating the values passed to the setEigentuemer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEigentuemer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEigentuemerForArrayConstraintsFromSetEigentuemer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_GrundstueckEigentuemerItem) {
            // validation for constraint: itemType
            if (!$cT_GrundstueckEigentuemerItem instanceof \BiPRO\StructType\CT_Eigentuemer) {
                $invalidValues[] = is_object($cT_GrundstueckEigentuemerItem) ? get_class($cT_GrundstueckEigentuemerItem) : sprintf('%s(%s)', gettype($cT_GrundstueckEigentuemerItem), var_export($cT_GrundstueckEigentuemerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Eigentuemer property can only contain items of type \BiPRO\StructType\CT_Eigentuemer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Eigentuemer value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Eigentuemer[] $eigentuemer
     * @return \BiPRO\StructType\CT_Grundstueck
     */
    public function setEigentuemer(array $eigentuemer = array())
    {
        // validation for constraint: array
        if ('' !== ($eigentuemerArrayErrorMessage = self::validateEigentuemerForArrayConstraintsFromSetEigentuemer($eigentuemer))) {
            throw new \InvalidArgumentException($eigentuemerArrayErrorMessage, __LINE__);
        }
        $this->Eigentuemer = $eigentuemer;
        return $this;
    }
    /**
     * Add item to Eigentuemer value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Eigentuemer $item
     * @return \BiPRO\StructType\CT_Grundstueck
     */
    public function addToEigentuemer(\BiPRO\StructType\CT_Eigentuemer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Eigentuemer) {
            throw new \InvalidArgumentException(sprintf('The Eigentuemer property can only contain items of type \BiPRO\StructType\CT_Eigentuemer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Eigentuemer[] = $item;
        return $this;
    }
    /**
     * Get Vermieter value
     * @return \BiPRO\StructType\CT_Vermieter[]|null
     */
    public function getVermieter()
    {
        return $this->Vermieter;
    }
    /**
     * This method is responsible for validating the values passed to the setVermieter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVermieter method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVermieterForArrayConstraintsFromSetVermieter(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_GrundstueckVermieterItem) {
            // validation for constraint: itemType
            if (!$cT_GrundstueckVermieterItem instanceof \BiPRO\StructType\CT_Vermieter) {
                $invalidValues[] = is_object($cT_GrundstueckVermieterItem) ? get_class($cT_GrundstueckVermieterItem) : sprintf('%s(%s)', gettype($cT_GrundstueckVermieterItem), var_export($cT_GrundstueckVermieterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Vermieter property can only contain items of type \BiPRO\StructType\CT_Vermieter, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Vermieter value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Vermieter[] $vermieter
     * @return \BiPRO\StructType\CT_Grundstueck
     */
    public function setVermieter(array $vermieter = array())
    {
        // validation for constraint: array
        if ('' !== ($vermieterArrayErrorMessage = self::validateVermieterForArrayConstraintsFromSetVermieter($vermieter))) {
            throw new \InvalidArgumentException($vermieterArrayErrorMessage, __LINE__);
        }
        $this->Vermieter = $vermieter;
        return $this;
    }
    /**
     * Add item to Vermieter value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Vermieter $item
     * @return \BiPRO\StructType\CT_Grundstueck
     */
    public function addToVermieter(\BiPRO\StructType\CT_Vermieter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Vermieter) {
            throw new \InvalidArgumentException(sprintf('The Vermieter property can only contain items of type \BiPRO\StructType\CT_Vermieter, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Vermieter[] = $item;
        return $this;
    }
    /**
     * Get Mieter value
     * @return \BiPRO\StructType\CT_Mieter[]|null
     */
    public function getMieter()
    {
        return $this->Mieter;
    }
    /**
     * This method is responsible for validating the values passed to the setMieter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMieter method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMieterForArrayConstraintsFromSetMieter(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_GrundstueckMieterItem) {
            // validation for constraint: itemType
            if (!$cT_GrundstueckMieterItem instanceof \BiPRO\StructType\CT_Mieter) {
                $invalidValues[] = is_object($cT_GrundstueckMieterItem) ? get_class($cT_GrundstueckMieterItem) : sprintf('%s(%s)', gettype($cT_GrundstueckMieterItem), var_export($cT_GrundstueckMieterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Mieter property can only contain items of type \BiPRO\StructType\CT_Mieter, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Mieter value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Mieter[] $mieter
     * @return \BiPRO\StructType\CT_Grundstueck
     */
    public function setMieter(array $mieter = array())
    {
        // validation for constraint: array
        if ('' !== ($mieterArrayErrorMessage = self::validateMieterForArrayConstraintsFromSetMieter($mieter))) {
            throw new \InvalidArgumentException($mieterArrayErrorMessage, __LINE__);
        }
        $this->Mieter = $mieter;
        return $this;
    }
    /**
     * Add item to Mieter value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Mieter $item
     * @return \BiPRO\StructType\CT_Grundstueck
     */
    public function addToMieter(\BiPRO\StructType\CT_Mieter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Mieter) {
            throw new \InvalidArgumentException(sprintf('The Mieter property can only contain items of type \BiPRO\StructType\CT_Mieter, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Mieter[] = $item;
        return $this;
    }
    /**
     * Get Objektanschrift value
     * @return \BiPRO\StructType\CT_Objektanschrift|null
     */
    public function getObjektanschrift()
    {
        return $this->Objektanschrift;
    }
    /**
     * Set Objektanschrift value
     * @param \BiPRO\StructType\CT_Objektanschrift $objektanschrift
     * @return \BiPRO\StructType\CT_Grundstueck
     */
    public function setObjektanschrift(\BiPRO\StructType\CT_Objektanschrift $objektanschrift = null)
    {
        $this->Objektanschrift = $objektanschrift;
        return $this;
    }
    /**
     * Get ArtID value
     * @return string|null
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @uses \BiPRO\EnumType\ST_Grundstueckart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Grundstueckart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artID
     * @return \BiPRO\StructType\CT_Grundstueck
     */
    public function setArtID($artID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Grundstueckart::valueIsValid($artID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Grundstueckart', is_array($artID) ? implode(', ', $artID) : var_export($artID, true), implode(', ', \BiPRO\EnumType\ST_Grundstueckart::getValidValues())), __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
}
