<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Glas StructType
 * Meta information extracted from the WSDL
 * - documentation: Eigenständiges Glasrisiko unabhängig von Gebäude und Hausrat.
 * @subpackage Structs
 */
class CT_Glas extends CT_Gegenstand
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArtID;
    /**
     * The Wert
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Wert;
    /**
     * The Werteinheit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Werteinheit;
    /**
     * The Objektanschrift
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Objektanschrift
     */
    public $Objektanschrift;
    /**
     * The Glasart
     * Meta information extracted from the WSDL
     * - documentation: Art des Glases.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_Glasart
     */
    public $Glasart;
    /**
     * The Verglasungsart
     * Meta information extracted from the WSDL
     * - documentation: Art der Verglasung.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_Verglasungsart
     */
    public $Verglasungsart;
    /**
     * The Glasverwendung
     * Meta information extracted from the WSDL
     * - documentation: Verwendungszweck des Glases.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_Glasverwendung
     */
    public $Glasverwendung;
    /**
     * The Lage
     * Meta information extracted from the WSDL
     * - documentation: Lage des Glases im Gebäude.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_Gebaeudeteil
     */
    public $Lage;
    /**
     * The Material
     * Meta information extracted from the WSDL
     * - documentation: Material des Glases.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Material;
    /**
     * The Oberflaechenbearbeitung
     * Meta information extracted from the WSDL
     * - documentation: Oberflächenbearbeitung des Glases.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_OberflaechenbearbeitungGlas
     */
    public $Oberflaechenbearbeitung;
    /**
     * The Rahmen
     * Meta information extracted from the WSDL
     * - documentation: JA = Glasscheibe ist gerahmt.NEIN = Glasscheibe ist nicht gerahmt.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Rahmen;
    /**
     * The Fabrikat
     * Meta information extracted from the WSDL
     * - documentation: Fabrikat des Glases, z. B. bei Glaskeramikkochflächen.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Fabrikat;
    /**
     * The Typenbezeichnung
     * Meta information extracted from the WSDL
     * - documentation: Typbezeichnung des Glases, z. B. bei Glaskeramikkochflächen.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Typenbezeichnung;
    /**
     * Constructor method for CT_Glas
     * @uses CT_Glas::setArtID()
     * @uses CT_Glas::setWert()
     * @uses CT_Glas::setWerteinheit()
     * @uses CT_Glas::setObjektanschrift()
     * @uses CT_Glas::setGlasart()
     * @uses CT_Glas::setVerglasungsart()
     * @uses CT_Glas::setGlasverwendung()
     * @uses CT_Glas::setLage()
     * @uses CT_Glas::setMaterial()
     * @uses CT_Glas::setOberflaechenbearbeitung()
     * @uses CT_Glas::setRahmen()
     * @uses CT_Glas::setFabrikat()
     * @uses CT_Glas::setTypenbezeichnung()
     * @param string $artID
     * @param float $wert
     * @param string $werteinheit
     * @param \BiPRO\StructType\CT_Objektanschrift $objektanschrift
     * @param \BiPRO\StructType\STE_Glasart $glasart
     * @param \BiPRO\StructType\STE_Verglasungsart $verglasungsart
     * @param \BiPRO\StructType\STE_Glasverwendung $glasverwendung
     * @param \BiPRO\StructType\STE_Gebaeudeteil $lage
     * @param string $material
     * @param \BiPRO\StructType\STE_OberflaechenbearbeitungGlas $oberflaechenbearbeitung
     * @param bool $rahmen
     * @param string $fabrikat
     * @param string $typenbezeichnung
     */
    public function __construct($artID = null, $wert = null, $werteinheit = null, \BiPRO\StructType\CT_Objektanschrift $objektanschrift = null, \BiPRO\StructType\STE_Glasart $glasart = null, \BiPRO\StructType\STE_Verglasungsart $verglasungsart = null, \BiPRO\StructType\STE_Glasverwendung $glasverwendung = null, \BiPRO\StructType\STE_Gebaeudeteil $lage = null, $material = null, \BiPRO\StructType\STE_OberflaechenbearbeitungGlas $oberflaechenbearbeitung = null, $rahmen = null, $fabrikat = null, $typenbezeichnung = null)
    {
        $this
            ->setArtID($artID)
            ->setWert($wert)
            ->setWerteinheit($werteinheit)
            ->setObjektanschrift($objektanschrift)
            ->setGlasart($glasart)
            ->setVerglasungsart($verglasungsart)
            ->setGlasverwendung($glasverwendung)
            ->setLage($lage)
            ->setMaterial($material)
            ->setOberflaechenbearbeitung($oberflaechenbearbeitung)
            ->setRahmen($rahmen)
            ->setFabrikat($fabrikat)
            ->setTypenbezeichnung($typenbezeichnung);
    }
    /**
     * Get ArtID value
     * @return string|null
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @uses \BiPRO\EnumType\ST_Glasrisiko::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Glasrisiko::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artID
     * @return \BiPRO\StructType\CT_Glas
     */
    public function setArtID($artID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Glasrisiko::valueIsValid($artID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Glasrisiko', is_array($artID) ? implode(', ', $artID) : var_export($artID, true), implode(', ', \BiPRO\EnumType\ST_Glasrisiko::getValidValues())), __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Wert value
     * @return float|null
     */
    public function getWert()
    {
        return $this->Wert;
    }
    /**
     * Set Wert value
     * @param float $wert
     * @return \BiPRO\StructType\CT_Glas
     */
    public function setWert($wert = null)
    {
        // validation for constraint: float
        if (!is_null($wert) && !(is_float($wert) || is_numeric($wert))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($wert, true), gettype($wert)), __LINE__);
        }
        $this->Wert = $wert;
        return $this;
    }
    /**
     * Get Werteinheit value
     * @return string|null
     */
    public function getWerteinheit()
    {
        return $this->Werteinheit;
    }
    /**
     * Set Werteinheit value
     * @uses \BiPRO\EnumType\ST_Werteinheit::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Werteinheit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $werteinheit
     * @return \BiPRO\StructType\CT_Glas
     */
    public function setWerteinheit($werteinheit = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Werteinheit::valueIsValid($werteinheit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Werteinheit', is_array($werteinheit) ? implode(', ', $werteinheit) : var_export($werteinheit, true), implode(', ', \BiPRO\EnumType\ST_Werteinheit::getValidValues())), __LINE__);
        }
        $this->Werteinheit = $werteinheit;
        return $this;
    }
    /**
     * Get Objektanschrift value
     * @return \BiPRO\StructType\CT_Objektanschrift|null
     */
    public function getObjektanschrift()
    {
        return $this->Objektanschrift;
    }
    /**
     * Set Objektanschrift value
     * @param \BiPRO\StructType\CT_Objektanschrift $objektanschrift
     * @return \BiPRO\StructType\CT_Glas
     */
    public function setObjektanschrift(\BiPRO\StructType\CT_Objektanschrift $objektanschrift = null)
    {
        $this->Objektanschrift = $objektanschrift;
        return $this;
    }
    /**
     * Get Glasart value
     * @return \BiPRO\StructType\STE_Glasart|null
     */
    public function getGlasart()
    {
        return $this->Glasart;
    }
    /**
     * Set Glasart value
     * @param \BiPRO\StructType\STE_Glasart $glasart
     * @return \BiPRO\StructType\CT_Glas
     */
    public function setGlasart(\BiPRO\StructType\STE_Glasart $glasart = null)
    {
        $this->Glasart = $glasart;
        return $this;
    }
    /**
     * Get Verglasungsart value
     * @return \BiPRO\StructType\STE_Verglasungsart|null
     */
    public function getVerglasungsart()
    {
        return $this->Verglasungsart;
    }
    /**
     * Set Verglasungsart value
     * @param \BiPRO\StructType\STE_Verglasungsart $verglasungsart
     * @return \BiPRO\StructType\CT_Glas
     */
    public function setVerglasungsart(\BiPRO\StructType\STE_Verglasungsart $verglasungsart = null)
    {
        $this->Verglasungsart = $verglasungsart;
        return $this;
    }
    /**
     * Get Glasverwendung value
     * @return \BiPRO\StructType\STE_Glasverwendung|null
     */
    public function getGlasverwendung()
    {
        return $this->Glasverwendung;
    }
    /**
     * Set Glasverwendung value
     * @param \BiPRO\StructType\STE_Glasverwendung $glasverwendung
     * @return \BiPRO\StructType\CT_Glas
     */
    public function setGlasverwendung(\BiPRO\StructType\STE_Glasverwendung $glasverwendung = null)
    {
        $this->Glasverwendung = $glasverwendung;
        return $this;
    }
    /**
     * Get Lage value
     * @return \BiPRO\StructType\STE_Gebaeudeteil|null
     */
    public function getLage()
    {
        return $this->Lage;
    }
    /**
     * Set Lage value
     * @param \BiPRO\StructType\STE_Gebaeudeteil $lage
     * @return \BiPRO\StructType\CT_Glas
     */
    public function setLage(\BiPRO\StructType\STE_Gebaeudeteil $lage = null)
    {
        $this->Lage = $lage;
        return $this;
    }
    /**
     * Get Material value
     * @return string|null
     */
    public function getMaterial()
    {
        return $this->Material;
    }
    /**
     * Set Material value
     * @uses \BiPRO\EnumType\ST_Material::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Material::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $material
     * @return \BiPRO\StructType\CT_Glas
     */
    public function setMaterial($material = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Material::valueIsValid($material)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Material', is_array($material) ? implode(', ', $material) : var_export($material, true), implode(', ', \BiPRO\EnumType\ST_Material::getValidValues())), __LINE__);
        }
        $this->Material = $material;
        return $this;
    }
    /**
     * Get Oberflaechenbearbeitung value
     * @return \BiPRO\StructType\STE_OberflaechenbearbeitungGlas|null
     */
    public function getOberflaechenbearbeitung()
    {
        return $this->Oberflaechenbearbeitung;
    }
    /**
     * Set Oberflaechenbearbeitung value
     * @param \BiPRO\StructType\STE_OberflaechenbearbeitungGlas $oberflaechenbearbeitung
     * @return \BiPRO\StructType\CT_Glas
     */
    public function setOberflaechenbearbeitung(\BiPRO\StructType\STE_OberflaechenbearbeitungGlas $oberflaechenbearbeitung = null)
    {
        $this->Oberflaechenbearbeitung = $oberflaechenbearbeitung;
        return $this;
    }
    /**
     * Get Rahmen value
     * @return bool|null
     */
    public function getRahmen()
    {
        return $this->Rahmen;
    }
    /**
     * Set Rahmen value
     * @param bool $rahmen
     * @return \BiPRO\StructType\CT_Glas
     */
    public function setRahmen($rahmen = null)
    {
        // validation for constraint: boolean
        if (!is_null($rahmen) && !is_bool($rahmen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rahmen, true), gettype($rahmen)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($rahmen) && !preg_match('/true|false/', $rahmen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($rahmen, true)), __LINE__);
        }
        $this->Rahmen = $rahmen;
        return $this;
    }
    /**
     * Get Fabrikat value
     * @return string|null
     */
    public function getFabrikat()
    {
        return $this->Fabrikat;
    }
    /**
     * Set Fabrikat value
     * @param string $fabrikat
     * @return \BiPRO\StructType\CT_Glas
     */
    public function setFabrikat($fabrikat = null)
    {
        // validation for constraint: string
        if (!is_null($fabrikat) && !is_string($fabrikat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fabrikat, true), gettype($fabrikat)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($fabrikat) && mb_strlen($fabrikat) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($fabrikat)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($fabrikat) && mb_strlen($fabrikat) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($fabrikat)), __LINE__);
        }
        $this->Fabrikat = $fabrikat;
        return $this;
    }
    /**
     * Get Typenbezeichnung value
     * @return string|null
     */
    public function getTypenbezeichnung()
    {
        return $this->Typenbezeichnung;
    }
    /**
     * Set Typenbezeichnung value
     * @param string $typenbezeichnung
     * @return \BiPRO\StructType\CT_Glas
     */
    public function setTypenbezeichnung($typenbezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($typenbezeichnung) && !is_string($typenbezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typenbezeichnung, true), gettype($typenbezeichnung)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($typenbezeichnung) && mb_strlen($typenbezeichnung) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($typenbezeichnung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($typenbezeichnung) && mb_strlen($typenbezeichnung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($typenbezeichnung)), __LINE__);
        }
        $this->Typenbezeichnung = $typenbezeichnung;
        return $this;
    }
}
