<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_GeteilterBeitrag StructType
 * Meta information extracted from the WSDL
 * - documentation: Klasse zur Abbildung geteilter Beiträge (z.B. Arbeitgeber- und Arbeitnehmeranteil in der betrieblichen Altersvorsorge).Der von GeteilterBeitrag referenzierte Betrag MUSS der Summe aller Teilbeiträge entsprechen.
 * @subpackage Structs
 */
class CT_GeteilterBeitrag extends CT_Beitrag
{
    /**
     * The Teilbeitrag
     * Meta information extracted from the WSDL
     * - documentation: Teilbeitrag des geteilten Beitrags.Die Zahlungsweise aller Teilbeiträge MUSS der Zahlungsweise der referenzierenden Klasse "GeteilterBeitrag" entsprechen..
     * - maxOccurs: unbounded
     * - minOccurs: 2
     * @var \BiPRO\StructType\CT_Teilbeitrag[]
     */
    public $Teilbeitrag;
    /**
     * Constructor method for CT_GeteilterBeitrag
     * @uses CT_GeteilterBeitrag::setTeilbeitrag()
     * @param \BiPRO\StructType\CT_Teilbeitrag[] $teilbeitrag
     */
    public function __construct(array $teilbeitrag = array())
    {
        $this
            ->setTeilbeitrag($teilbeitrag);
    }
    /**
     * Get Teilbeitrag value
     * @return \BiPRO\StructType\CT_Teilbeitrag[]
     */
    public function getTeilbeitrag()
    {
        return $this->Teilbeitrag;
    }
    /**
     * This method is responsible for validating the values passed to the setTeilbeitrag method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTeilbeitrag method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTeilbeitragForArrayConstraintsFromSetTeilbeitrag(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_GeteilterBeitragTeilbeitragItem) {
            // validation for constraint: itemType
            if (!$cT_GeteilterBeitragTeilbeitragItem instanceof \BiPRO\StructType\CT_Teilbeitrag) {
                $invalidValues[] = is_object($cT_GeteilterBeitragTeilbeitragItem) ? get_class($cT_GeteilterBeitragTeilbeitragItem) : sprintf('%s(%s)', gettype($cT_GeteilterBeitragTeilbeitragItem), var_export($cT_GeteilterBeitragTeilbeitragItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Teilbeitrag property can only contain items of type \BiPRO\StructType\CT_Teilbeitrag, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Teilbeitrag value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Teilbeitrag[] $teilbeitrag
     * @return \BiPRO\StructType\CT_GeteilterBeitrag
     */
    public function setTeilbeitrag(array $teilbeitrag = array())
    {
        // validation for constraint: array
        if ('' !== ($teilbeitragArrayErrorMessage = self::validateTeilbeitragForArrayConstraintsFromSetTeilbeitrag($teilbeitrag))) {
            throw new \InvalidArgumentException($teilbeitragArrayErrorMessage, __LINE__);
        }
        $this->Teilbeitrag = $teilbeitrag;
        return $this;
    }
    /**
     * Add item to Teilbeitrag value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Teilbeitrag $item
     * @return \BiPRO\StructType\CT_GeteilterBeitrag
     */
    public function addToTeilbeitrag(\BiPRO\StructType\CT_Teilbeitrag $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Teilbeitrag) {
            throw new \InvalidArgumentException(sprintf('The Teilbeitrag property can only contain items of type \BiPRO\StructType\CT_Teilbeitrag, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Teilbeitrag[] = $item;
        return $this;
    }
}
