<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Gegenstandsrolle StructType
 * @subpackage Structs
 */
abstract class CT_Gegenstandsrolle extends CT_Objekt
{
    /**
     * The GegenstandID
     * Meta information extracted from the WSDL
     * - documentation: Typ fuer alle IDs.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $GegenstandID;
    /**
     * Constructor method for CT_Gegenstandsrolle
     * @uses CT_Gegenstandsrolle::setGegenstandID()
     * @param string $gegenstandID
     */
    public function __construct($gegenstandID = null)
    {
        $this
            ->setGegenstandID($gegenstandID);
    }
    /**
     * Get GegenstandID value
     * @return string
     */
    public function getGegenstandID()
    {
        return $this->GegenstandID;
    }
    /**
     * Set GegenstandID value
     * @param string $gegenstandID
     * @return \BiPRO\StructType\CT_Gegenstandsrolle
     */
    public function setGegenstandID($gegenstandID = null)
    {
        // validation for constraint: string
        if (!is_null($gegenstandID) && !is_string($gegenstandID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gegenstandID, true), gettype($gegenstandID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($gegenstandID) && mb_strlen($gegenstandID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($gegenstandID)), __LINE__);
        }
        $this->GegenstandID = $gegenstandID;
        return $this;
    }
}
