<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Gegenstand StructType
 * @subpackage Structs
 */
abstract class CT_Gegenstand extends CT_Objekt
{
    /**
     * The GegenstandID
     * Meta information extracted from the WSDL
     * - documentation: Eindeutige Identifikationsnummer zur Referenzierung des Objektes innerhalb des Datenaustauschs. | Typ fuer alle IDs.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $GegenstandID;
    /**
     * The Referenz
     * Meta information extracted from the WSDL
     * - documentation: Vom Provider generierte, eindeutige Referenznummer zur Identifizierung des Objektes über Prozesse hinweg, insbesondere zwischen Auskunfts- und Änderungsprozessen. | Allgemeiner Datentyp für alle externen, statischen Referenzen zur
     * Identifizierung von Objekten. Mit diesem Datentyp können Objekte über unterschiedliche Nachrichten (z.B. Auskunft und Änderung) hinweg identifiziert werden.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Referenz;
    /**
     * The ZusaetzlicheGegenstandsdaten
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_ZusaetzlicheGegenstandsdaten[]
     */
    public $ZusaetzlicheGegenstandsdaten;
    /**
     * The Beschreibung
     * Meta information extracted from the WSDL
     * - documentation: Genaue Beschreibung des Gegenstandes. In Gewerbe auch eine Zusammenfassung von mehreren Objekten zu einem Komplex, bzw. Beschreibung der Zugehörigkeit eines Objektes bzw.genaue Bezeichnung einer Anlage.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Beschreibung;
    /**
     * The Groesse
     * Meta information extracted from the WSDL
     * - documentation: Die physische Ausdehnung eines Gegenstandes.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Groesse
     */
    public $Groesse;
    /**
     * The Beinhaltet
     * Meta information extracted from the WSDL
     * - documentation: Referenziert die Gegenstände, die ein Gegenstand enthält.Beispiele:Ein Grundstück enthält Gebäude.Ein Gebäude enthält Gebäudeteile oder Anlagen oder Fahrzeuge.Referenziert die Gegenstände, die zu einem Gebäudeteil
     * gehören.Referenziert die Gegenstände, die zu einem Betrieb gehören.Referenziert die Gegenstände, die zu einer Betriebsstätte gehören.Referenziert die Gegenstände, die zu einer Anlage gehören.Referenziert die Gegenstände, die in einem
     * Fahrzeug enthalten sind.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Beinhaltet[]
     */
    public $Beinhaltet;
    /**
     * Constructor method for CT_Gegenstand
     * @uses CT_Gegenstand::setGegenstandID()
     * @uses CT_Gegenstand::setReferenz()
     * @uses CT_Gegenstand::setZusaetzlicheGegenstandsdaten()
     * @uses CT_Gegenstand::setBeschreibung()
     * @uses CT_Gegenstand::setGroesse()
     * @uses CT_Gegenstand::setBeinhaltet()
     * @param string $gegenstandID
     * @param string $referenz
     * @param \BiPRO\StructType\CT_ZusaetzlicheGegenstandsdaten[] $zusaetzlicheGegenstandsdaten
     * @param string $beschreibung
     * @param \BiPRO\StructType\CT_Groesse $groesse
     * @param \BiPRO\StructType\CT_Beinhaltet[] $beinhaltet
     */
    public function __construct($gegenstandID = null, $referenz = null, array $zusaetzlicheGegenstandsdaten = array(), $beschreibung = null, \BiPRO\StructType\CT_Groesse $groesse = null, array $beinhaltet = array())
    {
        $this
            ->setGegenstandID($gegenstandID)
            ->setReferenz($referenz)
            ->setZusaetzlicheGegenstandsdaten($zusaetzlicheGegenstandsdaten)
            ->setBeschreibung($beschreibung)
            ->setGroesse($groesse)
            ->setBeinhaltet($beinhaltet);
    }
    /**
     * Get GegenstandID value
     * @return string
     */
    public function getGegenstandID()
    {
        return $this->GegenstandID;
    }
    /**
     * Set GegenstandID value
     * @param string $gegenstandID
     * @return \BiPRO\StructType\CT_Gegenstand
     */
    public function setGegenstandID($gegenstandID = null)
    {
        // validation for constraint: string
        if (!is_null($gegenstandID) && !is_string($gegenstandID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gegenstandID, true), gettype($gegenstandID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($gegenstandID) && mb_strlen($gegenstandID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($gegenstandID)), __LINE__);
        }
        $this->GegenstandID = $gegenstandID;
        return $this;
    }
    /**
     * Get Referenz value
     * @return string|null
     */
    public function getReferenz()
    {
        return $this->Referenz;
    }
    /**
     * Set Referenz value
     * @param string $referenz
     * @return \BiPRO\StructType\CT_Gegenstand
     */
    public function setReferenz($referenz = null)
    {
        // validation for constraint: string
        if (!is_null($referenz) && !is_string($referenz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenz, true), gettype($referenz)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($referenz) && mb_strlen($referenz) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($referenz)), __LINE__);
        }
        $this->Referenz = $referenz;
        return $this;
    }
    /**
     * Get ZusaetzlicheGegenstandsdaten value
     * @return \BiPRO\StructType\CT_ZusaetzlicheGegenstandsdaten[]|null
     */
    public function getZusaetzlicheGegenstandsdaten()
    {
        return $this->ZusaetzlicheGegenstandsdaten;
    }
    /**
     * This method is responsible for validating the values passed to the setZusaetzlicheGegenstandsdaten method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZusaetzlicheGegenstandsdaten method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZusaetzlicheGegenstandsdatenForArrayConstraintsFromSetZusaetzlicheGegenstandsdaten(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_GegenstandZusaetzlicheGegenstandsdatenItem) {
            // validation for constraint: itemType
            if (!$cT_GegenstandZusaetzlicheGegenstandsdatenItem instanceof \BiPRO\StructType\CT_ZusaetzlicheGegenstandsdaten) {
                $invalidValues[] = is_object($cT_GegenstandZusaetzlicheGegenstandsdatenItem) ? get_class($cT_GegenstandZusaetzlicheGegenstandsdatenItem) : sprintf('%s(%s)', gettype($cT_GegenstandZusaetzlicheGegenstandsdatenItem), var_export($cT_GegenstandZusaetzlicheGegenstandsdatenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ZusaetzlicheGegenstandsdaten property can only contain items of type \BiPRO\StructType\CT_ZusaetzlicheGegenstandsdaten, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ZusaetzlicheGegenstandsdaten value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_ZusaetzlicheGegenstandsdaten[] $zusaetzlicheGegenstandsdaten
     * @return \BiPRO\StructType\CT_Gegenstand
     */
    public function setZusaetzlicheGegenstandsdaten(array $zusaetzlicheGegenstandsdaten = array())
    {
        // validation for constraint: array
        if ('' !== ($zusaetzlicheGegenstandsdatenArrayErrorMessage = self::validateZusaetzlicheGegenstandsdatenForArrayConstraintsFromSetZusaetzlicheGegenstandsdaten($zusaetzlicheGegenstandsdaten))) {
            throw new \InvalidArgumentException($zusaetzlicheGegenstandsdatenArrayErrorMessage, __LINE__);
        }
        $this->ZusaetzlicheGegenstandsdaten = $zusaetzlicheGegenstandsdaten;
        return $this;
    }
    /**
     * Add item to ZusaetzlicheGegenstandsdaten value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_ZusaetzlicheGegenstandsdaten $item
     * @return \BiPRO\StructType\CT_Gegenstand
     */
    public function addToZusaetzlicheGegenstandsdaten(\BiPRO\StructType\CT_ZusaetzlicheGegenstandsdaten $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_ZusaetzlicheGegenstandsdaten) {
            throw new \InvalidArgumentException(sprintf('The ZusaetzlicheGegenstandsdaten property can only contain items of type \BiPRO\StructType\CT_ZusaetzlicheGegenstandsdaten, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ZusaetzlicheGegenstandsdaten[] = $item;
        return $this;
    }
    /**
     * Get Beschreibung value
     * @return string|null
     */
    public function getBeschreibung()
    {
        return $this->Beschreibung;
    }
    /**
     * Set Beschreibung value
     * @param string $beschreibung
     * @return \BiPRO\StructType\CT_Gegenstand
     */
    public function setBeschreibung($beschreibung = null)
    {
        // validation for constraint: string
        if (!is_null($beschreibung) && !is_string($beschreibung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beschreibung, true), gettype($beschreibung)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($beschreibung) && mb_strlen($beschreibung) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($beschreibung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($beschreibung) && mb_strlen($beschreibung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($beschreibung)), __LINE__);
        }
        $this->Beschreibung = $beschreibung;
        return $this;
    }
    /**
     * Get Groesse value
     * @return \BiPRO\StructType\CT_Groesse|null
     */
    public function getGroesse()
    {
        return $this->Groesse;
    }
    /**
     * Set Groesse value
     * @param \BiPRO\StructType\CT_Groesse $groesse
     * @return \BiPRO\StructType\CT_Gegenstand
     */
    public function setGroesse(\BiPRO\StructType\CT_Groesse $groesse = null)
    {
        $this->Groesse = $groesse;
        return $this;
    }
    /**
     * Get Beinhaltet value
     * @return \BiPRO\StructType\CT_Beinhaltet[]|null
     */
    public function getBeinhaltet()
    {
        return $this->Beinhaltet;
    }
    /**
     * This method is responsible for validating the values passed to the setBeinhaltet method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBeinhaltet method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBeinhaltetForArrayConstraintsFromSetBeinhaltet(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_GegenstandBeinhaltetItem) {
            // validation for constraint: itemType
            if (!$cT_GegenstandBeinhaltetItem instanceof \BiPRO\StructType\CT_Beinhaltet) {
                $invalidValues[] = is_object($cT_GegenstandBeinhaltetItem) ? get_class($cT_GegenstandBeinhaltetItem) : sprintf('%s(%s)', gettype($cT_GegenstandBeinhaltetItem), var_export($cT_GegenstandBeinhaltetItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Beinhaltet property can only contain items of type \BiPRO\StructType\CT_Beinhaltet, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Beinhaltet value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Beinhaltet[] $beinhaltet
     * @return \BiPRO\StructType\CT_Gegenstand
     */
    public function setBeinhaltet(array $beinhaltet = array())
    {
        // validation for constraint: array
        if ('' !== ($beinhaltetArrayErrorMessage = self::validateBeinhaltetForArrayConstraintsFromSetBeinhaltet($beinhaltet))) {
            throw new \InvalidArgumentException($beinhaltetArrayErrorMessage, __LINE__);
        }
        $this->Beinhaltet = $beinhaltet;
        return $this;
    }
    /**
     * Add item to Beinhaltet value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Beinhaltet $item
     * @return \BiPRO\StructType\CT_Gegenstand
     */
    public function addToBeinhaltet(\BiPRO\StructType\CT_Beinhaltet $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Beinhaltet) {
            throw new \InvalidArgumentException(sprintf('The Beinhaltet property can only contain items of type \BiPRO\StructType\CT_Beinhaltet, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Beinhaltet[] = $item;
        return $this;
    }
}
