<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Fuehrerschein StructType
 * @subpackage Structs
 */
class CT_Fuehrerschein extends CT_Objekt
{
    /**
     * The Fuehrerscheinklasse
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Fuehrerscheinklasse;
    /**
     * The FuehrerscheinAusstellung
     * Meta information extracted from the WSDL
     * - documentation: nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $FuehrerscheinAusstellung;
    /**
     * The FuehrerscheinAusstellungsLand
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FuehrerscheinAusstellungsLand;
    /**
     * The EUFuehrerschein
     * Meta information extracted from the WSDL
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $EUFuehrerschein;
    /**
     * The Vorhanden
     * Meta information extracted from the WSDL
     * - documentation: JA = Es gibt eine gültige Fahrerlaubnis.NEIN = Es gibt keine gültige Fahrerlaubnis
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Vorhanden;
    /**
     * The EntzogenAm
     * Meta information extracted from the WSDL
     * - documentation: Datum, an dem der Führerschein entzogen wurde. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $EntzogenAm;
    /**
     * Constructor method for CT_Fuehrerschein
     * @uses CT_Fuehrerschein::setFuehrerscheinklasse()
     * @uses CT_Fuehrerschein::setFuehrerscheinAusstellung()
     * @uses CT_Fuehrerschein::setFuehrerscheinAusstellungsLand()
     * @uses CT_Fuehrerschein::setEUFuehrerschein()
     * @uses CT_Fuehrerschein::setVorhanden()
     * @uses CT_Fuehrerschein::setEntzogenAm()
     * @param string[] $fuehrerscheinklasse
     * @param string $fuehrerscheinAusstellung
     * @param string $fuehrerscheinAusstellungsLand
     * @param bool $eUFuehrerschein
     * @param bool $vorhanden
     * @param string $entzogenAm
     */
    public function __construct(array $fuehrerscheinklasse = array(), $fuehrerscheinAusstellung = null, $fuehrerscheinAusstellungsLand = null, $eUFuehrerschein = null, $vorhanden = null, $entzogenAm = null)
    {
        $this
            ->setFuehrerscheinklasse($fuehrerscheinklasse)
            ->setFuehrerscheinAusstellung($fuehrerscheinAusstellung)
            ->setFuehrerscheinAusstellungsLand($fuehrerscheinAusstellungsLand)
            ->setEUFuehrerschein($eUFuehrerschein)
            ->setVorhanden($vorhanden)
            ->setEntzogenAm($entzogenAm);
    }
    /**
     * Get Fuehrerscheinklasse value
     * @return string[]|null
     */
    public function getFuehrerscheinklasse()
    {
        return $this->Fuehrerscheinklasse;
    }
    /**
     * This method is responsible for validating the values passed to the setFuehrerscheinklasse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFuehrerscheinklasse method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFuehrerscheinklasseForArrayConstraintsFromSetFuehrerscheinklasse(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_FuehrerscheinFuehrerscheinklasseItem) {
            // validation for constraint: enumeration
            if (!\BiPRO\EnumType\ST_Fuehrerscheinklasse::valueIsValid($cT_FuehrerscheinFuehrerscheinklasseItem)) {
                $invalidValues[] = is_object($cT_FuehrerscheinFuehrerscheinklasseItem) ? get_class($cT_FuehrerscheinFuehrerscheinklasseItem) : sprintf('%s(%s)', gettype($cT_FuehrerscheinFuehrerscheinklasseItem), var_export($cT_FuehrerscheinFuehrerscheinklasseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Fuehrerscheinklasse', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \BiPRO\EnumType\ST_Fuehrerscheinklasse::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Fuehrerscheinklasse value
     * @uses \BiPRO\EnumType\ST_Fuehrerscheinklasse::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Fuehrerscheinklasse::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $fuehrerscheinklasse
     * @return \BiPRO\StructType\CT_Fuehrerschein
     */
    public function setFuehrerscheinklasse(array $fuehrerscheinklasse = array())
    {
        // validation for constraint: array
        if ('' !== ($fuehrerscheinklasseArrayErrorMessage = self::validateFuehrerscheinklasseForArrayConstraintsFromSetFuehrerscheinklasse($fuehrerscheinklasse))) {
            throw new \InvalidArgumentException($fuehrerscheinklasseArrayErrorMessage, __LINE__);
        }
        $this->Fuehrerscheinklasse = $fuehrerscheinklasse;
        return $this;
    }
    /**
     * Add item to Fuehrerscheinklasse value
     * @uses \BiPRO\EnumType\ST_Fuehrerscheinklasse::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Fuehrerscheinklasse::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \BiPRO\StructType\CT_Fuehrerschein
     */
    public function addToFuehrerscheinklasse($item)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Fuehrerscheinklasse::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Fuehrerscheinklasse', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \BiPRO\EnumType\ST_Fuehrerscheinklasse::getValidValues())), __LINE__);
        }
        $this->Fuehrerscheinklasse[] = $item;
        return $this;
    }
    /**
     * Get FuehrerscheinAusstellung value
     * @return string|null
     */
    public function getFuehrerscheinAusstellung()
    {
        return $this->FuehrerscheinAusstellung;
    }
    /**
     * Set FuehrerscheinAusstellung value
     * @param string $fuehrerscheinAusstellung
     * @return \BiPRO\StructType\CT_Fuehrerschein
     */
    public function setFuehrerscheinAusstellung($fuehrerscheinAusstellung = null)
    {
        // validation for constraint: string
        if (!is_null($fuehrerscheinAusstellung) && !is_string($fuehrerscheinAusstellung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fuehrerscheinAusstellung, true), gettype($fuehrerscheinAusstellung)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($fuehrerscheinAusstellung) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $fuehrerscheinAusstellung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($fuehrerscheinAusstellung, true)), __LINE__);
        }
        $this->FuehrerscheinAusstellung = $fuehrerscheinAusstellung;
        return $this;
    }
    /**
     * Get FuehrerscheinAusstellungsLand value
     * @return string|null
     */
    public function getFuehrerscheinAusstellungsLand()
    {
        return $this->FuehrerscheinAusstellungsLand;
    }
    /**
     * Set FuehrerscheinAusstellungsLand value
     * @uses \BiPRO\EnumType\ST_Laenderkennzeichen::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Laenderkennzeichen::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fuehrerscheinAusstellungsLand
     * @return \BiPRO\StructType\CT_Fuehrerschein
     */
    public function setFuehrerscheinAusstellungsLand($fuehrerscheinAusstellungsLand = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Laenderkennzeichen::valueIsValid($fuehrerscheinAusstellungsLand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Laenderkennzeichen', is_array($fuehrerscheinAusstellungsLand) ? implode(', ', $fuehrerscheinAusstellungsLand) : var_export($fuehrerscheinAusstellungsLand, true), implode(', ', \BiPRO\EnumType\ST_Laenderkennzeichen::getValidValues())), __LINE__);
        }
        $this->FuehrerscheinAusstellungsLand = $fuehrerscheinAusstellungsLand;
        return $this;
    }
    /**
     * Get EUFuehrerschein value
     * @return bool|null
     */
    public function getEUFuehrerschein()
    {
        return $this->EUFuehrerschein;
    }
    /**
     * Set EUFuehrerschein value
     * @param bool $eUFuehrerschein
     * @return \BiPRO\StructType\CT_Fuehrerschein
     */
    public function setEUFuehrerschein($eUFuehrerschein = null)
    {
        // validation for constraint: boolean
        if (!is_null($eUFuehrerschein) && !is_bool($eUFuehrerschein)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eUFuehrerschein, true), gettype($eUFuehrerschein)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($eUFuehrerschein) && !preg_match('/true|false/', $eUFuehrerschein)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($eUFuehrerschein, true)), __LINE__);
        }
        $this->EUFuehrerschein = $eUFuehrerschein;
        return $this;
    }
    /**
     * Get Vorhanden value
     * @return bool|null
     */
    public function getVorhanden()
    {
        return $this->Vorhanden;
    }
    /**
     * Set Vorhanden value
     * @param bool $vorhanden
     * @return \BiPRO\StructType\CT_Fuehrerschein
     */
    public function setVorhanden($vorhanden = null)
    {
        // validation for constraint: boolean
        if (!is_null($vorhanden) && !is_bool($vorhanden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vorhanden, true), gettype($vorhanden)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($vorhanden) && !preg_match('/true|false/', $vorhanden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($vorhanden, true)), __LINE__);
        }
        $this->Vorhanden = $vorhanden;
        return $this;
    }
    /**
     * Get EntzogenAm value
     * @return string|null
     */
    public function getEntzogenAm()
    {
        return $this->EntzogenAm;
    }
    /**
     * Set EntzogenAm value
     * @param string $entzogenAm
     * @return \BiPRO\StructType\CT_Fuehrerschein
     */
    public function setEntzogenAm($entzogenAm = null)
    {
        // validation for constraint: string
        if (!is_null($entzogenAm) && !is_string($entzogenAm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entzogenAm, true), gettype($entzogenAm)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($entzogenAm) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $entzogenAm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($entzogenAm, true)), __LINE__);
        }
        $this->EntzogenAm = $entzogenAm;
        return $this;
    }
}
