<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Fragenkomplex StructType
 * Meta information extracted from the WSDL
 * - documentation: Inhaltlich zusammenhängende Menge von Fragen und Gliederungselementen, z.B. &bdquo;Fragen zum Beruf&ldquo; oder &bdquo;Gesundheitsfragen&ldquo;. Welche Fragen wie zu Fragenkomplexen zusammengefasst werden, entscheidet der Provider
 * in seiner Fragenmodellierung. Z.B. kann ein Provider &bdquo;Fragen zum Beruf&ldquo; und &bdquo;Fragen zur Gesundheit&ldquo; in getrennten Fragenkomplexen liefern. Ein anderer Provider kann diese Fragen in einem Fragenkomplex &bdquo;Fragen zum
 * Antrag&ldquo; liefern.Ein Fragenkomplex enthält immer alle für den jeweiligen Context relevanten Fragen. D.h. auch, wenn ein Provider sukzessive Folgefragen abhängig von den gegebenen Antworten nachliefert ("Ping Pong"), enthält der Fragenkomplex
 * immer alle zu diesem Zeitpunkt als relevant erkannten Fragen, d.h. es erfolgt immer eine Volllieferung der Fragen, keine Delta-Lieferung zusätzlicher Fragen.
 * @subpackage Structs
 */
class CT_Fragenkomplex extends CT_Objekt
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Maschinell auswertbare Identifikation der Semantik des Fragenkomplexes. Der Consumer benötigt diese Information, um die gelieferten Fragenkomplexe den Controls im Frontend zuzuordnen, z.B. wenn &bdquo;Fragen zum Beruf&ldquo; und
     * &bdquo;Fragen zur Gesundheit&ldquo; in verschiedenen Fragenkomplexen geliefert werden.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \BiPRO\StructType\STE_FragenkomplexArt
     */
    public $ArtID;
    /**
     * The Bezeichnung
     * Meta information extracted from the WSDL
     * - documentation: Hier wird der Gegenstand des Fragenkomplexes in natürlicher Frage beschrieben, z.B. "Fragen zum Antrag" oder "Fragen zum Beruf". Der Consumer kann diese Information zur Anzeige im Frontend nutzen.
     * - base: xsd:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $Bezeichnung;
    /**
     * The Element
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \BiPRO\StructType\CT_Element[]
     */
    public $Element;
    /**
     * Constructor method for CT_Fragenkomplex
     * @uses CT_Fragenkomplex::setArtID()
     * @uses CT_Fragenkomplex::setBezeichnung()
     * @uses CT_Fragenkomplex::setElement()
     * @param \BiPRO\StructType\STE_FragenkomplexArt $artID
     * @param string $bezeichnung
     * @param \BiPRO\StructType\CT_Element[] $element
     */
    public function __construct(\BiPRO\StructType\STE_FragenkomplexArt $artID = null, $bezeichnung = null, array $element = array())
    {
        $this
            ->setArtID($artID)
            ->setBezeichnung($bezeichnung)
            ->setElement($element);
    }
    /**
     * Get ArtID value
     * @return \BiPRO\StructType\STE_FragenkomplexArt
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @param \BiPRO\StructType\STE_FragenkomplexArt $artID
     * @return \BiPRO\StructType\CT_Fragenkomplex
     */
    public function setArtID(\BiPRO\StructType\STE_FragenkomplexArt $artID = null)
    {
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Bezeichnung value
     * @return string
     */
    public function getBezeichnung()
    {
        return $this->Bezeichnung;
    }
    /**
     * Set Bezeichnung value
     * @param string $bezeichnung
     * @return \BiPRO\StructType\CT_Fragenkomplex
     */
    public function setBezeichnung($bezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($bezeichnung) && !is_string($bezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bezeichnung, true), gettype($bezeichnung)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($bezeichnung) && mb_strlen($bezeichnung) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($bezeichnung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($bezeichnung) && mb_strlen($bezeichnung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($bezeichnung)), __LINE__);
        }
        $this->Bezeichnung = $bezeichnung;
        return $this;
    }
    /**
     * Get Element value
     * @return \BiPRO\StructType\CT_Element[]
     */
    public function getElement()
    {
        return $this->Element;
    }
    /**
     * This method is responsible for validating the values passed to the setElement method
     * This method is willingly generated in order to preserve the one-line inline validation within the setElement method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateElementForArrayConstraintsFromSetElement(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_FragenkomplexElementItem) {
            // validation for constraint: itemType
            if (!$cT_FragenkomplexElementItem instanceof \BiPRO\StructType\CT_Element) {
                $invalidValues[] = is_object($cT_FragenkomplexElementItem) ? get_class($cT_FragenkomplexElementItem) : sprintf('%s(%s)', gettype($cT_FragenkomplexElementItem), var_export($cT_FragenkomplexElementItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Element property can only contain items of type \BiPRO\StructType\CT_Element, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Element value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Element[] $element
     * @return \BiPRO\StructType\CT_Fragenkomplex
     */
    public function setElement(array $element = array())
    {
        // validation for constraint: array
        if ('' !== ($elementArrayErrorMessage = self::validateElementForArrayConstraintsFromSetElement($element))) {
            throw new \InvalidArgumentException($elementArrayErrorMessage, __LINE__);
        }
        $this->Element = $element;
        return $this;
    }
    /**
     * Add item to Element value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Element $item
     * @return \BiPRO\StructType\CT_Fragenkomplex
     */
    public function addToElement(\BiPRO\StructType\CT_Element $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Element) {
            throw new \InvalidArgumentException(sprintf('The Element property can only contain items of type \BiPRO\StructType\CT_Element, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Element[] = $item;
        return $this;
    }
}
