<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_FrageWerteliste StructType
 * Meta information extracted from the WSDL
 * - documentation: Frage, die mit der Auswahl EINES Wertes aus einer Werteliste beantwortet wird (Single-Selection-Listbox
 * @subpackage Structs
 */
class CT_FrageWerteliste extends CT_EinfacheFrage
{
    /**
     * The MoeglicherWert
     * Meta information extracted from the WSDL
     * - documentation: Übermittlung der Auswahlmöglichkeiten.
     * - base: xsd:string
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $MoeglicherWert;
    /**
     * The MehrfachAntwortErlaubt
     * Meta information extracted from the WSDL
     * - documentation: Steuert ob bei der Beantwortung der Frage mehrere Werte der Liste &bdquo;MöglicherWert&ldquo; gewählt werden dürfen oder nur ein Wert akzeptiert wird. Wird das Attribut nicht gefüllt, ist es als mit &bdquo;false&ldquo; belegt zu
     * interpretieren.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $MehrfachAntwortErlaubt;
    /**
     * The AntwortWerteliste
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_AntwortWerteliste
     */
    public $AntwortWerteliste;
    /**
     * Constructor method for CT_FrageWerteliste
     * @uses CT_FrageWerteliste::setMoeglicherWert()
     * @uses CT_FrageWerteliste::setMehrfachAntwortErlaubt()
     * @uses CT_FrageWerteliste::setAntwortWerteliste()
     * @param string[] $moeglicherWert
     * @param bool $mehrfachAntwortErlaubt
     * @param \BiPRO\StructType\CT_AntwortWerteliste $antwortWerteliste
     */
    public function __construct(array $moeglicherWert = array(), $mehrfachAntwortErlaubt = null, \BiPRO\StructType\CT_AntwortWerteliste $antwortWerteliste = null)
    {
        $this
            ->setMoeglicherWert($moeglicherWert)
            ->setMehrfachAntwortErlaubt($mehrfachAntwortErlaubt)
            ->setAntwortWerteliste($antwortWerteliste);
    }
    /**
     * Get MoeglicherWert value
     * @return string[]
     */
    public function getMoeglicherWert()
    {
        return $this->MoeglicherWert;
    }
    /**
     * This method is responsible for validating the values passed to the setMoeglicherWert method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMoeglicherWert method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMoeglicherWertForArrayConstraintsFromSetMoeglicherWert(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_FrageWertelisteMoeglicherWertItem) {
            // validation for constraint: itemType
            if (!is_string($cT_FrageWertelisteMoeglicherWertItem)) {
                $invalidValues[] = is_object($cT_FrageWertelisteMoeglicherWertItem) ? get_class($cT_FrageWertelisteMoeglicherWertItem) : sprintf('%s(%s)', gettype($cT_FrageWertelisteMoeglicherWertItem), var_export($cT_FrageWertelisteMoeglicherWertItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MoeglicherWert property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MoeglicherWert value
     * @throws \InvalidArgumentException
     * @param string[] $moeglicherWert
     * @return \BiPRO\StructType\CT_FrageWerteliste
     */
    public function setMoeglicherWert(array $moeglicherWert = array())
    {
        // validation for constraint: array
        if ('' !== ($moeglicherWertArrayErrorMessage = self::validateMoeglicherWertForArrayConstraintsFromSetMoeglicherWert($moeglicherWert))) {
            throw new \InvalidArgumentException($moeglicherWertArrayErrorMessage, __LINE__);
        }
        $this->MoeglicherWert = $moeglicherWert;
        return $this;
    }
    /**
     * Add item to MoeglicherWert value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \BiPRO\StructType\CT_FrageWerteliste
     */
    public function addToMoeglicherWert($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The MoeglicherWert property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MoeglicherWert[] = $item;
        return $this;
    }
    /**
     * Get MehrfachAntwortErlaubt value
     * @return bool|null
     */
    public function getMehrfachAntwortErlaubt()
    {
        return $this->MehrfachAntwortErlaubt;
    }
    /**
     * Set MehrfachAntwortErlaubt value
     * @param bool $mehrfachAntwortErlaubt
     * @return \BiPRO\StructType\CT_FrageWerteliste
     */
    public function setMehrfachAntwortErlaubt($mehrfachAntwortErlaubt = null)
    {
        // validation for constraint: boolean
        if (!is_null($mehrfachAntwortErlaubt) && !is_bool($mehrfachAntwortErlaubt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mehrfachAntwortErlaubt, true), gettype($mehrfachAntwortErlaubt)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($mehrfachAntwortErlaubt) && !preg_match('/true|false/', $mehrfachAntwortErlaubt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($mehrfachAntwortErlaubt, true)), __LINE__);
        }
        $this->MehrfachAntwortErlaubt = $mehrfachAntwortErlaubt;
        return $this;
    }
    /**
     * Get AntwortWerteliste value
     * @return \BiPRO\StructType\CT_AntwortWerteliste|null
     */
    public function getAntwortWerteliste()
    {
        return $this->AntwortWerteliste;
    }
    /**
     * Set AntwortWerteliste value
     * @param \BiPRO\StructType\CT_AntwortWerteliste $antwortWerteliste
     * @return \BiPRO\StructType\CT_FrageWerteliste
     */
    public function setAntwortWerteliste(\BiPRO\StructType\CT_AntwortWerteliste $antwortWerteliste = null)
    {
        $this->AntwortWerteliste = $antwortWerteliste;
        return $this;
    }
}
