<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Frage StructType
 * Meta information extracted from the WSDL
 * - documentation: Eine Frage ist ein zu beantwortendes Element. Es gibt mehrere Arten von Fragen, daher ist diese Klasse abstrakt modelliert. Die tatsächlich möglichen Arten von Fragen ergeben sich aus den abgeleiteten Klassen. Erläuterung siehe
 * dort.
 * @subpackage Structs
 */
abstract class CT_Frage extends CT_Element
{
    /**
     * The Erlaeuterung
     * Meta information extracted from the WSDL
     * - documentation: Optionale Angabe eines Erläuterungstextes zur Frage. Erläuterungstexte liefern ergänzende Informationen, die den Consumer bei der korrekten und vollständigen Beantwortung der Fragen unterstützen sollen. Dies ist insbesondere
     * dann sinnvoll, wenn die Fragen aus Gründen der juristischen eindeutigkeit so formuliert sind, dass ihre intuitive Erfassung möglicherweise schwer fällt. Beispiel: Frage: Üben Sie derzeit ein Hobby mit erhöhter Unfallgefährdung oder
     * Verletzungsgefahr aus? Erläuterungstext: Dazu zählen insbesonderen Tauchen, Kampfsport, Flugsport, Motorsport, Fallschirmspringen und Bergsport.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Erlaeuterung;
    /**
     * The Optional
     * Meta information extracted from the WSDL
     * - documentation: Eine als optional markierte Frage MUSS NICHT beantwortet werden.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Optional;
    /**
     * The Bedingung
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Bedingung
     */
    public $Bedingung;
    /**
     * The Wiederholbar
     * Meta information extracted from the WSDL
     * - documentation: Kennzeichnet, ob eine Frage mehrfach beantwortet werden DARF. Ist das Attribut mit 'true' belegt, DARF der Consumer die Frage im Response mehrfach zurückliefern und so mehrfach beantworten. Beispiel: Die Frage nach Krankheiten in
     * den vergangenen 5 Jahren muss vom Provider nur einmal gestellt werden, darf jedoch n-mal beantwortet werden.Ist das Feld nicht belegt, MUSS es als mit 'false' belegt interpretiert werden. Eine mehrfache Beantwortung ist dann also nicht erlaubt.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Wiederholbar;
    /**
     * The MaxAntworten
     * Meta information extracted from the WSDL
     * - documentation: Dieses Attribut DARF NUR belegt werden, WENN Wiederholbar = true. Es legt die maximal erlaubte Zahl der Wiederholungen fest.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $MaxAntworten;
    /**
     * Constructor method for CT_Frage
     * @uses CT_Frage::setErlaeuterung()
     * @uses CT_Frage::setOptional()
     * @uses CT_Frage::setBedingung()
     * @uses CT_Frage::setWiederholbar()
     * @uses CT_Frage::setMaxAntworten()
     * @param string $erlaeuterung
     * @param bool $optional
     * @param \BiPRO\StructType\CT_Bedingung $bedingung
     * @param bool $wiederholbar
     * @param int $maxAntworten
     */
    public function __construct($erlaeuterung = null, $optional = null, \BiPRO\StructType\CT_Bedingung $bedingung = null, $wiederholbar = null, $maxAntworten = null)
    {
        $this
            ->setErlaeuterung($erlaeuterung)
            ->setOptional($optional)
            ->setBedingung($bedingung)
            ->setWiederholbar($wiederholbar)
            ->setMaxAntworten($maxAntworten);
    }
    /**
     * Get Erlaeuterung value
     * @return string|null
     */
    public function getErlaeuterung()
    {
        return $this->Erlaeuterung;
    }
    /**
     * Set Erlaeuterung value
     * @param string $erlaeuterung
     * @return \BiPRO\StructType\CT_Frage
     */
    public function setErlaeuterung($erlaeuterung = null)
    {
        // validation for constraint: string
        if (!is_null($erlaeuterung) && !is_string($erlaeuterung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($erlaeuterung, true), gettype($erlaeuterung)), __LINE__);
        }
        $this->Erlaeuterung = $erlaeuterung;
        return $this;
    }
    /**
     * Get Optional value
     * @return bool|null
     */
    public function getOptional()
    {
        return $this->Optional;
    }
    /**
     * Set Optional value
     * @param bool $optional
     * @return \BiPRO\StructType\CT_Frage
     */
    public function setOptional($optional = null)
    {
        // validation for constraint: boolean
        if (!is_null($optional) && !is_bool($optional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optional, true), gettype($optional)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($optional) && !preg_match('/true|false/', $optional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($optional, true)), __LINE__);
        }
        $this->Optional = $optional;
        return $this;
    }
    /**
     * Get Bedingung value
     * @return \BiPRO\StructType\CT_Bedingung|null
     */
    public function getBedingung()
    {
        return $this->Bedingung;
    }
    /**
     * Set Bedingung value
     * @param \BiPRO\StructType\CT_Bedingung $bedingung
     * @return \BiPRO\StructType\CT_Frage
     */
    public function setBedingung(\BiPRO\StructType\CT_Bedingung $bedingung = null)
    {
        $this->Bedingung = $bedingung;
        return $this;
    }
    /**
     * Get Wiederholbar value
     * @return bool|null
     */
    public function getWiederholbar()
    {
        return $this->Wiederholbar;
    }
    /**
     * Set Wiederholbar value
     * @param bool $wiederholbar
     * @return \BiPRO\StructType\CT_Frage
     */
    public function setWiederholbar($wiederholbar = null)
    {
        // validation for constraint: boolean
        if (!is_null($wiederholbar) && !is_bool($wiederholbar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($wiederholbar, true), gettype($wiederholbar)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($wiederholbar) && !preg_match('/true|false/', $wiederholbar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($wiederholbar, true)), __LINE__);
        }
        $this->Wiederholbar = $wiederholbar;
        return $this;
    }
    /**
     * Get MaxAntworten value
     * @return int|null
     */
    public function getMaxAntworten()
    {
        return $this->MaxAntworten;
    }
    /**
     * Set MaxAntworten value
     * @param int $maxAntworten
     * @return \BiPRO\StructType\CT_Frage
     */
    public function setMaxAntworten($maxAntworten = null)
    {
        // validation for constraint: int
        if (!is_null($maxAntworten) && !(is_int($maxAntworten) || ctype_digit($maxAntworten))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAntworten, true), gettype($maxAntworten)), __LINE__);
        }
        $this->MaxAntworten = $maxAntworten;
        return $this;
    }
}
