<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_FondsPortfolio StructType
 * Meta information extracted from the WSDL
 * - documentation: Das Fonds-Portfolio einer fondsgebundenen Versicherung
 * @subpackage Structs
 */
class CT_FondsPortfolio extends CT_Objekt
{
    /**
     * The Portfoliobezeichnung
     * Meta information extracted from the WSDL
     * - documentation: VU-individuelle Beschreibung des Portfolios
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_Portfoliobezeichnung
     */
    public $Portfoliobezeichnung;
    /**
     * The Portfoliomanagement
     * Meta information extracted from the WSDL
     * - documentation: VU-individuelles Kennzeichen für ein Management des Portfolios
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_Portfoliomanagement
     */
    public $Portfoliomanagement;
    /**
     * The Beitragsgarantie
     * Meta information extracted from the WSDL
     * - documentation: Die Beitragsgarantie als Faktor (Werte: 0.0 bis 1.0)
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Beitragsgarantie;
    /**
     * The Phase
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phase;
    /**
     * The Hoechststandsicherung
     * Meta information extracted from the WSDL
     * - documentation: Zulässiger Wertebereich 0%..100% | Prozentanteil ohne Prozentzeichen z.B. 50 = 50% oder 12,5 = 12,5%
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * @var float
     */
    public $Hoechststandsicherung;
    /**
     * The FondsAnteil
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_FondsAnteil[]
     */
    public $FondsAnteil;
    /**
     * Constructor method for CT_FondsPortfolio
     * @uses CT_FondsPortfolio::setPortfoliobezeichnung()
     * @uses CT_FondsPortfolio::setPortfoliomanagement()
     * @uses CT_FondsPortfolio::setBeitragsgarantie()
     * @uses CT_FondsPortfolio::setPhase()
     * @uses CT_FondsPortfolio::setHoechststandsicherung()
     * @uses CT_FondsPortfolio::setFondsAnteil()
     * @param \BiPRO\StructType\STE_Portfoliobezeichnung $portfoliobezeichnung
     * @param \BiPRO\StructType\STE_Portfoliomanagement $portfoliomanagement
     * @param float $beitragsgarantie
     * @param string $phase
     * @param float $hoechststandsicherung
     * @param \BiPRO\StructType\CT_FondsAnteil[] $fondsAnteil
     */
    public function __construct(\BiPRO\StructType\STE_Portfoliobezeichnung $portfoliobezeichnung = null, \BiPRO\StructType\STE_Portfoliomanagement $portfoliomanagement = null, $beitragsgarantie = null, $phase = null, $hoechststandsicherung = null, array $fondsAnteil = array())
    {
        $this
            ->setPortfoliobezeichnung($portfoliobezeichnung)
            ->setPortfoliomanagement($portfoliomanagement)
            ->setBeitragsgarantie($beitragsgarantie)
            ->setPhase($phase)
            ->setHoechststandsicherung($hoechststandsicherung)
            ->setFondsAnteil($fondsAnteil);
    }
    /**
     * Get Portfoliobezeichnung value
     * @return \BiPRO\StructType\STE_Portfoliobezeichnung|null
     */
    public function getPortfoliobezeichnung()
    {
        return $this->Portfoliobezeichnung;
    }
    /**
     * Set Portfoliobezeichnung value
     * @param \BiPRO\StructType\STE_Portfoliobezeichnung $portfoliobezeichnung
     * @return \BiPRO\StructType\CT_FondsPortfolio
     */
    public function setPortfoliobezeichnung(\BiPRO\StructType\STE_Portfoliobezeichnung $portfoliobezeichnung = null)
    {
        $this->Portfoliobezeichnung = $portfoliobezeichnung;
        return $this;
    }
    /**
     * Get Portfoliomanagement value
     * @return \BiPRO\StructType\STE_Portfoliomanagement|null
     */
    public function getPortfoliomanagement()
    {
        return $this->Portfoliomanagement;
    }
    /**
     * Set Portfoliomanagement value
     * @param \BiPRO\StructType\STE_Portfoliomanagement $portfoliomanagement
     * @return \BiPRO\StructType\CT_FondsPortfolio
     */
    public function setPortfoliomanagement(\BiPRO\StructType\STE_Portfoliomanagement $portfoliomanagement = null)
    {
        $this->Portfoliomanagement = $portfoliomanagement;
        return $this;
    }
    /**
     * Get Beitragsgarantie value
     * @return float|null
     */
    public function getBeitragsgarantie()
    {
        return $this->Beitragsgarantie;
    }
    /**
     * Set Beitragsgarantie value
     * @param float $beitragsgarantie
     * @return \BiPRO\StructType\CT_FondsPortfolio
     */
    public function setBeitragsgarantie($beitragsgarantie = null)
    {
        // validation for constraint: float
        if (!is_null($beitragsgarantie) && !(is_float($beitragsgarantie) || is_numeric($beitragsgarantie))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($beitragsgarantie, true), gettype($beitragsgarantie)), __LINE__);
        }
        $this->Beitragsgarantie = $beitragsgarantie;
        return $this;
    }
    /**
     * Get Phase value
     * @return string|null
     */
    public function getPhase()
    {
        return $this->Phase;
    }
    /**
     * Set Phase value
     * @uses \BiPRO\EnumType\ST_Phase::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Phase::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phase
     * @return \BiPRO\StructType\CT_FondsPortfolio
     */
    public function setPhase($phase = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Phase::valueIsValid($phase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Phase', is_array($phase) ? implode(', ', $phase) : var_export($phase, true), implode(', ', \BiPRO\EnumType\ST_Phase::getValidValues())), __LINE__);
        }
        $this->Phase = $phase;
        return $this;
    }
    /**
     * Get Hoechststandsicherung value
     * @return float|null
     */
    public function getHoechststandsicherung()
    {
        return $this->Hoechststandsicherung;
    }
    /**
     * Set Hoechststandsicherung value
     * @param float $hoechststandsicherung
     * @return \BiPRO\StructType\CT_FondsPortfolio
     */
    public function setHoechststandsicherung($hoechststandsicherung = null)
    {
        // validation for constraint: float
        if (!is_null($hoechststandsicherung) && !(is_float($hoechststandsicherung) || is_numeric($hoechststandsicherung))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($hoechststandsicherung, true), gettype($hoechststandsicherung)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($hoechststandsicherung) && $hoechststandsicherung < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($hoechststandsicherung, true)), __LINE__);
        }
        $this->Hoechststandsicherung = $hoechststandsicherung;
        return $this;
    }
    /**
     * Get FondsAnteil value
     * @return \BiPRO\StructType\CT_FondsAnteil[]|null
     */
    public function getFondsAnteil()
    {
        return $this->FondsAnteil;
    }
    /**
     * This method is responsible for validating the values passed to the setFondsAnteil method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFondsAnteil method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFondsAnteilForArrayConstraintsFromSetFondsAnteil(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_FondsPortfolioFondsAnteilItem) {
            // validation for constraint: itemType
            if (!$cT_FondsPortfolioFondsAnteilItem instanceof \BiPRO\StructType\CT_FondsAnteil) {
                $invalidValues[] = is_object($cT_FondsPortfolioFondsAnteilItem) ? get_class($cT_FondsPortfolioFondsAnteilItem) : sprintf('%s(%s)', gettype($cT_FondsPortfolioFondsAnteilItem), var_export($cT_FondsPortfolioFondsAnteilItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FondsAnteil property can only contain items of type \BiPRO\StructType\CT_FondsAnteil, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FondsAnteil value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_FondsAnteil[] $fondsAnteil
     * @return \BiPRO\StructType\CT_FondsPortfolio
     */
    public function setFondsAnteil(array $fondsAnteil = array())
    {
        // validation for constraint: array
        if ('' !== ($fondsAnteilArrayErrorMessage = self::validateFondsAnteilForArrayConstraintsFromSetFondsAnteil($fondsAnteil))) {
            throw new \InvalidArgumentException($fondsAnteilArrayErrorMessage, __LINE__);
        }
        $this->FondsAnteil = $fondsAnteil;
        return $this;
    }
    /**
     * Add item to FondsAnteil value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_FondsAnteil $item
     * @return \BiPRO\StructType\CT_FondsPortfolio
     */
    public function addToFondsAnteil(\BiPRO\StructType\CT_FondsAnteil $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_FondsAnteil) {
            throw new \InvalidArgumentException(sprintf('The FondsAnteil property can only contain items of type \BiPRO\StructType\CT_FondsAnteil, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FondsAnteil[] = $item;
        return $this;
    }
}
