<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Fahrzeugvollversicherung StructType
 * @subpackage Structs
 */
class CT_Fahrzeugvollversicherung extends CT_Elementarprodukt
{
    /**
     * The SelbstbeteiligungKFV
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_SelbstbeteiligungKfz
     */
    public $SelbstbeteiligungKFV;
    /**
     * The SelbstbeteiligungKFT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_SelbstbeteiligungKfz
     */
    public $SelbstbeteiligungKFT;
    /**
     * The SFKlasse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_SFKlasseKFV
     */
    public $SFKlasse;
    /**
     * The SFEinstufungsgrund
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_SFEinstufungsgrund
     */
    public $SFEinstufungsgrund;
    /**
     * The Rabattgrundjahr
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 4
     * @var int
     */
    public $Rabattgrundjahr;
    /**
     * The SchadenfreieJahre
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $SchadenfreieJahre;
    /**
     * The Beitragssatz
     * Meta information extracted from the WSDL
     * - documentation: Prozentanteil ohne Prozentzeichen z.B. 50 = 50% oder 12,5 = 12,5%
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * @var float
     */
    public $Beitragssatz;
    /**
     * The Typklasse
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Typklasse;
    /**
     * The Regionalklasse
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 5
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Regionalklasse;
    /**
     * The SchaedenAusRueckstufung
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der Schäden aus Vorjahr relevant für die Rückstufung
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $SchaedenAusRueckstufung;
    /**
     * The SFKlasseIntern
     * Meta information extracted from the WSDL
     * - documentation: Abweichende SF-Klasse / SFR intern geführt, relevant für den Versicherungsschein und die Beitragsrechnung
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_SFKlasseKFV
     */
    public $SFKlasseIntern;
    /**
     * Constructor method for CT_Fahrzeugvollversicherung
     * @uses CT_Fahrzeugvollversicherung::setSelbstbeteiligungKFV()
     * @uses CT_Fahrzeugvollversicherung::setSelbstbeteiligungKFT()
     * @uses CT_Fahrzeugvollversicherung::setSFKlasse()
     * @uses CT_Fahrzeugvollversicherung::setSFEinstufungsgrund()
     * @uses CT_Fahrzeugvollversicherung::setRabattgrundjahr()
     * @uses CT_Fahrzeugvollversicherung::setSchadenfreieJahre()
     * @uses CT_Fahrzeugvollversicherung::setBeitragssatz()
     * @uses CT_Fahrzeugvollversicherung::setTypklasse()
     * @uses CT_Fahrzeugvollversicherung::setRegionalklasse()
     * @uses CT_Fahrzeugvollversicherung::setSchaedenAusRueckstufung()
     * @uses CT_Fahrzeugvollversicherung::setSFKlasseIntern()
     * @param \BiPRO\StructType\STE_SelbstbeteiligungKfz $selbstbeteiligungKFV
     * @param \BiPRO\StructType\STE_SelbstbeteiligungKfz $selbstbeteiligungKFT
     * @param \BiPRO\StructType\STE_SFKlasseKFV $sFKlasse
     * @param \BiPRO\StructType\STE_SFEinstufungsgrund $sFEinstufungsgrund
     * @param int $rabattgrundjahr
     * @param int $schadenfreieJahre
     * @param float $beitragssatz
     * @param int $typklasse
     * @param string $regionalklasse
     * @param int $schaedenAusRueckstufung
     * @param \BiPRO\StructType\STE_SFKlasseKFV $sFKlasseIntern
     */
    public function __construct(\BiPRO\StructType\STE_SelbstbeteiligungKfz $selbstbeteiligungKFV = null, \BiPRO\StructType\STE_SelbstbeteiligungKfz $selbstbeteiligungKFT = null, \BiPRO\StructType\STE_SFKlasseKFV $sFKlasse = null, \BiPRO\StructType\STE_SFEinstufungsgrund $sFEinstufungsgrund = null, $rabattgrundjahr = null, $schadenfreieJahre = null, $beitragssatz = null, $typklasse = null, $regionalklasse = null, $schaedenAusRueckstufung = null, \BiPRO\StructType\STE_SFKlasseKFV $sFKlasseIntern = null)
    {
        $this
            ->setSelbstbeteiligungKFV($selbstbeteiligungKFV)
            ->setSelbstbeteiligungKFT($selbstbeteiligungKFT)
            ->setSFKlasse($sFKlasse)
            ->setSFEinstufungsgrund($sFEinstufungsgrund)
            ->setRabattgrundjahr($rabattgrundjahr)
            ->setSchadenfreieJahre($schadenfreieJahre)
            ->setBeitragssatz($beitragssatz)
            ->setTypklasse($typklasse)
            ->setRegionalklasse($regionalklasse)
            ->setSchaedenAusRueckstufung($schaedenAusRueckstufung)
            ->setSFKlasseIntern($sFKlasseIntern);
    }
    /**
     * Get SelbstbeteiligungKFV value
     * @return \BiPRO\StructType\STE_SelbstbeteiligungKfz|null
     */
    public function getSelbstbeteiligungKFV()
    {
        return $this->SelbstbeteiligungKFV;
    }
    /**
     * Set SelbstbeteiligungKFV value
     * @param \BiPRO\StructType\STE_SelbstbeteiligungKfz $selbstbeteiligungKFV
     * @return \BiPRO\StructType\CT_Fahrzeugvollversicherung
     */
    public function setSelbstbeteiligungKFV(\BiPRO\StructType\STE_SelbstbeteiligungKfz $selbstbeteiligungKFV = null)
    {
        $this->SelbstbeteiligungKFV = $selbstbeteiligungKFV;
        return $this;
    }
    /**
     * Get SelbstbeteiligungKFT value
     * @return \BiPRO\StructType\STE_SelbstbeteiligungKfz|null
     */
    public function getSelbstbeteiligungKFT()
    {
        return $this->SelbstbeteiligungKFT;
    }
    /**
     * Set SelbstbeteiligungKFT value
     * @param \BiPRO\StructType\STE_SelbstbeteiligungKfz $selbstbeteiligungKFT
     * @return \BiPRO\StructType\CT_Fahrzeugvollversicherung
     */
    public function setSelbstbeteiligungKFT(\BiPRO\StructType\STE_SelbstbeteiligungKfz $selbstbeteiligungKFT = null)
    {
        $this->SelbstbeteiligungKFT = $selbstbeteiligungKFT;
        return $this;
    }
    /**
     * Get SFKlasse value
     * @return \BiPRO\StructType\STE_SFKlasseKFV|null
     */
    public function getSFKlasse()
    {
        return $this->SFKlasse;
    }
    /**
     * Set SFKlasse value
     * @param \BiPRO\StructType\STE_SFKlasseKFV $sFKlasse
     * @return \BiPRO\StructType\CT_Fahrzeugvollversicherung
     */
    public function setSFKlasse(\BiPRO\StructType\STE_SFKlasseKFV $sFKlasse = null)
    {
        $this->SFKlasse = $sFKlasse;
        return $this;
    }
    /**
     * Get SFEinstufungsgrund value
     * @return \BiPRO\StructType\STE_SFEinstufungsgrund|null
     */
    public function getSFEinstufungsgrund()
    {
        return $this->SFEinstufungsgrund;
    }
    /**
     * Set SFEinstufungsgrund value
     * @param \BiPRO\StructType\STE_SFEinstufungsgrund $sFEinstufungsgrund
     * @return \BiPRO\StructType\CT_Fahrzeugvollversicherung
     */
    public function setSFEinstufungsgrund(\BiPRO\StructType\STE_SFEinstufungsgrund $sFEinstufungsgrund = null)
    {
        $this->SFEinstufungsgrund = $sFEinstufungsgrund;
        return $this;
    }
    /**
     * Get Rabattgrundjahr value
     * @return int|null
     */
    public function getRabattgrundjahr()
    {
        return $this->Rabattgrundjahr;
    }
    /**
     * Set Rabattgrundjahr value
     * @param int $rabattgrundjahr
     * @return \BiPRO\StructType\CT_Fahrzeugvollversicherung
     */
    public function setRabattgrundjahr($rabattgrundjahr = null)
    {
        // validation for constraint: int
        if (!is_null($rabattgrundjahr) && !(is_int($rabattgrundjahr) || ctype_digit($rabattgrundjahr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rabattgrundjahr, true), gettype($rabattgrundjahr)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($rabattgrundjahr) && mb_strlen(preg_replace('/(\D)/', '', $rabattgrundjahr)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($rabattgrundjahr, true), mb_strlen(preg_replace('/(\D)/', '', $rabattgrundjahr))), __LINE__);
        }
        $this->Rabattgrundjahr = $rabattgrundjahr;
        return $this;
    }
    /**
     * Get SchadenfreieJahre value
     * @return int|null
     */
    public function getSchadenfreieJahre()
    {
        return $this->SchadenfreieJahre;
    }
    /**
     * Set SchadenfreieJahre value
     * @param int $schadenfreieJahre
     * @return \BiPRO\StructType\CT_Fahrzeugvollversicherung
     */
    public function setSchadenfreieJahre($schadenfreieJahre = null)
    {
        // validation for constraint: int
        if (!is_null($schadenfreieJahre) && !(is_int($schadenfreieJahre) || ctype_digit($schadenfreieJahre))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($schadenfreieJahre, true), gettype($schadenfreieJahre)), __LINE__);
        }
        $this->SchadenfreieJahre = $schadenfreieJahre;
        return $this;
    }
    /**
     * Get Beitragssatz value
     * @return float|null
     */
    public function getBeitragssatz()
    {
        return $this->Beitragssatz;
    }
    /**
     * Set Beitragssatz value
     * @param float $beitragssatz
     * @return \BiPRO\StructType\CT_Fahrzeugvollversicherung
     */
    public function setBeitragssatz($beitragssatz = null)
    {
        // validation for constraint: float
        if (!is_null($beitragssatz) && !(is_float($beitragssatz) || is_numeric($beitragssatz))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($beitragssatz, true), gettype($beitragssatz)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($beitragssatz) && $beitragssatz < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($beitragssatz, true)), __LINE__);
        }
        $this->Beitragssatz = $beitragssatz;
        return $this;
    }
    /**
     * Get Typklasse value
     * @return int|null
     */
    public function getTypklasse()
    {
        return $this->Typklasse;
    }
    /**
     * Set Typklasse value
     * @param int $typklasse
     * @return \BiPRO\StructType\CT_Fahrzeugvollversicherung
     */
    public function setTypklasse($typklasse = null)
    {
        // validation for constraint: int
        if (!is_null($typklasse) && !(is_int($typklasse) || ctype_digit($typklasse))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($typklasse, true), gettype($typklasse)), __LINE__);
        }
        $this->Typklasse = $typklasse;
        return $this;
    }
    /**
     * Get Regionalklasse value
     * @return string|null
     */
    public function getRegionalklasse()
    {
        return $this->Regionalklasse;
    }
    /**
     * Set Regionalklasse value
     * @param string $regionalklasse
     * @return \BiPRO\StructType\CT_Fahrzeugvollversicherung
     */
    public function setRegionalklasse($regionalklasse = null)
    {
        // validation for constraint: string
        if (!is_null($regionalklasse) && !is_string($regionalklasse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regionalklasse, true), gettype($regionalklasse)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($regionalklasse) && mb_strlen($regionalklasse) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($regionalklasse)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($regionalklasse) && mb_strlen($regionalklasse) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($regionalklasse)), __LINE__);
        }
        $this->Regionalklasse = $regionalklasse;
        return $this;
    }
    /**
     * Get SchaedenAusRueckstufung value
     * @return int|null
     */
    public function getSchaedenAusRueckstufung()
    {
        return $this->SchaedenAusRueckstufung;
    }
    /**
     * Set SchaedenAusRueckstufung value
     * @param int $schaedenAusRueckstufung
     * @return \BiPRO\StructType\CT_Fahrzeugvollversicherung
     */
    public function setSchaedenAusRueckstufung($schaedenAusRueckstufung = null)
    {
        // validation for constraint: int
        if (!is_null($schaedenAusRueckstufung) && !(is_int($schaedenAusRueckstufung) || ctype_digit($schaedenAusRueckstufung))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($schaedenAusRueckstufung, true), gettype($schaedenAusRueckstufung)), __LINE__);
        }
        $this->SchaedenAusRueckstufung = $schaedenAusRueckstufung;
        return $this;
    }
    /**
     * Get SFKlasseIntern value
     * @return \BiPRO\StructType\STE_SFKlasseKFV|null
     */
    public function getSFKlasseIntern()
    {
        return $this->SFKlasseIntern;
    }
    /**
     * Set SFKlasseIntern value
     * @param \BiPRO\StructType\STE_SFKlasseKFV $sFKlasseIntern
     * @return \BiPRO\StructType\CT_Fahrzeugvollversicherung
     */
    public function setSFKlasseIntern(\BiPRO\StructType\STE_SFKlasseKFV $sFKlasseIntern = null)
    {
        $this->SFKlasseIntern = $sFKlasseIntern;
        return $this;
    }
}
