<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Fahrzeugnutzung StructType
 * @subpackage Structs
 */
abstract class CT_Fahrzeugnutzung extends CT_Objekt
{
    /**
     * The Garage
     * Meta information extracted from the WSDL
     * - documentation: Gemäß GDV-Schlüssel Satzart 0210.050/2 Feld 21
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_Garage
     */
    public $Garage;
    /**
     * The Betriebsausgabe
     * Meta information extracted from the WSDL
     * - documentation: Ja = Fahrzeug wird dem Finanzamt als Betriebsausgabe gemeldet.Nein = sonst
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Betriebsausgabe;
    /**
     * The Nutzungsart
     * Meta information extracted from the WSDL
     * - documentation: Gemäß GDV-Schlüssel Satzart 0210.050/2 Feld 22
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Nutzungsart;
    /**
     * The Jahresfahrleistung
     * Meta information extracted from the WSDL
     * - documentation: Jahresfahrleistung in Kilometern.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Jahresfahrleistung;
    /**
     * The JahresfahrleistungUnbegrenzt
     * Meta information extracted from the WSDL
     * - documentation: Ja=Die Jahresfahrleistung ist unbegrenzt.Nein=sonst
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $JahresfahrleistungUnbegrenzt;
    /**
     * The Flughafenvorfeld
     * Meta information extracted from the WSDL
     * - documentation: Ja = Das Fahrzeug wird im Vorfeld eines Flughafens genutzt.Nein = Das Fahrzeug wird nicht im Vorfeld eines Flughafens genutzt.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Flughafenvorfeld;
    /**
     * The Betriebsart
     * Meta information extracted from the WSDL
     * - documentation: Art des Betriebes, in dem das Fahrzeug genutzt wird.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Betriebsart;
    /**
     * Constructor method for CT_Fahrzeugnutzung
     * @uses CT_Fahrzeugnutzung::setGarage()
     * @uses CT_Fahrzeugnutzung::setBetriebsausgabe()
     * @uses CT_Fahrzeugnutzung::setNutzungsart()
     * @uses CT_Fahrzeugnutzung::setJahresfahrleistung()
     * @uses CT_Fahrzeugnutzung::setJahresfahrleistungUnbegrenzt()
     * @uses CT_Fahrzeugnutzung::setFlughafenvorfeld()
     * @uses CT_Fahrzeugnutzung::setBetriebsart()
     * @param \BiPRO\StructType\STE_Garage $garage
     * @param bool $betriebsausgabe
     * @param string $nutzungsart
     * @param int $jahresfahrleistung
     * @param bool $jahresfahrleistungUnbegrenzt
     * @param bool $flughafenvorfeld
     * @param string $betriebsart
     */
    public function __construct(\BiPRO\StructType\STE_Garage $garage = null, $betriebsausgabe = null, $nutzungsart = null, $jahresfahrleistung = null, $jahresfahrleistungUnbegrenzt = null, $flughafenvorfeld = null, $betriebsart = null)
    {
        $this
            ->setGarage($garage)
            ->setBetriebsausgabe($betriebsausgabe)
            ->setNutzungsart($nutzungsart)
            ->setJahresfahrleistung($jahresfahrleistung)
            ->setJahresfahrleistungUnbegrenzt($jahresfahrleistungUnbegrenzt)
            ->setFlughafenvorfeld($flughafenvorfeld)
            ->setBetriebsart($betriebsart);
    }
    /**
     * Get Garage value
     * @return \BiPRO\StructType\STE_Garage|null
     */
    public function getGarage()
    {
        return $this->Garage;
    }
    /**
     * Set Garage value
     * @param \BiPRO\StructType\STE_Garage $garage
     * @return \BiPRO\StructType\CT_Fahrzeugnutzung
     */
    public function setGarage(\BiPRO\StructType\STE_Garage $garage = null)
    {
        $this->Garage = $garage;
        return $this;
    }
    /**
     * Get Betriebsausgabe value
     * @return bool|null
     */
    public function getBetriebsausgabe()
    {
        return $this->Betriebsausgabe;
    }
    /**
     * Set Betriebsausgabe value
     * @param bool $betriebsausgabe
     * @return \BiPRO\StructType\CT_Fahrzeugnutzung
     */
    public function setBetriebsausgabe($betriebsausgabe = null)
    {
        // validation for constraint: boolean
        if (!is_null($betriebsausgabe) && !is_bool($betriebsausgabe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($betriebsausgabe, true), gettype($betriebsausgabe)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($betriebsausgabe) && !preg_match('/true|false/', $betriebsausgabe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($betriebsausgabe, true)), __LINE__);
        }
        $this->Betriebsausgabe = $betriebsausgabe;
        return $this;
    }
    /**
     * Get Nutzungsart value
     * @return string|null
     */
    public function getNutzungsart()
    {
        return $this->Nutzungsart;
    }
    /**
     * Set Nutzungsart value
     * @uses \BiPRO\EnumType\ST_Nutzungsart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Nutzungsart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nutzungsart
     * @return \BiPRO\StructType\CT_Fahrzeugnutzung
     */
    public function setNutzungsart($nutzungsart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Nutzungsart::valueIsValid($nutzungsart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Nutzungsart', is_array($nutzungsart) ? implode(', ', $nutzungsart) : var_export($nutzungsart, true), implode(', ', \BiPRO\EnumType\ST_Nutzungsart::getValidValues())), __LINE__);
        }
        $this->Nutzungsart = $nutzungsart;
        return $this;
    }
    /**
     * Get Jahresfahrleistung value
     * @return int|null
     */
    public function getJahresfahrleistung()
    {
        return $this->Jahresfahrleistung;
    }
    /**
     * Set Jahresfahrleistung value
     * @param int $jahresfahrleistung
     * @return \BiPRO\StructType\CT_Fahrzeugnutzung
     */
    public function setJahresfahrleistung($jahresfahrleistung = null)
    {
        // validation for constraint: int
        if (!is_null($jahresfahrleistung) && !(is_int($jahresfahrleistung) || ctype_digit($jahresfahrleistung))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($jahresfahrleistung, true), gettype($jahresfahrleistung)), __LINE__);
        }
        $this->Jahresfahrleistung = $jahresfahrleistung;
        return $this;
    }
    /**
     * Get JahresfahrleistungUnbegrenzt value
     * @return bool|null
     */
    public function getJahresfahrleistungUnbegrenzt()
    {
        return $this->JahresfahrleistungUnbegrenzt;
    }
    /**
     * Set JahresfahrleistungUnbegrenzt value
     * @param bool $jahresfahrleistungUnbegrenzt
     * @return \BiPRO\StructType\CT_Fahrzeugnutzung
     */
    public function setJahresfahrleistungUnbegrenzt($jahresfahrleistungUnbegrenzt = null)
    {
        // validation for constraint: boolean
        if (!is_null($jahresfahrleistungUnbegrenzt) && !is_bool($jahresfahrleistungUnbegrenzt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($jahresfahrleistungUnbegrenzt, true), gettype($jahresfahrleistungUnbegrenzt)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($jahresfahrleistungUnbegrenzt) && !preg_match('/true|false/', $jahresfahrleistungUnbegrenzt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($jahresfahrleistungUnbegrenzt, true)), __LINE__);
        }
        $this->JahresfahrleistungUnbegrenzt = $jahresfahrleistungUnbegrenzt;
        return $this;
    }
    /**
     * Get Flughafenvorfeld value
     * @return bool|null
     */
    public function getFlughafenvorfeld()
    {
        return $this->Flughafenvorfeld;
    }
    /**
     * Set Flughafenvorfeld value
     * @param bool $flughafenvorfeld
     * @return \BiPRO\StructType\CT_Fahrzeugnutzung
     */
    public function setFlughafenvorfeld($flughafenvorfeld = null)
    {
        // validation for constraint: boolean
        if (!is_null($flughafenvorfeld) && !is_bool($flughafenvorfeld)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($flughafenvorfeld, true), gettype($flughafenvorfeld)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($flughafenvorfeld) && !preg_match('/true|false/', $flughafenvorfeld)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($flughafenvorfeld, true)), __LINE__);
        }
        $this->Flughafenvorfeld = $flughafenvorfeld;
        return $this;
    }
    /**
     * Get Betriebsart value
     * @return string|null
     */
    public function getBetriebsart()
    {
        return $this->Betriebsart;
    }
    /**
     * Set Betriebsart value
     * @uses \BiPRO\EnumType\ST_BetriebsartFahrzeug::valueIsValid()
     * @uses \BiPRO\EnumType\ST_BetriebsartFahrzeug::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $betriebsart
     * @return \BiPRO\StructType\CT_Fahrzeugnutzung
     */
    public function setBetriebsart($betriebsart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_BetriebsartFahrzeug::valueIsValid($betriebsart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_BetriebsartFahrzeug', is_array($betriebsart) ? implode(', ', $betriebsart) : var_export($betriebsart, true), implode(', ', \BiPRO\EnumType\ST_BetriebsartFahrzeug::getValidValues())), __LINE__);
        }
        $this->Betriebsart = $betriebsart;
        return $this;
    }
}
