<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Fahrzeug StructType
 * @subpackage Structs
 */
class CT_Fahrzeug extends CT_Gegenstand
{
    /**
     * The Eigentumsverhaeltnis
     * Meta information extracted from the WSDL
     * - documentation: Finanzierungsart gemäß GDV-Schlüssel Satzart 0210.050/2 Feld 23
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Eigentumsverhaeltnis;
    /**
     * The Erstzulassung
     * Meta information extracted from the WSDL
     * - documentation: nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Erstzulassung;
    /**
     * The FahrzeugGesamtNeuwert
     * Meta information extracted from the WSDL
     * - documentation: Neuwert des Fahrzeugs.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Neuwert
     */
    public $FahrzeugGesamtNeuwert;
    /**
     * The FahrzeugGesamtZeitwert
     * Meta information extracted from the WSDL
     * - documentation: Zeitwert des Fahrzeugs.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zeitwert
     */
    public $FahrzeugGesamtZeitwert;
    /**
     * The Fahrzeugidentifizierungsnummer
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Fahrzeugidentifizierungsnummer;
    /**
     * The Flottenkennzeichen
     * Meta information extracted from the WSDL
     * - documentation: Fahrzeug ist Teil einer Flotte.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Flottenkennzeichen;
    /**
     * The Herstellername
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Herstellername;
    /**
     * The Herstellerschluessel
     * Meta information extracted from the WSDL
     * - documentation: Auspraegungen gemaess gemäß GDV-Satzart 0210 Kfz-Fahrzeugdaten, Nr. 12.
     * - base: xsd:string
     * - length: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Herstellerschluessel;
    /**
     * The Hubraum
     * Meta information extracted from the WSDL
     * - documentation: Hubraum in ccm
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Hubraum;
    /**
     * The Modellname
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Modellname;
    /**
     * The MotorLeistung
     * Meta information extracted from the WSDL
     * - documentation: Motorleistung in KW. Wird bei Anhängern nicht verwendet.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $MotorLeistung;
    /**
     * The Typschluessel
     * Meta information extracted from the WSDL
     * - documentation: Auspraegungen gemaess GDV-Satzart 0210 Kfz-Fahrzeugdaten, Nr. 13.
     * - base: xsd:string
     * - length: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Typschluessel;
    /**
     * The VarianteVersionSchluessel
     * Meta information extracted from the WSDL
     * - documentation: Auspraegungen gemaess GDV-VB Schnittstelle VU – Zentrale Stelle: Fahrzeug.SchluesselVarianteVersion
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $VarianteVersionSchluessel;
    /**
     * The Wagniskennziffer
     * Meta information extracted from the WSDL
     * - documentation: Auspraegungen gemaess GDV-Satzart 0210 Kfz-Fahrzeugdaten, Nr. 8.
     * - base: xsd:string
     * - length: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Wagniskennziffer;
    /**
     * The WagniskennzifferText
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $WagniskennzifferText;
    /**
     * The Fahrzeugart
     * Meta information extracted from the WSDL
     * - documentation: Über die Fahrzeugart kann beim eVB-Abruf optional die Gültigkeit der eVB auf eine bestimmte Fahrzeugart (PKW, LKW, Anhänger etc.) eingeschränkt werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fahrzeugart;
    /**
     * The Kennzeichen
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Kennzeichen
     */
    public $Kennzeichen;
    /**
     * The Sicherungsglaeubiger
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Sicherungsglaeubiger
     */
    public $Sicherungsglaeubiger;
    /**
     * The Sonderausstattung
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Sonderausstattung[]
     */
    public $Sonderausstattung;
    /**
     * The VersicherungsbestaetigungKfz
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_VersicherungsbestaetigungKfz
     */
    public $VersicherungsbestaetigungKfz;
    /**
     * The Leasingnehmer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Leasingnehmer
     */
    public $Leasingnehmer;
    /**
     * The Leasinggeber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Leasinggeber
     */
    public $Leasinggeber;
    /**
     * The SFRBerechtigter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_SFRBerechtigter
     */
    public $SFRBerechtigter;
    /**
     * The Halter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Halter
     */
    public $Halter;
    /**
     * The Fahrer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Fahrer[]
     */
    public $Fahrer;
    /**
     * The Wegfahrsperre
     * Meta information extracted from the WSDL
     * - documentation: Gibt an ob das Fahrzeug über eine Wegfahrsperre verfügt.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Wegfahrsperre;
    /**
     * The Staerke
     * Meta information extracted from the WSDL
     * - documentation: Stärke des Fahrzeugs gemäß Staerkeeinheit (je nach Wagniskennziffer in: KW, CCM, Tonnen, Plätze)
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Staerke;
    /**
     * The Staerkeeinheit
     * Meta information extracted from the WSDL
     * - documentation: Einheit zur Staerke (KW, CCM, Tonnen, Plätze)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Staerkeeinheit;
    /**
     * The Finanzierungslaufzeit
     * Meta information extracted from the WSDL
     * - documentation: Laufzeit der Finanzierung.Es MÜSSEN die konkreten Zeitpunkte angegeben werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zeitraum
     */
    public $Finanzierungslaufzeit;
    /**
     * The Fahrerassistenzsystem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Fahrerassistenzsystem[]
     */
    public $Fahrerassistenzsystem;
    /**
     * The FahrzeugGesamtKaufpreis
     * Meta information extracted from the WSDL
     * - documentation: FahrzeugKaufpreis ist der im Kaufvertrag angegebene Preis für das Fahrzeug. Es DARF nicht der Neuwert oder Zeitwert angegeben werden. Neuwert ist der Betrag, der aufzuwenden ist, um Sachen gleicher Art und Güte in neuwertigem
     * Zustand wiederzubeschaffen. Zeitwert ist der aktuelle Wert einer versicherten Sache. Der Zeitwert errechnet sich aus dem Neuwert abzüglich der Wertminderung durch Alter und Abnutzung.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Kaufpreis
     */
    public $FahrzeugGesamtKaufpreis;
    /**
     * The Zulassungspflichtig
     * Meta information extracted from the WSDL
     * - documentation: Ja = zulassungspflichtigNein = nicht zulassungspflichtigIst das Attribut nicht belegt, MUSS es als mit "Ja" belegt interpretiert werden.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Zulassungspflichtig;
    /**
     * The Baujahr
     * Meta information extracted from the WSDL
     * - documentation: Baujahr des Fahrzeugs.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 4
     * @var int
     */
    public $Baujahr;
    /**
     * The Reimport
     * Meta information extracted from the WSDL
     * - documentation: Typschlüssel des Vergleichsfahrzeugs wird im Typschluessel übermittelt.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Reimport;
    /**
     * The AnzahlDerVorbesitzer
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der Vorbesitzer gemäß Fahrzeugbrief.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzahlDerVorbesitzer;
    /**
     * The NaechsteHauptuntersuchung
     * Meta information extracted from the WSDL
     * - documentation: Datum der nächsten Hauptuntersuchung. | In Form von JJJJ-MM
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]
     * @var string
     */
    public $NaechsteHauptuntersuchung;
    /**
     * The Dachart
     * Meta information extracted from the WSDL
     * - documentation: Art des Dachs des Fahrzeugs
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Dachart;
    /**
     * The Farbe
     * Meta information extracted from the WSDL
     * - documentation: Farbe des Fahrzeugs. Es kann u.a. die Farbe sein, die ein Schadenmelder in die Schadenmeldung eingibt (also eher grau als anthrazit-metallic) oder die werbliche Farbbezeichnung sein.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Farbe;
    /**
     * The Sitzbezug
     * Meta information extracted from the WSDL
     * - documentation: Art der Sitzbezüge.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Sitzbezug;
    /**
     * The Motorart
     * Meta information extracted from the WSDL
     * - documentation: Art des Fahrzeugmotors.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Motorart;
    /**
     * The Getriebeart
     * Meta information extracted from the WSDL
     * - documentation: Art des Getriebes.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Getriebeart;
    /**
     * The AnzahlGaenge
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der Gänge, ohne Rückwärtsgänge.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzahlGaenge;
    /**
     * The Felgenart
     * Meta information extracted from the WSDL
     * - documentation: Art der Felgen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Felgenart;
    /**
     * The Reserveradart
     * Meta information extracted from the WSDL
     * - documentation: Art des Reserverades.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reserveradart;
    /**
     * The AnzahlAchsen
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der Achsen.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzahlAchsen;
    /**
     * The AnzahlAngetriebeneAchsen
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der angetriebenen Achsen.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzahlAngetriebeneAchsen;
    /**
     * The AnzahlTueren
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der Türen.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzahlTueren;
    /**
     * The AnzahlElektrischeFensterheber
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der elektrischen Fensterheber.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzahlElektrischeFensterheber;
    /**
     * The AnzahlSitzheizungen
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der Sitzheizungen.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzahlSitzheizungen;
    /**
     * The AnzahlAirbags
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der Airbags.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzahlAirbags;
    /**
     * The Anhaengerkupplung
     * Meta information extracted from the WSDL
     * - documentation: JA = Das Fahrzeug hat eine AnhängerkupplungNEIN = Das Fahrzeug hat keine Anhängerkupplung
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Anhaengerkupplung;
    /**
     * The Frontscheibenreparaturen
     * Meta information extracted from the WSDL
     * - documentation: Anzahl Reparaturen an der aktuell eingebauten Frontscheibe.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Frontscheibenreparaturen;
    /**
     * The ErsteZulassungAufDenVNOderHalter
     * Meta information extracted from the WSDL
     * - documentation: Erste Zulassung dieses Fahrzeuges auf den aktuellen VN oder Halter. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $ErsteZulassungAufDenVNOderHalter;
    /**
     * The Reifen
     * Meta information extracted from the WSDL
     * - documentation: Informationen zu den Reifen eines Fahrzeugs.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Reifen[]
     */
    public $Reifen;
    /**
     * The Betriebsleistung
     * Meta information extracted from the WSDL
     * - documentation: Die Betriebsleistung des Fahrzeugs, z. B. die Fahrleistung (Kilometerstand) oder die Nutzungsdauer (Betriebsstunden).
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Betriebsleistung[]
     */
    public $Betriebsleistung;
    /**
     * The Ausnahmegenehmigung70StVZO
     * Meta information extracted from the WSDL
     * - documentation: Ja = Das Fahrzeug besitzt eine Ausnahmegenehmigung nach §70 StVZO.Nein = sonst.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Ausnahmegenehmigung70StVZO;
    /**
     * The WagniskennzifferSpezifizierung
     * Meta information extracted from the WSDL
     * - documentation: Attribut zur genaueren Spezifizierung der GDV-Wagniskennziffer (WKZ, Anlage 110) mit nicht eindeutigen oder mehreren Ausprägungen. Im Attribut Wagniskennziffer MUSS der in der Anlage 110 angegebene GDV-Schlüssel mit übermittelt
     * werden.Beispiel: WKZ 651 = Bus im Linienverkehr/FernlinienverkehrAusprägung: 651001 Linienverkehr, 651002 Fernlinienverkehr
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WagniskennzifferSpezifizierung;
    /**
     * Constructor method for CT_Fahrzeug
     * @uses CT_Fahrzeug::setEigentumsverhaeltnis()
     * @uses CT_Fahrzeug::setErstzulassung()
     * @uses CT_Fahrzeug::setFahrzeugGesamtNeuwert()
     * @uses CT_Fahrzeug::setFahrzeugGesamtZeitwert()
     * @uses CT_Fahrzeug::setFahrzeugidentifizierungsnummer()
     * @uses CT_Fahrzeug::setFlottenkennzeichen()
     * @uses CT_Fahrzeug::setHerstellername()
     * @uses CT_Fahrzeug::setHerstellerschluessel()
     * @uses CT_Fahrzeug::setHubraum()
     * @uses CT_Fahrzeug::setModellname()
     * @uses CT_Fahrzeug::setMotorLeistung()
     * @uses CT_Fahrzeug::setTypschluessel()
     * @uses CT_Fahrzeug::setVarianteVersionSchluessel()
     * @uses CT_Fahrzeug::setWagniskennziffer()
     * @uses CT_Fahrzeug::setWagniskennzifferText()
     * @uses CT_Fahrzeug::setFahrzeugart()
     * @uses CT_Fahrzeug::setKennzeichen()
     * @uses CT_Fahrzeug::setSicherungsglaeubiger()
     * @uses CT_Fahrzeug::setSonderausstattung()
     * @uses CT_Fahrzeug::setVersicherungsbestaetigungKfz()
     * @uses CT_Fahrzeug::setLeasingnehmer()
     * @uses CT_Fahrzeug::setLeasinggeber()
     * @uses CT_Fahrzeug::setSFRBerechtigter()
     * @uses CT_Fahrzeug::setHalter()
     * @uses CT_Fahrzeug::setFahrer()
     * @uses CT_Fahrzeug::setWegfahrsperre()
     * @uses CT_Fahrzeug::setStaerke()
     * @uses CT_Fahrzeug::setStaerkeeinheit()
     * @uses CT_Fahrzeug::setFinanzierungslaufzeit()
     * @uses CT_Fahrzeug::setFahrerassistenzsystem()
     * @uses CT_Fahrzeug::setFahrzeugGesamtKaufpreis()
     * @uses CT_Fahrzeug::setZulassungspflichtig()
     * @uses CT_Fahrzeug::setBaujahr()
     * @uses CT_Fahrzeug::setReimport()
     * @uses CT_Fahrzeug::setAnzahlDerVorbesitzer()
     * @uses CT_Fahrzeug::setNaechsteHauptuntersuchung()
     * @uses CT_Fahrzeug::setDachart()
     * @uses CT_Fahrzeug::setFarbe()
     * @uses CT_Fahrzeug::setSitzbezug()
     * @uses CT_Fahrzeug::setMotorart()
     * @uses CT_Fahrzeug::setGetriebeart()
     * @uses CT_Fahrzeug::setAnzahlGaenge()
     * @uses CT_Fahrzeug::setFelgenart()
     * @uses CT_Fahrzeug::setReserveradart()
     * @uses CT_Fahrzeug::setAnzahlAchsen()
     * @uses CT_Fahrzeug::setAnzahlAngetriebeneAchsen()
     * @uses CT_Fahrzeug::setAnzahlTueren()
     * @uses CT_Fahrzeug::setAnzahlElektrischeFensterheber()
     * @uses CT_Fahrzeug::setAnzahlSitzheizungen()
     * @uses CT_Fahrzeug::setAnzahlAirbags()
     * @uses CT_Fahrzeug::setAnhaengerkupplung()
     * @uses CT_Fahrzeug::setFrontscheibenreparaturen()
     * @uses CT_Fahrzeug::setErsteZulassungAufDenVNOderHalter()
     * @uses CT_Fahrzeug::setReifen()
     * @uses CT_Fahrzeug::setBetriebsleistung()
     * @uses CT_Fahrzeug::setAusnahmegenehmigung70StVZO()
     * @uses CT_Fahrzeug::setWagniskennzifferSpezifizierung()
     * @param string $eigentumsverhaeltnis
     * @param string $erstzulassung
     * @param \BiPRO\StructType\CT_Neuwert $fahrzeugGesamtNeuwert
     * @param \BiPRO\StructType\CT_Zeitwert $fahrzeugGesamtZeitwert
     * @param string $fahrzeugidentifizierungsnummer
     * @param bool $flottenkennzeichen
     * @param string $herstellername
     * @param string $herstellerschluessel
     * @param int $hubraum
     * @param string $modellname
     * @param int $motorLeistung
     * @param string $typschluessel
     * @param string $varianteVersionSchluessel
     * @param string $wagniskennziffer
     * @param string $wagniskennzifferText
     * @param string $fahrzeugart
     * @param \BiPRO\StructType\CT_Kennzeichen $kennzeichen
     * @param \BiPRO\StructType\CT_Sicherungsglaeubiger $sicherungsglaeubiger
     * @param \BiPRO\StructType\CT_Sonderausstattung[] $sonderausstattung
     * @param \BiPRO\StructType\CT_VersicherungsbestaetigungKfz $versicherungsbestaetigungKfz
     * @param \BiPRO\StructType\CT_Leasingnehmer $leasingnehmer
     * @param \BiPRO\StructType\CT_Leasinggeber $leasinggeber
     * @param \BiPRO\StructType\CT_SFRBerechtigter $sFRBerechtigter
     * @param \BiPRO\StructType\CT_Halter $halter
     * @param \BiPRO\StructType\CT_Fahrer[] $fahrer
     * @param bool $wegfahrsperre
     * @param float $staerke
     * @param string $staerkeeinheit
     * @param \BiPRO\StructType\CT_Zeitraum $finanzierungslaufzeit
     * @param \BiPRO\StructType\CT_Fahrerassistenzsystem[] $fahrerassistenzsystem
     * @param \BiPRO\StructType\CT_Kaufpreis $fahrzeugGesamtKaufpreis
     * @param bool $zulassungspflichtig
     * @param int $baujahr
     * @param bool $reimport
     * @param int $anzahlDerVorbesitzer
     * @param string $naechsteHauptuntersuchung
     * @param string $dachart
     * @param string $farbe
     * @param string $sitzbezug
     * @param string $motorart
     * @param string $getriebeart
     * @param int $anzahlGaenge
     * @param string $felgenart
     * @param string $reserveradart
     * @param int $anzahlAchsen
     * @param int $anzahlAngetriebeneAchsen
     * @param int $anzahlTueren
     * @param int $anzahlElektrischeFensterheber
     * @param int $anzahlSitzheizungen
     * @param int $anzahlAirbags
     * @param bool $anhaengerkupplung
     * @param int $frontscheibenreparaturen
     * @param string $ersteZulassungAufDenVNOderHalter
     * @param \BiPRO\StructType\CT_Reifen[] $reifen
     * @param \BiPRO\StructType\CT_Betriebsleistung[] $betriebsleistung
     * @param bool $ausnahmegenehmigung70StVZO
     * @param string $wagniskennzifferSpezifizierung
     */
    public function __construct($eigentumsverhaeltnis = null, $erstzulassung = null, \BiPRO\StructType\CT_Neuwert $fahrzeugGesamtNeuwert = null, \BiPRO\StructType\CT_Zeitwert $fahrzeugGesamtZeitwert = null, $fahrzeugidentifizierungsnummer = null, $flottenkennzeichen = null, $herstellername = null, $herstellerschluessel = null, $hubraum = null, $modellname = null, $motorLeistung = null, $typschluessel = null, $varianteVersionSchluessel = null, $wagniskennziffer = null, $wagniskennzifferText = null, $fahrzeugart = null, \BiPRO\StructType\CT_Kennzeichen $kennzeichen = null, \BiPRO\StructType\CT_Sicherungsglaeubiger $sicherungsglaeubiger = null, array $sonderausstattung = array(), \BiPRO\StructType\CT_VersicherungsbestaetigungKfz $versicherungsbestaetigungKfz = null, \BiPRO\StructType\CT_Leasingnehmer $leasingnehmer = null, \BiPRO\StructType\CT_Leasinggeber $leasinggeber = null, \BiPRO\StructType\CT_SFRBerechtigter $sFRBerechtigter = null, \BiPRO\StructType\CT_Halter $halter = null, array $fahrer = array(), $wegfahrsperre = null, $staerke = null, $staerkeeinheit = null, \BiPRO\StructType\CT_Zeitraum $finanzierungslaufzeit = null, array $fahrerassistenzsystem = array(), \BiPRO\StructType\CT_Kaufpreis $fahrzeugGesamtKaufpreis = null, $zulassungspflichtig = null, $baujahr = null, $reimport = null, $anzahlDerVorbesitzer = null, $naechsteHauptuntersuchung = null, $dachart = null, $farbe = null, $sitzbezug = null, $motorart = null, $getriebeart = null, $anzahlGaenge = null, $felgenart = null, $reserveradart = null, $anzahlAchsen = null, $anzahlAngetriebeneAchsen = null, $anzahlTueren = null, $anzahlElektrischeFensterheber = null, $anzahlSitzheizungen = null, $anzahlAirbags = null, $anhaengerkupplung = null, $frontscheibenreparaturen = null, $ersteZulassungAufDenVNOderHalter = null, array $reifen = array(), array $betriebsleistung = array(), $ausnahmegenehmigung70StVZO = null, $wagniskennzifferSpezifizierung = null)
    {
        $this
            ->setEigentumsverhaeltnis($eigentumsverhaeltnis)
            ->setErstzulassung($erstzulassung)
            ->setFahrzeugGesamtNeuwert($fahrzeugGesamtNeuwert)
            ->setFahrzeugGesamtZeitwert($fahrzeugGesamtZeitwert)
            ->setFahrzeugidentifizierungsnummer($fahrzeugidentifizierungsnummer)
            ->setFlottenkennzeichen($flottenkennzeichen)
            ->setHerstellername($herstellername)
            ->setHerstellerschluessel($herstellerschluessel)
            ->setHubraum($hubraum)
            ->setModellname($modellname)
            ->setMotorLeistung($motorLeistung)
            ->setTypschluessel($typschluessel)
            ->setVarianteVersionSchluessel($varianteVersionSchluessel)
            ->setWagniskennziffer($wagniskennziffer)
            ->setWagniskennzifferText($wagniskennzifferText)
            ->setFahrzeugart($fahrzeugart)
            ->setKennzeichen($kennzeichen)
            ->setSicherungsglaeubiger($sicherungsglaeubiger)
            ->setSonderausstattung($sonderausstattung)
            ->setVersicherungsbestaetigungKfz($versicherungsbestaetigungKfz)
            ->setLeasingnehmer($leasingnehmer)
            ->setLeasinggeber($leasinggeber)
            ->setSFRBerechtigter($sFRBerechtigter)
            ->setHalter($halter)
            ->setFahrer($fahrer)
            ->setWegfahrsperre($wegfahrsperre)
            ->setStaerke($staerke)
            ->setStaerkeeinheit($staerkeeinheit)
            ->setFinanzierungslaufzeit($finanzierungslaufzeit)
            ->setFahrerassistenzsystem($fahrerassistenzsystem)
            ->setFahrzeugGesamtKaufpreis($fahrzeugGesamtKaufpreis)
            ->setZulassungspflichtig($zulassungspflichtig)
            ->setBaujahr($baujahr)
            ->setReimport($reimport)
            ->setAnzahlDerVorbesitzer($anzahlDerVorbesitzer)
            ->setNaechsteHauptuntersuchung($naechsteHauptuntersuchung)
            ->setDachart($dachart)
            ->setFarbe($farbe)
            ->setSitzbezug($sitzbezug)
            ->setMotorart($motorart)
            ->setGetriebeart($getriebeart)
            ->setAnzahlGaenge($anzahlGaenge)
            ->setFelgenart($felgenart)
            ->setReserveradart($reserveradart)
            ->setAnzahlAchsen($anzahlAchsen)
            ->setAnzahlAngetriebeneAchsen($anzahlAngetriebeneAchsen)
            ->setAnzahlTueren($anzahlTueren)
            ->setAnzahlElektrischeFensterheber($anzahlElektrischeFensterheber)
            ->setAnzahlSitzheizungen($anzahlSitzheizungen)
            ->setAnzahlAirbags($anzahlAirbags)
            ->setAnhaengerkupplung($anhaengerkupplung)
            ->setFrontscheibenreparaturen($frontscheibenreparaturen)
            ->setErsteZulassungAufDenVNOderHalter($ersteZulassungAufDenVNOderHalter)
            ->setReifen($reifen)
            ->setBetriebsleistung($betriebsleistung)
            ->setAusnahmegenehmigung70StVZO($ausnahmegenehmigung70StVZO)
            ->setWagniskennzifferSpezifizierung($wagniskennzifferSpezifizierung);
    }
    /**
     * Get Eigentumsverhaeltnis value
     * @return string|null
     */
    public function getEigentumsverhaeltnis()
    {
        return $this->Eigentumsverhaeltnis;
    }
    /**
     * Set Eigentumsverhaeltnis value
     * @uses \BiPRO\EnumType\ST_Eigentumsverhaeltnis::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Eigentumsverhaeltnis::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eigentumsverhaeltnis
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setEigentumsverhaeltnis($eigentumsverhaeltnis = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Eigentumsverhaeltnis::valueIsValid($eigentumsverhaeltnis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Eigentumsverhaeltnis', is_array($eigentumsverhaeltnis) ? implode(', ', $eigentumsverhaeltnis) : var_export($eigentumsverhaeltnis, true), implode(', ', \BiPRO\EnumType\ST_Eigentumsverhaeltnis::getValidValues())), __LINE__);
        }
        $this->Eigentumsverhaeltnis = $eigentumsverhaeltnis;
        return $this;
    }
    /**
     * Get Erstzulassung value
     * @return string|null
     */
    public function getErstzulassung()
    {
        return $this->Erstzulassung;
    }
    /**
     * Set Erstzulassung value
     * @param string $erstzulassung
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setErstzulassung($erstzulassung = null)
    {
        // validation for constraint: string
        if (!is_null($erstzulassung) && !is_string($erstzulassung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($erstzulassung, true), gettype($erstzulassung)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($erstzulassung) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $erstzulassung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($erstzulassung, true)), __LINE__);
        }
        $this->Erstzulassung = $erstzulassung;
        return $this;
    }
    /**
     * Get FahrzeugGesamtNeuwert value
     * @return \BiPRO\StructType\CT_Neuwert|null
     */
    public function getFahrzeugGesamtNeuwert()
    {
        return $this->FahrzeugGesamtNeuwert;
    }
    /**
     * Set FahrzeugGesamtNeuwert value
     * @param \BiPRO\StructType\CT_Neuwert $fahrzeugGesamtNeuwert
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setFahrzeugGesamtNeuwert(\BiPRO\StructType\CT_Neuwert $fahrzeugGesamtNeuwert = null)
    {
        $this->FahrzeugGesamtNeuwert = $fahrzeugGesamtNeuwert;
        return $this;
    }
    /**
     * Get FahrzeugGesamtZeitwert value
     * @return \BiPRO\StructType\CT_Zeitwert|null
     */
    public function getFahrzeugGesamtZeitwert()
    {
        return $this->FahrzeugGesamtZeitwert;
    }
    /**
     * Set FahrzeugGesamtZeitwert value
     * @param \BiPRO\StructType\CT_Zeitwert $fahrzeugGesamtZeitwert
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setFahrzeugGesamtZeitwert(\BiPRO\StructType\CT_Zeitwert $fahrzeugGesamtZeitwert = null)
    {
        $this->FahrzeugGesamtZeitwert = $fahrzeugGesamtZeitwert;
        return $this;
    }
    /**
     * Get Fahrzeugidentifizierungsnummer value
     * @return string|null
     */
    public function getFahrzeugidentifizierungsnummer()
    {
        return $this->Fahrzeugidentifizierungsnummer;
    }
    /**
     * Set Fahrzeugidentifizierungsnummer value
     * @param string $fahrzeugidentifizierungsnummer
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setFahrzeugidentifizierungsnummer($fahrzeugidentifizierungsnummer = null)
    {
        // validation for constraint: string
        if (!is_null($fahrzeugidentifizierungsnummer) && !is_string($fahrzeugidentifizierungsnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fahrzeugidentifizierungsnummer, true), gettype($fahrzeugidentifizierungsnummer)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($fahrzeugidentifizierungsnummer) && mb_strlen($fahrzeugidentifizierungsnummer) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($fahrzeugidentifizierungsnummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($fahrzeugidentifizierungsnummer) && mb_strlen($fahrzeugidentifizierungsnummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($fahrzeugidentifizierungsnummer)), __LINE__);
        }
        $this->Fahrzeugidentifizierungsnummer = $fahrzeugidentifizierungsnummer;
        return $this;
    }
    /**
     * Get Flottenkennzeichen value
     * @return bool|null
     */
    public function getFlottenkennzeichen()
    {
        return $this->Flottenkennzeichen;
    }
    /**
     * Set Flottenkennzeichen value
     * @param bool $flottenkennzeichen
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setFlottenkennzeichen($flottenkennzeichen = null)
    {
        // validation for constraint: boolean
        if (!is_null($flottenkennzeichen) && !is_bool($flottenkennzeichen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($flottenkennzeichen, true), gettype($flottenkennzeichen)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($flottenkennzeichen) && !preg_match('/true|false/', $flottenkennzeichen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($flottenkennzeichen, true)), __LINE__);
        }
        $this->Flottenkennzeichen = $flottenkennzeichen;
        return $this;
    }
    /**
     * Get Herstellername value
     * @return string|null
     */
    public function getHerstellername()
    {
        return $this->Herstellername;
    }
    /**
     * Set Herstellername value
     * @param string $herstellername
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setHerstellername($herstellername = null)
    {
        // validation for constraint: string
        if (!is_null($herstellername) && !is_string($herstellername)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($herstellername, true), gettype($herstellername)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($herstellername) && mb_strlen($herstellername) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($herstellername)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($herstellername) && mb_strlen($herstellername) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($herstellername)), __LINE__);
        }
        $this->Herstellername = $herstellername;
        return $this;
    }
    /**
     * Get Herstellerschluessel value
     * @return string|null
     */
    public function getHerstellerschluessel()
    {
        return $this->Herstellerschluessel;
    }
    /**
     * Set Herstellerschluessel value
     * @param string $herstellerschluessel
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setHerstellerschluessel($herstellerschluessel = null)
    {
        // validation for constraint: string
        if (!is_null($herstellerschluessel) && !is_string($herstellerschluessel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($herstellerschluessel, true), gettype($herstellerschluessel)), __LINE__);
        }
        // validation for constraint: length(4)
        if (!is_null($herstellerschluessel) && mb_strlen($herstellerschluessel) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 4', mb_strlen($herstellerschluessel)), __LINE__);
        }
        $this->Herstellerschluessel = $herstellerschluessel;
        return $this;
    }
    /**
     * Get Hubraum value
     * @return int|null
     */
    public function getHubraum()
    {
        return $this->Hubraum;
    }
    /**
     * Set Hubraum value
     * @param int $hubraum
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setHubraum($hubraum = null)
    {
        // validation for constraint: int
        if (!is_null($hubraum) && !(is_int($hubraum) || ctype_digit($hubraum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hubraum, true), gettype($hubraum)), __LINE__);
        }
        $this->Hubraum = $hubraum;
        return $this;
    }
    /**
     * Get Modellname value
     * @return string|null
     */
    public function getModellname()
    {
        return $this->Modellname;
    }
    /**
     * Set Modellname value
     * @param string $modellname
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setModellname($modellname = null)
    {
        // validation for constraint: string
        if (!is_null($modellname) && !is_string($modellname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modellname, true), gettype($modellname)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($modellname) && mb_strlen($modellname) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($modellname)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($modellname) && mb_strlen($modellname) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($modellname)), __LINE__);
        }
        $this->Modellname = $modellname;
        return $this;
    }
    /**
     * Get MotorLeistung value
     * @return int|null
     */
    public function getMotorLeistung()
    {
        return $this->MotorLeistung;
    }
    /**
     * Set MotorLeistung value
     * @param int $motorLeistung
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setMotorLeistung($motorLeistung = null)
    {
        // validation for constraint: int
        if (!is_null($motorLeistung) && !(is_int($motorLeistung) || ctype_digit($motorLeistung))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($motorLeistung, true), gettype($motorLeistung)), __LINE__);
        }
        $this->MotorLeistung = $motorLeistung;
        return $this;
    }
    /**
     * Get Typschluessel value
     * @return string|null
     */
    public function getTypschluessel()
    {
        return $this->Typschluessel;
    }
    /**
     * Set Typschluessel value
     * @param string $typschluessel
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setTypschluessel($typschluessel = null)
    {
        // validation for constraint: string
        if (!is_null($typschluessel) && !is_string($typschluessel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typschluessel, true), gettype($typschluessel)), __LINE__);
        }
        // validation for constraint: length(3)
        if (!is_null($typschluessel) && mb_strlen($typschluessel) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 3', mb_strlen($typschluessel)), __LINE__);
        }
        $this->Typschluessel = $typschluessel;
        return $this;
    }
    /**
     * Get VarianteVersionSchluessel value
     * @return string|null
     */
    public function getVarianteVersionSchluessel()
    {
        return $this->VarianteVersionSchluessel;
    }
    /**
     * Set VarianteVersionSchluessel value
     * @param string $varianteVersionSchluessel
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setVarianteVersionSchluessel($varianteVersionSchluessel = null)
    {
        // validation for constraint: string
        if (!is_null($varianteVersionSchluessel) && !is_string($varianteVersionSchluessel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($varianteVersionSchluessel, true), gettype($varianteVersionSchluessel)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($varianteVersionSchluessel) && mb_strlen($varianteVersionSchluessel) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($varianteVersionSchluessel)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($varianteVersionSchluessel) && mb_strlen($varianteVersionSchluessel) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($varianteVersionSchluessel)), __LINE__);
        }
        $this->VarianteVersionSchluessel = $varianteVersionSchluessel;
        return $this;
    }
    /**
     * Get Wagniskennziffer value
     * @return string|null
     */
    public function getWagniskennziffer()
    {
        return $this->Wagniskennziffer;
    }
    /**
     * Set Wagniskennziffer value
     * @param string $wagniskennziffer
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setWagniskennziffer($wagniskennziffer = null)
    {
        // validation for constraint: string
        if (!is_null($wagniskennziffer) && !is_string($wagniskennziffer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wagniskennziffer, true), gettype($wagniskennziffer)), __LINE__);
        }
        // validation for constraint: length(3)
        if (!is_null($wagniskennziffer) && mb_strlen($wagniskennziffer) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 3', mb_strlen($wagniskennziffer)), __LINE__);
        }
        $this->Wagniskennziffer = $wagniskennziffer;
        return $this;
    }
    /**
     * Get WagniskennzifferText value
     * @return string|null
     */
    public function getWagniskennzifferText()
    {
        return $this->WagniskennzifferText;
    }
    /**
     * Set WagniskennzifferText value
     * @param string $wagniskennzifferText
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setWagniskennzifferText($wagniskennzifferText = null)
    {
        // validation for constraint: string
        if (!is_null($wagniskennzifferText) && !is_string($wagniskennzifferText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wagniskennzifferText, true), gettype($wagniskennzifferText)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($wagniskennzifferText) && mb_strlen($wagniskennzifferText) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($wagniskennzifferText)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($wagniskennzifferText) && mb_strlen($wagniskennzifferText) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($wagniskennzifferText)), __LINE__);
        }
        $this->WagniskennzifferText = $wagniskennzifferText;
        return $this;
    }
    /**
     * Get Fahrzeugart value
     * @return string|null
     */
    public function getFahrzeugart()
    {
        return $this->Fahrzeugart;
    }
    /**
     * Set Fahrzeugart value
     * @uses \BiPRO\EnumType\ST_Fahrzeugart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Fahrzeugart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fahrzeugart
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setFahrzeugart($fahrzeugart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Fahrzeugart::valueIsValid($fahrzeugart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Fahrzeugart', is_array($fahrzeugart) ? implode(', ', $fahrzeugart) : var_export($fahrzeugart, true), implode(', ', \BiPRO\EnumType\ST_Fahrzeugart::getValidValues())), __LINE__);
        }
        $this->Fahrzeugart = $fahrzeugart;
        return $this;
    }
    /**
     * Get Kennzeichen value
     * @return \BiPRO\StructType\CT_Kennzeichen|null
     */
    public function getKennzeichen()
    {
        return $this->Kennzeichen;
    }
    /**
     * Set Kennzeichen value
     * @param \BiPRO\StructType\CT_Kennzeichen $kennzeichen
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setKennzeichen(\BiPRO\StructType\CT_Kennzeichen $kennzeichen = null)
    {
        $this->Kennzeichen = $kennzeichen;
        return $this;
    }
    /**
     * Get Sicherungsglaeubiger value
     * @return \BiPRO\StructType\CT_Sicherungsglaeubiger|null
     */
    public function getSicherungsglaeubiger()
    {
        return $this->Sicherungsglaeubiger;
    }
    /**
     * Set Sicherungsglaeubiger value
     * @param \BiPRO\StructType\CT_Sicherungsglaeubiger $sicherungsglaeubiger
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setSicherungsglaeubiger(\BiPRO\StructType\CT_Sicherungsglaeubiger $sicherungsglaeubiger = null)
    {
        $this->Sicherungsglaeubiger = $sicherungsglaeubiger;
        return $this;
    }
    /**
     * Get Sonderausstattung value
     * @return \BiPRO\StructType\CT_Sonderausstattung[]|null
     */
    public function getSonderausstattung()
    {
        return $this->Sonderausstattung;
    }
    /**
     * This method is responsible for validating the values passed to the setSonderausstattung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSonderausstattung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSonderausstattungForArrayConstraintsFromSetSonderausstattung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_FahrzeugSonderausstattungItem) {
            // validation for constraint: itemType
            if (!$cT_FahrzeugSonderausstattungItem instanceof \BiPRO\StructType\CT_Sonderausstattung) {
                $invalidValues[] = is_object($cT_FahrzeugSonderausstattungItem) ? get_class($cT_FahrzeugSonderausstattungItem) : sprintf('%s(%s)', gettype($cT_FahrzeugSonderausstattungItem), var_export($cT_FahrzeugSonderausstattungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Sonderausstattung property can only contain items of type \BiPRO\StructType\CT_Sonderausstattung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Sonderausstattung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Sonderausstattung[] $sonderausstattung
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setSonderausstattung(array $sonderausstattung = array())
    {
        // validation for constraint: array
        if ('' !== ($sonderausstattungArrayErrorMessage = self::validateSonderausstattungForArrayConstraintsFromSetSonderausstattung($sonderausstattung))) {
            throw new \InvalidArgumentException($sonderausstattungArrayErrorMessage, __LINE__);
        }
        $this->Sonderausstattung = $sonderausstattung;
        return $this;
    }
    /**
     * Add item to Sonderausstattung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Sonderausstattung $item
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function addToSonderausstattung(\BiPRO\StructType\CT_Sonderausstattung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Sonderausstattung) {
            throw new \InvalidArgumentException(sprintf('The Sonderausstattung property can only contain items of type \BiPRO\StructType\CT_Sonderausstattung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Sonderausstattung[] = $item;
        return $this;
    }
    /**
     * Get VersicherungsbestaetigungKfz value
     * @return \BiPRO\StructType\CT_VersicherungsbestaetigungKfz|null
     */
    public function getVersicherungsbestaetigungKfz()
    {
        return $this->VersicherungsbestaetigungKfz;
    }
    /**
     * Set VersicherungsbestaetigungKfz value
     * @param \BiPRO\StructType\CT_VersicherungsbestaetigungKfz $versicherungsbestaetigungKfz
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setVersicherungsbestaetigungKfz(\BiPRO\StructType\CT_VersicherungsbestaetigungKfz $versicherungsbestaetigungKfz = null)
    {
        $this->VersicherungsbestaetigungKfz = $versicherungsbestaetigungKfz;
        return $this;
    }
    /**
     * Get Leasingnehmer value
     * @return \BiPRO\StructType\CT_Leasingnehmer|null
     */
    public function getLeasingnehmer()
    {
        return $this->Leasingnehmer;
    }
    /**
     * Set Leasingnehmer value
     * @param \BiPRO\StructType\CT_Leasingnehmer $leasingnehmer
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setLeasingnehmer(\BiPRO\StructType\CT_Leasingnehmer $leasingnehmer = null)
    {
        $this->Leasingnehmer = $leasingnehmer;
        return $this;
    }
    /**
     * Get Leasinggeber value
     * @return \BiPRO\StructType\CT_Leasinggeber|null
     */
    public function getLeasinggeber()
    {
        return $this->Leasinggeber;
    }
    /**
     * Set Leasinggeber value
     * @param \BiPRO\StructType\CT_Leasinggeber $leasinggeber
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setLeasinggeber(\BiPRO\StructType\CT_Leasinggeber $leasinggeber = null)
    {
        $this->Leasinggeber = $leasinggeber;
        return $this;
    }
    /**
     * Get SFRBerechtigter value
     * @return \BiPRO\StructType\CT_SFRBerechtigter|null
     */
    public function getSFRBerechtigter()
    {
        return $this->SFRBerechtigter;
    }
    /**
     * Set SFRBerechtigter value
     * @param \BiPRO\StructType\CT_SFRBerechtigter $sFRBerechtigter
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setSFRBerechtigter(\BiPRO\StructType\CT_SFRBerechtigter $sFRBerechtigter = null)
    {
        $this->SFRBerechtigter = $sFRBerechtigter;
        return $this;
    }
    /**
     * Get Halter value
     * @return \BiPRO\StructType\CT_Halter|null
     */
    public function getHalter()
    {
        return $this->Halter;
    }
    /**
     * Set Halter value
     * @param \BiPRO\StructType\CT_Halter $halter
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setHalter(\BiPRO\StructType\CT_Halter $halter = null)
    {
        $this->Halter = $halter;
        return $this;
    }
    /**
     * Get Fahrer value
     * @return \BiPRO\StructType\CT_Fahrer[]|null
     */
    public function getFahrer()
    {
        return $this->Fahrer;
    }
    /**
     * This method is responsible for validating the values passed to the setFahrer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFahrer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFahrerForArrayConstraintsFromSetFahrer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_FahrzeugFahrerItem) {
            // validation for constraint: itemType
            if (!$cT_FahrzeugFahrerItem instanceof \BiPRO\StructType\CT_Fahrer) {
                $invalidValues[] = is_object($cT_FahrzeugFahrerItem) ? get_class($cT_FahrzeugFahrerItem) : sprintf('%s(%s)', gettype($cT_FahrzeugFahrerItem), var_export($cT_FahrzeugFahrerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Fahrer property can only contain items of type \BiPRO\StructType\CT_Fahrer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Fahrer value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Fahrer[] $fahrer
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setFahrer(array $fahrer = array())
    {
        // validation for constraint: array
        if ('' !== ($fahrerArrayErrorMessage = self::validateFahrerForArrayConstraintsFromSetFahrer($fahrer))) {
            throw new \InvalidArgumentException($fahrerArrayErrorMessage, __LINE__);
        }
        $this->Fahrer = $fahrer;
        return $this;
    }
    /**
     * Add item to Fahrer value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Fahrer $item
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function addToFahrer(\BiPRO\StructType\CT_Fahrer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Fahrer) {
            throw new \InvalidArgumentException(sprintf('The Fahrer property can only contain items of type \BiPRO\StructType\CT_Fahrer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Fahrer[] = $item;
        return $this;
    }
    /**
     * Get Wegfahrsperre value
     * @return bool|null
     */
    public function getWegfahrsperre()
    {
        return $this->Wegfahrsperre;
    }
    /**
     * Set Wegfahrsperre value
     * @param bool $wegfahrsperre
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setWegfahrsperre($wegfahrsperre = null)
    {
        // validation for constraint: boolean
        if (!is_null($wegfahrsperre) && !is_bool($wegfahrsperre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($wegfahrsperre, true), gettype($wegfahrsperre)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($wegfahrsperre) && !preg_match('/true|false/', $wegfahrsperre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($wegfahrsperre, true)), __LINE__);
        }
        $this->Wegfahrsperre = $wegfahrsperre;
        return $this;
    }
    /**
     * Get Staerke value
     * @return float|null
     */
    public function getStaerke()
    {
        return $this->Staerke;
    }
    /**
     * Set Staerke value
     * @param float $staerke
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setStaerke($staerke = null)
    {
        // validation for constraint: float
        if (!is_null($staerke) && !(is_float($staerke) || is_numeric($staerke))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($staerke, true), gettype($staerke)), __LINE__);
        }
        $this->Staerke = $staerke;
        return $this;
    }
    /**
     * Get Staerkeeinheit value
     * @return string|null
     */
    public function getStaerkeeinheit()
    {
        return $this->Staerkeeinheit;
    }
    /**
     * Set Staerkeeinheit value
     * @uses \BiPRO\EnumType\ST_Werteinheit::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Werteinheit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $staerkeeinheit
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setStaerkeeinheit($staerkeeinheit = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Werteinheit::valueIsValid($staerkeeinheit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Werteinheit', is_array($staerkeeinheit) ? implode(', ', $staerkeeinheit) : var_export($staerkeeinheit, true), implode(', ', \BiPRO\EnumType\ST_Werteinheit::getValidValues())), __LINE__);
        }
        $this->Staerkeeinheit = $staerkeeinheit;
        return $this;
    }
    /**
     * Get Finanzierungslaufzeit value
     * @return \BiPRO\StructType\CT_Zeitraum|null
     */
    public function getFinanzierungslaufzeit()
    {
        return $this->Finanzierungslaufzeit;
    }
    /**
     * Set Finanzierungslaufzeit value
     * @param \BiPRO\StructType\CT_Zeitraum $finanzierungslaufzeit
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setFinanzierungslaufzeit(\BiPRO\StructType\CT_Zeitraum $finanzierungslaufzeit = null)
    {
        $this->Finanzierungslaufzeit = $finanzierungslaufzeit;
        return $this;
    }
    /**
     * Get Fahrerassistenzsystem value
     * @return \BiPRO\StructType\CT_Fahrerassistenzsystem[]|null
     */
    public function getFahrerassistenzsystem()
    {
        return $this->Fahrerassistenzsystem;
    }
    /**
     * This method is responsible for validating the values passed to the setFahrerassistenzsystem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFahrerassistenzsystem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFahrerassistenzsystemForArrayConstraintsFromSetFahrerassistenzsystem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_FahrzeugFahrerassistenzsystemItem) {
            // validation for constraint: itemType
            if (!$cT_FahrzeugFahrerassistenzsystemItem instanceof \BiPRO\StructType\CT_Fahrerassistenzsystem) {
                $invalidValues[] = is_object($cT_FahrzeugFahrerassistenzsystemItem) ? get_class($cT_FahrzeugFahrerassistenzsystemItem) : sprintf('%s(%s)', gettype($cT_FahrzeugFahrerassistenzsystemItem), var_export($cT_FahrzeugFahrerassistenzsystemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Fahrerassistenzsystem property can only contain items of type \BiPRO\StructType\CT_Fahrerassistenzsystem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Fahrerassistenzsystem value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Fahrerassistenzsystem[] $fahrerassistenzsystem
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setFahrerassistenzsystem(array $fahrerassistenzsystem = array())
    {
        // validation for constraint: array
        if ('' !== ($fahrerassistenzsystemArrayErrorMessage = self::validateFahrerassistenzsystemForArrayConstraintsFromSetFahrerassistenzsystem($fahrerassistenzsystem))) {
            throw new \InvalidArgumentException($fahrerassistenzsystemArrayErrorMessage, __LINE__);
        }
        $this->Fahrerassistenzsystem = $fahrerassistenzsystem;
        return $this;
    }
    /**
     * Add item to Fahrerassistenzsystem value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Fahrerassistenzsystem $item
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function addToFahrerassistenzsystem(\BiPRO\StructType\CT_Fahrerassistenzsystem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Fahrerassistenzsystem) {
            throw new \InvalidArgumentException(sprintf('The Fahrerassistenzsystem property can only contain items of type \BiPRO\StructType\CT_Fahrerassistenzsystem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Fahrerassistenzsystem[] = $item;
        return $this;
    }
    /**
     * Get FahrzeugGesamtKaufpreis value
     * @return \BiPRO\StructType\CT_Kaufpreis|null
     */
    public function getFahrzeugGesamtKaufpreis()
    {
        return $this->FahrzeugGesamtKaufpreis;
    }
    /**
     * Set FahrzeugGesamtKaufpreis value
     * @param \BiPRO\StructType\CT_Kaufpreis $fahrzeugGesamtKaufpreis
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setFahrzeugGesamtKaufpreis(\BiPRO\StructType\CT_Kaufpreis $fahrzeugGesamtKaufpreis = null)
    {
        $this->FahrzeugGesamtKaufpreis = $fahrzeugGesamtKaufpreis;
        return $this;
    }
    /**
     * Get Zulassungspflichtig value
     * @return bool|null
     */
    public function getZulassungspflichtig()
    {
        return $this->Zulassungspflichtig;
    }
    /**
     * Set Zulassungspflichtig value
     * @param bool $zulassungspflichtig
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setZulassungspflichtig($zulassungspflichtig = null)
    {
        // validation for constraint: boolean
        if (!is_null($zulassungspflichtig) && !is_bool($zulassungspflichtig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($zulassungspflichtig, true), gettype($zulassungspflichtig)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($zulassungspflichtig) && !preg_match('/true|false/', $zulassungspflichtig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($zulassungspflichtig, true)), __LINE__);
        }
        $this->Zulassungspflichtig = $zulassungspflichtig;
        return $this;
    }
    /**
     * Get Baujahr value
     * @return int|null
     */
    public function getBaujahr()
    {
        return $this->Baujahr;
    }
    /**
     * Set Baujahr value
     * @param int $baujahr
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setBaujahr($baujahr = null)
    {
        // validation for constraint: int
        if (!is_null($baujahr) && !(is_int($baujahr) || ctype_digit($baujahr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($baujahr, true), gettype($baujahr)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($baujahr) && mb_strlen(preg_replace('/(\D)/', '', $baujahr)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($baujahr, true), mb_strlen(preg_replace('/(\D)/', '', $baujahr))), __LINE__);
        }
        $this->Baujahr = $baujahr;
        return $this;
    }
    /**
     * Get Reimport value
     * @return bool|null
     */
    public function getReimport()
    {
        return $this->Reimport;
    }
    /**
     * Set Reimport value
     * @param bool $reimport
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setReimport($reimport = null)
    {
        // validation for constraint: boolean
        if (!is_null($reimport) && !is_bool($reimport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reimport, true), gettype($reimport)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($reimport) && !preg_match('/true|false/', $reimport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($reimport, true)), __LINE__);
        }
        $this->Reimport = $reimport;
        return $this;
    }
    /**
     * Get AnzahlDerVorbesitzer value
     * @return int|null
     */
    public function getAnzahlDerVorbesitzer()
    {
        return $this->AnzahlDerVorbesitzer;
    }
    /**
     * Set AnzahlDerVorbesitzer value
     * @param int $anzahlDerVorbesitzer
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setAnzahlDerVorbesitzer($anzahlDerVorbesitzer = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlDerVorbesitzer) && !(is_int($anzahlDerVorbesitzer) || ctype_digit($anzahlDerVorbesitzer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlDerVorbesitzer, true), gettype($anzahlDerVorbesitzer)), __LINE__);
        }
        $this->AnzahlDerVorbesitzer = $anzahlDerVorbesitzer;
        return $this;
    }
    /**
     * Get NaechsteHauptuntersuchung value
     * @return string|null
     */
    public function getNaechsteHauptuntersuchung()
    {
        return $this->NaechsteHauptuntersuchung;
    }
    /**
     * Set NaechsteHauptuntersuchung value
     * @param string $naechsteHauptuntersuchung
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setNaechsteHauptuntersuchung($naechsteHauptuntersuchung = null)
    {
        // validation for constraint: string
        if (!is_null($naechsteHauptuntersuchung) && !is_string($naechsteHauptuntersuchung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naechsteHauptuntersuchung, true), gettype($naechsteHauptuntersuchung)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9])
        if (!is_null($naechsteHauptuntersuchung) && !preg_match('/\\d{4}\\-[0-1][0-9]/', $naechsteHauptuntersuchung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]', var_export($naechsteHauptuntersuchung, true)), __LINE__);
        }
        $this->NaechsteHauptuntersuchung = $naechsteHauptuntersuchung;
        return $this;
    }
    /**
     * Get Dachart value
     * @return string|null
     */
    public function getDachart()
    {
        return $this->Dachart;
    }
    /**
     * Set Dachart value
     * @uses \BiPRO\EnumType\ST_Fahrzeugdachart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Fahrzeugdachart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dachart
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setDachart($dachart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Fahrzeugdachart::valueIsValid($dachart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Fahrzeugdachart', is_array($dachart) ? implode(', ', $dachart) : var_export($dachart, true), implode(', ', \BiPRO\EnumType\ST_Fahrzeugdachart::getValidValues())), __LINE__);
        }
        $this->Dachart = $dachart;
        return $this;
    }
    /**
     * Get Farbe value
     * @return string|null
     */
    public function getFarbe()
    {
        return $this->Farbe;
    }
    /**
     * Set Farbe value
     * @param string $farbe
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setFarbe($farbe = null)
    {
        // validation for constraint: string
        if (!is_null($farbe) && !is_string($farbe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($farbe, true), gettype($farbe)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($farbe) && mb_strlen($farbe) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($farbe)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($farbe) && mb_strlen($farbe) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($farbe)), __LINE__);
        }
        $this->Farbe = $farbe;
        return $this;
    }
    /**
     * Get Sitzbezug value
     * @return string|null
     */
    public function getSitzbezug()
    {
        return $this->Sitzbezug;
    }
    /**
     * Set Sitzbezug value
     * @uses \BiPRO\EnumType\ST_Sitzbezug::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Sitzbezug::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sitzbezug
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setSitzbezug($sitzbezug = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Sitzbezug::valueIsValid($sitzbezug)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Sitzbezug', is_array($sitzbezug) ? implode(', ', $sitzbezug) : var_export($sitzbezug, true), implode(', ', \BiPRO\EnumType\ST_Sitzbezug::getValidValues())), __LINE__);
        }
        $this->Sitzbezug = $sitzbezug;
        return $this;
    }
    /**
     * Get Motorart value
     * @return string|null
     */
    public function getMotorart()
    {
        return $this->Motorart;
    }
    /**
     * Set Motorart value
     * @uses \BiPRO\EnumType\ST_Motorart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Motorart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $motorart
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setMotorart($motorart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Motorart::valueIsValid($motorart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Motorart', is_array($motorart) ? implode(', ', $motorart) : var_export($motorart, true), implode(', ', \BiPRO\EnumType\ST_Motorart::getValidValues())), __LINE__);
        }
        $this->Motorart = $motorart;
        return $this;
    }
    /**
     * Get Getriebeart value
     * @return string|null
     */
    public function getGetriebeart()
    {
        return $this->Getriebeart;
    }
    /**
     * Set Getriebeart value
     * @uses \BiPRO\EnumType\ST_Getriebeart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Getriebeart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $getriebeart
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setGetriebeart($getriebeart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Getriebeart::valueIsValid($getriebeart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Getriebeart', is_array($getriebeart) ? implode(', ', $getriebeart) : var_export($getriebeart, true), implode(', ', \BiPRO\EnumType\ST_Getriebeart::getValidValues())), __LINE__);
        }
        $this->Getriebeart = $getriebeart;
        return $this;
    }
    /**
     * Get AnzahlGaenge value
     * @return int|null
     */
    public function getAnzahlGaenge()
    {
        return $this->AnzahlGaenge;
    }
    /**
     * Set AnzahlGaenge value
     * @param int $anzahlGaenge
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setAnzahlGaenge($anzahlGaenge = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlGaenge) && !(is_int($anzahlGaenge) || ctype_digit($anzahlGaenge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlGaenge, true), gettype($anzahlGaenge)), __LINE__);
        }
        $this->AnzahlGaenge = $anzahlGaenge;
        return $this;
    }
    /**
     * Get Felgenart value
     * @return string|null
     */
    public function getFelgenart()
    {
        return $this->Felgenart;
    }
    /**
     * Set Felgenart value
     * @uses \BiPRO\EnumType\ST_Felgenart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Felgenart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $felgenart
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setFelgenart($felgenart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Felgenart::valueIsValid($felgenart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Felgenart', is_array($felgenart) ? implode(', ', $felgenart) : var_export($felgenart, true), implode(', ', \BiPRO\EnumType\ST_Felgenart::getValidValues())), __LINE__);
        }
        $this->Felgenart = $felgenart;
        return $this;
    }
    /**
     * Get Reserveradart value
     * @return string|null
     */
    public function getReserveradart()
    {
        return $this->Reserveradart;
    }
    /**
     * Set Reserveradart value
     * @uses \BiPRO\EnumType\ST_Reserveradart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Reserveradart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reserveradart
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setReserveradart($reserveradart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Reserveradart::valueIsValid($reserveradart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Reserveradart', is_array($reserveradart) ? implode(', ', $reserveradart) : var_export($reserveradart, true), implode(', ', \BiPRO\EnumType\ST_Reserveradart::getValidValues())), __LINE__);
        }
        $this->Reserveradart = $reserveradart;
        return $this;
    }
    /**
     * Get AnzahlAchsen value
     * @return int|null
     */
    public function getAnzahlAchsen()
    {
        return $this->AnzahlAchsen;
    }
    /**
     * Set AnzahlAchsen value
     * @param int $anzahlAchsen
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setAnzahlAchsen($anzahlAchsen = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlAchsen) && !(is_int($anzahlAchsen) || ctype_digit($anzahlAchsen))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlAchsen, true), gettype($anzahlAchsen)), __LINE__);
        }
        $this->AnzahlAchsen = $anzahlAchsen;
        return $this;
    }
    /**
     * Get AnzahlAngetriebeneAchsen value
     * @return int|null
     */
    public function getAnzahlAngetriebeneAchsen()
    {
        return $this->AnzahlAngetriebeneAchsen;
    }
    /**
     * Set AnzahlAngetriebeneAchsen value
     * @param int $anzahlAngetriebeneAchsen
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setAnzahlAngetriebeneAchsen($anzahlAngetriebeneAchsen = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlAngetriebeneAchsen) && !(is_int($anzahlAngetriebeneAchsen) || ctype_digit($anzahlAngetriebeneAchsen))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlAngetriebeneAchsen, true), gettype($anzahlAngetriebeneAchsen)), __LINE__);
        }
        $this->AnzahlAngetriebeneAchsen = $anzahlAngetriebeneAchsen;
        return $this;
    }
    /**
     * Get AnzahlTueren value
     * @return int|null
     */
    public function getAnzahlTueren()
    {
        return $this->AnzahlTueren;
    }
    /**
     * Set AnzahlTueren value
     * @param int $anzahlTueren
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setAnzahlTueren($anzahlTueren = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlTueren) && !(is_int($anzahlTueren) || ctype_digit($anzahlTueren))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlTueren, true), gettype($anzahlTueren)), __LINE__);
        }
        $this->AnzahlTueren = $anzahlTueren;
        return $this;
    }
    /**
     * Get AnzahlElektrischeFensterheber value
     * @return int|null
     */
    public function getAnzahlElektrischeFensterheber()
    {
        return $this->AnzahlElektrischeFensterheber;
    }
    /**
     * Set AnzahlElektrischeFensterheber value
     * @param int $anzahlElektrischeFensterheber
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setAnzahlElektrischeFensterheber($anzahlElektrischeFensterheber = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlElektrischeFensterheber) && !(is_int($anzahlElektrischeFensterheber) || ctype_digit($anzahlElektrischeFensterheber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlElektrischeFensterheber, true), gettype($anzahlElektrischeFensterheber)), __LINE__);
        }
        $this->AnzahlElektrischeFensterheber = $anzahlElektrischeFensterheber;
        return $this;
    }
    /**
     * Get AnzahlSitzheizungen value
     * @return int|null
     */
    public function getAnzahlSitzheizungen()
    {
        return $this->AnzahlSitzheizungen;
    }
    /**
     * Set AnzahlSitzheizungen value
     * @param int $anzahlSitzheizungen
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setAnzahlSitzheizungen($anzahlSitzheizungen = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlSitzheizungen) && !(is_int($anzahlSitzheizungen) || ctype_digit($anzahlSitzheizungen))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlSitzheizungen, true), gettype($anzahlSitzheizungen)), __LINE__);
        }
        $this->AnzahlSitzheizungen = $anzahlSitzheizungen;
        return $this;
    }
    /**
     * Get AnzahlAirbags value
     * @return int|null
     */
    public function getAnzahlAirbags()
    {
        return $this->AnzahlAirbags;
    }
    /**
     * Set AnzahlAirbags value
     * @param int $anzahlAirbags
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setAnzahlAirbags($anzahlAirbags = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlAirbags) && !(is_int($anzahlAirbags) || ctype_digit($anzahlAirbags))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlAirbags, true), gettype($anzahlAirbags)), __LINE__);
        }
        $this->AnzahlAirbags = $anzahlAirbags;
        return $this;
    }
    /**
     * Get Anhaengerkupplung value
     * @return bool|null
     */
    public function getAnhaengerkupplung()
    {
        return $this->Anhaengerkupplung;
    }
    /**
     * Set Anhaengerkupplung value
     * @param bool $anhaengerkupplung
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setAnhaengerkupplung($anhaengerkupplung = null)
    {
        // validation for constraint: boolean
        if (!is_null($anhaengerkupplung) && !is_bool($anhaengerkupplung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($anhaengerkupplung, true), gettype($anhaengerkupplung)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($anhaengerkupplung) && !preg_match('/true|false/', $anhaengerkupplung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($anhaengerkupplung, true)), __LINE__);
        }
        $this->Anhaengerkupplung = $anhaengerkupplung;
        return $this;
    }
    /**
     * Get Frontscheibenreparaturen value
     * @return int|null
     */
    public function getFrontscheibenreparaturen()
    {
        return $this->Frontscheibenreparaturen;
    }
    /**
     * Set Frontscheibenreparaturen value
     * @param int $frontscheibenreparaturen
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setFrontscheibenreparaturen($frontscheibenreparaturen = null)
    {
        // validation for constraint: int
        if (!is_null($frontscheibenreparaturen) && !(is_int($frontscheibenreparaturen) || ctype_digit($frontscheibenreparaturen))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($frontscheibenreparaturen, true), gettype($frontscheibenreparaturen)), __LINE__);
        }
        $this->Frontscheibenreparaturen = $frontscheibenreparaturen;
        return $this;
    }
    /**
     * Get ErsteZulassungAufDenVNOderHalter value
     * @return string|null
     */
    public function getErsteZulassungAufDenVNOderHalter()
    {
        return $this->ErsteZulassungAufDenVNOderHalter;
    }
    /**
     * Set ErsteZulassungAufDenVNOderHalter value
     * @param string $ersteZulassungAufDenVNOderHalter
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setErsteZulassungAufDenVNOderHalter($ersteZulassungAufDenVNOderHalter = null)
    {
        // validation for constraint: string
        if (!is_null($ersteZulassungAufDenVNOderHalter) && !is_string($ersteZulassungAufDenVNOderHalter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ersteZulassungAufDenVNOderHalter, true), gettype($ersteZulassungAufDenVNOderHalter)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($ersteZulassungAufDenVNOderHalter) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $ersteZulassungAufDenVNOderHalter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($ersteZulassungAufDenVNOderHalter, true)), __LINE__);
        }
        $this->ErsteZulassungAufDenVNOderHalter = $ersteZulassungAufDenVNOderHalter;
        return $this;
    }
    /**
     * Get Reifen value
     * @return \BiPRO\StructType\CT_Reifen[]|null
     */
    public function getReifen()
    {
        return $this->Reifen;
    }
    /**
     * This method is responsible for validating the values passed to the setReifen method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReifen method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReifenForArrayConstraintsFromSetReifen(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_FahrzeugReifenItem) {
            // validation for constraint: itemType
            if (!$cT_FahrzeugReifenItem instanceof \BiPRO\StructType\CT_Reifen) {
                $invalidValues[] = is_object($cT_FahrzeugReifenItem) ? get_class($cT_FahrzeugReifenItem) : sprintf('%s(%s)', gettype($cT_FahrzeugReifenItem), var_export($cT_FahrzeugReifenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Reifen property can only contain items of type \BiPRO\StructType\CT_Reifen, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Reifen value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Reifen[] $reifen
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setReifen(array $reifen = array())
    {
        // validation for constraint: array
        if ('' !== ($reifenArrayErrorMessage = self::validateReifenForArrayConstraintsFromSetReifen($reifen))) {
            throw new \InvalidArgumentException($reifenArrayErrorMessage, __LINE__);
        }
        $this->Reifen = $reifen;
        return $this;
    }
    /**
     * Add item to Reifen value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Reifen $item
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function addToReifen(\BiPRO\StructType\CT_Reifen $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Reifen) {
            throw new \InvalidArgumentException(sprintf('The Reifen property can only contain items of type \BiPRO\StructType\CT_Reifen, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Reifen[] = $item;
        return $this;
    }
    /**
     * Get Betriebsleistung value
     * @return \BiPRO\StructType\CT_Betriebsleistung[]|null
     */
    public function getBetriebsleistung()
    {
        return $this->Betriebsleistung;
    }
    /**
     * This method is responsible for validating the values passed to the setBetriebsleistung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBetriebsleistung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBetriebsleistungForArrayConstraintsFromSetBetriebsleistung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_FahrzeugBetriebsleistungItem) {
            // validation for constraint: itemType
            if (!$cT_FahrzeugBetriebsleistungItem instanceof \BiPRO\StructType\CT_Betriebsleistung) {
                $invalidValues[] = is_object($cT_FahrzeugBetriebsleistungItem) ? get_class($cT_FahrzeugBetriebsleistungItem) : sprintf('%s(%s)', gettype($cT_FahrzeugBetriebsleistungItem), var_export($cT_FahrzeugBetriebsleistungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Betriebsleistung property can only contain items of type \BiPRO\StructType\CT_Betriebsleistung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Betriebsleistung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Betriebsleistung[] $betriebsleistung
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setBetriebsleistung(array $betriebsleistung = array())
    {
        // validation for constraint: array
        if ('' !== ($betriebsleistungArrayErrorMessage = self::validateBetriebsleistungForArrayConstraintsFromSetBetriebsleistung($betriebsleistung))) {
            throw new \InvalidArgumentException($betriebsleistungArrayErrorMessage, __LINE__);
        }
        $this->Betriebsleistung = $betriebsleistung;
        return $this;
    }
    /**
     * Add item to Betriebsleistung value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Betriebsleistung $item
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function addToBetriebsleistung(\BiPRO\StructType\CT_Betriebsleistung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Betriebsleistung) {
            throw new \InvalidArgumentException(sprintf('The Betriebsleistung property can only contain items of type \BiPRO\StructType\CT_Betriebsleistung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Betriebsleistung[] = $item;
        return $this;
    }
    /**
     * Get Ausnahmegenehmigung70StVZO value
     * @return bool|null
     */
    public function getAusnahmegenehmigung70StVZO()
    {
        return $this->Ausnahmegenehmigung70StVZO;
    }
    /**
     * Set Ausnahmegenehmigung70StVZO value
     * @param bool $ausnahmegenehmigung70StVZO
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setAusnahmegenehmigung70StVZO($ausnahmegenehmigung70StVZO = null)
    {
        // validation for constraint: boolean
        if (!is_null($ausnahmegenehmigung70StVZO) && !is_bool($ausnahmegenehmigung70StVZO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ausnahmegenehmigung70StVZO, true), gettype($ausnahmegenehmigung70StVZO)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($ausnahmegenehmigung70StVZO) && !preg_match('/true|false/', $ausnahmegenehmigung70StVZO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($ausnahmegenehmigung70StVZO, true)), __LINE__);
        }
        $this->Ausnahmegenehmigung70StVZO = $ausnahmegenehmigung70StVZO;
        return $this;
    }
    /**
     * Get WagniskennzifferSpezifizierung value
     * @return string|null
     */
    public function getWagniskennzifferSpezifizierung()
    {
        return $this->WagniskennzifferSpezifizierung;
    }
    /**
     * Set WagniskennzifferSpezifizierung value
     * @uses \BiPRO\EnumType\ST_WagniskennzifferSpezifizierung::valueIsValid()
     * @uses \BiPRO\EnumType\ST_WagniskennzifferSpezifizierung::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $wagniskennzifferSpezifizierung
     * @return \BiPRO\StructType\CT_Fahrzeug
     */
    public function setWagniskennzifferSpezifizierung($wagniskennzifferSpezifizierung = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_WagniskennzifferSpezifizierung::valueIsValid($wagniskennzifferSpezifizierung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_WagniskennzifferSpezifizierung', is_array($wagniskennzifferSpezifizierung) ? implode(', ', $wagniskennzifferSpezifizierung) : var_export($wagniskennzifferSpezifizierung, true), implode(', ', \BiPRO\EnumType\ST_WagniskennzifferSpezifizierung::getValidValues())), __LINE__);
        }
        $this->WagniskennzifferSpezifizierung = $wagniskennzifferSpezifizierung;
        return $this;
    }
}
