<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Fahrrad StructType
 * Meta information extracted from the WSDL
 * - documentation: Ein Fahrrad ist ein zumeist zweirädriges (einspuriges) Landfahrzeug, das mit Muskelkraft durch das Treten von Pedalen angetrieben wird.
 * @subpackage Structs
 */
class CT_Fahrrad extends CT_Gegenstand
{
    /**
     * The Rahmennummer
     * Meta information extracted from the WSDL
     * - documentation: Die Rahmennummer ist ein für jeden Fahrradrahmen spezifischer Code, bestehend aus einer Buchstaben- und/oder Zahlenkombination, welche vom Fahrradhersteller in den Rahmen eingestanzt wird.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Rahmennummer;
    /**
     * The Fahrradcodierung
     * Meta information extracted from the WSDL
     * - documentation: Die Fahrradcodierung dient zur Eigentümeridentifizierung und wird bundesweit von der Polizei, dem Allgemeinen Deutschen Fahrrad-Club, der Deutschen Verkehrswacht und Fahrradhändlern vergeben.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Fahrradcodierung;
    /**
     * The Eigentuemer
     * Meta information extracted from the WSDL
     * - documentation: Eigentümer des Fahrrads.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Eigentuemer[]
     */
    public $Eigentuemer;
    /**
     * Constructor method for CT_Fahrrad
     * @uses CT_Fahrrad::setRahmennummer()
     * @uses CT_Fahrrad::setFahrradcodierung()
     * @uses CT_Fahrrad::setEigentuemer()
     * @param string $rahmennummer
     * @param string $fahrradcodierung
     * @param \BiPRO\StructType\CT_Eigentuemer[] $eigentuemer
     */
    public function __construct($rahmennummer = null, $fahrradcodierung = null, array $eigentuemer = array())
    {
        $this
            ->setRahmennummer($rahmennummer)
            ->setFahrradcodierung($fahrradcodierung)
            ->setEigentuemer($eigentuemer);
    }
    /**
     * Get Rahmennummer value
     * @return string|null
     */
    public function getRahmennummer()
    {
        return $this->Rahmennummer;
    }
    /**
     * Set Rahmennummer value
     * @param string $rahmennummer
     * @return \BiPRO\StructType\CT_Fahrrad
     */
    public function setRahmennummer($rahmennummer = null)
    {
        // validation for constraint: string
        if (!is_null($rahmennummer) && !is_string($rahmennummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rahmennummer, true), gettype($rahmennummer)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($rahmennummer) && mb_strlen($rahmennummer) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($rahmennummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($rahmennummer) && mb_strlen($rahmennummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($rahmennummer)), __LINE__);
        }
        $this->Rahmennummer = $rahmennummer;
        return $this;
    }
    /**
     * Get Fahrradcodierung value
     * @return string|null
     */
    public function getFahrradcodierung()
    {
        return $this->Fahrradcodierung;
    }
    /**
     * Set Fahrradcodierung value
     * @param string $fahrradcodierung
     * @return \BiPRO\StructType\CT_Fahrrad
     */
    public function setFahrradcodierung($fahrradcodierung = null)
    {
        // validation for constraint: string
        if (!is_null($fahrradcodierung) && !is_string($fahrradcodierung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fahrradcodierung, true), gettype($fahrradcodierung)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($fahrradcodierung) && mb_strlen($fahrradcodierung) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($fahrradcodierung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($fahrradcodierung) && mb_strlen($fahrradcodierung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($fahrradcodierung)), __LINE__);
        }
        $this->Fahrradcodierung = $fahrradcodierung;
        return $this;
    }
    /**
     * Get Eigentuemer value
     * @return \BiPRO\StructType\CT_Eigentuemer[]|null
     */
    public function getEigentuemer()
    {
        return $this->Eigentuemer;
    }
    /**
     * This method is responsible for validating the values passed to the setEigentuemer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEigentuemer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEigentuemerForArrayConstraintsFromSetEigentuemer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_FahrradEigentuemerItem) {
            // validation for constraint: itemType
            if (!$cT_FahrradEigentuemerItem instanceof \BiPRO\StructType\CT_Eigentuemer) {
                $invalidValues[] = is_object($cT_FahrradEigentuemerItem) ? get_class($cT_FahrradEigentuemerItem) : sprintf('%s(%s)', gettype($cT_FahrradEigentuemerItem), var_export($cT_FahrradEigentuemerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Eigentuemer property can only contain items of type \BiPRO\StructType\CT_Eigentuemer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Eigentuemer value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Eigentuemer[] $eigentuemer
     * @return \BiPRO\StructType\CT_Fahrrad
     */
    public function setEigentuemer(array $eigentuemer = array())
    {
        // validation for constraint: array
        if ('' !== ($eigentuemerArrayErrorMessage = self::validateEigentuemerForArrayConstraintsFromSetEigentuemer($eigentuemer))) {
            throw new \InvalidArgumentException($eigentuemerArrayErrorMessage, __LINE__);
        }
        $this->Eigentuemer = $eigentuemer;
        return $this;
    }
    /**
     * Add item to Eigentuemer value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Eigentuemer $item
     * @return \BiPRO\StructType\CT_Fahrrad
     */
    public function addToEigentuemer(\BiPRO\StructType\CT_Eigentuemer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Eigentuemer) {
            throw new \InvalidArgumentException(sprintf('The Eigentuemer property can only contain items of type \BiPRO\StructType\CT_Eigentuemer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Eigentuemer[] = $item;
        return $this;
    }
}
