<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Fahrerassistenzsystem StructType
 * Meta information extracted from the WSDL
 * - documentation: Elektronische Zusatzeinrichtung in Kraftfahrzeugen zur Unterstützung des Fahrers in bestimmten Fahrsituationen.
 * @subpackage Structs
 */
class CT_Fahrerassistenzsystem extends CT_Objekt
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Art des Fahrerassistenzsystems
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ArtID;
    /**
     * Constructor method for CT_Fahrerassistenzsystem
     * @uses CT_Fahrerassistenzsystem::setArtID()
     * @param string $artID
     */
    public function __construct($artID = null)
    {
        $this
            ->setArtID($artID);
    }
    /**
     * Get ArtID value
     * @return string
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @uses \BiPRO\EnumType\ST_Fahrerassistenzsystem::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Fahrerassistenzsystem::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artID
     * @return \BiPRO\StructType\CT_Fahrerassistenzsystem
     */
    public function setArtID($artID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Fahrerassistenzsystem::valueIsValid($artID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Fahrerassistenzsystem', is_array($artID) ? implode(', ', $artID) : var_export($artID, true), implode(', ', \BiPRO\EnumType\ST_Fahrerassistenzsystem::getValidValues())), __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
}
