<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Fahrer StructType
 * @subpackage Structs
 */
class CT_Fahrer extends CT_Partnerrolle
{
    /**
     * The UeberwiegenderFahrer
     * Meta information extracted from the WSDL
     * - documentation: Dieser Fahrer ist der überwiegende Nutzer des Fahrzeugs
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $UeberwiegenderFahrer;
    /**
     * The BerechtigterNutzer
     * Meta information extracted from the WSDL
     * - documentation: JA = Erlaubnis des Fahrzeughalters zur Nutzung des Fahrzeugs vorhanden.NEIN = Erlaubnis des Fahrzeughalters zur Nutzung des Fahrzeugs nicht vorhanden.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $BerechtigterNutzer;
    /**
     * The BegleiteterFahrer
     * Meta information extracted from the WSDL
     * - documentation: Zur eindeutigen Zuordnung begleiteter Fahrer.Ja = Fahrer ist begleiteter Fahrer.Nein = sonst
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $BegleiteterFahrer;
    /**
     * The Begleitperson
     * Meta information extracted from the WSDL
     * - documentation: Referenz auf die Begleitperson(en) des Fahrers zum begleiteten Fahren (Fahrerlaubnis ab 17 Jahre).
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Begleitperson[]
     */
    public $Begleitperson;
    /**
     * Constructor method for CT_Fahrer
     * @uses CT_Fahrer::setUeberwiegenderFahrer()
     * @uses CT_Fahrer::setBerechtigterNutzer()
     * @uses CT_Fahrer::setBegleiteterFahrer()
     * @uses CT_Fahrer::setBegleitperson()
     * @param bool $ueberwiegenderFahrer
     * @param bool $berechtigterNutzer
     * @param bool $begleiteterFahrer
     * @param \BiPRO\StructType\CT_Begleitperson[] $begleitperson
     */
    public function __construct($ueberwiegenderFahrer = null, $berechtigterNutzer = null, $begleiteterFahrer = null, array $begleitperson = array())
    {
        $this
            ->setUeberwiegenderFahrer($ueberwiegenderFahrer)
            ->setBerechtigterNutzer($berechtigterNutzer)
            ->setBegleiteterFahrer($begleiteterFahrer)
            ->setBegleitperson($begleitperson);
    }
    /**
     * Get UeberwiegenderFahrer value
     * @return bool|null
     */
    public function getUeberwiegenderFahrer()
    {
        return $this->UeberwiegenderFahrer;
    }
    /**
     * Set UeberwiegenderFahrer value
     * @param bool $ueberwiegenderFahrer
     * @return \BiPRO\StructType\CT_Fahrer
     */
    public function setUeberwiegenderFahrer($ueberwiegenderFahrer = null)
    {
        // validation for constraint: boolean
        if (!is_null($ueberwiegenderFahrer) && !is_bool($ueberwiegenderFahrer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ueberwiegenderFahrer, true), gettype($ueberwiegenderFahrer)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($ueberwiegenderFahrer) && !preg_match('/true|false/', $ueberwiegenderFahrer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($ueberwiegenderFahrer, true)), __LINE__);
        }
        $this->UeberwiegenderFahrer = $ueberwiegenderFahrer;
        return $this;
    }
    /**
     * Get BerechtigterNutzer value
     * @return bool|null
     */
    public function getBerechtigterNutzer()
    {
        return $this->BerechtigterNutzer;
    }
    /**
     * Set BerechtigterNutzer value
     * @param bool $berechtigterNutzer
     * @return \BiPRO\StructType\CT_Fahrer
     */
    public function setBerechtigterNutzer($berechtigterNutzer = null)
    {
        // validation for constraint: boolean
        if (!is_null($berechtigterNutzer) && !is_bool($berechtigterNutzer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($berechtigterNutzer, true), gettype($berechtigterNutzer)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($berechtigterNutzer) && !preg_match('/true|false/', $berechtigterNutzer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($berechtigterNutzer, true)), __LINE__);
        }
        $this->BerechtigterNutzer = $berechtigterNutzer;
        return $this;
    }
    /**
     * Get BegleiteterFahrer value
     * @return bool|null
     */
    public function getBegleiteterFahrer()
    {
        return $this->BegleiteterFahrer;
    }
    /**
     * Set BegleiteterFahrer value
     * @param bool $begleiteterFahrer
     * @return \BiPRO\StructType\CT_Fahrer
     */
    public function setBegleiteterFahrer($begleiteterFahrer = null)
    {
        // validation for constraint: boolean
        if (!is_null($begleiteterFahrer) && !is_bool($begleiteterFahrer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($begleiteterFahrer, true), gettype($begleiteterFahrer)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($begleiteterFahrer) && !preg_match('/true|false/', $begleiteterFahrer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($begleiteterFahrer, true)), __LINE__);
        }
        $this->BegleiteterFahrer = $begleiteterFahrer;
        return $this;
    }
    /**
     * Get Begleitperson value
     * @return \BiPRO\StructType\CT_Begleitperson[]|null
     */
    public function getBegleitperson()
    {
        return $this->Begleitperson;
    }
    /**
     * This method is responsible for validating the values passed to the setBegleitperson method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBegleitperson method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBegleitpersonForArrayConstraintsFromSetBegleitperson(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_FahrerBegleitpersonItem) {
            // validation for constraint: itemType
            if (!$cT_FahrerBegleitpersonItem instanceof \BiPRO\StructType\CT_Begleitperson) {
                $invalidValues[] = is_object($cT_FahrerBegleitpersonItem) ? get_class($cT_FahrerBegleitpersonItem) : sprintf('%s(%s)', gettype($cT_FahrerBegleitpersonItem), var_export($cT_FahrerBegleitpersonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Begleitperson property can only contain items of type \BiPRO\StructType\CT_Begleitperson, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Begleitperson value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Begleitperson[] $begleitperson
     * @return \BiPRO\StructType\CT_Fahrer
     */
    public function setBegleitperson(array $begleitperson = array())
    {
        // validation for constraint: array
        if ('' !== ($begleitpersonArrayErrorMessage = self::validateBegleitpersonForArrayConstraintsFromSetBegleitperson($begleitperson))) {
            throw new \InvalidArgumentException($begleitpersonArrayErrorMessage, __LINE__);
        }
        $this->Begleitperson = $begleitperson;
        return $this;
    }
    /**
     * Add item to Begleitperson value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Begleitperson $item
     * @return \BiPRO\StructType\CT_Fahrer
     */
    public function addToBegleitperson(\BiPRO\StructType\CT_Begleitperson $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Begleitperson) {
            throw new \InvalidArgumentException(sprintf('The Begleitperson property can only contain items of type \BiPRO\StructType\CT_Begleitperson, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Begleitperson[] = $item;
        return $this;
    }
}
